/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa;

import ch.cyberduck.ui.cocoa.CDController;
import ch.cyberduck.ui.cocoa.CDTableCellAttributes;
import ch.cyberduck.ui.cocoa.application.NSFont;
import ch.cyberduck.ui.cocoa.application.NSView;
import ch.cyberduck.ui.cocoa.foundation.NSArray;
import ch.cyberduck.ui.cocoa.foundation.NSBundle;
import ch.cyberduck.ui.cocoa.foundation.NSDictionary;
import org.apache.log4j.Logger;

public abstract class CDBundleController
extends CDController {
    private static Logger log = Logger.getLogger(CDBundleController.class);
    protected static final NSDictionary TRUNCATE_MIDDLE_ATTRIBUTES = NSDictionary.dictionaryWithObjectsForKeys(NSArray.arrayWithObject(CDTableCellAttributes.PARAGRAPH_STYLE_LEFT_ALIGNMENT_TRUNCATE_MIDDLE), NSArray.arrayWithObject("NSParagraphStyle"));
    protected static final NSDictionary FIXED_WITH_FONT_ATTRIBUTES = NSDictionary.dictionaryWithObjectsForKeys(NSArray.arrayWithObject(NSFont.userFixedPitchFontOfSize(9.0)), NSArray.arrayWithObject("NSFont"));
    private boolean awaked;

    protected void loadBundle() {
        String bundleName = this.getBundleName();
        if (null == bundleName) {
            log.debug((Object)("No bundle to load for " + this.toString()));
            return;
        }
        this.loadBundle(bundleName);
    }

    protected void loadBundle(String bundleName) {
        if (this.awaked) {
            log.warn((Object)("Bundle " + bundleName + " already loaded"));
            return;
        }
        log.info((Object)("Loading bundle " + bundleName));
        if (!NSBundle.loadNibNamed(bundleName, this.id())) {
            log.fatal((Object)("Couldn't load " + bundleName + ".nib"));
            return;
        }
        if (!this.awaked) {
            this.awakeFromNib();
        }
    }

    public void awakeFromNib() {
        log.debug((Object)"awakeFromNib");
        this.awaked = true;
    }

    protected NSView view() {
        return null;
    }

    protected abstract String getBundleName();
}

