/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa;

import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.TranscriptListener;
import ch.cyberduck.core.threading.BackgroundAction;
import ch.cyberduck.core.threading.MainAction;
import ch.cyberduck.ui.cocoa.CDBrowserController;
import ch.cyberduck.ui.cocoa.CDBundleController;
import ch.cyberduck.ui.cocoa.CDIconCache;
import ch.cyberduck.ui.cocoa.CDSheetController;
import ch.cyberduck.ui.cocoa.CDWindowController;
import ch.cyberduck.ui.cocoa.application.NSButton;
import ch.cyberduck.ui.cocoa.application.NSImageView;
import ch.cyberduck.ui.cocoa.application.NSLayoutManager;
import ch.cyberduck.ui.cocoa.application.NSProgressIndicator;
import ch.cyberduck.ui.cocoa.application.NSTextField;
import ch.cyberduck.ui.cocoa.application.NSTextView;
import ch.cyberduck.ui.cocoa.application.NSWorkspace;
import ch.cyberduck.ui.cocoa.foundation.NSAttributedString;
import ch.cyberduck.ui.cocoa.foundation.NSObject;
import ch.cyberduck.ui.cocoa.foundation.NSRange;
import ch.cyberduck.ui.cocoa.threading.BrowserBackgroundAction;
import ch.cyberduck.ui.cocoa.threading.WindowMainAction;
import com.enterprisedt.net.ftp.FTPException;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.rococoa.cocoa.foundation.NSUInteger;

public class CDCommandController
extends CDSheetController
implements TranscriptListener {
    private static Logger log = Logger.getLogger(CDCommandController.class);
    private NSTextField inputField;
    private NSTextView responseField;
    private NSProgressIndicator progress;
    private NSImageView image;
    private Session session;

    public void setInputField(NSTextField inputField) {
        this.inputField = inputField;
    }

    public void setResponseField(NSTextView responseField) {
        this.responseField = responseField;
        this.responseField.setEditable(false);
        this.responseField.setSelectable(true);
        this.responseField.setUsesFontPanel(false);
        this.responseField.setRichText(false);
        this.responseField.layoutManager().setDelegate(this.id());
    }

    public void setProgress(NSProgressIndicator progress) {
        this.progress = progress;
        this.progress.setDisplayedWhenStopped(false);
    }

    public void setImage(NSImageView image) {
        this.image = image;
        String t = NSWorkspace.sharedWorkspace().absolutePathForAppBundleWithIdentifier("com.apple.Terminal");
        this.image.setImage(CDIconCache.instance().iconForPath(LocalFactory.createLocal((String)t), (Integer)128));
    }

    public void layoutManagerDidCompleteLayoutForTextContainer(NSLayoutManager layoutManager, NSObject textContainer, boolean finished) {
        if (finished && this.responseField.window().isVisible()) {
            this.responseField.scrollRangeToVisible(NSRange.NSMakeRange(this.responseField.textStorage().length(), new NSUInteger(0L)));
        }
    }

    public CDCommandController(CDWindowController parent, Session session) {
        super(parent);
        this.session = session;
        this.session.addTranscriptListener((TranscriptListener)this);
    }

    protected String getBundleName() {
        return "Command";
    }

    public void sendButtonClicked(final NSButton sender) {
        final String command = this.inputField.stringValue();
        if (StringUtils.isNotBlank((String)command)) {
            this.progress.startAnimation(null);
            sender.setEnabled(false);
            this.parent.background((BackgroundAction)new BrowserBackgroundAction((CDBrowserController)this.parent){
                boolean close;

                public void run() {
                    try {
                        CDCommandController.this.session.sendCommand(command);
                    }
                    catch (FTPException e) {
                    }
                    catch (IOException e) {
                        log.warn((Object)e.getMessage());
                    }
                }

                public void cleanup() {
                    CDCommandController.this.progress.stopAnimation(null);
                    sender.setEnabled(true);
                    if (this.close) {
                        CDCommandController.this.closeSheet(sender);
                    }
                }

                public String getActivity() {
                    return command;
                }
            });
        }
    }

    public void log(boolean request, final String message) {
        this.invoke((MainAction)new WindowMainAction(this){

            public void run() {
                CDCommandController.this.responseField.textStorage().replaceCharactersInRange_withAttributedString(NSRange.NSMakeRange(CDCommandController.this.responseField.textStorage().length(), new NSUInteger(0L)), NSAttributedString.attributedStringWithAttributes(message + "\n", CDBundleController.FIXED_WITH_FONT_ATTRIBUTES));
            }
        });
    }

    protected boolean validateInput() {
        return true;
    }

    public void callback(int returncode) {
    }

    protected void invalidate() {
        this.session.removeTranscriptListener((TranscriptListener)this);
        this.responseField.layoutManager().setDelegate(null);
        super.invalidate();
    }
}

