/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa;

import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostCollection;
import ch.cyberduck.core.Keychain;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.core.threading.AbstractBackgroundAction;
import ch.cyberduck.core.threading.BackgroundAction;
import ch.cyberduck.ui.cocoa.CDBrowserController;
import ch.cyberduck.ui.cocoa.CDController;
import ch.cyberduck.ui.cocoa.CDIconCache;
import ch.cyberduck.ui.cocoa.CDMainController;
import ch.cyberduck.ui.cocoa.CDSheetController;
import ch.cyberduck.ui.cocoa.CDWindowController;
import ch.cyberduck.ui.cocoa.application.NSButton;
import ch.cyberduck.ui.cocoa.application.NSComboBox;
import ch.cyberduck.ui.cocoa.application.NSControl;
import ch.cyberduck.ui.cocoa.application.NSMenuItem;
import ch.cyberduck.ui.cocoa.application.NSOpenPanel;
import ch.cyberduck.ui.cocoa.application.NSPopUpButton;
import ch.cyberduck.ui.cocoa.application.NSTextField;
import ch.cyberduck.ui.cocoa.application.NSTextFieldCell;
import ch.cyberduck.ui.cocoa.application.NSWorkspace;
import ch.cyberduck.ui.cocoa.foundation.NSArray;
import ch.cyberduck.ui.cocoa.foundation.NSEnumerator;
import ch.cyberduck.ui.cocoa.foundation.NSMutableAttributedString;
import ch.cyberduck.ui.cocoa.foundation.NSNotification;
import ch.cyberduck.ui.cocoa.foundation.NSNotificationCenter;
import ch.cyberduck.ui.cocoa.foundation.NSObject;
import ch.cyberduck.ui.cocoa.foundation.NSString;
import ch.cyberduck.ui.cocoa.foundation.NSURL;
import ch.cyberduck.ui.cocoa.util.HyperlinkAttributedStringFactory;
import com.enterprisedt.net.ftp.FTPConnectMode;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.rococoa.Foundation;
import org.rococoa.ID;
import org.rococoa.Rococoa;
import org.rococoa.cocoa.foundation.NSInteger;
import org.spearce.jgit.transport.OpenSshConfig;

public class CDConnectionController
extends CDSheetController {
    private static Logger log = Logger.getLogger(CDConnectionController.class);
    private NSPopUpButton protocolPopup;
    private NSComboBox hostField;
    private CDController hostFieldModel = new HostFieldModel();
    private NSButton alertIcon;
    private NSTextField pathField;
    private NSTextField portField;
    private NSTextField usernameField;
    private NSTextField passField;
    private NSTextField pkLabel;
    private NSButton keychainCheckbox;
    private NSButton anonymousCheckbox;
    private NSButton pkCheckbox;
    private NSOpenPanel publicKeyPanel;
    private NSTextField urlLabel;
    private NSPopUpButton encodingPopup;
    private NSPopUpButton connectmodePopup;
    private static final String CONNECTMODE_ACTIVE = Locale.localizedString((String)"Active");
    private static final String CONNECTMODE_PASSIVE = Locale.localizedString((String)"Passive");
    private NSButton toggleOptionsButton;
    private static final Map<CDWindowController, CDConnectionController> controllers = new HashMap<CDWindowController, CDConnectionController>();

    public void setProtocolPopup(NSPopUpButton protocolPopup) {
        Protocol[] protocols;
        this.protocolPopup = protocolPopup;
        this.protocolPopup.setEnabled(true);
        this.protocolPopup.setTarget(this.id());
        this.protocolPopup.setAction(Foundation.selector("protocolSelectionDidChange:"));
        this.protocolPopup.removeAllItems();
        for (Protocol protocol : protocols = Protocol.getKnownProtocols()) {
            String title = protocol.getDescription();
            this.protocolPopup.addItemWithTitle(title);
            NSMenuItem item = this.protocolPopup.itemWithTitle(title);
            item.setRepresentedObject(protocol.getIdentifier());
            item.setImage(CDIconCache.iconNamed(protocol.icon(), 16));
        }
        Protocol defaultProtocol = Protocol.forName((String)Preferences.instance().getProperty("connection.protocol.default"));
        this.protocolPopup.selectItemWithTitle(defaultProtocol.getDescription());
    }

    public void protocolSelectionDidChange(NSPopUpButton sender) {
        boolean supportsCustomEncoding;
        log.debug((Object)("protocolSelectionDidChange:" + sender));
        Protocol protocol = Protocol.forName((String)this.protocolPopup.selectedItem().representedObject());
        this.portField.setIntValue(protocol.getDefaultPort());
        if (!protocol.isHostnameConfigurable()) {
            this.hostField.setStringValue(protocol.getDefaultHostname());
            this.hostField.setEnabled(false);
            this.portField.setEnabled(false);
            this.pathField.setEnabled(true);
        } else {
            if (!this.hostField.isEnabled()) {
                this.hostField.setStringValue("");
            }
            if (!this.pathField.isEnabled()) {
                this.pathField.setStringValue("");
            }
            this.usernameField.setEnabled(true);
            this.hostField.setEnabled(true);
            this.portField.setEnabled(true);
            this.pathField.setEnabled(true);
            this.usernameField.cell().setPlaceholderString("");
            this.passField.cell().setPlaceholderString("");
        }
        if (protocol.equals((Object)Protocol.S3)) {
            this.hostField.setStringValue(protocol.getDefaultHostname());
            Rococoa.cast(this.usernameField.cell(), NSTextFieldCell.class).setPlaceholderString(Locale.localizedString((String)"Access Key ID", (String)"S3"));
            Rococoa.cast(this.passField.cell(), NSTextFieldCell.class).setPlaceholderString(Locale.localizedString((String)"Secret Access Key", (String)"S3"));
        }
        if (protocol.equals((Object)Protocol.MOSSO)) {
            Rococoa.cast(this.usernameField.cell(), NSTextFieldCell.class).setPlaceholderString("");
            Rococoa.cast(this.passField.cell(), NSTextFieldCell.class).setPlaceholderString(Locale.localizedString((String)"API Access Key", (String)"Mosso"));
        }
        if (protocol.equals((Object)Protocol.IDISK)) {
            Rococoa.cast(this.usernameField.cell(), NSTextFieldCell.class).setPlaceholderString(Locale.localizedString((String)"MobileMe Member Name", (String)"IDisk"));
            String member = Preferences.instance().getProperty("iToolsMember");
            if (StringUtils.isNotEmpty((String)member)) {
                this.usernameField.setStringValue(member);
                this.usernameField.setEnabled(false);
                this.pathField.setStringValue("/" + member);
                this.pathField.setEnabled(false);
            }
        }
        this.connectmodePopup.setEnabled(protocol.equals((Object)Protocol.FTP) || protocol.equals((Object)Protocol.FTP_TLS));
        boolean bl = supportsCustomEncoding = protocol.equals((Object)Protocol.FTP) || protocol.equals((Object)Protocol.FTP_TLS) || protocol.equals((Object)Protocol.SFTP);
        if (!supportsCustomEncoding) {
            this.encodingPopup.selectItemWithTitle("Default");
        }
        this.encodingPopup.setEnabled(supportsCustomEncoding);
        this.updateIdentity();
        this.updateURLLabel();
        this.reachable();
    }

    private void updateIdentity() {
        Protocol protocol = Protocol.forName((String)this.protocolPopup.selectedItem().representedObject());
        this.pkCheckbox.setEnabled(protocol.equals((Object)Protocol.SFTP));
        if (protocol.equals((Object)Protocol.SFTP)) {
            if (StringUtils.isNotEmpty((String)this.hostField.stringValue())) {
                OpenSshConfig.Host entry = OpenSshConfig.create().lookup(this.hostField.stringValue());
                if (null != entry.getIdentityFile()) {
                    if (this.pkCheckbox.state() == 0) {
                        this.pkLabel.setStringValue(LocalFactory.createLocal((String)entry.getIdentityFile().getAbsolutePath()).getAbbreviatedPath());
                        this.pkCheckbox.setState(1);
                    }
                } else {
                    this.pkCheckbox.setState(0);
                    this.pkLabel.setStringValue(Locale.localizedString((String)"No Private Key selected"));
                }
                if (StringUtils.isNotBlank((String)entry.getUser())) {
                    this.usernameField.setStringValue(entry.getUser());
                }
            }
        } else {
            this.pkCheckbox.setState(0);
            this.pkLabel.setStringValue(Locale.localizedString((String)"No Private Key selected"));
        }
    }

    public void setHostPopup(NSComboBox hostPopup) {
        this.hostField = hostPopup;
        this.hostField.setTarget(this.id());
        this.hostField.setAction(Foundation.selector("hostPopupSelectionDidChange:"));
        this.hostField.setUsesDataSource(true);
        this.hostField.setDataSource(this.hostFieldModel.id());
        NSNotificationCenter.defaultCenter().addObserver(this.id(), Foundation.selector("hostFieldTextDidChange:"), "NSControlTextDidChangeNotification", this.hostField);
    }

    public void hostPopupSelectionDidChange(NSControl sender) {
        String input = sender.stringValue();
        if (StringUtils.isBlank((String)input)) {
            return;
        }
        input = input.trim();
        for (Host h : HostCollection.defaultCollection()) {
            if (!h.getNickname().equals(input)) continue;
            this.hostChanged(h);
            break;
        }
    }

    public void hostFieldTextDidChange(NSNotification sender) {
        if (Protocol.isURL((String)this.hostField.stringValue())) {
            Host parsed = Host.parse((String)this.hostField.stringValue());
            this.hostChanged(parsed);
        } else {
            this.updateURLLabel();
            this.updateIdentity();
            this.reachable();
        }
    }

    private void hostChanged(Host host) {
        this.updateField(this.hostField, host.getHostname());
        this.protocolPopup.selectItemWithTitle(host.getProtocol().getDescription());
        this.updateField(this.portField, String.valueOf(host.getPort()));
        this.updateField(this.usernameField, host.getCredentials().getUsername());
        this.updateField(this.pathField, host.getDefaultPath());
        this.anonymousCheckbox.setState(host.getCredentials().isAnonymousLogin() ? 1 : 0);
        this.anonymousCheckboxClicked(this.anonymousCheckbox);
        if (host.getCredentials().isPublicKeyAuthentication()) {
            this.pkCheckbox.setState(1);
            this.pkLabel.setStringValue(host.getCredentials().getIdentity().toURL());
        } else {
            this.updateIdentity();
        }
        this.updateURLLabel();
        this.readPasswordFromKeychain();
        this.reachable();
    }

    private void reachable() {
        final String hostname = this.hostField.stringValue();
        if (StringUtils.isNotBlank((String)hostname)) {
            this.background((BackgroundAction)new AbstractBackgroundAction(){
                boolean reachable = false;

                public void run() {
                    this.reachable = new Host(hostname).isReachable();
                }

                public void cleanup() {
                    CDConnectionController.this.alertIcon.setHidden(this.reachable);
                }
            });
        } else {
            this.alertIcon.setHidden(true);
        }
    }

    public void setAlertIcon(NSButton alertIcon) {
        this.alertIcon = alertIcon;
        this.alertIcon.setHidden(true);
        this.alertIcon.setTarget(this.id());
        this.alertIcon.setAction(Foundation.selector("launchNetworkAssistant:"));
    }

    public void launchNetworkAssistant(NSButton sender) {
        Host.parse((String)this.urlLabel.stringValue()).diagnose();
    }

    public void setPathField(NSTextField pathField) {
        this.pathField = pathField;
        NSNotificationCenter.defaultCenter().addObserver(this.id(), Foundation.selector("pathInputDidEndEditing:"), "NSControlTextDidEndEditingNotification", this.pathField);
    }

    public void pathInputDidEndEditing(NSNotification sender) {
        this.updateURLLabel();
        if (StringUtils.isBlank((String)this.pathField.stringValue())) {
            return;
        }
        this.pathField.setStringValue(Path.normalize((String)this.pathField.stringValue(), (boolean)false));
    }

    public void setPortField(NSTextField portField) {
        this.portField = portField;
        NSNotificationCenter.defaultCenter().addObserver(this.id(), Foundation.selector("portFieldTextDidChange:"), "NSControlTextDidChangeNotification", this.portField);
    }

    public void portFieldTextDidChange(NSNotification sender) {
        if (null == this.portField.stringValue() || this.portField.stringValue().equals("")) {
            Protocol protocol = Protocol.forName((String)this.protocolPopup.selectedItem().representedObject());
            this.portField.setStringValue(String.valueOf(protocol.getDefaultPort()));
        }
        this.updateURLLabel();
    }

    public void setUsernameField(NSTextField usernameField) {
        this.usernameField = usernameField;
        this.usernameField.setStringValue(Preferences.instance().getProperty("connection.login.name"));
        NSNotificationCenter.defaultCenter().addObserver(this.id(), Foundation.selector("usernameFieldTextDidChange:"), "NSControlTextDidChangeNotification", this.usernameField);
        NSNotificationCenter.defaultCenter().addObserver(this.id(), Foundation.selector("usernameFieldTextDidEndEditing:"), "NSControlTextDidEndEditingNotification", this.usernameField);
    }

    public void usernameFieldTextDidChange(NSNotification sender) {
        this.updateURLLabel();
    }

    public void usernameFieldTextDidEndEditing(NSNotification sender) {
        this.readPasswordFromKeychain();
    }

    public void setPassField(NSTextField passField) {
        this.passField = passField;
    }

    public void setPkLabel(NSTextField pkLabel) {
        this.pkLabel = pkLabel;
        this.pkLabel.setStringValue(Locale.localizedString((String)"No Private Key selected"));
    }

    public void setKeychainCheckbox(NSButton keychainCheckbox) {
        this.keychainCheckbox = keychainCheckbox;
        this.keychainCheckbox.setState(0);
    }

    public void setAnonymousCheckbox(NSButton anonymousCheckbox) {
        this.anonymousCheckbox = anonymousCheckbox;
        this.anonymousCheckbox.setTarget(this.id());
        this.anonymousCheckbox.setAction(Foundation.selector("anonymousCheckboxClicked:"));
        this.anonymousCheckbox.setState(0);
    }

    public void anonymousCheckboxClicked(NSButton sender) {
        if (sender.state() == 1) {
            this.usernameField.setEnabled(false);
            this.usernameField.setStringValue(Preferences.instance().getProperty("connection.login.anon.name"));
            this.passField.setEnabled(false);
            this.passField.setStringValue("");
        }
        if (sender.state() == 0) {
            this.usernameField.setEnabled(true);
            this.usernameField.setStringValue(Preferences.instance().getProperty("connection.login.name"));
            this.passField.setEnabled(true);
        }
        this.updateURLLabel();
    }

    public void setPkCheckbox(NSButton pkCheckbox) {
        this.pkCheckbox = pkCheckbox;
        this.pkCheckbox.setTarget(this.id());
        this.pkCheckbox.setAction(Foundation.selector("pkCheckboxSelectionDidChange:"));
        this.pkCheckbox.setState(0);
        this.pkCheckbox.setEnabled(Preferences.instance().getProperty("connection.protocol.default").equals(Protocol.SFTP.getIdentifier()));
    }

    public void pkCheckboxSelectionDidChange(NSButton sender) {
        log.debug((Object)"pkCheckboxSelectionDidChange");
        if (sender.state() == 1) {
            this.publicKeyPanel = NSOpenPanel.openPanel();
            this.publicKeyPanel.setCanChooseDirectories(false);
            this.publicKeyPanel.setCanChooseFiles(true);
            this.publicKeyPanel.setAllowsMultipleSelection(false);
            this.publicKeyPanel.beginSheetForDirectory(LocalFactory.createLocal((String)"~/.ssh").getAbsolute(), null, this.window(), this.id(), Foundation.selector("pkSelectionPanelDidEnd:returnCode:contextInfo:"), null);
        } else {
            this.passField.setEnabled(true);
            this.pkCheckbox.setState(0);
            this.pkLabel.setStringValue(Locale.localizedString((String)"No Private Key selected"));
        }
    }

    public void pkSelectionPanelDidEnd_returnCode_contextInfo(NSOpenPanel window, int returncode, ID contextInfo) {
        if (1 == returncode) {
            NSObject next;
            NSArray selected = window.filenames();
            NSEnumerator enumerator = selected.objectEnumerator();
            while (null != (next = enumerator.nextObject())) {
                this.pkLabel.setStringValue(LocalFactory.createLocal((String)Rococoa.cast(next, NSString.class).toString()).getAbbreviatedPath());
            }
            this.passField.setEnabled(false);
        }
        if (0 == returncode) {
            this.passField.setEnabled(true);
            this.pkCheckbox.setState(0);
            this.pkLabel.setStringValue(Locale.localizedString((String)"No Private Key selected"));
        }
        this.publicKeyPanel = null;
    }

    public void setUrlLabel(NSTextField urlLabel) {
        this.urlLabel = urlLabel;
        this.urlLabel.setAllowsEditingTextAttributes(true);
        this.urlLabel.setSelectable(true);
    }

    public void setEncodingPopup(NSPopUpButton encodingPopup) {
        this.encodingPopup = encodingPopup;
        this.encodingPopup.setEnabled(true);
        this.encodingPopup.removeAllItems();
        this.encodingPopup.addItemWithTitle("Default");
        this.encodingPopup.menu().addItem(NSMenuItem.separatorItem());
        this.encodingPopup.addItemsWithTitles(NSArray.arrayWithObjects(CDMainController.availableCharsets()));
        this.encodingPopup.selectItemWithTitle("Default");
    }

    public void setConnectmodePopup(NSPopUpButton connectmodePopup) {
        this.connectmodePopup = connectmodePopup;
        this.connectmodePopup.removeAllItems();
        this.connectmodePopup.addItemWithTitle("Default");
        this.connectmodePopup.menu().addItem(NSMenuItem.separatorItem());
        this.connectmodePopup.addItemWithTitle(CONNECTMODE_ACTIVE);
        this.connectmodePopup.addItemWithTitle(CONNECTMODE_PASSIVE);
        this.connectmodePopup.selectItemWithTitle("Default");
    }

    public void setToggleOptionsButton(NSButton b) {
        this.toggleOptionsButton = b;
    }

    public static CDConnectionController instance(CDWindowController parent) {
        if (!controllers.containsKey(parent)) {
            CDConnectionController controller = new CDConnectionController(parent){

                protected void invalidate() {
                    controllers.remove(this.parent);
                    super.invalidate();
                }
            };
            controllers.put(parent, controller);
        }
        return controllers.get(parent);
    }

    public boolean isSingleton() {
        return true;
    }

    private CDConnectionController(CDWindowController parent) {
        super(parent);
    }

    protected String getBundleName() {
        return "Connection";
    }

    public void awakeFromNib() {
        this.protocolSelectionDidChange(null);
        this.setState(this.toggleOptionsButton, Preferences.instance().getBoolean("connection.toggle.options"));
        super.awakeFromNib();
    }

    public void readPasswordFromKeychain() {
        if (Preferences.instance().getBoolean("connection.login.useKeychain")) {
            if (StringUtils.isBlank((String)this.hostField.stringValue())) {
                return;
            }
            if (StringUtils.isBlank((String)this.portField.stringValue())) {
                return;
            }
            if (StringUtils.isBlank((String)this.usernameField.stringValue())) {
                return;
            }
            Protocol protocol = Protocol.forName((String)this.protocolPopup.selectedItem().representedObject());
            this.updateField(this.passField, Keychain.instance().getInternetPasswordFromKeychain(protocol.getScheme(), Integer.parseInt(this.portField.stringValue()), this.hostField.stringValue(), this.usernameField.stringValue()));
        }
    }

    private void updateURLLabel() {
        if (StringUtils.isNotBlank((String)this.hostField.stringValue())) {
            Protocol protocol = Protocol.forName((String)this.protocolPopup.selectedItem().representedObject());
            String url = protocol.getScheme() + "://" + this.usernameField.stringValue() + "@" + this.hostField.stringValue() + ":" + this.portField.stringValue() + Path.normalize((String)this.pathField.stringValue());
            this.urlLabel.setAttributedStringValue(HyperlinkAttributedStringFactory.create(NSMutableAttributedString.create(url, TRUNCATE_MIDDLE_ATTRIBUTES), url));
        } else {
            this.urlLabel.setStringValue(this.hostField.stringValue());
        }
    }

    public void helpButtonClicked(ID sender) {
        Protocol protocol = Protocol.forName((String)this.protocolPopup.selectedItem().representedObject());
        NSWorkspace.sharedWorkspace().openURL(NSURL.URLWithString(Preferences.instance().getProperty("website.help") + "/" + protocol.getIdentifier()));
    }

    public void callback(int returncode) {
        if (returncode == 1) {
            this.window().endEditingFor(null);
            Protocol protocol = Protocol.forName((String)this.protocolPopup.selectedItem().representedObject());
            Host host = new Host(protocol, this.hostField.stringValue(), Integer.parseInt(this.portField.stringValue()), this.pathField.stringValue());
            if (protocol.equals((Object)Protocol.FTP) || protocol.equals((Object)Protocol.FTP_TLS)) {
                if (this.connectmodePopup.titleOfSelectedItem().equals("Default")) {
                    host.setFTPConnectMode(null);
                } else if (this.connectmodePopup.titleOfSelectedItem().equals(CONNECTMODE_ACTIVE)) {
                    host.setFTPConnectMode(FTPConnectMode.ACTIVE);
                } else if (this.connectmodePopup.titleOfSelectedItem().equals(CONNECTMODE_PASSIVE)) {
                    host.setFTPConnectMode(FTPConnectMode.PASV);
                }
            }
            Credentials credentials = host.getCredentials();
            credentials.setUsername(this.usernameField.stringValue());
            credentials.setPassword(this.passField.stringValue());
            credentials.setUseKeychain(this.keychainCheckbox.state() == 1);
            if (protocol.equals((Object)Protocol.SFTP) && this.pkCheckbox.state() == 1) {
                credentials.setIdentity(LocalFactory.createLocal((String)this.pkLabel.stringValue()));
            }
            if (this.encodingPopup.titleOfSelectedItem().equals("Default")) {
                host.setEncoding(null);
            } else {
                host.setEncoding(this.encodingPopup.titleOfSelectedItem());
            }
            ((CDBrowserController)this.parent).mount(host);
        }
        this.reset();
    }

    private void reset() {
        this.passField.setStringValue("");
        Preferences.instance().setProperty("connection.toggle.options", this.toggleOptionsButton.state());
    }

    private static class HostFieldModel
    extends CDController
    implements NSComboBox.DataSource {
        private HostFieldModel() {
        }

        public NSInteger numberOfItemsInComboBox(NSComboBox sender) {
            return new NSInteger(HostCollection.defaultCollection().size());
        }

        public NSObject comboBox_objectValueForItemAtIndex(NSComboBox sender, NSInteger row) {
            return NSString.stringWithString(HostCollection.defaultCollection().get(row.intValue()).getNickname());
        }
    }
}

