/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa;

import ch.cyberduck.core.threading.MainAction;
import ch.cyberduck.core.threading.MainActionRegistry;
import ch.cyberduck.ui.AbstractController;
import ch.cyberduck.ui.cocoa.foundation.NSAutoreleasePool;
import ch.cyberduck.ui.cocoa.foundation.NSNotificationCenter;
import ch.cyberduck.ui.cocoa.foundation.NSObject;
import ch.cyberduck.ui.cocoa.foundation.NSThread;
import org.apache.log4j.Logger;
import org.rococoa.Foundation;
import org.rococoa.ID;
import org.rococoa.Rococoa;
import org.rococoa.internal.AutoreleaseBatcher;
import org.rococoa.internal.OperationBatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDController
extends AbstractController {
    private static Logger log = Logger.getLogger(CDController.class);
    private NSObject proxy;
    private ID id;

    public NSObject proxy() {
        return this.proxy(NSObject.class);
    }

    public NSObject proxy(Class<? extends NSObject> type) {
        if (null == this.proxy) {
            this.proxy = Rococoa.proxy(this, type);
        }
        return this.proxy;
    }

    public ID id() {
        return this.id(NSObject.class);
    }

    public ID id(Class<? extends NSObject> type) {
        if (null == this.id) {
            this.id = this.proxy(type).id();
        }
        return this.id;
    }

    protected void invalidate() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("invalidate:" + this.toString()));
        }
        if (this.id != null) {
            NSNotificationCenter.defaultCenter().removeObserver(this.id);
        }
    }

    protected void finalize() throws Throwable {
        if (log.isTraceEnabled()) {
            log.trace((Object)("finalize:" + this.toString()));
        }
        super.finalize();
    }

    @Override
    protected OperationBatcher getBatcher(int size) {
        return AutoreleaseBatcher.forThread(size);
    }

    @Override
    public void invoke(final MainAction runnable, boolean wait) {
        log.debug((Object)("invoke:" + runnable));
        if (this.isMainThread()) {
            log.debug((Object)("Already on main thread. Invoke " + runnable + " directly."));
            runnable.run();
            return;
        }
        final MainActionRegistry registry = MainActionRegistry.instance();
        MainAction main = new MainAction(){

            public boolean isValid() {
                return runnable.isValid();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                NSAutoreleasePool pool = NSAutoreleasePool.push();
                try {
                    runnable.run();
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    registry.remove((Object)this);
                    pool.drain();
                    throw throwable;
                }
                registry.remove((Object)this);
                pool.drain();
            }
        };
        registry.add((Object)main);
        Foundation.runOnMainThread((Runnable)main, wait);
    }

    @Override
    public boolean isMainThread() {
        return NSThread.isMainThread();
    }
}

