/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa;

import ch.cyberduck.ui.cocoa.foundation.NSDate;
import ch.cyberduck.ui.cocoa.foundation.NSDateFormatter;
import ch.cyberduck.ui.cocoa.foundation.NSTimeZone;
import org.apache.log4j.Logger;

public class CDDateFormatter {
    private static Logger log = Logger.getLogger(CDDateFormatter.class);
    private static final NSDateFormatter longDateFormatter = NSDateFormatter.dateFormatter();
    private static final NSDateFormatter shortDateFormatter;

    private static NSDate toDate(long milliseconds) {
        return NSDate.dateWithTimeIntervalSince1970(milliseconds / 1000L);
    }

    public static String getShortFormat(long milliseconds) {
        return CDDateFormatter.getShortFormat(CDDateFormatter.toDate(milliseconds), NSTimeZone.systemTimeZone());
    }

    public static String getShortFormat(NSDate date, NSTimeZone timezone) {
        return shortDateFormatter.stringFromDate(date);
    }

    public static String getLongFormat(long milliseconds) {
        return CDDateFormatter.getLongFormat(CDDateFormatter.toDate(milliseconds), NSTimeZone.systemTimeZone());
    }

    public static String getLongFormat(NSDate date, NSTimeZone timezone) {
        return longDateFormatter.stringFromDate(date);
    }

    static {
        longDateFormatter.setDateStyle(NSDateFormatter.kCFDateFormatterLongStyle);
        longDateFormatter.setTimeStyle(NSDateFormatter.kCFDateFormatterLongStyle);
        shortDateFormatter = NSDateFormatter.dateFormatter();
        shortDateFormatter.setDateStyle(NSDateFormatter.kCFDateFormatterShortStyle);
        shortDateFormatter.setTimeStyle(NSDateFormatter.kCFDateFormatterShortStyle);
    }
}

