/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathFilter;
import ch.cyberduck.core.Status;
import ch.cyberduck.core.Transfer;
import ch.cyberduck.ui.cocoa.CDTableCellAttributes;
import ch.cyberduck.ui.cocoa.CDTransferPromptModel;
import ch.cyberduck.ui.cocoa.CDWindowController;
import ch.cyberduck.ui.cocoa.foundation.NSAttributedString;
import ch.cyberduck.ui.cocoa.foundation.NSObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDDownloadPromptModel
extends CDTransferPromptModel {
    private PathFilter<Path> filter = new CDTransferPromptModel.PromptFilter(){

        public boolean accept(Path child) {
            CDTransferPromptModel.log.debug((Object)("accept:" + child));
            if (child.getLocal().exists()) {
                if (child.attributes.isFile() && child.getLocal().attributes.getSize() == 0L) {
                    return false;
                }
                return super.accept(child);
            }
            return false;
        }
    };

    public CDDownloadPromptModel(CDWindowController c, Transfer transfer) {
        super(c, transfer);
    }

    @Override
    protected PathFilter<Path> filter() {
        return this.filter;
    }

    @Override
    protected NSObject objectValueForItem(Path item, String identifier) {
        NSObject cached = this.modelCache.get(item, identifier);
        if (null == cached) {
            if (identifier.equals("SIZE")) {
                return this.modelCache.put(item, identifier, NSAttributedString.attributedStringWithAttributes(Status.getSizeAsString((double)item.getLocal().attributes.getSize()), CDTableCellAttributes.browserFontRightAlignment()));
            }
            if (identifier.equals("WARNING")) {
                if (item.attributes.isFile()) {
                    if (item.attributes.getSize() == 0L) {
                        return this.modelCache.put(item, identifier, this.ALERT_ICON);
                    }
                    if (item.getLocal().attributes.getSize() > item.attributes.getSize()) {
                        return this.modelCache.put(item, identifier, this.ALERT_ICON);
                    }
                }
                return null;
            }
        }
        return super.objectValueForItem(item, identifier);
    }
}

