/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathFactory;
import ch.cyberduck.core.Session;
import ch.cyberduck.ui.cocoa.CDBrowserController;
import ch.cyberduck.ui.cocoa.CDDateFormatter;
import ch.cyberduck.ui.cocoa.CDFileController;
import ch.cyberduck.ui.cocoa.CDIconCache;
import ch.cyberduck.ui.cocoa.CDWindowController;
import ch.cyberduck.ui.cocoa.application.NSImageView;
import ch.cyberduck.ui.cocoa.application.NSTextField;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;

public class CDDuplicateFileController
extends CDFileController {
    private NSImageView iconView;

    public void setIconView(NSImageView iconView) {
        this.iconView = iconView;
        this.iconView.setImage(CDIconCache.instance().iconForExtension(((CDBrowserController)this.parent).getSelectedPath().getExtension(), 64));
    }

    public CDDuplicateFileController(CDWindowController parent) {
        super(parent);
    }

    protected String getBundleName() {
        return "Duplicate";
    }

    public void setFilenameField(NSTextField field) {
        super.setFilenameField(field);
        Path selected = ((CDBrowserController)this.parent).getSelectedPath();
        StringBuffer proposal = new StringBuffer();
        proposal.append(FilenameUtils.getBaseName((String)selected.getName()));
        proposal.append(" (").append(CDDateFormatter.getShortFormat(System.currentTimeMillis()).replace('/', ':')).append(")");
        if (StringUtils.isNotEmpty((String)selected.getExtension())) {
            proposal.append(".").append(selected.getExtension());
        }
        this.filenameField.setStringValue(proposal.toString());
    }

    public void callback(int returncode) {
        Path selected = ((CDBrowserController)this.parent).getSelectedPath();
        if (returncode == 1) {
            this.duplicateFile(selected, this.filenameField.stringValue(), false);
        }
        if (returncode == -1) {
            this.duplicateFile(selected, this.filenameField.stringValue(), true);
        }
    }

    protected Path getWorkdir() {
        return ((CDBrowserController)this.parent).getSelectedPath().getParent();
    }

    private void duplicateFile(Path selected, String filename, boolean edit) {
        Path duplicate = PathFactory.createPath((Session)selected.getSession(), (Object)selected.getAsDictionary());
        duplicate.setPath(duplicate.getParent().getAbsolute(), filename);
        ((CDBrowserController)this.parent).duplicatePath(selected, duplicate, edit);
    }
}

