/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa;

import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.core.threading.BackgroundException;
import ch.cyberduck.ui.cocoa.CDBundleController;
import ch.cyberduck.ui.cocoa.CDTaskController;
import ch.cyberduck.ui.cocoa.application.NSTextField;
import ch.cyberduck.ui.cocoa.application.NSView;
import ch.cyberduck.ui.cocoa.foundation.NSAttributedString;
import ch.ethz.ssh2.sftp.SFTPException;
import com.enterprisedt.net.ftp.FTPException;
import com.mosso.client.cloudfiles.FilesException;
import java.io.IOException;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.StatusLine;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jets3t.service.CloudFrontServiceException;
import org.jets3t.service.S3ServiceException;

public class CDErrorController
extends CDBundleController {
    private static Logger log = Logger.getLogger(CDTaskController.class);
    private NSTextField hostField;
    private NSTextField descriptionField;
    private NSTextField errorField;
    private NSView view;
    private BackgroundException failure;

    public void setHostField(NSTextField hostField) {
        this.hostField = hostField;
        if (null == this.failure.getPath()) {
            this.hostField.setAttributedStringValue(NSAttributedString.attributedStringWithAttributes(this.failure.getSession().getHost().toURL(), FIXED_WITH_FONT_ATTRIBUTES));
        } else {
            this.hostField.setAttributedStringValue(NSAttributedString.attributedStringWithAttributes(this.failure.getPath().getAbsolute(), FIXED_WITH_FONT_ATTRIBUTES));
        }
    }

    public void setDescriptionField(NSTextField descriptionField) {
        this.descriptionField = descriptionField;
        this.descriptionField.setSelectable(true);
        this.descriptionField.setAttributedStringValue(NSAttributedString.attributedStringWithAttributes(this.getDetailedCauseMessage(this.failure), TRUNCATE_MIDDLE_ATTRIBUTES));
    }

    public void setErrorField(NSTextField errorField) {
        this.errorField = errorField;
        this.errorField.setSelectable(true);
        this.errorField.setAttributedStringValue(NSAttributedString.attributedStringWithAttributes(this.getReadableTitle(this.failure) + ": " + this.failure.getMessage(), TRUNCATE_MIDDLE_ATTRIBUTES));
    }

    public void setView(NSView view) {
        this.view = view;
    }

    public NSView view() {
        return this.view;
    }

    public CDErrorController(BackgroundException e) {
        this.failure = e;
        this.loadBundle();
    }

    public String getTooltip() {
        return this.getReadableTitle(this.failure);
    }

    private String getReadableTitle(BackgroundException e) {
        Throwable cause = e.getCause();
        if (cause instanceof FTPException) {
            return "FTP " + Locale.localizedString((String)"Error");
        }
        if (cause instanceof SFTPException) {
            return "SSH " + Locale.localizedString((String)"Error");
        }
        if (cause instanceof S3ServiceException) {
            return "S3 " + Locale.localizedString((String)"Error");
        }
        if (cause instanceof CloudFrontServiceException) {
            return "CloudFront " + Locale.localizedString((String)"Error");
        }
        if (cause instanceof HttpException) {
            return "HTTP " + Locale.localizedString((String)"Error");
        }
        if (cause instanceof SocketException) {
            return "Network " + Locale.localizedString((String)"Error");
        }
        if (cause instanceof UnknownHostException) {
            return "DNS " + Locale.localizedString((String)"Error");
        }
        if (cause instanceof IOException) {
            return "I/O " + Locale.localizedString((String)"Error");
        }
        return Locale.localizedString((String)"Error");
    }

    private String getDetailedCauseMessage(BackgroundException e) {
        String message;
        Throwable cause = e.getCause();
        StringBuilder buffer = new StringBuilder();
        if (null != cause) {
            StatusLine status;
            CloudFrontServiceException cf;
            if (StringUtils.isNotBlank((String)cause.getMessage())) {
                buffer.append(cause.getMessage());
            }
            if (cause instanceof SFTPException) {
                // empty if block
            }
            if (cause instanceof S3ServiceException) {
                S3ServiceException s3 = (S3ServiceException)cause;
                if (StringUtils.isNotBlank((String)s3.getResponseStatus())) {
                    buffer.append(" ").append(s3.getResponseStatus());
                }
                if (StringUtils.isNotBlank((String)s3.getS3ErrorMessage())) {
                    buffer.append(" ").append(s3.getS3ErrorMessage());
                }
            }
            if (cause instanceof CloudFrontServiceException) {
                cf = (CloudFrontServiceException)cause;
                if (StringUtils.isNotBlank((String)cf.getErrorMessage())) {
                    buffer.append(cf.getErrorMessage()).append(". ");
                }
                if (StringUtils.isNotBlank((String)cf.getErrorDetail())) {
                    buffer.append(" ").append(cf.getErrorDetail());
                }
            }
            if (cause instanceof FilesException && null != (status = (cf = (FilesException)cause).getHttpStatusLine()) && StringUtils.isNotBlank((String)status.getReasonPhrase())) {
                buffer.append(" ").append(status.getReasonPhrase());
            }
        }
        if (!(message = buffer.toString()).endsWith(".")) {
            message = message + ".";
        }
        return Locale.localizedString((String)message, (String)"Error");
    }

    protected String getBundleName() {
        return "Error";
    }
}

