/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathFactory;
import ch.cyberduck.core.Session;
import ch.cyberduck.ui.cocoa.CDBrowserController;
import ch.cyberduck.ui.cocoa.CDSheetController;
import ch.cyberduck.ui.cocoa.CDWindowController;
import ch.cyberduck.ui.cocoa.application.NSButton;
import ch.cyberduck.ui.cocoa.application.NSTextField;
import ch.cyberduck.ui.cocoa.odb.EditorFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public abstract class CDFileController
extends CDSheetController {
    protected static Logger log = Logger.getLogger(CDFileController.class);
    protected NSTextField filenameField;
    private NSButton editButton;

    public void setFilenameField(NSTextField filenameField) {
        this.filenameField = filenameField;
    }

    public void setEditButton(NSButton editButton) {
        this.editButton = editButton;
        this.editButton.setEnabled(EditorFactory.defaultEditor() != null);
    }

    public CDFileController(CDWindowController parent) {
        super(parent);
    }

    protected Path getWorkdir() {
        if (((CDBrowserController)this.parent).getSelectionCount() == 1) {
            Path selected = ((CDBrowserController)this.parent).getSelectedPath();
            if (selected.attributes.isDirectory()) {
                return selected;
            }
            return selected.getParent();
        }
        return ((CDBrowserController)this.parent).workdir();
    }

    protected boolean validateInput() {
        if (this.filenameField.stringValue().indexOf(47) != -1) {
            return false;
        }
        if (StringUtils.isNotBlank((String)this.filenameField.stringValue())) {
            Path file = PathFactory.createPath((Session)this.getWorkdir().getSession(), (String)this.getWorkdir().getAbsolute(), (String)this.filenameField.stringValue(), (int)1);
            return !file.exists();
        }
        return false;
    }
}

