/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.ui.cocoa.application.NSImage;
import ch.cyberduck.ui.cocoa.application.NSWorkspace;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.map.AbstractLinkedMap;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.rococoa.cocoa.foundation.NSPoint;
import org.rococoa.cocoa.foundation.NSRect;
import org.rococoa.cocoa.foundation.NSSize;

public class CDIconCache {
    private static Logger log = Logger.getLogger(CDIconCache.class);
    private static CDIconCache instance = null;
    private static final Object lock = new Object();
    private Map<String, Map<Integer, NSImage>> cache = new LRUMap(Preferences.instance().getInteger("icon.cache.size")){

        protected boolean removeLRU(AbstractLinkedMap.LinkEntry entry) {
            log.debug((Object)("Removing from cache:" + entry));
            return true;
        }
    };
    private final NSRect NSZeroRect = new NSRect(0.0, 0.0);
    private final boolean overlayFolderImage = Preferences.instance().getBoolean("browser.markInaccessibleFolders");
    private static Local FOLDER_PATH = LocalFactory.createLocal((String)Preferences.instance().getProperty("application.support.path"));
    private final NSImage FOLDER_ICON = this.iconForPath(FOLDER_PATH);

    public static NSImage iconNamed(String name) {
        return CDIconCache.instance().iconForName(name);
    }

    public static NSImage iconNamed(String name, Integer size) {
        return CDIconCache.instance().iconForName(name, size);
    }

    public static NSImage iconNamed(String name, Integer width, Integer height) {
        return CDIconCache.instance().iconForName(name, width, height);
    }

    public static NSImage folderIcon(Integer size) {
        return CDIconCache.instance().iconForPath(FOLDER_PATH, size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CDIconCache instance() {
        Object object = lock;
        synchronized (object) {
            if (null == instance) {
                instance = new CDIconCache();
            }
        }
        return instance;
    }

    private void put(String key, NSImage image, Integer size) {
        Map<Integer, NSImage> versions = this.cache.containsKey(key) ? this.cache.get(key) : new HashMap<Integer, NSImage>();
        versions.put(size, image);
        this.cache.put(key, versions);
    }

    private NSImage get(String key, Integer size) {
        if (!this.cache.containsKey(key)) {
            log.warn((Object)("No cached image for " + key));
            return null;
        }
        Map<Integer, NSImage> versions = this.cache.get(key);
        return versions.get(size);
    }

    public NSImage iconForExtension(String extension, Integer size) {
        NSImage img = this.get(extension, size);
        if (null == img) {
            img = NSWorkspace.sharedWorkspace().iconForFileType(extension);
            this.put(extension, this.convert(img, size), size);
        }
        return img;
    }

    protected NSImage iconForName(String name) {
        return this.iconForName(name, null);
    }

    protected NSImage iconForName(String name, Integer size) {
        return this.iconForName(name, size, size);
    }

    protected NSImage iconForName(String name, Integer width, Integer height) {
        NSImage image = this.get(name, width);
        if (null == image) {
            image = NSImage.imageNamed(name);
            if (null == image) {
                log.warn((Object)("No icon named " + name));
            }
            this.put(name, this.convert(image, width, height), width);
        }
        return image;
    }

    public NSImage iconForPath(Local item) {
        return this.iconForPath(item, null);
    }

    public NSImage iconForPath(Local item, Integer size) {
        if (item.exists()) {
            NSImage icon = this.iconForName(item.getAbsolute(), size);
            if (null == icon) {
                icon = NSWorkspace.sharedWorkspace().iconForFile(item.getAbsolute());
                this.put(item.getAbsolute(), this.convert(icon, size), size);
            }
            return icon;
        }
        return this.iconForName("notfound.tiff", size);
    }

    public NSImage iconForPath(Path item, Integer size) {
        if (item.attributes.isSymbolicLink()) {
            if (item.attributes.isDirectory()) {
                NSImage folder = NSImage.imageWithSize(new NSSize(size.intValue(), size.intValue()));
                folder.lockFocus();
                NSImage f = this.FOLDER_ICON;
                f.drawInRect(new NSRect(new NSPoint(0.0, 0.0), folder.size()), this.NSZeroRect, 2, 1.0);
                NSImage o = this.iconForName("AliasBadgeIcon.icns");
                o.drawInRect(new NSRect(new NSPoint(0.0, 0.0), folder.size()), this.NSZeroRect, 2, 1.0);
                folder.unlockFocus();
                return this.convert(folder, size);
            }
            NSImage symlink = NSImage.imageWithSize(new NSSize(size.intValue(), size.intValue()));
            symlink.lockFocus();
            NSImage f = this.iconForExtension(item.getExtension(), size);
            f.drawInRect(new NSRect(new NSPoint(0.0, 0.0), symlink.size()), this.NSZeroRect, 2, 1.0);
            NSImage o = this.iconForName("AliasBadgeIcon.icns");
            o.drawInRect(new NSRect(new NSPoint(0.0, 0.0), symlink.size()), this.NSZeroRect, 2, 1.0);
            symlink.unlockFocus();
            return symlink;
        }
        if (item.attributes.isFile()) {
            if (StringUtils.isEmpty((String)item.getExtension()) && null != item.attributes.getPermission() && item.isExecutable()) {
                return this.iconForName("executable.tiff", size);
            }
            return this.iconForExtension(item.getExtension(), size);
        }
        if (item.attributes.isVolume()) {
            return this.iconForName(item.getHost().getProtocol().disk(), size);
        }
        if (item.attributes.isDirectory()) {
            if (this.overlayFolderImage && null != item.attributes.getPermission()) {
                if (!item.isExecutable() || item.isCached() && !item.cache().get((AbstractPath)item).attributes().isReadable()) {
                    NSImage folder = NSImage.imageWithSize(new NSSize(size.intValue(), size.intValue()));
                    folder.lockFocus();
                    NSImage f = this.FOLDER_ICON;
                    f.drawInRect(new NSRect(new NSPoint(0.0, 0.0), folder.size()), this.NSZeroRect, 2, 1.0);
                    NSImage o = this.iconForName("PrivateFolderBadgeIcon.icns");
                    o.drawInRect(new NSRect(new NSPoint(0.0, 0.0), folder.size()), this.NSZeroRect, 2, 1.0);
                    folder.unlockFocus();
                    return this.convert(folder, size);
                }
                if (!item.isReadable() && item.isWritable()) {
                    NSImage folder = NSImage.imageWithSize(new NSSize(size.intValue(), size.intValue()));
                    folder.lockFocus();
                    NSImage f = this.FOLDER_ICON;
                    f.drawInRect(new NSRect(new NSPoint(0.0, 0.0), folder.size()), this.NSZeroRect, 2, 1.0);
                    NSImage o = this.iconForName("DropFolderBadgeIcon.icns");
                    o.drawInRect(new NSRect(new NSPoint(0.0, 0.0), folder.size()), this.NSZeroRect, 2, 1.0);
                    folder.unlockFocus();
                    return this.convert(folder, size);
                }
                if (!item.isWritable()) {
                    NSImage folder = NSImage.imageWithSize(new NSSize(size.intValue(), size.intValue()));
                    folder.lockFocus();
                    NSImage f = this.FOLDER_ICON;
                    f.drawInRect(new NSRect(new NSPoint(0.0, 0.0), folder.size()), this.NSZeroRect, 2, 1.0);
                    NSImage o = this.iconForName("ReadOnlyFolderBadgeIcon.icns");
                    o.drawInRect(new NSRect(new NSPoint(0.0, 0.0), folder.size()), this.NSZeroRect, 2, 1.0);
                    folder.unlockFocus();
                    return this.convert(folder, size);
                }
            }
            return this.iconForPath(FOLDER_PATH, size);
        }
        return this.iconForName("notfound.tiff", size);
    }

    public NSImage convert(NSImage icon, Integer size) {
        return this.convert(icon, size, size);
    }

    public NSImage convert(NSImage icon, Integer width, Integer height) {
        if (null == icon) {
            log.warn((Object)"Icon is null");
            return null;
        }
        if (null == width || null == height) {
            log.info((Object)("Return default size for " + icon.name()));
            return icon;
        }
        icon.setName(icon.name() + width + height);
        icon.setCacheMode(3);
        icon.setScalesWhenResized(true);
        icon.setSize(new NSSize(width.intValue(), height.intValue()));
        return icon;
    }
}

