/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathFactory;
import ch.cyberduck.core.Permission;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.Status;
import ch.cyberduck.core.cf.CFPath;
import ch.cyberduck.core.cloud.CloudPath;
import ch.cyberduck.core.cloud.Distribution;
import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.core.s3.S3Path;
import ch.cyberduck.core.threading.BackgroundAction;
import ch.cyberduck.ui.cocoa.CDBrowserController;
import ch.cyberduck.ui.cocoa.CDBundleController;
import ch.cyberduck.ui.cocoa.CDDateFormatter;
import ch.cyberduck.ui.cocoa.CDIconCache;
import ch.cyberduck.ui.cocoa.CDWindowController;
import ch.cyberduck.ui.cocoa.CDWindowListener;
import ch.cyberduck.ui.cocoa.application.NSAlert;
import ch.cyberduck.ui.cocoa.application.NSButton;
import ch.cyberduck.ui.cocoa.application.NSImageView;
import ch.cyberduck.ui.cocoa.application.NSPopUpButton;
import ch.cyberduck.ui.cocoa.application.NSProgressIndicator;
import ch.cyberduck.ui.cocoa.application.NSTextField;
import ch.cyberduck.ui.cocoa.application.NSTextFieldCell;
import ch.cyberduck.ui.cocoa.application.NSWindow;
import ch.cyberduck.ui.cocoa.application.NSWorkspace;
import ch.cyberduck.ui.cocoa.foundation.NSAttributedString;
import ch.cyberduck.ui.cocoa.foundation.NSMutableAttributedString;
import ch.cyberduck.ui.cocoa.foundation.NSNotification;
import ch.cyberduck.ui.cocoa.foundation.NSNotificationCenter;
import ch.cyberduck.ui.cocoa.foundation.NSURL;
import ch.cyberduck.ui.cocoa.threading.BrowserBackgroundAction;
import ch.cyberduck.ui.cocoa.util.HyperlinkAttributedStringFactory;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.rococoa.Foundation;
import org.rococoa.ID;
import org.rococoa.Rococoa;
import org.rococoa.cocoa.foundation.NSPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDInfoController
extends CDWindowController {
    private static Logger log = Logger.getLogger(CDInfoController.class);
    private List<Path> files;
    private NSTextField filenameField;
    private NSTextField groupField;
    private NSTextField kindField;
    private NSTextField modifiedField;
    private NSTextField ownerField;
    private NSTextField sizeField;
    private NSTextField pathField;
    private NSTextField webUrlField;
    private NSTextField permissionsBox;
    private NSButton recursiveCheckbox;
    private NSButton permissionApplyButton;
    private NSButton distributionApplyButton;
    private NSButton distributionStatusButton;
    private NSButton sizeButton;
    private NSProgressIndicator sizeProgress;
    private NSProgressIndicator permissionProgress;
    private NSProgressIndicator s3Progress;
    private NSProgressIndicator distributionProgress;
    private NSButton distributionEnableButton;
    private NSButton distributionLoggingButton;
    private NSTextField bucketLocationField;
    private NSButton bucketLoggingButton;
    private NSTextField s3PublicUrlField;
    private NSTextField s3torrentUrlField;
    private NSPopUpButton s3CachePopup;
    private NSTextField distributionCnameField;
    private NSTextField distributionStatusField;
    private NSTextField distributionUrlField;
    private NSTextField distributionCnameUrlField;
    public NSButton ownerr;
    public NSButton ownerw;
    public NSButton ownerx;
    public NSButton groupr;
    public NSButton groupw;
    public NSButton groupx;
    public NSButton otherr;
    public NSButton otherw;
    public NSButton otherx;
    private NSImageView iconImageView;
    private NSButton distributionToggle;
    private NSButton permissionToggle;
    private NSButton s3Toggle;
    private CDBrowserController controller;
    private final CDWindowListener browserWindowListener = new CDWindowListener(){

        public void windowWillClose() {
            NSWindow window = CDInfoController.this.window();
            if (null != window) {
                window.close();
            }
        }
    };
    private static NSPoint cascadedWindowPoint;

    public void setFilenameField(NSTextField filenameField) {
        this.filenameField = filenameField;
        NSNotificationCenter.defaultCenter().addObserver(this.id(), Foundation.selector("filenameInputDidEndEditing:"), "NSControlTextDidEndEditingNotification", filenameField);
    }

    public void setGroupField(NSTextField t) {
        this.groupField = t;
    }

    public void setKindField(NSTextField t) {
        this.kindField = t;
    }

    public void setModifiedField(NSTextField t) {
        this.modifiedField = t;
    }

    public void setOwnerField(NSTextField ownerField) {
        this.ownerField = ownerField;
    }

    public void setSizeField(NSTextField sizeField) {
        this.sizeField = sizeField;
    }

    public void setPathField(NSTextField pathField) {
        this.pathField = pathField;
    }

    public void setWebUrlField(NSTextField webUrlField) {
        this.webUrlField = webUrlField;
        this.webUrlField.setAllowsEditingTextAttributes(true);
        this.webUrlField.setSelectable(true);
    }

    public void setPermissionsBox(NSTextField t) {
        this.permissionsBox = t;
    }

    public void setRecursiveCheckbox(NSButton b) {
        this.recursiveCheckbox = b;
        this.recursiveCheckbox.setState(0);
    }

    public void setPermissionApplyButton(NSButton b) {
        this.permissionApplyButton = b;
        this.permissionApplyButton.setTarget(this.id());
        this.permissionApplyButton.setAction(Foundation.selector("permissionApplyButtonClicked:"));
    }

    public void setDistributionApplyButton(NSButton b) {
        this.distributionApplyButton = b;
        this.distributionApplyButton.setTarget(this.id());
        this.distributionApplyButton.setAction(Foundation.selector("distributionApplyButtonClicked:"));
    }

    public void setDistributionStatusButton(NSButton b) {
        this.distributionStatusButton = b;
        this.distributionStatusButton.setTarget(this.id());
        this.distributionStatusButton.setAction(Foundation.selector("distributionStatusButtonClicked:"));
    }

    public void setSizeButton(NSButton b) {
        this.sizeButton = b;
        this.sizeButton.setTarget(this.id());
        this.sizeButton.setAction(Foundation.selector("calculateSizeButtonClicked:"));
    }

    public void setSizeProgress(NSProgressIndicator p) {
        this.sizeProgress = p;
        this.sizeProgress.setDisplayedWhenStopped(false);
        this.sizeProgress.setStyle(1);
    }

    public void setPermissionProgress(NSProgressIndicator p) {
        this.permissionProgress = p;
        this.permissionProgress.setDisplayedWhenStopped(false);
        this.permissionProgress.setStyle(1);
    }

    public void setS3Progress(NSProgressIndicator p) {
        this.s3Progress = p;
        this.s3Progress.setDisplayedWhenStopped(false);
        this.s3Progress.setStyle(1);
    }

    public void setDistributionProgress(NSProgressIndicator p) {
        this.distributionProgress = p;
        this.distributionProgress.setDisplayedWhenStopped(false);
        this.distributionProgress.setStyle(1);
    }

    public void setDistributionEnableButton(NSButton b) {
        this.distributionEnableButton = b;
    }

    public void setDistributionLoggingButton(NSButton b) {
        this.distributionLoggingButton = b;
    }

    public void setBucketLocationField(NSTextField t) {
        this.bucketLocationField = t;
        this.bucketLocationField.setStringValue(Locale.localizedString((String)"Unknown"));
    }

    public void setBucketLoggingButton(NSButton b) {
        this.bucketLoggingButton = b;
        this.bucketLoggingButton.setAction(Foundation.selector("bucketLoggingButtonClicked:"));
    }

    public void setS3PublicUrlField(NSTextField t) {
        this.s3PublicUrlField = t;
        this.s3PublicUrlField.setAllowsEditingTextAttributes(true);
        this.s3PublicUrlField.setSelectable(true);
        this.s3PublicUrlField.setToolTip("Expires in " + Preferences.instance().getDouble("s3.url.expire.seconds") / 60.0 / 60.0 + " hours");
    }

    public void setS3torrentUrlField(NSTextField t) {
        this.s3torrentUrlField = t;
        this.s3torrentUrlField.setAllowsEditingTextAttributes(true);
        this.s3torrentUrlField.setSelectable(true);
    }

    public void setS3CachePopup(NSPopUpButton b) {
        this.s3CachePopup = b;
        this.s3CachePopup.removeAllItems();
        this.s3CachePopup.setTarget(this.id());
        this.s3CachePopup.setAction(Foundation.selector("s3CachePopupClicked:"));
        for (int i = 0; i < this.s3CachePopup.numberOfItems(); ++i) {
            this.s3CachePopup.itemAtIndex(i).setState(0);
        }
        this.s3CachePopup.addItemWithTitle(Locale.localizedString((String)"None"));
        this.s3CachePopup.addItemWithTitle("public,max-age=" + Preferences.instance().getInteger("s3.cache.seconds"));
    }

    public void s3CachePopupClicked(NSPopUpButton sender) {
        if (sender.indexOfSelectedItem() == 0) {
            this.toggleS3Settings(false);
            this.controller.background((BackgroundAction)new BrowserBackgroundAction(this.controller){

                public void run() {
                    for (Path next : CDInfoController.this.files) {
                        ((S3Path)next).setCacheControl(null);
                    }
                }

                public void cleanup() {
                    CDInfoController.this.toggleS3Settings(true);
                }
            });
        }
        if (sender.indexOfSelectedItem() == 1) {
            final String cache = sender.selectedItem().title();
            this.toggleS3Settings(false);
            this.controller.background((BackgroundAction)new BrowserBackgroundAction(this.controller){

                public void run() {
                    for (Path next : CDInfoController.this.files) {
                        ((S3Path)next).setCacheControl(cache);
                    }
                }

                public void cleanup() {
                    CDInfoController.this.toggleS3Settings(true);
                }
            });
        }
    }

    public void setDistributionCnameField(NSTextField t) {
        this.distributionCnameField = t;
    }

    public void setDistributionStatusField(NSTextField t) {
        this.distributionStatusField = t;
    }

    public void setDistributionUrlField(NSTextField t) {
        this.distributionUrlField = t;
        this.distributionUrlField.setAllowsEditingTextAttributes(true);
        this.distributionUrlField.setSelectable(true);
    }

    public void setDistributionCnameUrlField(NSTextField t) {
        this.distributionCnameUrlField = t;
        this.distributionCnameUrlField.setAllowsEditingTextAttributes(true);
        this.distributionCnameUrlField.setSelectable(true);
    }

    public void setOwnerr(NSButton ownerr) {
        this.ownerr = ownerr;
    }

    public void setOwnerw(NSButton ownerw) {
        this.ownerw = ownerw;
    }

    public void setOwnerx(NSButton ownerx) {
        this.ownerx = ownerx;
    }

    public void setGroupr(NSButton groupr) {
        this.groupr = groupr;
    }

    public void setGroupw(NSButton groupw) {
        this.groupw = groupw;
    }

    public void setGroupx(NSButton groupx) {
        this.groupx = groupx;
    }

    public void setOtherr(NSButton otherr) {
        this.otherr = otherr;
    }

    public void setOtherw(NSButton otherw) {
        this.otherw = otherw;
    }

    public void setOtherx(NSButton otherx) {
        this.otherx = otherx;
    }

    public void setIconImageView(NSImageView iconImageView) {
        this.iconImageView = iconImageView;
    }

    public void setDistributionToggle(NSButton b) {
        this.distributionToggle = b;
    }

    public void setPermissionToggle(NSButton t) {
        this.permissionToggle = t;
    }

    public void setS3Toggle(NSButton s3Toggle) {
        this.s3Toggle = s3Toggle;
    }

    @Override
    public void windowWillClose(NSNotification notification) {
        this.window().endEditingFor(null);
        Preferences.instance().setProperty("info.toggle.permission", this.permissionToggle.state());
        Preferences.instance().setProperty("info.toggle.distribution", this.distributionToggle.state());
        Preferences.instance().setProperty("info.toggle.s3", this.s3Toggle.state());
        super.windowWillClose(notification);
    }

    @Override
    public boolean isSingleton() {
        return Preferences.instance().getBoolean("browser.info.isInspector");
    }

    private CDInfoController(CDBrowserController controller, List<Path> files) {
        this.controller = controller;
        this.controller.addListener(this.browserWindowListener);
        this.loadBundle();
        this.setFiles(files);
        this.setState(this.permissionToggle, Preferences.instance().getBoolean("info.toggle.permission"));
        Credentials credentials = controller.getSession().getHost().getCredentials();
        Path path = files.get(0);
        boolean cloud = path instanceof CloudPath && !credentials.isAnonymousLogin();
        boolean amazon = path instanceof S3Path && !credentials.isAnonymousLogin();
        this.setState(this.distributionToggle, cloud && Preferences.instance().getBoolean("info.toggle.distribution"));
        this.distributionToggle.setEnabled(cloud);
        this.setState(this.s3Toggle, amazon && Preferences.instance().getBoolean("info.toggle.s3"));
        this.s3Toggle.setEnabled(amazon);
        this.setState(this.s3Toggle, this.files.get(0) instanceof S3Path && Preferences.instance().getBoolean("info.toggle.s3"));
    }

    @Override
    protected void invalidate() {
        this.controller.removeListener(this.browserWindowListener);
        super.invalidate();
    }

    @Override
    protected String getBundleName() {
        return "Info";
    }

    public void setFiles(List<Path> files) {
        this.files = files;
        this.init();
    }

    @Override
    protected void cascade() {
        cascadedWindowPoint = null == cascadedWindowPoint ? this.window.cascadeTopLeftFromPoint(this.window.frame().origin) : this.window.cascadeTopLeftFromPoint(cascadedWindowPoint);
    }

    @Override
    public void awakeFromNib() {
        this.cascade();
        this.ownerr.setTarget(this.id());
        this.ownerr.setAction(Foundation.selector("permissionSelectionChanged:"));
        this.ownerr.setAllowsMixedState(true);
        this.ownerw.setTarget(this.id());
        this.ownerw.setAction(Foundation.selector("permissionSelectionChanged:"));
        this.ownerw.setAllowsMixedState(true);
        this.ownerx.setTarget(this.id());
        this.ownerx.setAction(Foundation.selector("permissionSelectionChanged:"));
        this.ownerx.setAllowsMixedState(true);
        this.groupr.setTarget(this.id());
        this.groupr.setAction(Foundation.selector("permissionSelectionChanged:"));
        this.groupr.setAllowsMixedState(true);
        this.groupw.setTarget(this.id());
        this.groupw.setAction(Foundation.selector("permissionSelectionChanged:"));
        this.groupw.setAllowsMixedState(true);
        this.groupx.setTarget(this.id());
        this.groupx.setAction(Foundation.selector("permissionSelectionChanged:"));
        this.groupx.setAllowsMixedState(true);
        this.otherr.setTarget(this.id());
        this.otherr.setAction(Foundation.selector("permissionSelectionChanged:"));
        this.otherr.setAllowsMixedState(true);
        this.otherw.setTarget(this.id());
        this.otherw.setAction(Foundation.selector("permissionSelectionChanged:"));
        this.otherw.setAllowsMixedState(true);
        this.otherx.setTarget(this.id());
        this.otherx.setAction(Foundation.selector("permissionSelectionChanged:"));
        this.otherx.setAllowsMixedState(true);
        super.awakeFromNib();
    }

    private void init() {
        int count = this.numberOfFiles();
        if (count > 0) {
            Path file = this.files.get(0);
            this.filenameField.setStringValue(count > 1 ? "(" + Locale.localizedString((String)"Multiple files") + ")" : file.getName());
            this.filenameField.setEnabled(1 == count && file.isRenameSupported());
            if (file.attributes.isSymbolicLink() && file.getSymbolicLinkPath() != null) {
                this.pathField.setAttributedStringValue(NSAttributedString.attributedStringWithAttributes(file.getSymbolicLinkPath(), TRUNCATE_MIDDLE_ATTRIBUTES));
            } else {
                this.pathField.setAttributedStringValue(NSAttributedString.attributedStringWithAttributes(file.getParent().getAbsolute(), TRUNCATE_MIDDLE_ATTRIBUTES));
            }
            this.groupField.setStringValue(count > 1 ? "(" + Locale.localizedString((String)"Multiple files") + ")" : file.attributes.getGroup());
            if (count > 1) {
                this.kindField.setStringValue("(" + Locale.localizedString((String)"Multiple files") + ")");
            } else {
                this.kindField.setAttributedStringValue(NSAttributedString.attributedStringWithAttributes(file.kind(), TRUNCATE_MIDDLE_ATTRIBUTES));
            }
            if (count > 1) {
                this.modifiedField.setStringValue("(" + Locale.localizedString((String)"Multiple files") + ")");
            } else if (-1L == file.attributes.getModificationDate()) {
                this.modifiedField.setAttributedStringValue(NSAttributedString.attributedStringWithAttributes(Locale.localizedString((String)"Unknown"), TRUNCATE_MIDDLE_ATTRIBUTES));
            } else {
                this.modifiedField.setAttributedStringValue(NSAttributedString.attributedStringWithAttributes(CDDateFormatter.getLongFormat(file.attributes.getModificationDate()), TRUNCATE_MIDDLE_ATTRIBUTES));
            }
            this.ownerField.setStringValue(count > 1 ? "(" + Locale.localizedString((String)"Multiple files") + ")" : file.attributes.getOwner());
            this.recursiveCheckbox.setEnabled(true);
            for (Path next : this.files) {
                if (!next.attributes.isFile()) continue;
                this.recursiveCheckbox.setState(0);
                this.recursiveCheckbox.setEnabled(false);
                this.sizeButton.setEnabled(false);
                break;
            }
            this.sizeButton.setEnabled(false);
            for (Path next : this.files) {
                if (!next.attributes.isDirectory()) continue;
                this.sizeButton.setEnabled(true);
                break;
            }
            this.initIcon();
            this.initSize();
            this.initDistribution(file);
            this.initS3(file);
            this.initWebUrl();
            this.initPermissions();
        }
    }

    private void initWebUrl() {
        if (this.numberOfFiles() > 1) {
            this.webUrlField.setStringValue("(" + Locale.localizedString((String)"Multiple files") + ")");
        } else {
            this.controller.background((BackgroundAction)new BrowserBackgroundAction(this.controller){
                String url;

                public void run() {
                    this.url = ((Path)CDInfoController.this.files.get(0)).toHttpURL();
                }

                public void cleanup() {
                    CDInfoController.this.webUrlField.setAttributedStringValue(HyperlinkAttributedStringFactory.create(NSMutableAttributedString.create(this.url, CDBundleController.TRUNCATE_MIDDLE_ATTRIBUTES), this.url));
                }
            });
        }
    }

    private void initPermissions() {
        this.initPermissionsCheckboxes();
        this.togglePermissionSettings(false);
        this.controller.background((BackgroundAction)new BrowserBackgroundAction(this.controller){

            public void run() {
                for (Path next : CDInfoController.this.files) {
                    if (this.isCanceled()) break;
                    if (null != next.attributes.getPermission()) continue;
                    next.readPermission();
                }
            }

            public void cleanup() {
                Permission permission = null;
                for (Path next : CDInfoController.this.files) {
                    permission = next.attributes.getPermission();
                    if (null == permission) {
                        CDInfoController.this.initPermissionsCheckboxes();
                        CDInfoController.this.togglePermissionSettings(false);
                        CDInfoController.this.permissionProgress.stopAnimation(null);
                        return;
                    }
                    CDInfoController.this.updateCheckbox(CDInfoController.this.ownerr, permission.getOwnerPermissions()[0]);
                    CDInfoController.this.updateCheckbox(CDInfoController.this.ownerw, permission.getOwnerPermissions()[1]);
                    CDInfoController.this.updateCheckbox(CDInfoController.this.ownerx, permission.getOwnerPermissions()[2]);
                    if (!(next instanceof CloudPath)) {
                        CDInfoController.this.updateCheckbox(CDInfoController.this.groupr, permission.getGroupPermissions()[0]);
                        CDInfoController.this.updateCheckbox(CDInfoController.this.groupw, permission.getGroupPermissions()[1]);
                        CDInfoController.this.updateCheckbox(CDInfoController.this.groupx, permission.getGroupPermissions()[2]);
                    }
                    CDInfoController.this.updateCheckbox(CDInfoController.this.otherr, permission.getOtherPermissions()[0]);
                    CDInfoController.this.updateCheckbox(CDInfoController.this.otherw, permission.getOtherPermissions()[1]);
                    CDInfoController.this.updateCheckbox(CDInfoController.this.otherx, permission.getOtherPermissions()[2]);
                }
                if (CDInfoController.this.numberOfFiles() > 1) {
                    CDInfoController.this.permissionsBox.setStringValue(Locale.localizedString((String)"Permissions") + " | " + "(" + Locale.localizedString((String)"Multiple files") + ")");
                } else {
                    CDInfoController.this.permissionsBox.setStringValue(Locale.localizedString((String)"Permissions") + " | " + (null == permission ? Locale.localizedString((String)"Unknown") : permission.toString()));
                }
                CDInfoController.this.togglePermissionSettings(true);
            }
        });
    }

    private void updateCheckbox(NSButton checkbox, boolean condition) {
        if (!(checkbox.state() != 0 && checkbox.isEnabled() || condition)) {
            checkbox.setState(0);
        } else if ((checkbox.state() == 1 || !checkbox.isEnabled()) && condition) {
            checkbox.setState(1);
        } else {
            checkbox.setState(-1);
        }
        checkbox.setEnabled(true);
    }

    private void initPermissionsCheckboxes() {
        this.ownerr.setState(0);
        this.ownerw.setState(0);
        this.ownerx.setState(0);
        this.groupr.setState(0);
        this.groupw.setState(0);
        this.groupx.setState(0);
        this.otherr.setState(0);
        this.otherw.setState(0);
        this.otherx.setState(0);
    }

    private void initIcon() {
        if (this.numberOfFiles() > 1) {
            this.iconImageView.setImage(CDIconCache.iconNamed("multipleDocuments", 32));
        } else {
            this.iconImageView.setImage(CDIconCache.instance().iconForPath(this.files.get(0), (Integer)32));
        }
    }

    private void initDistribution(Path file) {
        boolean mosso;
        boolean cloud = file instanceof CloudPath;
        this.distributionStatusField.setStringValue(Locale.localizedString((String)"Unknown"));
        Rococoa.cast(this.distributionCnameField.cell(), NSTextFieldCell.class).setPlaceholderString(Locale.localizedString((String)"Unknown"));
        this.distributionStatusButton.setEnabled(cloud);
        this.distributionApplyButton.setEnabled(cloud);
        this.distributionUrlField.setStringValue(Locale.localizedString((String)"Unknown"));
        this.distributionUrlField.setEnabled(cloud);
        this.distributionStatusField.setStringValue(Locale.localizedString((String)"Unknown"));
        this.distributionStatusField.setEnabled(cloud);
        boolean amazon = file instanceof S3Path;
        this.distributionCnameField.setStringValue(Locale.localizedString((String)"Unknown"));
        this.distributionCnameField.setEnabled(amazon);
        this.distributionLoggingButton.setEnabled(amazon);
        String servicename = "";
        if (amazon) {
            servicename = Locale.localizedString((String)"Amazon CloudFront", (String)"S3");
        }
        if (mosso = file instanceof CFPath) {
            servicename = Locale.localizedString((String)"Mosso Cloud Files", (String)"Mosso");
        }
        this.distributionEnableButton.setEnabled(cloud);
        this.distributionEnableButton.setTitle(MessageFormat.format(Locale.localizedString((String)"Enable {0} Distribution", (String)"Status"), servicename));
        if (cloud) {
            this.distributionStatusButtonClicked(null);
        }
    }

    private void initSize() {
        this.sizeProgress.startAnimation(null);
        this.controller.background((BackgroundAction)new BrowserBackgroundAction(this.controller){
            long size;
            {
                this.size = 0L;
            }

            public void run() {
                for (Path next : CDInfoController.this.files) {
                    if (-1L == next.attributes.getSize()) {
                        next.readSize();
                    }
                    this.size += next.attributes.getSize();
                }
            }

            public void cleanup() {
                CDInfoController.this.sizeField.setAttributedStringValue(NSAttributedString.attributedStringWithAttributes(Status.getSizeAsString((double)this.size) + " (" + this.size + " bytes)", CDBundleController.TRUNCATE_MIDDLE_ATTRIBUTES));
                CDInfoController.this.sizeProgress.stopAnimation(null);
            }
        });
    }

    private void toggleS3Settings(boolean enabled) {
        this.bucketLoggingButton.setEnabled(enabled);
        this.s3CachePopup.setEnabled(enabled);
        if (enabled) {
            this.s3Progress.stopAnimation(null);
        } else {
            this.s3Progress.startAnimation(null);
        }
    }

    private void initS3(Path file) {
        Credentials credentials = file.getHost().getCredentials();
        boolean amazon = file instanceof S3Path && !credentials.isAnonymousLogin();
        this.bucketLocationField.setStringValue(Locale.localizedString((String)"Unknown"));
        this.bucketLocationField.setEnabled(amazon);
        this.s3CachePopup.setEnabled(amazon && file.attributes.isFile());
        this.bucketLoggingButton.setEnabled(amazon);
        this.bucketLoggingButton.setToolTip("");
        this.s3PublicUrlField.setStringValue(Locale.localizedString((String)"Unknown"));
        this.s3torrentUrlField.setStringValue(Locale.localizedString((String)"Unknown"));
        if (amazon) {
            final S3Path s3 = (S3Path)file;
            if (file.attributes.isFile()) {
                if (this.numberOfFiles() > 1) {
                    this.s3PublicUrlField.setStringValue("(" + Locale.localizedString((String)"Multiple files") + ")");
                    this.s3torrentUrlField.setStringValue("(" + Locale.localizedString((String)"Multiple files") + ")");
                } else {
                    String signedUrl = s3.createSignedUrl();
                    this.s3PublicUrlField.setAttributedStringValue(HyperlinkAttributedStringFactory.create(NSMutableAttributedString.create(signedUrl, TRUNCATE_MIDDLE_ATTRIBUTES), signedUrl));
                    String torrent = s3.createTorrentUrl();
                    this.s3torrentUrlField.setAttributedStringValue(HyperlinkAttributedStringFactory.create(NSMutableAttributedString.create(torrent, TRUNCATE_MIDDLE_ATTRIBUTES), torrent));
                }
            }
            this.bucketLoggingButton.setToolTip(s3.getContainerName() + "/" + Preferences.instance().getProperty("s3.logging.prefix"));
            this.toggleS3Settings(false);
            this.controller.background((BackgroundAction)new BrowserBackgroundAction(this.controller){
                String location;
                boolean logging;
                Map metadata;
                {
                    super(x0);
                    this.location = null;
                    this.metadata = null;
                }

                public void run() {
                    this.location = s3.getLocation();
                    if (null == this.location) {
                        this.location = "US";
                    }
                    this.logging = s3.isLogging();
                    this.metadata = s3.getMetadata();
                }

                public void cleanup() {
                    String cache;
                    CDInfoController.this.bucketLoggingButton.setState(this.logging ? 1 : 0);
                    if (StringUtils.isNotBlank((String)this.location)) {
                        CDInfoController.this.bucketLocationField.setStringValue(this.location);
                    }
                    if (this.metadata.containsKey("Cache-Control") && StringUtils.isNotBlank((String)(cache = (String)this.metadata.get("Cache-Control")))) {
                        if (CDInfoController.this.s3CachePopup.indexOfItemWithTitle(cache) == -1) {
                            CDInfoController.this.s3CachePopup.addItemWithTitle(cache);
                        }
                        CDInfoController.this.s3CachePopup.selectItemWithTitle(cache);
                    }
                    CDInfoController.this.toggleS3Settings(true);
                }
            });
        }
    }

    public void bucketLoggingButtonClicked(Object sender) {
        this.toggleS3Settings(false);
        this.controller.background((BackgroundAction)new BrowserBackgroundAction(this.controller){

            public void run() {
                block0: {
                    Iterator i$ = CDInfoController.this.files.iterator();
                    if (!i$.hasNext()) break block0;
                    Path next = (Path)i$.next();
                    ((S3Path)next).setLogging(CDInfoController.this.bucketLoggingButton.state() == 1);
                }
            }

            public void cleanup() {
                CDInfoController.this.toggleS3Settings(true);
            }
        });
    }

    private int numberOfFiles() {
        return null == this.files ? 0 : this.files.size();
    }

    public void filenameInputDidEndEditing(NSNotification sender) {
        if (this.numberOfFiles() == 1) {
            Path current = this.files.get(0);
            if (!this.filenameField.stringValue().equals(current.getName())) {
                if (this.filenameField.stringValue().indexOf(47) == -1) {
                    Path renamed = PathFactory.createPath((Session)this.controller.workdir().getSession(), (String)current.getParent().getAbsolute(), (String)this.filenameField.stringValue(), (int)current.attributes.getType());
                    this.controller.renamePath(current, renamed);
                } else if (StringUtils.isBlank((String)this.filenameField.stringValue())) {
                    this.filenameField.setStringValue(current.getName());
                    this.initWebUrl();
                } else {
                    this.alert(NSAlert.alert(Locale.localizedString((String)"Error"), Locale.localizedString((String)"Invalid character in filename."), Locale.localizedString((String)"OK"), null, null));
                }
            }
        }
    }

    private Permission getPermissionFromSelection() {
        boolean[][] p = new boolean[3][3];
        p[0][0] = this.ownerr.state() == 1;
        p[0][1] = this.ownerw.state() == 1;
        p[0][2] = this.ownerx.state() == 1;
        p[1][0] = this.groupr.state() == 1;
        p[1][1] = this.groupw.state() == 1;
        p[1][2] = this.groupx.state() == 1;
        p[2][0] = this.otherr.state() == 1;
        p[2][1] = this.otherw.state() == 1;
        p[2][2] = this.otherx.state() == 1;
        return new Permission(p);
    }

    public void permissionSelectionChanged(NSButton sender) {
        if (sender.state() == -1) {
            sender.setState(1);
        }
        Permission permission = this.getPermissionFromSelection();
        this.permissionsBox.setStringValue(Locale.localizedString((String)"Permissions") + " | " + permission.toString());
    }

    public void permissionApplyButtonClicked(ID sender) {
        this.togglePermissionSettings(false);
        this.permissionProgress.startAnimation(null);
        final Permission permission = this.getPermissionFromSelection();
        this.controller.background((BackgroundAction)new BrowserBackgroundAction(this.controller){

            public void run() {
                for (Path next : CDInfoController.this.files) {
                    next.writePermissions(permission, CDInfoController.this.recursiveCheckbox.state() == 1);
                    if (!CDInfoController.this.controller.isConnected()) break;
                    next.getParent().invalidate();
                }
            }

            public void cleanup() {
                CDInfoController.this.controller.reloadData(true);
                CDInfoController.this.togglePermissionSettings(true);
                CDInfoController.this.permissionProgress.stopAnimation(null);
            }

            public String getActivity() {
                return MessageFormat.format(Locale.localizedString((String)"Changing permission of {0} to {1}", (String)"Status"), ((Path)CDInfoController.this.files.get(0)).getName(), permission);
            }
        });
    }

    private void togglePermissionSettings(boolean enabled) {
        for (Path next : this.files) {
            if (next.isWritePermissionsSupported()) continue;
            enabled = false;
        }
        this.permissionApplyButton.setEnabled(enabled);
        this.recursiveCheckbox.setEnabled(enabled);
        this.ownerr.setEnabled(enabled);
        this.ownerw.setEnabled(enabled);
        this.ownerx.setEnabled(enabled);
        this.groupr.setEnabled(enabled);
        this.groupw.setEnabled(enabled);
        this.groupx.setEnabled(enabled);
        this.otherr.setEnabled(enabled);
        this.otherw.setEnabled(enabled);
        this.otherx.setEnabled(enabled);
        if (enabled) {
            this.permissionProgress.stopAnimation(null);
        } else {
            this.permissionProgress.startAnimation(null);
        }
    }

    private void toggleDistributionSettings(boolean statusEnabled, boolean applyEnabled) {
        this.distributionStatusButton.setEnabled(statusEnabled);
        this.distributionEnableButton.setEnabled(applyEnabled);
        this.distributionLoggingButton.setEnabled(applyEnabled && statusEnabled);
        this.distributionApplyButton.setEnabled(applyEnabled);
        this.distributionLoggingButton.setEnabled(statusEnabled);
        if (statusEnabled) {
            this.distributionProgress.stopAnimation(null);
        } else {
            this.distributionProgress.startAnimation(null);
        }
    }

    public void distributionApplyButtonClicked(final ID sender) {
        this.toggleDistributionSettings(false, false);
        this.controller.background((BackgroundAction)new BrowserBackgroundAction(this.controller){

            public void run() {
                block2: {
                    Iterator i$ = CDInfoController.this.files.iterator();
                    if (!i$.hasNext()) break block2;
                    Path next = (Path)i$.next();
                    if (StringUtils.isNotBlank((String)CDInfoController.this.distributionCnameField.stringValue())) {
                        ((CloudPath)next).writeDistribution(CDInfoController.this.distributionEnableButton.state() == 1, StringUtils.split((String)CDInfoController.this.distributionCnameField.stringValue()), CDInfoController.this.distributionLoggingButton.state() == 1);
                    } else {
                        ((CloudPath)next).writeDistribution(CDInfoController.this.distributionEnableButton.state() == 1, new String[]{}, CDInfoController.this.distributionLoggingButton.state() == 1);
                    }
                }
            }

            public void cleanup() {
                CDInfoController.this.distributionStatusButtonClicked(sender);
            }
        });
    }

    public void distributionStatusButtonClicked(ID sender) {
        this.toggleDistributionSettings(false, false);
        this.controller.background((BackgroundAction)new BrowserBackgroundAction(this.controller){
            Distribution distribution;

            public void run() {
                block0: {
                    Iterator i$ = CDInfoController.this.files.iterator();
                    if (!i$.hasNext()) break block0;
                    Path next = (Path)i$.next();
                    this.distribution = ((CloudPath)next).readDistribution();
                }
            }

            public void cleanup() {
                block5: {
                    Object[] cnames;
                    String key;
                    block4: {
                        CDInfoController.this.toggleDistributionSettings(true, !this.distribution.isInprogress());
                        CDInfoController.this.distributionEnableButton.setState(this.distribution.isEnabled() ? 1 : 0);
                        CDInfoController.this.distributionStatusField.setStringValue(this.distribution.getStatus());
                        CDInfoController.this.distributionLoggingButton.setState(this.distribution.isLogging() ? 1 : 0);
                        CloudPath file = (CloudPath)CDInfoController.this.files.get(0);
                        CDInfoController.this.distributionLoggingButton.setEnabled(file instanceof S3Path);
                        String string = key = file.isContainer() ? "" : file.encode(file.getKey());
                        if (CDInfoController.this.numberOfFiles() > 1) {
                            CDInfoController.this.distributionUrlField.setStringValue("(" + Locale.localizedString((String)"Multiple files") + ")");
                            CDInfoController.this.distributionCnameUrlField.setStringValue("(" + Locale.localizedString((String)"Multiple files") + ")");
                        } else if (null == this.distribution.getUrl()) {
                            CDInfoController.this.distributionUrlField.setStringValue(Locale.localizedString((String)"Unknown"));
                        } else {
                            String url = this.distribution.getUrl() + key;
                            CDInfoController.this.distributionUrlField.setAttributedStringValue(HyperlinkAttributedStringFactory.create(NSMutableAttributedString.create(url, CDBundleController.TRUNCATE_MIDDLE_ATTRIBUTES), url));
                        }
                        cnames = this.distribution.getCNAMEs();
                        if (0 != cnames.length) break block4;
                        CDInfoController.this.distributionCnameField.setStringValue("");
                        CDInfoController.this.distributionCnameUrlField.setStringValue("");
                        break block5;
                    }
                    CDInfoController.this.distributionCnameField.setStringValue(StringUtils.join((Object[])cnames, (char)' '));
                    Object[] arr$ = cnames;
                    int len$ = arr$.length;
                    int i$ = 0;
                    if (i$ >= len$) break block5;
                    Object cname = arr$[i$];
                    String url = "http://" + (String)cname + key;
                    CDInfoController.this.distributionCnameUrlField.setAttributedStringValue(HyperlinkAttributedStringFactory.create(NSMutableAttributedString.create(url, CDBundleController.TRUNCATE_MIDDLE_ATTRIBUTES), url));
                }
            }
        });
    }

    public void calculateSizeButtonClicked(ID sender) {
        log.debug((Object)"calculateSizeButtonClicked");
        this.sizeButton.setEnabled(false);
        this.sizeProgress.startAnimation(null);
        this.controller.background((BackgroundAction)new BrowserBackgroundAction(this.controller){

            public void run() {
                for (Path next : CDInfoController.this.files) {
                    this.calculateSize((AbstractPath)next);
                    if (CDInfoController.this.controller.isConnected()) continue;
                    break;
                }
            }

            public void cleanup() {
                CDInfoController.this.controller.reloadData(true);
                CDInfoController.this.initSize();
                CDInfoController.this.sizeButton.setEnabled(true);
                CDInfoController.this.sizeProgress.stopAnimation(null);
            }

            private double calculateSize(AbstractPath p) {
                if (p.attributes.isDirectory()) {
                    long size = 0L;
                    for (AbstractPath next : p.childs()) {
                        size = (long)((double)size + this.calculateSize(next));
                    }
                    p.attributes.setSize(size);
                }
                return p.attributes.getSize();
            }

            public String getActivity() {
                return MessageFormat.format(Locale.localizedString((String)"Getting size of {0}", (String)"Status"), ((Path)CDInfoController.this.files.get(0)).getName());
            }
        });
    }

    @Override
    public void helpButtonClicked(NSButton sender) {
        NSWorkspace.sharedWorkspace().openURL(NSURL.URLWithString(Preferences.instance().getProperty("website.help") + "/howto/s3"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory {
        private static Map<List<Path>, CDInfoController> open = new HashMap<List<Path>, CDInfoController>();

        public static CDInfoController create(CDBrowserController controller, final List<Path> files) {
            if (open.containsKey(files)) {
                return open.get(files);
            }
            CDInfoController c = new CDInfoController(controller, files){

                public void windowWillClose(NSNotification notification) {
                    open.remove(files);
                    super.windowWillClose(notification);
                }
            };
            open.put(files, c);
            return c;
        }
    }
}

