/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.Collection;
import ch.cyberduck.core.DownloadTransfer;
import ch.cyberduck.core.HistoryCollection;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostCollection;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathFactory;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.Rendezvous;
import ch.cyberduck.core.RendezvousListener;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.SessionFactory;
import ch.cyberduck.core.Transfer;
import ch.cyberduck.core.UploadTransfer;
import ch.cyberduck.core.aquaticprime.License;
import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.core.serializer.HostReaderFactory;
import ch.cyberduck.core.threading.AbstractBackgroundAction;
import ch.cyberduck.core.threading.BackgroundAction;
import ch.cyberduck.core.threading.DefaultMainAction;
import ch.cyberduck.core.threading.MainAction;
import ch.cyberduck.core.util.URLSchemeHandlerConfiguration;
import ch.cyberduck.ui.cocoa.CDActivityController;
import ch.cyberduck.ui.cocoa.CDBrowserController;
import ch.cyberduck.ui.cocoa.CDBundleController;
import ch.cyberduck.ui.cocoa.CDDownloadController;
import ch.cyberduck.ui.cocoa.CDPreferencesController;
import ch.cyberduck.ui.cocoa.CDTransferController;
import ch.cyberduck.ui.cocoa.CDWindowController;
import ch.cyberduck.ui.cocoa.CDWindowListener;
import ch.cyberduck.ui.cocoa.application.NSAlert;
import ch.cyberduck.ui.cocoa.application.NSApplication;
import ch.cyberduck.ui.cocoa.application.NSButton;
import ch.cyberduck.ui.cocoa.application.NSMenu;
import ch.cyberduck.ui.cocoa.application.NSMenuItem;
import ch.cyberduck.ui.cocoa.application.NSWindow;
import ch.cyberduck.ui.cocoa.application.NSWorkspace;
import ch.cyberduck.ui.cocoa.delegate.ArchiveMenuDelegate;
import ch.cyberduck.ui.cocoa.delegate.BookmarkMenuDelegate;
import ch.cyberduck.ui.cocoa.delegate.EditMenuDelegate;
import ch.cyberduck.ui.cocoa.delegate.HistoryMenuDelegate;
import ch.cyberduck.ui.cocoa.delegate.RendezvousMenuDelegate;
import ch.cyberduck.ui.cocoa.foundation.NSAppleEventDescriptor;
import ch.cyberduck.ui.cocoa.foundation.NSAppleEventManager;
import ch.cyberduck.ui.cocoa.foundation.NSArray;
import ch.cyberduck.ui.cocoa.foundation.NSBundle;
import ch.cyberduck.ui.cocoa.foundation.NSDictionary;
import ch.cyberduck.ui.cocoa.foundation.NSMutableArray;
import ch.cyberduck.ui.cocoa.foundation.NSNotification;
import ch.cyberduck.ui.cocoa.foundation.NSURL;
import ch.cyberduck.ui.growl.Growl;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.rococoa.Foundation;
import org.rococoa.ID;
import org.rococoa.cocoa.foundation.NSUInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDMainController
extends CDBundleController
implements NSApplication.Delegate {
    private static Logger log = Logger.getLogger(CDMainController.class);
    public static final int kInternetEventClass = 1196773964;
    public static final int kAEGetURL = 1196773964;
    public static final int kAEFetchURL = 1179996748;
    public static final int keyAEResult = 0x2D2D2D2D;
    private NSMenu encodingMenu;
    private NSMenu columnMenu;
    private NSMenu editMenu;
    private EditMenuDelegate editMenuDelegate;
    private NSMenu archiveMenu;
    private ArchiveMenuDelegate archiveMenuDelegate;
    private NSMenu bookmarkMenu;
    private BookmarkMenuDelegate bookmarkMenuDelegate;
    private NSMenu historyMenu;
    private HistoryMenuDelegate historyMenuDelegate;
    private NSMenu rendezvousMenu;
    private RendezvousMenuDelegate rendezvousMenuDelegate;
    private HistoryCollection sessions = new HistoryCollection(LocalFactory.createLocal((String)Preferences.instance().getProperty("application.support.path"), (String)"Sessions"));
    private boolean donationPrompt = true;
    private CDWindowController donationController;
    private static List<CDBrowserController> browsers = new ArrayList<CDBrowserController>();

    public CDMainController() {
        this.loadBundle();
    }

    @Override
    public void awakeFromNib() {
        NSAppleEventManager.sharedAppleEventManager().setEventHandler_andSelector_forEventClass_andEventID(this.id(), Foundation.selector("handleGetURLEvent:withReplyEvent:"), 1196773964, 1196773964);
        super.awakeFromNib();
    }

    public void handleGetURLEvent_withReplyEvent(NSAppleEventDescriptor event, NSAppleEventDescriptor reply) {
        Session s;
        Path p;
        log.debug((Object)("Received URL from Apple Event:" + event));
        NSAppleEventDescriptor param = event.paramDescriptorForKeyword(0x2D2D2D2D);
        if (null == param) {
            log.error((Object)"No URL parameter");
            return;
        }
        String url = param.stringValue();
        if (StringUtils.isEmpty((String)url)) {
            log.error((Object)"URL parameter is empty");
            return;
        }
        Host h = Host.parse((String)url);
        if (StringUtils.isNotEmpty((String)h.getDefaultPath()) && !h.getDefaultPath().endsWith("/") && StringUtils.isNotBlank((String)(p = PathFactory.createPath((Session)(s = SessionFactory.createSession((Host)h)), (String)h.getDefaultPath(), (int)1)).getExtension())) {
            CDTransferController.instance().startTransfer((Transfer)new DownloadTransfer(p));
            return;
        }
        CDBrowserController doc = CDMainController.newDocument();
        doc.mount(h);
    }

    public void setEncodingMenu(NSMenu encodingMenu) {
        this.encodingMenu = encodingMenu;
        for (String charset : CDMainController.availableCharsets()) {
            this.encodingMenu.addItemWithTitle_action_keyEquivalent(charset, Foundation.selector("encodingMenuClicked:"), "");
        }
    }

    public void setColumnMenu(NSMenu columnMenu) {
        this.columnMenu = columnMenu;
        HashMap<String, String> columns = new HashMap<String, String>();
        columns.put("browser.columnKind", Locale.localizedString((String)"Kind"));
        columns.put("browser.columnSize", Locale.localizedString((String)"Size"));
        columns.put("browser.columnModification", Locale.localizedString((String)"Modified"));
        columns.put("browser.columnOwner", Locale.localizedString((String)"Owner"));
        columns.put("browser.columnGroup", Locale.localizedString((String)"Group"));
        columns.put("browser.columnPermissions", Locale.localizedString((String)"Permissions"));
        Iterator identifiers = columns.keySet().iterator();
        int i = 0;
        Iterator iter = columns.values().iterator();
        while (iter.hasNext()) {
            NSMenuItem item = this.columnMenu.addItemWithTitle_action_keyEquivalent((String)iter.next(), Foundation.selector("columnMenuClicked:"), "");
            String identifier = (String)identifiers.next();
            item.setState(Preferences.instance().getBoolean(identifier) ? 1 : 0);
            item.setRepresentedObject(identifier);
            ++i;
        }
    }

    public void columnMenuClicked(NSMenuItem sender) {
        String identifier = sender.representedObject();
        boolean enabled = !Preferences.instance().getBoolean(identifier);
        sender.setState(enabled ? 1 : 0);
        Preferences.instance().setProperty(identifier, enabled);
        CDBrowserController.updateBrowserTableColumns();
    }

    public void setEditMenu(NSMenu editMenu) {
        this.editMenu = editMenu;
        this.editMenuDelegate = new EditMenuDelegate();
        this.editMenu.setDelegate(this.editMenuDelegate.id());
    }

    public void setArchiveMenu(NSMenu archiveMenu) {
        this.archiveMenu = archiveMenu;
        this.archiveMenuDelegate = new ArchiveMenuDelegate();
        this.archiveMenu.setDelegate(this.archiveMenuDelegate.id());
    }

    public void setBookmarkMenu(NSMenu bookmarkMenu) {
        this.bookmarkMenu = bookmarkMenu;
        this.bookmarkMenuDelegate = new BookmarkMenuDelegate();
        this.bookmarkMenu.setDelegate(this.bookmarkMenuDelegate.id());
    }

    public void setHistoryMenu(NSMenu historyMenu) {
        this.historyMenu = historyMenu;
        this.historyMenuDelegate = new HistoryMenuDelegate();
        this.historyMenu.setDelegate(this.historyMenuDelegate.id());
    }

    public void setRendezvousMenu(NSMenu rendezvousMenu) {
        this.rendezvousMenu = rendezvousMenu;
        this.rendezvousMenuDelegate = new RendezvousMenuDelegate();
        this.rendezvousMenu.setDelegate(this.rendezvousMenuDelegate.id());
    }

    public void historyMenuClicked(NSMenuItem sender) {
        NSWorkspace.sharedWorkspace().openFile(HistoryCollection.defaultCollection().getFile().getAbsolute());
    }

    public void bugreportMenuClicked(ID sender) {
        NSWorkspace.sharedWorkspace().openURL(NSURL.URLWithString(Preferences.instance().getProperty("website.bug")));
    }

    public void helpMenuClicked(ID sender) {
        NSWorkspace.sharedWorkspace().openURL(NSURL.URLWithString(Preferences.instance().getProperty("website.help")));
    }

    public void faqMenuClicked(ID sender) {
        NSWorkspace.sharedWorkspace().openFile(new File(NSBundle.mainBundle().pathForResource_ofType("Cyberduck FAQ", "rtfd")).toString());
    }

    public void licenseMenuClicked(ID sender) {
        NSWorkspace.sharedWorkspace().openFile(new File(NSBundle.mainBundle().pathForResource_ofType("License", "txt")).toString());
    }

    public void acknowledgmentsMenuClicked(ID sender) {
        NSWorkspace.sharedWorkspace().openFile(new File(NSBundle.mainBundle().pathForResource_ofType("Acknowledgments", "rtf")).toString());
    }

    public void websiteMenuClicked(ID sender) {
        NSWorkspace.sharedWorkspace().openURL(NSURL.URLWithString(Preferences.instance().getProperty("website.home")));
    }

    public void forumMenuClicked(ID sender) {
        NSWorkspace.sharedWorkspace().openURL(NSURL.URLWithString(Preferences.instance().getProperty("website.forum")));
    }

    public void donateMenuClicked(ID sender) {
        NSWorkspace.sharedWorkspace().openURL(NSURL.URLWithString(Preferences.instance().getProperty("website.donate")));
    }

    public void aboutMenuClicked(ID sender) {
        NSDictionary dict = NSDictionary.dictionaryWithObjectsForKeys(NSArray.arrayWithObjects(NSBundle.mainBundle().objectForInfoDictionaryKey("CFBundleShortVersionString").toString(), ""), NSArray.arrayWithObjects("ApplicationVersion", "Version"));
        NSApplication.sharedApplication().orderFrontStandardAboutPanelWithOptions(dict);
    }

    public void feedbackMenuClicked(ID sender) {
        String versionString = NSBundle.mainBundle().objectForInfoDictionaryKey("CFBundleVersion").toString();
        NSWorkspace.sharedWorkspace().openURL(NSURL.URLWithString(Preferences.instance().getProperty("mail.feedback") + "?subject=" + NSBundle.mainBundle().objectForInfoDictionaryKey("CFBundleName") + "-" + versionString));
    }

    public void preferencesMenuClicked(ID sender) {
        CDPreferencesController controller = CDPreferencesController.instance();
        controller.window().makeKeyAndOrderFront(null);
    }

    public void newDownloadMenuClicked(ID sender) {
        this.showTransferQueueClicked(sender);
        CDDownloadController c = new CDDownloadController(CDTransferController.instance());
        c.beginSheet();
    }

    public void newBrowserMenuClicked(ID sender) {
        this.openDefaultBookmark(CDMainController.newDocument(true));
    }

    public void showTransferQueueClicked(ID sender) {
        CDTransferController c = CDTransferController.instance();
        c.window().makeKeyAndOrderFront(null);
    }

    public void showActivityWindowClicked(ID sender) {
        CDActivityController c = CDActivityController.instance();
        if (c.isVisible()) {
            c.window().close();
        } else {
            c.window().orderFront(null);
        }
    }

    @Override
    public boolean application_openFile(NSApplication app, String filename) {
        log.debug((Object)("applicationOpenFile:" + filename));
        Local f = LocalFactory.createLocal((String)filename);
        if (f.exists()) {
            if ("duck".equals(f.getExtension())) {
                Host host = (Host)HostReaderFactory.instance().read(f);
                CDMainController.newDocument().mount(host);
                return true;
            }
            if ("cyberducklicense".equals(f.getExtension())) {
                License l = new License(f);
                if (l.verify()) {
                    String to = l.getValue("Name");
                    if (StringUtils.isBlank((String)to)) {
                        to = l.getValue("Email");
                    }
                    NSAlert alert = NSAlert.alert(MessageFormat.format(Locale.localizedString((String)"Registered to {0}", (String)"License"), to), Locale.localizedString((String)"Thanks for your support! Your contribution helps to further advance development to make Cyberduck even better.", (String)"License") + "\n\n" + Locale.localizedString((String)"Your donation key has been copied to the Application Support folder.", (String)"License"), Locale.localizedString((String)"Continue"), null, null);
                    alert.setAlertStyle(1);
                    if (alert.runModal() == 1) {
                        f.copy((AbstractPath)LocalFactory.createLocal((String)Preferences.instance().getProperty("application.support.path"), (String)f.getName()));
                    }
                } else {
                    NSAlert alert = NSAlert.alert(Locale.localizedString((String)"Not a valid donation key", (String)"License"), Locale.localizedString((String)"This donation key does not appear to be valid.", (String)"License"), Locale.localizedString((String)"Continue"), null, null);
                    alert.setAlertStyle(0);
                    alert.runModal();
                }
                return true;
            }
            for (CDBrowserController controller : browsers) {
                if (!controller.isMounted()) continue;
                Path workdir = controller.workdir();
                Session session = controller.getTransferSession();
                UploadTransfer q = new UploadTransfer(PathFactory.createPath((Session)session, (String)workdir.getAbsolute(), (Local)f));
                controller.transfer((Transfer)q, workdir);
                break;
            }
        }
        return false;
    }

    @Override
    public boolean application_openTempFile(NSApplication app, String filename) {
        log.debug((Object)("applicationOpenTempFile:" + filename));
        return this.application_openFile(app, filename);
    }

    @Override
    public boolean applicationShouldOpenUntitledFile(NSApplication sender) {
        log.debug((Object)"applicationShouldOpenUntitledFile");
        return Preferences.instance().getBoolean("browser.openUntitled");
    }

    @Override
    public boolean applicationOpenUntitledFile(NSApplication app) {
        log.debug((Object)"applicationOpenUntitledFile");
        return false;
    }

    private void openDefaultBookmark(CDBrowserController controller) {
        String defaultBookmark = Preferences.instance().getProperty("browser.defaultBookmark");
        if (null == defaultBookmark) {
            return;
        }
        for (Host bookmark : HostCollection.defaultCollection()) {
            if (!bookmark.getNickname().equals(defaultBookmark)) continue;
            controller.mount(bookmark);
            return;
        }
    }

    @Override
    public boolean applicationShouldHandleReopen_hasVisibleWindows(NSApplication app, boolean visibleWindowsFound) {
        log.debug((Object)"applicationShouldHandleReopen");
        if (browsers.size() == 0 && !CDTransferController.instance().isVisible()) {
            this.openDefaultBookmark(CDMainController.newDocument());
        }
        NSWindow miniaturized = null;
        for (CDBrowserController controller : browsers) {
            if (!controller.window().isMiniaturized()) {
                return false;
            }
            if (null != miniaturized) continue;
            miniaturized = controller.window();
        }
        if (null == miniaturized) {
            return false;
        }
        miniaturized.deminiaturize(null);
        return false;
    }

    @Override
    public void applicationDidFinishLaunching(NSNotification notification) {
        log.info((Object)("Running Java " + System.getProperty("java.version") + " on " + System.getProperty("os.arch")));
        if (log.isInfoEnabled()) {
            log.info((Object)("Available localizations:" + NSBundle.mainBundle().localizations()));
        }
        if (Preferences.instance().getBoolean("browser.serialize")) {
            this.background((BackgroundAction)new AbstractBackgroundAction(){

                public void run() {
                    CDMainController.this.sessions.load();
                }

                public void cleanup() {
                    if (CDMainController.this.sessions.isEmpty() && Preferences.instance().getBoolean("browser.openUntitled")) {
                        CDMainController.this.openDefaultBookmark(CDMainController.newDocument());
                    }
                    for (Host host : CDMainController.this.sessions) {
                        CDMainController.newDocument(true).mount(host);
                    }
                    CDMainController.this.sessions.clear();
                }
            });
        } else if (Preferences.instance().getBoolean("browser.openUntitled")) {
            this.openDefaultBookmark(CDMainController.newDocument());
        }
        if (Preferences.instance().getBoolean("queue.openByDefault")) {
            this.showTransferQueueClicked(null);
        }
        this.background((BackgroundAction)new AbstractBackgroundAction(){

            public void run() {
                HostCollection.defaultCollection().load();
            }

            public void cleanup() {
            }
        });
        this.background((BackgroundAction)new AbstractBackgroundAction(){

            public void run() {
                HistoryCollection.defaultCollection().load();
            }

            public void cleanup() {
            }
        });
        this.background((BackgroundAction)new AbstractBackgroundAction(){

            public void run() {
                Growl.instance().register();
            }

            public void cleanup() {
            }
        });
        Rendezvous.instance().addListener(new RendezvousListener(){

            public void serviceResolved(final String identifier, String hostname) {
                if (Preferences.instance().getBoolean("rendezvous.loopback.supress")) {
                    try {
                        if (InetAddress.getByName(hostname).equals(InetAddress.getLocalHost())) {
                            log.info((Object)("Supressed Rendezvous notification for " + hostname));
                            return;
                        }
                    }
                    catch (UnknownHostException unknownHostException) {
                        // empty catch block
                    }
                }
                CDMainController.this.invoke((MainAction)new DefaultMainAction(){

                    public void run() {
                        Growl.instance().notifyWithImage("Bonjour", Rendezvous.instance().getDisplayedName(identifier), "rendezvous");
                    }
                });
            }

            public void serviceLost(String servicename) {
            }
        });
        if (Preferences.instance().getBoolean("defaulthandler.reminder") && !URLSchemeHandlerConfiguration.instance().isDefaultHandlerForURLScheme(new String[]{Protocol.FTP.getScheme(), Protocol.FTP_TLS.getScheme(), Protocol.SFTP.getScheme()})) {
            NSAlert alert = NSAlert.alert(Locale.localizedString((String)"Set Cyberduck as default application for FTP and SFTP locations?", (String)"Configuration"), Locale.localizedString((String)"As the default application, Cyberduck will open when you click on FTP or SFTP links in other applications, such as your web browser. You can change this setting in the Preferences later.", (String)"Configuration"), Locale.localizedString((String)"Change", (String)"Configuration"), Locale.localizedString((String)"Don't Ask Again", (String)"Configuration"), Locale.localizedString((String)"Cancel", (String)"Configuration"));
            alert.setAlertStyle(1);
            int choice = alert.runModal();
            if (choice == 1) {
                URLSchemeHandlerConfiguration.instance().setDefaultHandlerForURLScheme(new String[]{Protocol.FTP.getScheme(), Protocol.FTP_TLS.getScheme(), Protocol.SFTP.getScheme()}, NSBundle.mainBundle().infoDictionary().objectForKey("CFBundleIdentifier").toString());
            }
            if (choice == 0) {
                Preferences.instance().setProperty("defaulthandler.reminder", false);
            }
        }
        NSWorkspace.sharedWorkspace().notificationCenter().addObserver(this.id(), Foundation.selector("workspaceWillPowerOff:"), "NSWorkspaceWillPowerOffNotification", null);
        NSWorkspace.sharedWorkspace().notificationCenter().addObserver(this.id(), Foundation.selector("workspaceWillLogout:"), "NSWorkspaceSessionDidResignActiveNotification", null);
        NSWorkspace.sharedWorkspace().notificationCenter().addObserver(this.id(), Foundation.selector("workspaceWillSleep:"), "NSWorkspaceWillSleepNotification", null);
        if (Preferences.instance().getBoolean("rendezvous.enable")) {
            this.background((BackgroundAction)new AbstractBackgroundAction(){

                public void run() {
                    Rendezvous.instance().init();
                }

                public void cleanup() {
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NSUInteger applicationShouldTerminate(NSApplication app) {
        log.debug((Object)"applicationShouldTerminate");
        if (this.donationPrompt) {
            block12: {
                try {
                    License l = License.find();
                    if (l.verify()) break block12;
                    Calendar lastreminder = Calendar.getInstance();
                    lastreminder.setTimeInMillis(Preferences.instance().getLong("donate.reminder.date"));
                    lastreminder.roll(6, Preferences.instance().getInteger("donate.reminder.interval"));
                    String lastversion = Preferences.instance().getProperty("donate.reminder");
                    if (!lastreminder.getTime().before(new Date(System.currentTimeMillis())) && NSBundle.mainBundle().infoDictionary().objectForKey("Version").toString().equals(lastversion)) break block12;
                    final int uses = Preferences.instance().getInteger("uses");
                    this.donationController = new CDWindowController(){
                        private NSButton neverShowDonationCheckbox;

                        protected String getBundleName() {
                            return "Donate";
                        }

                        public void setNeverShowDonationCheckbox(NSButton neverShowDonationCheckbox) {
                            this.neverShowDonationCheckbox = neverShowDonationCheckbox;
                            this.neverShowDonationCheckbox.setTarget(this.id());
                            this.neverShowDonationCheckbox.setState(0);
                        }

                        public void awakeFromNib() {
                            this.window().setTitle(this.window().title() + " (" + uses + ")");
                            this.window().center();
                            this.window().makeKeyAndOrderFront(null);
                            super.awakeFromNib();
                        }

                        public void closeDonationSheet(NSButton sender) {
                            if (this.neverShowDonationCheckbox.state() == 1) {
                                Preferences.instance().setProperty("donate.reminder", NSBundle.mainBundle().infoDictionary().objectForKey("Version").toString());
                            }
                            if (sender.tag() == 1) {
                                NSWorkspace.sharedWorkspace().openURL(NSURL.URLWithString(Preferences.instance().getProperty("website.donate")));
                            }
                            Preferences.instance().setProperty("donate.reminder.date", System.currentTimeMillis());
                            NSApplication.sharedApplication().terminate(null);
                        }
                    };
                    this.donationController.loadBundle();
                    NSUInteger nSUInteger = NSApplication.NSTerminateCancel;
                    Object var8_10 = null;
                    this.donationPrompt = false;
                    return nSUInteger;
                }
                catch (Throwable throwable) {
                    Object var8_12 = null;
                    this.donationPrompt = false;
                    throw throwable;
                }
            }
            Object var8_11 = null;
            this.donationPrompt = false;
        }
        for (CDBrowserController controller : browsers) {
            if (Preferences.instance().getBoolean("browser.serialize") && controller.isMounted()) {
                Host serialized = new Host(controller.getSession().getHost().getAsDictionary());
                try {
                    serialized.setDefaultPath(controller.getSession().workdir().getAbsolute());
                }
                catch (IOException e) {
                    log.warn((Object)e.getMessage());
                }
                this.sessions.add(serialized);
            }
            if (!controller.isConnected()) continue;
            if (Preferences.instance().getBoolean("browser.confirmDisconnect")) {
                NSAlert alert = NSAlert.alert(Locale.localizedString((String)"Quit"), Locale.localizedString((String)"You are connected to at least one remote site. Do you want to review open browsers?"), Locale.localizedString((String)"Quit Anyway"), Locale.localizedString((String)"Cancel"), Locale.localizedString((String)"Review..."));
                alert.setAlertStyle(0);
                int choice = alert.runModal();
                if (choice == -1) {
                    NSUInteger result = CDBrowserController.applicationShouldTerminate(app);
                    if (NSApplication.NSTerminateNow.equals((Object)result)) {
                        return CDTransferController.applicationShouldTerminate(app);
                    }
                    return result;
                }
                if (choice == 0) {
                    this.sessions.clear();
                    return NSApplication.NSTerminateCancel;
                }
                if (choice != 1) continue;
                return CDTransferController.applicationShouldTerminate(app);
            }
            controller.unmount();
        }
        return CDTransferController.applicationShouldTerminate(app);
    }

    @Override
    public void applicationWillTerminate(NSNotification notification) {
        log.debug((Object)"applicationWillTerminate");
        this.invalidate();
        Rendezvous.instance().quit();
        Preferences.instance().setProperty("uses", Preferences.instance().getInteger("uses") + 1);
        Preferences.instance().save();
    }

    public void workspaceWillPowerOff(NSNotification notification) {
        log.debug((Object)"workspaceWillPowerOff");
    }

    public void workspaceWillLogout(NSNotification notification) {
        log.debug((Object)"workspaceWillLogout");
    }

    public void workspaceWillSleep(NSNotification notification) {
        log.debug((Object)"workspaceWillSleep");
    }

    public static CDBrowserController newDocument() {
        return CDMainController.newDocument(false);
    }

    public static List<CDBrowserController> getBrowsers() {
        return browsers;
    }

    public static CDBrowserController newDocument(boolean force) {
        log.debug((Object)"newDocument");
        if (!force) {
            for (CDBrowserController controller : browsers) {
                if (controller.hasSession()) continue;
                controller.window().makeKeyAndOrderFront(null);
                return controller;
            }
        }
        final CDBrowserController controller = new CDBrowserController();
        controller.addListener(new CDWindowListener(){

            public void windowWillClose() {
                browsers.remove(controller);
            }
        });
        if (browsers.size() > 0) {
            controller.cascade();
        }
        controller.window().makeKeyAndOrderFront(null);
        browsers.add(controller);
        return controller;
    }

    public boolean application_delegateHandlesKey(NSApplication application, String key) {
        return key.equals("orderedBrowsers");
    }

    public NSArray orderedBrowsers() {
        NSMutableArray orderedDocs = NSMutableArray.array();
        for (CDBrowserController browser : browsers) {
            orderedDocs.addObject(browser.proxy());
        }
        return orderedDocs;
    }

    @Override
    public boolean applicationShouldTerminateAfterLastWindowClosed(NSApplication app) {
        return false;
    }

    public static String[] availableCharsets() {
        Collection charsets = new Collection();
        for (Charset charset : Charset.availableCharsets().values()) {
            String name = charset.displayName();
            if (name.startsWith("IBM") || name.startsWith("x-")) continue;
            charsets.add(name);
        }
        return charsets.toArray(new String[charsets.size()]);
    }

    @Override
    protected String getBundleName() {
        return "Main";
    }
}

