/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.ui.cocoa.CDPreferencesImpl;
import ch.cyberduck.ui.cocoa.foundation.NSBundle;
import ch.cyberduck.ui.cocoa.foundation.NSDictionary;
import ch.cyberduck.ui.cocoa.foundation.NSMutableDictionary;
import ch.cyberduck.ui.cocoa.foundation.NSObject;
import org.apache.log4j.Logger;

public class CDPortablePreferencesImpl
extends CDPreferencesImpl {
    private static Logger log = Logger.getLogger(CDPortablePreferencesImpl.class);
    private NSMutableDictionary dict;

    public Object getObject(String property) {
        NSObject value = this.dict.objectForKey(property);
        if (null == value) {
            return super.getObject(property);
        }
        return value;
    }

    public void setProperty(String property, String value) {
        log.info((Object)("setProperty:" + property + "," + value));
        this.dict.setObjectForKey(value, property);
    }

    public void deleteProperty(String property) {
        this.dict.removeObjectForKey(property);
        this.save();
    }

    protected void load() {
        Local f = LocalFactory.createLocal((String)NSBundle.mainBundle().objectForInfoDictionaryKey("application.preferences.path").toString());
        if (f.exists()) {
            log.info((Object)("Found preferences file: " + f.toString()));
            this.dict = NSMutableDictionary.dictionary();
            this.dict.setDictionary(NSDictionary.dictionaryWithContentsOfFile(f.getAbsolute()));
        } else {
            this.dict = NSMutableDictionary.dictionary();
        }
    }

    public void save() {
        Local f = LocalFactory.createLocal((String)NSBundle.mainBundle().objectForInfoDictionaryKey("application.preferences.path").toString());
        f.getParent().mkdir();
        this.dict.writeToFile(f.getAbsolute());
    }
}

