/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa;

import ch.cyberduck.core.CollectionListener;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostCollection;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.Permission;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.TransferAction;
import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.core.util.URLSchemeHandlerConfiguration;
import ch.cyberduck.ui.cocoa.CDBrowserController;
import ch.cyberduck.ui.cocoa.CDIconCache;
import ch.cyberduck.ui.cocoa.CDMainController;
import ch.cyberduck.ui.cocoa.CDWindowController;
import ch.cyberduck.ui.cocoa.application.NSApplication;
import ch.cyberduck.ui.cocoa.application.NSButton;
import ch.cyberduck.ui.cocoa.application.NSColor;
import ch.cyberduck.ui.cocoa.application.NSFont;
import ch.cyberduck.ui.cocoa.application.NSMenuItem;
import ch.cyberduck.ui.cocoa.application.NSOpenPanel;
import ch.cyberduck.ui.cocoa.application.NSPopUpButton;
import ch.cyberduck.ui.cocoa.application.NSTabView;
import ch.cyberduck.ui.cocoa.application.NSTextField;
import ch.cyberduck.ui.cocoa.application.NSTextView;
import ch.cyberduck.ui.cocoa.application.NSView;
import ch.cyberduck.ui.cocoa.application.NSWindow;
import ch.cyberduck.ui.cocoa.application.NSWorkspace;
import ch.cyberduck.ui.cocoa.foundation.NSArray;
import ch.cyberduck.ui.cocoa.foundation.NSBundle;
import ch.cyberduck.ui.cocoa.foundation.NSDictionary;
import ch.cyberduck.ui.cocoa.foundation.NSFileManager;
import ch.cyberduck.ui.cocoa.foundation.NSMutableAttributedString;
import ch.cyberduck.ui.cocoa.foundation.NSNotification;
import ch.cyberduck.ui.cocoa.foundation.NSNotificationCenter;
import ch.cyberduck.ui.cocoa.foundation.NSRange;
import ch.cyberduck.ui.cocoa.odb.EditorFactory;
import com.enterprisedt.net.ftp.FTPTransferType;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.rococoa.Foundation;
import org.rococoa.ID;
import org.rococoa.Selector;
import org.rococoa.cocoa.foundation.NSInteger;
import org.rococoa.cocoa.foundation.NSUInteger;

public class CDPreferencesController
extends CDWindowController {
    private static Logger log = Logger.getLogger(CDPreferencesController.class);
    private static CDPreferencesController instance = null;
    private NSTabView tabView;
    private NSView panelGeneral;
    private NSView panelInterface;
    private NSView panelTransfer;
    private NSView panelFTP;
    private NSView panelSFTP;
    private NSView panelS3;
    private NSView panelBandwidth;
    private NSView panelAdvanced;
    private NSView panelUpdate;
    private static final String TRANSFERMODE_AUTO = Locale.localizedString((String)"Auto");
    private static final String TRANSFERMODE_BINARY = Locale.localizedString((String)"Binary");
    private static final String TRANSFERMODE_ASCII = Locale.localizedString((String)"ASCII");
    private static final String UNIX_LINE_ENDINGS = Locale.localizedString((String)"Unix Line Endings (LF)");
    private static final String MAC_LINE_ENDINGS = Locale.localizedString((String)"Mac Line Endings (CR)");
    private static final String WINDOWS_LINE_ENDINGS = Locale.localizedString((String)"Windows Line Endings (CRLF)");
    private NSPopUpButton editorCombobox;
    private NSPopUpButton bookmarkSizePopup;
    private NSButton openUntitledBrowserCheckbox;
    private NSButton browserSerializeCheckbox;
    private NSPopUpButton defaultBookmarkCombobox;
    private final CollectionListener<Host> bookmarkCollectionListener = new CollectionListener<Host>(){

        public void collectionItemAdded(Host bookmark) {
            CDPreferencesController.this.defaultBookmarkCombobox.addItemWithTitle(bookmark.getNickname());
            CDPreferencesController.this.defaultBookmarkCombobox.itemWithTitle(bookmark.getNickname()).setImage(CDIconCache.iconNamed("cyberduck-document", 16));
            CDPreferencesController.this.defaultBookmarkCombobox.lastItem().setRepresentedObject(bookmark.getNickname());
        }

        public void collectionItemRemoved(Host bookmark) {
            NSInteger i;
            if (CDPreferencesController.this.defaultBookmarkCombobox.titleOfSelectedItem().equals(bookmark.getNickname())) {
                Preferences.instance().deleteProperty("browser.defaultBookmark");
            }
            if ((i = CDPreferencesController.this.defaultBookmarkCombobox.menu().indexOfItemWithRepresentedObject(bookmark.getNickname())).intValue() > -1) {
                CDPreferencesController.this.defaultBookmarkCombobox.removeItemAtIndex(i);
            }
        }

        public void collectionItemChanged(Host bookmark) {
        }
    };
    private NSPopUpButton encodingCombobox;
    private NSPopUpButton chmodUploadTypePopup;
    private NSPopUpButton chmodDownloadTypePopup;
    private NSButton chmodUploadCheckbox;
    private NSButton chmodUploadDefaultCheckbox;
    private NSButton chmodUploadCustomCheckbox;
    private NSButton chmodDownloadCheckbox;
    private NSButton chmodDownloadDefaultCheckbox;
    private NSButton chmodDownloadCustomCheckbox;
    private NSButton downerr;
    private NSButton downerw;
    private NSButton downerx;
    private NSButton dgroupr;
    private NSButton dgroupw;
    private NSButton dgroupx;
    private NSButton dotherr;
    private NSButton dotherw;
    private NSButton dotherx;
    public NSButton uownerr;
    public NSButton uownerw;
    public NSButton uownerx;
    public NSButton ugroupr;
    public NSButton ugroupw;
    public NSButton ugroupx;
    public NSButton uotherr;
    public NSButton uotherw;
    public NSButton uotherx;
    private NSButton preserveModificationDownloadCheckbox;
    private NSButton preserveModificationUploadCheckbox;
    private NSButton horizontalLinesCheckbox;
    private NSButton verticalLinesCheckbox;
    private NSButton alternatingRowBackgroundCheckbox;
    private NSButton infoWindowAsInspectorCheckbox;
    private NSPopUpButton downloadPathPopup;
    private static final String CHOOSE = Locale.localizedString((String)"Choose") + "...";
    private final Local DEFAULT_DOWNLOAD_FOLDER = LocalFactory.createLocal((String)Preferences.instance().getProperty("queue.download.folder"));
    private NSOpenPanel downloadPathPanel;
    private NSPopUpButton transferPopup;
    private final int USE_QUEUE_SESSION_INDEX = 0;
    private final int USE_BROWSER_SESSION_INDEX = 1;
    private NSTextField anonymousField;
    private NSTextField textFileTypeRegexField;
    private NSButton downloadSkipButton;
    private NSButton downloadSkipRegexDefaultButton;
    private NSTextView downloadSkipRegexField;
    private NSButton uploadSkipButton;
    private NSButton uploadSkipRegexDefaultButton;
    private NSTextView uploadSkipRegexField;
    protected static NSDictionary RED_FONT = NSDictionary.dictionaryWithObjectsForKeys(NSArray.arrayWithObjects(NSColor.redColor()), NSArray.arrayWithObjects("NSColor"));
    private NSTextField loginField;
    private NSButton keychainCheckbox;
    private NSButton doubleClickCheckbox;
    private NSButton returnKeyCheckbox;
    private NSButton showHiddenCheckbox;
    private NSButton bringQueueToFrontCheckbox;
    private NSButton bringQueueToBackCheckbox;
    private NSButton removeFromQueueCheckbox;
    private NSButton openAfterDownloadCheckbox;
    private NSPopUpButton duplicateDownloadCombobox;
    private NSButton duplicateDownloadOverwriteButton;
    private NSPopUpButton duplicateUploadCombobox;
    private NSButton duplicateUploadOverwriteButton;
    private NSPopUpButton lineEndingCombobox;
    private NSPopUpButton transfermodeCombobox;
    private NSPopUpButton protocolCombobox;
    private NSButton confirmDisconnectCheckbox;
    private NSButton secureDataChannelCheckbox;
    private NSButton failInsecureDataChannelCheckbox;
    private NSPopUpButton sshTransfersCombobox;
    private NSPopUpButton defaultFTPHandlerCombobox;
    private NSPopUpButton defaultSFTPHandlerCombobox;
    private NSPopUpButton defaultDownloadThrottleCombobox;
    private NSPopUpButton defaultUploadThrottleCombobox;
    private NSButton updateCheckbox;
    private NSPopUpButton defaultBucketLocation;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CDPreferencesController instance() {
        NSApplication nSApplication = NSApplication.sharedApplication();
        synchronized (nSApplication) {
            if (null == instance) {
                instance = new CDPreferencesController();
            }
            return instance;
        }
    }

    private CDPreferencesController() {
        this.loadBundle();
    }

    protected String getBundleName() {
        return "Preferences";
    }

    public void setTabView(NSTabView tabView) {
        this.tabView = tabView;
    }

    public void setPanelUpdate(NSView panelUpdate) {
        this.panelUpdate = panelUpdate;
    }

    public void setPanelAdvanced(NSView panelAdvanced) {
        this.panelAdvanced = panelAdvanced;
    }

    public void setPanelBandwidth(NSView panelBandwidth) {
        this.panelBandwidth = panelBandwidth;
    }

    public void setPanelSFTP(NSView panelSFTP) {
        this.panelSFTP = panelSFTP;
    }

    public void setPanelFTP(NSView panelFTP) {
        this.panelFTP = panelFTP;
    }

    public void setPanelS3(NSView panelS3) {
        this.panelS3 = panelS3;
    }

    public void setPanelTransfer(NSView panelTransfer) {
        this.panelTransfer = panelTransfer;
    }

    public void setPanelInterface(NSView panelInterface) {
        this.panelInterface = panelInterface;
    }

    public void setPanelGeneral(NSView panelGeneral) {
        this.panelGeneral = panelGeneral;
    }

    protected void invalidate() {
        HostCollection.defaultCollection().removeListener(this.bookmarkCollectionListener);
        super.invalidate();
        instance = null;
    }

    public void setWindow(NSWindow window) {
        window.setExcludedFromWindowsMenu(true);
        window.setShowsToolbarButton(false);
        super.setWindow(window);
    }

    public void awakeFromNib() {
        this.window.center();
        this.transfermodeComboboxClicked(this.transfermodeCombobox);
        this.chmodDownloadTypePopupChanged(this.chmodDownloadTypePopup);
        this.chmodUploadTypePopupChanged(this.chmodUploadTypePopup);
        boolean chmodDownloadDefaultEnabled = Preferences.instance().getBoolean("queue.download.changePermissions") && Preferences.instance().getBoolean("queue.download.permissions.useDefault");
        this.downerr.setEnabled(chmodDownloadDefaultEnabled);
        this.downerr.setTarget(this.id());
        this.downerr.setAction(Foundation.selector("defaultPermissionsDownloadChanged:"));
        this.downerw.setEnabled(chmodDownloadDefaultEnabled);
        this.downerw.setTarget(this.id());
        this.downerw.setAction(Foundation.selector("defaultPermissionsDownloadChanged:"));
        this.downerx.setEnabled(chmodDownloadDefaultEnabled);
        this.downerx.setTarget(this.id());
        this.downerx.setAction(Foundation.selector("defaultPermissionsDownloadChanged:"));
        this.dgroupr.setEnabled(chmodDownloadDefaultEnabled);
        this.dgroupr.setTarget(this.id());
        this.dgroupr.setAction(Foundation.selector("defaultPermissionsDownloadChanged:"));
        this.dgroupw.setEnabled(chmodDownloadDefaultEnabled);
        this.dgroupw.setTarget(this.id());
        this.dgroupw.setAction(Foundation.selector("defaultPermissionsDownloadChanged:"));
        this.dgroupx.setEnabled(chmodDownloadDefaultEnabled);
        this.dgroupx.setTarget(this.id());
        this.dgroupx.setAction(Foundation.selector("defaultPermissionsDownloadChanged:"));
        this.dotherr.setEnabled(chmodDownloadDefaultEnabled);
        this.dotherr.setTarget(this.id());
        this.dotherr.setAction(Foundation.selector("defaultPermissionsDownloadChanged:"));
        this.dotherw.setEnabled(chmodDownloadDefaultEnabled);
        this.dotherw.setTarget(this.id());
        this.dotherw.setAction(Foundation.selector("defaultPermissionsDownloadChanged:"));
        this.dotherx.setEnabled(chmodDownloadDefaultEnabled);
        this.dotherx.setTarget(this.id());
        this.dotherx.setAction(Foundation.selector("defaultPermissionsDownloadChanged:"));
        boolean chmodUploadDefaultEnabled = Preferences.instance().getBoolean("queue.upload.changePermissions") && Preferences.instance().getBoolean("queue.upload.permissions.useDefault");
        this.uownerr.setEnabled(chmodUploadDefaultEnabled);
        this.uownerr.setTarget(this.id());
        this.uownerr.setAction(Foundation.selector("defaultPermissionsUploadChanged:"));
        this.uownerw.setEnabled(chmodUploadDefaultEnabled);
        this.uownerw.setTarget(this.id());
        this.uownerw.setAction(Foundation.selector("defaultPermissionsUploadChanged:"));
        this.uownerx.setEnabled(chmodUploadDefaultEnabled);
        this.uownerx.setTarget(this.id());
        this.uownerx.setAction(Foundation.selector("defaultPermissionsUploadChanged:"));
        this.ugroupr.setEnabled(chmodUploadDefaultEnabled);
        this.ugroupr.setTarget(this.id());
        this.ugroupr.setAction(Foundation.selector("defaultPermissionsUploadChanged:"));
        this.ugroupw.setEnabled(chmodUploadDefaultEnabled);
        this.ugroupw.setTarget(this.id());
        this.ugroupw.setAction(Foundation.selector("defaultPermissionsUploadChanged:"));
        this.ugroupx.setEnabled(chmodUploadDefaultEnabled);
        this.ugroupx.setTarget(this.id());
        this.ugroupx.setAction(Foundation.selector("defaultPermissionsUploadChanged:"));
        this.uotherr.setEnabled(chmodUploadDefaultEnabled);
        this.uotherr.setTarget(this.id());
        this.uotherr.setAction(Foundation.selector("defaultPermissionsUploadChanged:"));
        this.uotherw.setEnabled(chmodUploadDefaultEnabled);
        this.uotherw.setTarget(this.id());
        this.uotherw.setAction(Foundation.selector("defaultPermissionsUploadChanged:"));
        this.uotherx.setEnabled(chmodUploadDefaultEnabled);
        this.uotherx.setTarget(this.id());
        this.uotherx.setAction(Foundation.selector("defaultPermissionsUploadChanged:"));
        int i = -1;
        this.tabView.tabViewItemAtIndex(++i).setView(this.panelGeneral);
        this.tabView.tabViewItemAtIndex(++i).setView(this.panelInterface);
        this.tabView.tabViewItemAtIndex(++i).setView(this.panelTransfer);
        this.tabView.tabViewItemAtIndex(++i).setView(this.panelFTP);
        this.tabView.tabViewItemAtIndex(++i).setView(this.panelSFTP);
        this.tabView.tabViewItemAtIndex(++i).setView(this.panelS3);
        this.tabView.tabViewItemAtIndex(++i).setView(this.panelBandwidth);
        this.tabView.tabViewItemAtIndex(++i).setView(this.panelAdvanced);
        this.tabView.tabViewItemAtIndex(++i).setView(this.panelUpdate);
        super.awakeFromNib();
    }

    public void setEditorCombobox(NSPopUpButton editorCombobox) {
        this.editorCombobox = editorCombobox;
        this.editorCombobox.setAutoenablesItems(false);
        this.editorCombobox.removeAllItems();
        Map<String, String> editors = EditorFactory.getSupportedOdbEditors();
        Iterator<String> editorNames = editors.keySet().iterator();
        Iterator<String> editorIdentifiers = editors.values().iterator();
        while (editorNames.hasNext()) {
            String path;
            String editor = editorNames.next();
            String identifier = editorIdentifiers.next();
            this.editorCombobox.addItemWithTitle(editor);
            boolean enabled = EditorFactory.getInstalledOdbEditors().containsValue(identifier);
            this.editorCombobox.itemWithTitle(editor).setEnabled(enabled);
            if (!enabled || !StringUtils.isNotEmpty((String)(path = NSWorkspace.sharedWorkspace().absolutePathForAppBundleWithIdentifier(identifier)))) continue;
            this.editorCombobox.itemWithTitle(editor).setImage(CDIconCache.instance().iconForPath(LocalFactory.createLocal((String)path), (Integer)16));
        }
        this.editorCombobox.setTarget(this.id());
        this.editorCombobox.setAction(Foundation.selector("editorComboboxClicked:"));
        this.editorCombobox.selectItemWithTitle(Preferences.instance().getProperty("editor.name"));
    }

    public void editorComboboxClicked(NSPopUpButton sender) {
        Preferences.instance().setProperty("editor.name", sender.titleOfSelectedItem());
        String selected = EditorFactory.getSupportedOdbEditors().get(sender.titleOfSelectedItem());
        Preferences.instance().setProperty("editor.bundleIdentifier", selected);
        EditorFactory.setSelectedEditor(selected);
        CDBrowserController.validateToolbarItems();
    }

    public void setBookmarkSizePopup(NSPopUpButton bookmarkSizePopup) {
        this.bookmarkSizePopup = bookmarkSizePopup;
        this.bookmarkSizePopup.setTarget(this.id());
        this.bookmarkSizePopup.setAction(Foundation.selector("bookmarkSizePopupClicked:"));
        int size = Preferences.instance().getInteger("bookmark.icon.size");
        for (int i = 0; i < this.bookmarkSizePopup.numberOfItems(); ++i) {
            this.bookmarkSizePopup.itemAtIndex(i).setState(0);
        }
        if (16 == size) {
            this.bookmarkSizePopup.selectItemAtIndex(0);
        }
        if (32 == size) {
            this.bookmarkSizePopup.selectItemAtIndex(1);
        }
        if (64 == size) {
            this.bookmarkSizePopup.selectItemAtIndex(2);
        }
    }

    public void bookmarkSizePopupClicked(NSPopUpButton sender) {
        if (sender.indexOfSelectedItem() == 0) {
            Preferences.instance().setProperty("bookmark.icon.size", 16);
        }
        if (sender.indexOfSelectedItem() == 1) {
            Preferences.instance().setProperty("bookmark.icon.size", 32);
        }
        if (sender.indexOfSelectedItem() == 2) {
            Preferences.instance().setProperty("bookmark.icon.size", 64);
        }
        CDBrowserController.updateBookmarkTableRowHeight();
    }

    public void setOpenUntitledBrowserCheckbox(NSButton openUntitledBrowserCheckbox) {
        this.openUntitledBrowserCheckbox = openUntitledBrowserCheckbox;
        this.openUntitledBrowserCheckbox.setTarget(this.id());
        this.openUntitledBrowserCheckbox.setAction(Foundation.selector("openUntitledBrowserCheckboxClicked:"));
        this.openUntitledBrowserCheckbox.setState(Preferences.instance().getBoolean("browser.openUntitled") ? 1 : 0);
    }

    public void openUntitledBrowserCheckboxClicked(NSButton sender) {
        boolean enabled = sender.state() == 1;
        Preferences.instance().setProperty("browser.openUntitled", enabled);
    }

    public void setBrowserSerializeCheckbox(NSButton browserSerializeCheckbox) {
        this.browserSerializeCheckbox = browserSerializeCheckbox;
        this.browserSerializeCheckbox.setTarget(this.id());
        this.browserSerializeCheckbox.setAction(Foundation.selector("browserSerializeCheckboxClicked:"));
        this.browserSerializeCheckbox.setState(Preferences.instance().getBoolean("browser.serialize") ? 1 : 0);
    }

    public void browserSerializeCheckboxClicked(NSButton sender) {
        boolean enabled = sender.state() == 1;
        Preferences.instance().setProperty("browser.serialize", enabled);
    }

    public void setDefaultBookmarkCombobox(NSPopUpButton defaultBookmarkCombobox) {
        this.defaultBookmarkCombobox = defaultBookmarkCombobox;
        this.defaultBookmarkCombobox.setToolTip(Locale.localizedString((String)"Bookmarks"));
        this.defaultBookmarkCombobox.removeAllItems();
        this.defaultBookmarkCombobox.addItemWithTitle(Locale.localizedString((String)"None"));
        this.defaultBookmarkCombobox.menu().addItem(NSMenuItem.separatorItem());
        for (Host bookmark : HostCollection.defaultCollection()) {
            this.defaultBookmarkCombobox.addItemWithTitle(bookmark.getNickname());
            this.defaultBookmarkCombobox.itemWithTitle(bookmark.getNickname()).setImage(CDIconCache.iconNamed("cyberduck-document", 16));
            this.defaultBookmarkCombobox.lastItem().setRepresentedObject(bookmark.getNickname());
        }
        HostCollection.defaultCollection().addListener(this.bookmarkCollectionListener);
        this.defaultBookmarkCombobox.setTarget(this.id());
        Selector action = Foundation.selector("defaultBookmarkComboboxClicked:");
        this.defaultBookmarkCombobox.setAction(action);
        String defaultBookmarkNickname = Preferences.instance().getProperty("browser.defaultBookmark");
        if (null == defaultBookmarkNickname) {
            this.defaultBookmarkCombobox.selectItemWithTitle(Locale.localizedString((String)"None"));
        } else {
            int i = this.defaultBookmarkCombobox.indexOfItemWithTitle(defaultBookmarkNickname);
            if (i > -1) {
                this.defaultBookmarkCombobox.selectItemAtIndex(i);
            } else {
                this.defaultBookmarkCombobox.selectItemWithTitle(Locale.localizedString((String)"None"));
            }
        }
    }

    public void defaultBookmarkComboboxClicked(NSPopUpButton sender) {
        if (Locale.localizedString((String)"None").equals(sender.titleOfSelectedItem())) {
            Preferences.instance().deleteProperty("browser.defaultBookmark");
        } else {
            Preferences.instance().setProperty("browser.defaultBookmark", sender.titleOfSelectedItem());
        }
    }

    public void setEncodingCombobox(NSPopUpButton encodingCombobox) {
        this.encodingCombobox = encodingCombobox;
        this.encodingCombobox.setTarget(this.id());
        this.encodingCombobox.setAction(Foundation.selector("encodingComboboxClicked:"));
        this.encodingCombobox.removeAllItems();
        this.encodingCombobox.addItemsWithTitles(NSArray.arrayWithObjects(CDMainController.availableCharsets()));
        this.encodingCombobox.selectItemWithTitle(Preferences.instance().getProperty("browser.charset.encoding"));
    }

    public void encodingComboboxClicked(NSPopUpButton sender) {
        Preferences.instance().setProperty("browser.charset.encoding", sender.titleOfSelectedItem());
    }

    public void setChmodUploadTypePopup(NSPopUpButton chmodUploadTypePopup) {
        this.chmodUploadTypePopup = chmodUploadTypePopup;
        this.chmodUploadTypePopup.selectItemAtIndex(0);
        this.chmodUploadTypePopup.setTarget(this.id());
        Selector action = Foundation.selector("chmodUploadTypePopupChanged:");
        this.chmodUploadTypePopup.setAction(action);
    }

    private void chmodUploadTypePopupChanged(NSPopUpButton sender) {
        Permission p = null;
        if (sender.selectedItem().tag() == 0) {
            p = new Permission(Preferences.instance().getInteger("queue.upload.permissions.file.default"));
        }
        if (sender.selectedItem().tag() == 1) {
            p = new Permission(Preferences.instance().getInteger("queue.upload.permissions.folder.default"));
        }
        if (null == p) {
            log.error((Object)("No selected item for:" + sender));
            return;
        }
        boolean[] ownerPerm = p.getOwnerPermissions();
        boolean[] groupPerm = p.getGroupPermissions();
        boolean[] otherPerm = p.getOtherPermissions();
        this.uownerr.setState(ownerPerm[0] ? 1 : 0);
        this.uownerw.setState(ownerPerm[1] ? 1 : 0);
        this.uownerx.setState(ownerPerm[2] ? 1 : 0);
        this.ugroupr.setState(groupPerm[0] ? 1 : 0);
        this.ugroupw.setState(groupPerm[1] ? 1 : 0);
        this.ugroupx.setState(groupPerm[2] ? 1 : 0);
        this.uotherr.setState(otherPerm[0] ? 1 : 0);
        this.uotherw.setState(otherPerm[1] ? 1 : 0);
        this.uotherx.setState(otherPerm[2] ? 1 : 0);
    }

    public void setChmodDownloadTypePopup(NSPopUpButton chmodDownloadTypePopup) {
        this.chmodDownloadTypePopup = chmodDownloadTypePopup;
        this.chmodDownloadTypePopup.selectItemAtIndex(0);
        this.chmodDownloadTypePopup.setTarget(this.id());
        Selector action = Foundation.selector("chmodDownloadTypePopupChanged:");
        this.chmodDownloadTypePopup.setAction(action);
    }

    private void chmodDownloadTypePopupChanged(NSPopUpButton sender) {
        Permission p = null;
        if (sender.selectedItem().tag() == 0) {
            p = new Permission(Preferences.instance().getInteger("queue.download.permissions.file.default"));
        }
        if (sender.selectedItem().tag() == 1) {
            p = new Permission(Preferences.instance().getInteger("queue.download.permissions.folder.default"));
        }
        if (null == p) {
            log.error((Object)("No selected item for:" + sender));
            return;
        }
        boolean[] ownerPerm = p.getOwnerPermissions();
        boolean[] groupPerm = p.getGroupPermissions();
        boolean[] otherPerm = p.getOtherPermissions();
        this.downerr.setState(ownerPerm[0] ? 1 : 0);
        this.downerw.setState(ownerPerm[1] ? 1 : 0);
        this.downerx.setState(ownerPerm[2] ? 1 : 0);
        this.dgroupr.setState(groupPerm[0] ? 1 : 0);
        this.dgroupw.setState(groupPerm[1] ? 1 : 0);
        this.dgroupx.setState(groupPerm[2] ? 1 : 0);
        this.dotherr.setState(otherPerm[0] ? 1 : 0);
        this.dotherw.setState(otherPerm[1] ? 1 : 0);
        this.dotherx.setState(otherPerm[2] ? 1 : 0);
    }

    public void setChmodUploadCheckbox(NSButton chmodUploadCheckbox) {
        this.chmodUploadCheckbox = chmodUploadCheckbox;
        this.chmodUploadCheckbox.setTarget(this.id());
        this.chmodUploadCheckbox.setAction(Foundation.selector("chmodUploadCheckboxClicked:"));
        this.chmodUploadCheckbox.setState(Preferences.instance().getBoolean("queue.upload.changePermissions") ? 1 : 0);
    }

    public void chmodUploadCheckboxClicked(NSButton sender) {
        boolean enabled = sender.state() == 1;
        Preferences.instance().setProperty("queue.upload.changePermissions", enabled);
        this.chmodUploadDefaultCheckbox.setEnabled(enabled);
        this.chmodUploadCustomCheckbox.setEnabled(enabled);
        boolean chmodUploadDefaultChecked = this.chmodUploadDefaultCheckbox.state() == 1;
        this.uownerr.setEnabled(enabled && chmodUploadDefaultChecked);
        this.uownerw.setEnabled(enabled && chmodUploadDefaultChecked);
        this.uownerx.setEnabled(enabled && chmodUploadDefaultChecked);
        this.ugroupr.setEnabled(enabled && chmodUploadDefaultChecked);
        this.ugroupw.setEnabled(enabled && chmodUploadDefaultChecked);
        this.ugroupx.setEnabled(enabled && chmodUploadDefaultChecked);
        this.uotherr.setEnabled(enabled && chmodUploadDefaultChecked);
        this.uotherw.setEnabled(enabled && chmodUploadDefaultChecked);
        this.uotherx.setEnabled(enabled && chmodUploadDefaultChecked);
    }

    public void setChmodUploadDefaultCheckbox(NSButton chmodUploadDefaultCheckbox) {
        this.chmodUploadDefaultCheckbox = chmodUploadDefaultCheckbox;
        this.chmodUploadDefaultCheckbox.setTarget(this.id());
        this.chmodUploadDefaultCheckbox.setAction(Foundation.selector("chmodUploadDefaultCheckboxClicked:"));
        this.chmodUploadDefaultCheckbox.setState(Preferences.instance().getBoolean("queue.upload.permissions.useDefault") ? 1 : 0);
        this.chmodUploadDefaultCheckbox.setEnabled(Preferences.instance().getBoolean("queue.upload.changePermissions"));
    }

    public void chmodUploadDefaultCheckboxClicked(NSButton sender) {
        boolean enabled = sender.state() == 1;
        Preferences.instance().setProperty("queue.upload.permissions.useDefault", enabled);
        this.uownerr.setEnabled(enabled);
        this.uownerw.setEnabled(enabled);
        this.uownerx.setEnabled(enabled);
        this.ugroupr.setEnabled(enabled);
        this.ugroupw.setEnabled(enabled);
        this.ugroupx.setEnabled(enabled);
        this.uotherr.setEnabled(enabled);
        this.uotherw.setEnabled(enabled);
        this.uotherx.setEnabled(enabled);
        this.chmodUploadCustomCheckbox.setState(!enabled ? 1 : 0);
    }

    public void setChmodUploadCustomCheckbox(NSButton chmodUploadCustomCheckbox) {
        this.chmodUploadCustomCheckbox = chmodUploadCustomCheckbox;
        this.chmodUploadCustomCheckbox.setTarget(this.id());
        this.chmodUploadCustomCheckbox.setAction(Foundation.selector("chmodUploadCustomCheckboxClicked:"));
        this.chmodUploadCustomCheckbox.setState(!Preferences.instance().getBoolean("queue.upload.permissions.useDefault") ? 1 : 0);
        this.chmodUploadCustomCheckbox.setEnabled(Preferences.instance().getBoolean("queue.upload.changePermissions"));
    }

    public void chmodUploadCustomCheckboxClicked(NSButton sender) {
        boolean enabled = sender.state() == 1;
        Preferences.instance().setProperty("queue.upload.permissions.useDefault", !enabled);
        this.uownerr.setEnabled(!enabled);
        this.uownerw.setEnabled(!enabled);
        this.uownerx.setEnabled(!enabled);
        this.ugroupr.setEnabled(!enabled);
        this.ugroupw.setEnabled(!enabled);
        this.ugroupx.setEnabled(!enabled);
        this.uotherr.setEnabled(!enabled);
        this.uotherw.setEnabled(!enabled);
        this.uotherx.setEnabled(!enabled);
        this.chmodUploadDefaultCheckbox.setState(!enabled ? 1 : 0);
    }

    public void setChmodDownloadCheckbox(NSButton chmodDownloadCheckbox) {
        this.chmodDownloadCheckbox = chmodDownloadCheckbox;
        this.chmodDownloadCheckbox.setTarget(this.id());
        this.chmodDownloadCheckbox.setAction(Foundation.selector("chmodDownloadCheckboxClicked:"));
        this.chmodDownloadCheckbox.setState(Preferences.instance().getBoolean("queue.download.changePermissions") ? 1 : 0);
    }

    public void chmodDownloadCheckboxClicked(NSButton sender) {
        boolean enabled = sender.state() == 1;
        Preferences.instance().setProperty("queue.download.changePermissions", enabled);
        this.chmodDownloadDefaultCheckbox.setEnabled(enabled);
        this.chmodDownloadCustomCheckbox.setEnabled(enabled);
        boolean chmodDownloadDefaultChecked = this.chmodDownloadDefaultCheckbox.state() == 1;
        this.downerr.setEnabled(enabled && chmodDownloadDefaultChecked);
        this.downerw.setEnabled(enabled && chmodDownloadDefaultChecked);
        this.downerx.setEnabled(enabled && chmodDownloadDefaultChecked);
        this.dgroupr.setEnabled(enabled && chmodDownloadDefaultChecked);
        this.dgroupw.setEnabled(enabled && chmodDownloadDefaultChecked);
        this.dgroupx.setEnabled(enabled && chmodDownloadDefaultChecked);
        this.dotherr.setEnabled(enabled && chmodDownloadDefaultChecked);
        this.dotherw.setEnabled(enabled && chmodDownloadDefaultChecked);
        this.dotherx.setEnabled(enabled && chmodDownloadDefaultChecked);
    }

    public void setChmodDownloadDefaultCheckbox(NSButton chmodDownloadDefaultCheckbox) {
        this.chmodDownloadDefaultCheckbox = chmodDownloadDefaultCheckbox;
        this.chmodDownloadDefaultCheckbox.setTarget(this.id());
        this.chmodDownloadDefaultCheckbox.setAction(Foundation.selector("chmodDownloadDefaultCheckboxClicked:"));
        this.chmodDownloadDefaultCheckbox.setState(Preferences.instance().getBoolean("queue.download.permissions.useDefault") ? 1 : 0);
        this.chmodDownloadDefaultCheckbox.setEnabled(Preferences.instance().getBoolean("queue.download.changePermissions"));
    }

    public void chmodDownloadDefaultCheckboxClicked(NSButton sender) {
        boolean enabled = sender.state() == 1;
        Preferences.instance().setProperty("queue.download.permissions.useDefault", enabled);
        this.downerr.setEnabled(enabled);
        this.downerw.setEnabled(enabled);
        this.downerx.setEnabled(enabled);
        this.dgroupr.setEnabled(enabled);
        this.dgroupw.setEnabled(enabled);
        this.dgroupx.setEnabled(enabled);
        this.dotherr.setEnabled(enabled);
        this.dotherw.setEnabled(enabled);
        this.dotherx.setEnabled(enabled);
        this.chmodDownloadCustomCheckbox.setState(!enabled ? 1 : 0);
    }

    public void setChmodDownloadCustomCheckbox(NSButton chmodDownloadCustomCheckbox) {
        this.chmodDownloadCustomCheckbox = chmodDownloadCustomCheckbox;
        this.chmodDownloadCustomCheckbox.setTarget(this.id());
        this.chmodDownloadCustomCheckbox.setAction(Foundation.selector("chmodDownloadCustomCheckboxClicked:"));
        this.chmodDownloadCustomCheckbox.setState(!Preferences.instance().getBoolean("queue.download.permissions.useDefault") ? 1 : 0);
        this.chmodDownloadCustomCheckbox.setEnabled(Preferences.instance().getBoolean("queue.download.changePermissions"));
    }

    public void chmodDownloadCustomCheckboxClicked(NSButton sender) {
        boolean enabled = sender.state() == 1;
        Preferences.instance().setProperty("queue.download.permissions.useDefault", !enabled);
        this.downerr.setEnabled(!enabled);
        this.downerw.setEnabled(!enabled);
        this.downerx.setEnabled(!enabled);
        this.dgroupr.setEnabled(!enabled);
        this.dgroupw.setEnabled(!enabled);
        this.dgroupx.setEnabled(!enabled);
        this.dotherr.setEnabled(!enabled);
        this.dotherw.setEnabled(!enabled);
        this.dotherx.setEnabled(!enabled);
        this.chmodDownloadDefaultCheckbox.setState(!enabled ? 1 : 0);
    }

    public void setDownerr(NSButton downerr) {
        this.downerr = downerr;
    }

    public void setDownerw(NSButton downerw) {
        this.downerw = downerw;
    }

    public void setDownerx(NSButton downerx) {
        this.downerx = downerx;
    }

    public void setDgroupr(NSButton dgroupr) {
        this.dgroupr = dgroupr;
    }

    public void setDgroupw(NSButton dgroupw) {
        this.dgroupw = dgroupw;
    }

    public void setDgroupx(NSButton dgroupx) {
        this.dgroupx = dgroupx;
    }

    public void setDotherr(NSButton dotherr) {
        this.dotherr = dotherr;
    }

    public void setDotherw(NSButton dotherw) {
        this.dotherw = dotherw;
    }

    public void setDotherx(NSButton dotherx) {
        this.dotherx = dotherx;
    }

    public void setUownerr(NSButton uownerr) {
        this.uownerr = uownerr;
    }

    public void setUownerw(NSButton uownerw) {
        this.uownerw = uownerw;
    }

    public void setUownerx(NSButton uownerx) {
        this.uownerx = uownerx;
    }

    public void setUgroupr(NSButton ugroupr) {
        this.ugroupr = ugroupr;
    }

    public void setUgroupw(NSButton ugroupw) {
        this.ugroupw = ugroupw;
    }

    public void setUgroupx(NSButton ugroupx) {
        this.ugroupx = ugroupx;
    }

    public void setUotherr(NSButton uotherr) {
        this.uotherr = uotherr;
    }

    public void setUotherw(NSButton uotherw) {
        this.uotherw = uotherw;
    }

    public void setUotherx(NSButton uotherx) {
        this.uotherx = uotherx;
    }

    public void defaultPermissionsDownloadChanged(ID sender) {
        boolean[][] p = new boolean[3][3];
        p[0][0] = this.downerr.state() == 1;
        p[0][1] = this.downerw.state() == 1;
        p[0][2] = this.downerx.state() == 1;
        p[1][0] = this.dgroupr.state() == 1;
        p[1][1] = this.dgroupw.state() == 1;
        p[1][2] = this.dgroupx.state() == 1;
        p[2][0] = this.dotherr.state() == 1;
        p[2][1] = this.dotherw.state() == 1;
        p[2][2] = this.dotherx.state() == 1;
        Permission permission = new Permission(p);
        if (this.chmodDownloadTypePopup.selectedItem().tag() == 0) {
            Preferences.instance().setProperty("queue.download.permissions.file.default", permission.getOctalString());
        }
        if (this.chmodDownloadTypePopup.selectedItem().tag() == 1) {
            Preferences.instance().setProperty("queue.download.permissions.folder.default", permission.getOctalString());
        }
    }

    public void defaultPermissionsUploadChanged(ID sender) {
        boolean[][] p = new boolean[3][3];
        p[0][0] = this.uownerr.state() == 1;
        p[0][1] = this.uownerw.state() == 1;
        p[0][2] = this.uownerx.state() == 1;
        p[1][0] = this.ugroupr.state() == 1;
        p[1][1] = this.ugroupw.state() == 1;
        p[1][2] = this.ugroupx.state() == 1;
        p[2][0] = this.uotherr.state() == 1;
        p[2][1] = this.uotherw.state() == 1;
        p[2][2] = this.uotherx.state() == 1;
        Permission permission = new Permission(p);
        if (this.chmodUploadTypePopup.selectedItem().tag() == 0) {
            Preferences.instance().setProperty("queue.upload.permissions.file.default", permission.getOctalString());
        }
        if (this.chmodUploadTypePopup.selectedItem().tag() == 1) {
            Preferences.instance().setProperty("queue.upload.permissions.folder.default", permission.getOctalString());
        }
    }

    public void setPreserveModificationDownloadCheckbox(NSButton preserveModificationDownloadCheckbox) {
        this.preserveModificationDownloadCheckbox = preserveModificationDownloadCheckbox;
        this.preserveModificationDownloadCheckbox.setTarget(this.id());
        this.preserveModificationDownloadCheckbox.setAction(Foundation.selector("preserveModificationDownloadCheckboxClicked:"));
        this.preserveModificationDownloadCheckbox.setState(Preferences.instance().getBoolean("queue.download.preserveDate") ? 1 : 0);
    }

    public void preserveModificationDownloadCheckboxClicked(NSButton sender) {
        boolean enabled = sender.state() == 1;
        Preferences.instance().setProperty("queue.download.preserveDate", enabled);
    }

    public void setPreserveModificationUploadCheckbox(NSButton preserveModificationUploadCheckbox) {
        this.preserveModificationUploadCheckbox = preserveModificationUploadCheckbox;
        this.preserveModificationUploadCheckbox.setTarget(this.id());
        this.preserveModificationUploadCheckbox.setAction(Foundation.selector("preserveModificationUploadCheckboxClicked:"));
        this.preserveModificationUploadCheckbox.setState(Preferences.instance().getBoolean("queue.upload.preserveDate") ? 1 : 0);
    }

    public void preserveModificationUploadCheckboxClicked(NSButton sender) {
        boolean enabled = sender.state() == 1;
        Preferences.instance().setProperty("queue.upload.preserveDate", enabled);
    }

    public void setHorizontalLinesCheckbox(NSButton horizontalLinesCheckbox) {
        this.horizontalLinesCheckbox = horizontalLinesCheckbox;
        this.horizontalLinesCheckbox.setTarget(this.id());
        this.horizontalLinesCheckbox.setAction(Foundation.selector("horizontalLinesCheckboxClicked:"));
        this.horizontalLinesCheckbox.setState(Preferences.instance().getBoolean("browser.horizontalLines") ? 1 : 0);
    }

    public void horizontalLinesCheckboxClicked(NSButton sender) {
        boolean enabled = sender.state() == 1;
        Preferences.instance().setProperty("browser.horizontalLines", enabled);
        CDBrowserController.updateBrowserTableAttributes();
    }

    public void setVerticalLinesCheckbox(NSButton verticalLinesCheckbox) {
        this.verticalLinesCheckbox = verticalLinesCheckbox;
        this.verticalLinesCheckbox.setTarget(this.id());
        this.verticalLinesCheckbox.setAction(Foundation.selector("verticalLinesCheckboxClicked:"));
        this.verticalLinesCheckbox.setState(Preferences.instance().getBoolean("browser.verticalLines") ? 1 : 0);
    }

    public void verticalLinesCheckboxClicked(NSButton sender) {
        boolean enabled = sender.state() == 1;
        Preferences.instance().setProperty("browser.verticalLines", enabled);
        CDBrowserController.updateBrowserTableAttributes();
    }

    public void setAlternatingRowBackgroundCheckbox(NSButton alternatingRowBackgroundCheckbox) {
        this.alternatingRowBackgroundCheckbox = alternatingRowBackgroundCheckbox;
        this.alternatingRowBackgroundCheckbox.setTarget(this.id());
        this.alternatingRowBackgroundCheckbox.setAction(Foundation.selector("alternatingRowBackgroundCheckboxClicked:"));
        this.alternatingRowBackgroundCheckbox.setState(Preferences.instance().getBoolean("browser.alternatingRows") ? 1 : 0);
    }

    public void alternatingRowBackgroundCheckboxClicked(NSButton sender) {
        boolean enabled = sender.state() == 1;
        Preferences.instance().setProperty("browser.alternatingRows", enabled);
        CDBrowserController.updateBrowserTableAttributes();
    }

    public void setInfoWindowAsInspectorCheckbox(NSButton infoWindowAsInspectorCheckbox) {
        this.infoWindowAsInspectorCheckbox = infoWindowAsInspectorCheckbox;
        this.infoWindowAsInspectorCheckbox.setTarget(this.id());
        this.infoWindowAsInspectorCheckbox.setAction(Foundation.selector("infoWindowAsInspectorCheckboxClicked:"));
        this.infoWindowAsInspectorCheckbox.setState(Preferences.instance().getBoolean("browser.info.isInspector") ? 1 : 0);
    }

    public void infoWindowAsInspectorCheckboxClicked(NSButton sender) {
        boolean enabled = sender.state() == 1;
        Preferences.instance().setProperty("browser.info.isInspector", enabled);
    }

    public void setDownloadPathPopup(NSPopUpButton downloadPathPopup) {
        this.downloadPathPopup = downloadPathPopup;
        this.downloadPathPopup.setTarget(this.id());
        Selector action = Foundation.selector("downloadPathPopupClicked:");
        this.downloadPathPopup.setAction(action);
        this.downloadPathPopup.removeAllItems();
        this.addDownloadPath(action, this.DEFAULT_DOWNLOAD_FOLDER);
        this.downloadPathPopup.menu().addItem(NSMenuItem.separatorItem());
        this.addDownloadPath(action, LocalFactory.createLocal((String)"~/Desktop"));
        this.addDownloadPath(action, LocalFactory.createLocal((String)"~"));
        this.addDownloadPath(action, LocalFactory.createLocal((String)"~/Downloads"));
        this.downloadPathPopup.menu().addItem(NSMenuItem.separatorItem());
        this.downloadPathPopup.menu().addItemWithTitle_action_keyEquivalent(CHOOSE, action, "");
        this.downloadPathPopup.itemAtIndex(this.downloadPathPopup.numberOfItems() - 1).setTarget(this.id());
    }

    private void addDownloadPath(Selector action, Local f) {
        if (f.exists()) {
            this.downloadPathPopup.menu().addItemWithTitle_action_keyEquivalent(NSFileManager.defaultManager().displayNameAtPath(f.getAbsolute()), action, "");
            this.downloadPathPopup.itemAtIndex(this.downloadPathPopup.numberOfItems() - 1).setTarget(this.id());
            this.downloadPathPopup.itemAtIndex(this.downloadPathPopup.numberOfItems() - 1).setImage(CDIconCache.instance().iconForPath(f, (Integer)16));
            this.downloadPathPopup.itemAtIndex(this.downloadPathPopup.numberOfItems() - 1).setRepresentedObject(f.getAbsolute());
            if (this.DEFAULT_DOWNLOAD_FOLDER.equals((Object)f)) {
                this.downloadPathPopup.selectItemAtIndex(this.downloadPathPopup.numberOfItems() - 1);
            }
        }
    }

    public void downloadPathPopupClicked(NSMenuItem sender) {
        if (sender.title().equals(CHOOSE)) {
            this.downloadPathPanel = NSOpenPanel.openPanel();
            this.downloadPathPanel.setCanChooseFiles(false);
            this.downloadPathPanel.setCanChooseDirectories(true);
            this.downloadPathPanel.setAllowsMultipleSelection(false);
            this.downloadPathPanel.setCanCreateDirectories(true);
            this.downloadPathPanel.beginSheetForDirectory(null, null, this.window, this.id(), Foundation.selector("downloadPathPanelDidEnd:returnCode:contextInfo:"), null);
        } else {
            Preferences.instance().setProperty("queue.download.folder", LocalFactory.createLocal((String)sender.representedObject()).getAbbreviatedPath());
        }
    }

    public void downloadPathPanelDidEnd_returnCode_contextInfo(NSOpenPanel sheet, int returncode, ID contextInfo) {
        NSArray selected;
        String filename;
        if (returncode == 1 && (filename = (selected = sheet.filenames()).lastObject().toString()) != null) {
            Preferences.instance().setProperty("queue.download.folder", LocalFactory.createLocal((String)filename).getAbbreviatedPath());
        }
        Local custom = LocalFactory.createLocal((String)Preferences.instance().getProperty("queue.download.folder"));
        this.downloadPathPopup.itemAtIndex(0).setTitle(NSFileManager.defaultManager().displayNameAtPath(custom.getAbsolute()));
        this.downloadPathPopup.itemAtIndex(0).setRepresentedObject(custom.getAbsolute());
        this.downloadPathPopup.itemAtIndex(0).setImage(CDIconCache.instance().iconForPath(custom, (Integer)16));
        this.downloadPathPopup.selectItemAtIndex(0);
        this.downloadPathPanel = null;
    }

    public void setTransferPopup(NSPopUpButton transferPopup) {
        this.transferPopup = transferPopup;
        this.transferPopup.setTarget(this.id());
        this.transferPopup.setAction(Foundation.selector("transferPopupClicked:"));
        this.transferPopup.selectItemAtIndex(Preferences.instance().getInteger("connection.host.max") == 1 ? 1 : 0);
    }

    public void transferPopupClicked(NSPopUpButton sender) {
        if (sender.indexOfSelectedItem() == 1) {
            Preferences.instance().setProperty("connection.host.max", 1);
        } else if (sender.indexOfSelectedItem() == 0) {
            Preferences.instance().setProperty("connection.host.max", -1);
        }
    }

    public void setAnonymousField(NSTextField anonymousField) {
        this.anonymousField = anonymousField;
        this.anonymousField.setStringValue(Preferences.instance().getProperty("connection.login.anon.pass"));
        NSNotificationCenter.defaultCenter().addObserver(this.id(), Foundation.selector("anonymousFieldDidChange:"), "NSControlTextDidChangeNotification", this.anonymousField);
    }

    public void anonymousFieldDidChange(NSNotification sender) {
        Preferences.instance().setProperty("connection.login.anon.pass", this.anonymousField.stringValue());
    }

    public void setTextFileTypeRegexField(NSTextField textFileTypeRegexField) {
        this.textFileTypeRegexField = textFileTypeRegexField;
        this.textFileTypeRegexField.setStringValue(Preferences.instance().getProperty("filetype.text.regex"));
        NSNotificationCenter.defaultCenter().addObserver(this.id(), Foundation.selector("textFileTypeRegexFieldDidChange:"), "NSControlTextDidChangeNotification", this.textFileTypeRegexField);
    }

    public void textFileTypeRegexFieldDidChange(NSNotification sender) {
        String value = this.textFileTypeRegexField.stringValue().trim();
        try {
            Pattern compiled = Pattern.compile(value);
            this.textFileTypeRegexField.setTextColor(NSColor.controlTextColor());
            Preferences.instance().setProperty("filetype.text.regex", compiled.pattern());
        }
        catch (PatternSyntaxException e) {
            this.textFileTypeRegexField.setTextColor(NSColor.redColor());
        }
    }

    public void setDownloadSkipButton(NSButton downloadSkipButton) {
        this.downloadSkipButton = downloadSkipButton;
        this.downloadSkipButton.setTarget(this.id());
        this.downloadSkipButton.setAction(Foundation.selector("downloadSkipButtonClicked:"));
        this.downloadSkipButton.setState(Preferences.instance().getBoolean("queue.download.skip.enable") ? 1 : 0);
    }

    public void downloadSkipButtonClicked(NSButton sender) {
        boolean enabled = sender.state() == 1;
        this.downloadSkipRegexField.setSelectable(enabled);
        this.downloadSkipRegexField.setEditable(enabled);
        this.downloadSkipRegexField.setTextColor(enabled ? NSColor.controlTextColor() : NSColor.disabledControlTextColor());
        Preferences.instance().setProperty("queue.download.skip.enable", enabled);
    }

    public void setDownloadSkipRegexDefaultButton(NSButton downloadSkipRegexDefaultButton) {
        this.downloadSkipRegexDefaultButton = downloadSkipRegexDefaultButton;
        this.downloadSkipRegexDefaultButton.setTarget(this.id());
        this.downloadSkipRegexDefaultButton.setAction(Foundation.selector("downloadSkipRegexDefaultButtonClicked:"));
    }

    public void downloadSkipRegexDefaultButtonClicked(NSButton sender) {
        String regex = Preferences.instance().getProperty("queue.download.skip.regex.default");
        this.downloadSkipRegexField.setString(regex);
        Preferences.instance().setProperty("queue.download.skip.regex", regex);
    }

    public void setDownloadSkipRegexField(NSTextView downloadSkipRegexField) {
        this.downloadSkipRegexField = downloadSkipRegexField;
        this.downloadSkipRegexField.setFont(NSFont.userFixedPitchFontOfSize(9.0));
        this.downloadSkipRegexField.setString(Preferences.instance().getProperty("queue.download.skip.regex"));
        NSNotificationCenter.defaultCenter().addObserver(this.id(), Foundation.selector("downloadSkipRegexFieldDidChange:"), "NSTextDidChangeNotification", this.downloadSkipRegexField);
    }

    public void downloadSkipRegexFieldDidChange(NSNotification sender) {
        String value = this.downloadSkipRegexField.string().trim();
        if ("".equals(value)) {
            Preferences.instance().setProperty("queue.download.skip.enable", false);
            Preferences.instance().setProperty("queue.download.skip.regex", value);
            this.downloadSkipButton.setState(0);
        }
        try {
            Pattern compiled = Pattern.compile(value);
            Preferences.instance().setProperty("queue.download.skip.regex", compiled.pattern());
            this.mark(this.downloadSkipRegexField.textStorage(), null);
        }
        catch (PatternSyntaxException e) {
            this.mark(this.downloadSkipRegexField.textStorage(), e);
        }
    }

    public void setUploadSkipButton(NSButton uploadSkipButton) {
        this.uploadSkipButton = uploadSkipButton;
        this.uploadSkipButton.setTarget(this.id());
        this.uploadSkipButton.setAction(Foundation.selector("uploadSkipButtonClicked:"));
        this.uploadSkipButton.setState(Preferences.instance().getBoolean("queue.upload.skip.enable") ? 1 : 0);
    }

    public void uploadSkipButtonClicked(NSButton sender) {
        boolean enabled = sender.state() == 1;
        this.uploadSkipRegexField.setSelectable(enabled);
        this.uploadSkipRegexField.setEditable(enabled);
        this.uploadSkipRegexField.setTextColor(enabled ? NSColor.controlTextColor() : NSColor.disabledControlTextColor());
        Preferences.instance().setProperty("queue.upload.skip.enable", enabled);
    }

    public void setUploadSkipRegexDefaultButton(NSButton uploadSkipRegexDefaultButton) {
        this.uploadSkipRegexDefaultButton = uploadSkipRegexDefaultButton;
        this.uploadSkipRegexDefaultButton.setTarget(this.id());
        this.uploadSkipRegexDefaultButton.setAction(Foundation.selector("uploadSkipRegexDefaultButtonClicked:"));
    }

    public void uploadSkipRegexDefaultButtonClicked(NSButton sender) {
        String regex = Preferences.instance().getProperty("queue.upload.skip.regex.default");
        this.uploadSkipRegexField.setString(regex);
        Preferences.instance().setProperty("queue.upload.skip.regex", regex);
    }

    public void setUploadSkipRegexField(NSTextView uploadSkipRegexField) {
        this.uploadSkipRegexField = uploadSkipRegexField;
        this.uploadSkipRegexField.setFont(NSFont.userFixedPitchFontOfSize(9.0));
        this.uploadSkipRegexField.setString(Preferences.instance().getProperty("queue.upload.skip.regex"));
        NSNotificationCenter.defaultCenter().addObserver(this.id(), Foundation.selector("uploadSkipRegexFieldDidChange:"), "NSTextDidChangeNotification", this.uploadSkipRegexField);
    }

    public void uploadSkipRegexFieldDidChange(NSNotification sender) {
        String value = this.uploadSkipRegexField.string().trim();
        if ("".equals(value)) {
            Preferences.instance().setProperty("queue.upload.skip.enable", false);
            Preferences.instance().setProperty("queue.upload.skip.regex", value);
            this.uploadSkipButton.setState(0);
        }
        try {
            Pattern compiled = Pattern.compile(value);
            Preferences.instance().setProperty("queue.upload.skip.regex", compiled.pattern());
            this.mark(this.uploadSkipRegexField.textStorage(), null);
        }
        catch (PatternSyntaxException e) {
            this.mark(this.uploadSkipRegexField.textStorage(), e);
        }
    }

    private void mark(NSMutableAttributedString text, PatternSyntaxException e) {
        if (null == e) {
            text.removeAttributeInRange("NSColor", NSRange.NSMakeRange(new NSUInteger(0L), text.length()));
            return;
        }
        int index = e.getIndex();
        NSRange range = null;
        if (-1 == index) {
            range = NSRange.NSMakeRange(new NSUInteger(0L), text.length());
        }
        if (index < text.length().intValue()) {
            range = NSRange.NSMakeRange(new NSUInteger(index), new NSUInteger(1L));
        }
        text.addAttributesInRange(RED_FONT, range);
    }

    public void setLoginField(NSTextField loginField) {
        this.loginField = loginField;
        this.loginField.setStringValue(Preferences.instance().getProperty("connection.login.name"));
        NSNotificationCenter.defaultCenter().addObserver(this.id(), Foundation.selector("loginFieldDidChange:"), "NSControlTextDidChangeNotification", this.loginField);
    }

    public void loginFieldDidChange(NSNotification sender) {
        Preferences.instance().setProperty("connection.login.name", this.loginField.stringValue());
    }

    public void setKeychainCheckbox(NSButton keychainCheckbox) {
        this.keychainCheckbox = keychainCheckbox;
        this.keychainCheckbox.setTarget(this.id());
        this.keychainCheckbox.setAction(Foundation.selector("keychainCheckboxClicked:"));
        this.keychainCheckbox.setState(Preferences.instance().getBoolean("connection.login.useKeychain") ? 1 : 0);
    }

    public void keychainCheckboxClicked(NSButton sender) {
        boolean enabled = sender.state() == 1;
        Preferences.instance().setProperty("connection.login.useKeychain", enabled);
    }

    public void setDoubleClickCheckbox(NSButton doubleClickCheckbox) {
        this.doubleClickCheckbox = doubleClickCheckbox;
        this.doubleClickCheckbox.setTarget(this.id());
        this.doubleClickCheckbox.setAction(Foundation.selector("doubleClickCheckboxClicked:"));
        this.doubleClickCheckbox.setState(Preferences.instance().getBoolean("browser.doubleclick.edit") ? 1 : 0);
    }

    public void doubleClickCheckboxClicked(NSButton sender) {
        boolean enabled = sender.state() == 1;
        Preferences.instance().setProperty("browser.doubleclick.edit", enabled);
    }

    public void setReturnKeyCheckbox(NSButton returnKeyCheckbox) {
        this.returnKeyCheckbox = returnKeyCheckbox;
        this.returnKeyCheckbox.setTarget(this.id());
        this.returnKeyCheckbox.setAction(Foundation.selector("returnKeyCheckboxClicked:"));
        this.returnKeyCheckbox.setState(Preferences.instance().getBoolean("browser.enterkey.rename") ? 1 : 0);
    }

    public void returnKeyCheckboxClicked(NSButton sender) {
        boolean enabled = sender.state() == 1;
        Preferences.instance().setProperty("browser.enterkey.rename", enabled);
    }

    public void setShowHiddenCheckbox(NSButton showHiddenCheckbox) {
        this.showHiddenCheckbox = showHiddenCheckbox;
        this.showHiddenCheckbox.setTarget(this.id());
        this.showHiddenCheckbox.setAction(Foundation.selector("showHiddenCheckboxClicked:"));
        this.showHiddenCheckbox.setState(Preferences.instance().getBoolean("browser.showHidden") ? 1 : 0);
    }

    public void showHiddenCheckboxClicked(NSButton sender) {
        boolean enabled = sender.state() == 1;
        Preferences.instance().setProperty("browser.showHidden", enabled);
    }

    public void setBringQueueToFrontCheckbox(NSButton bringQueueToFrontCheckbox) {
        this.bringQueueToFrontCheckbox = bringQueueToFrontCheckbox;
        this.bringQueueToFrontCheckbox.setTarget(this.id());
        this.bringQueueToFrontCheckbox.setAction(Foundation.selector("bringQueueToFrontCheckboxClicked:"));
        this.bringQueueToFrontCheckbox.setState(Preferences.instance().getBoolean("queue.orderFrontOnStart") ? 1 : 0);
    }

    public void bringQueueToFrontCheckboxClicked(NSButton sender) {
        boolean enabled = sender.state() == 1;
        Preferences.instance().setProperty("queue.orderFrontOnStart", enabled);
    }

    public void setBringQueueToBackCheckbox(NSButton bringQueueToBackCheckbox) {
        this.bringQueueToBackCheckbox = bringQueueToBackCheckbox;
        this.bringQueueToBackCheckbox.setTarget(this.id());
        this.bringQueueToBackCheckbox.setAction(Foundation.selector("bringQueueToBackCheckboxClicked:"));
        this.bringQueueToBackCheckbox.setState(Preferences.instance().getBoolean("queue.orderBackOnStop") ? 1 : 0);
    }

    public void bringQueueToBackCheckboxClicked(NSButton sender) {
        boolean enabled = sender.state() == 1;
        Preferences.instance().setProperty("queue.orderBackOnStop", enabled);
    }

    public void setRemoveFromQueueCheckbox(NSButton removeFromQueueCheckbox) {
        this.removeFromQueueCheckbox = removeFromQueueCheckbox;
        this.removeFromQueueCheckbox.setTarget(this.id());
        this.removeFromQueueCheckbox.setAction(Foundation.selector("removeFromQueueCheckboxClicked:"));
        this.removeFromQueueCheckbox.setState(Preferences.instance().getBoolean("queue.removeItemWhenComplete") ? 1 : 0);
    }

    public void removeFromQueueCheckboxClicked(NSButton sender) {
        boolean enabled = sender.state() == 1;
        Preferences.instance().setProperty("queue.removeItemWhenComplete", enabled);
    }

    public void setOpenAfterDownloadCheckbox(NSButton openAfterDownloadCheckbox) {
        this.openAfterDownloadCheckbox = openAfterDownloadCheckbox;
        this.openAfterDownloadCheckbox.setTarget(this.id());
        this.openAfterDownloadCheckbox.setAction(Foundation.selector("openAfterDownloadCheckboxClicked:"));
        this.openAfterDownloadCheckbox.setState(Preferences.instance().getBoolean("queue.postProcessItemWhenComplete") ? 1 : 0);
    }

    public void openAfterDownloadCheckboxClicked(NSButton sender) {
        boolean enabled = sender.state() == 1;
        Preferences.instance().setProperty("queue.postProcessItemWhenComplete", enabled);
    }

    private void duplicateComboboxClicked(String selected, String property) {
        if (selected.equals(TransferAction.ACTION_CALLBACK.getLocalizableString())) {
            Preferences.instance().setProperty(property, TransferAction.ACTION_CALLBACK.toString());
        } else if (selected.equals(TransferAction.ACTION_OVERWRITE.getLocalizableString())) {
            Preferences.instance().setProperty(property, TransferAction.ACTION_OVERWRITE.toString());
        } else if (selected.equals(TransferAction.ACTION_RESUME.getLocalizableString())) {
            Preferences.instance().setProperty(property, TransferAction.ACTION_RESUME.toString());
        } else if (selected.equals(TransferAction.ACTION_RENAME.getLocalizableString())) {
            Preferences.instance().setProperty(property, TransferAction.ACTION_RENAME.toString());
        } else if (selected.equals(TransferAction.ACTION_SKIP.getLocalizableString())) {
            Preferences.instance().setProperty(property, TransferAction.ACTION_SKIP.toString());
        }
    }

    public void setDuplicateDownloadCombobox(NSPopUpButton duplicateDownloadCombobox) {
        this.duplicateDownloadCombobox = duplicateDownloadCombobox;
        this.duplicateDownloadCombobox.setTarget(this.id());
        this.duplicateDownloadCombobox.setAction(Foundation.selector("duplicateDownloadComboboxClicked:"));
        this.duplicateDownloadCombobox.removeAllItems();
        this.duplicateDownloadCombobox.addItemsWithTitles(NSArray.arrayWithObjects(TransferAction.ACTION_CALLBACK.getLocalizableString(), TransferAction.ACTION_OVERWRITE.getLocalizableString(), TransferAction.ACTION_RESUME.getLocalizableString(), TransferAction.ACTION_RENAME.getLocalizableString(), TransferAction.ACTION_SKIP.getLocalizableString()));
        if (Preferences.instance().getProperty("queue.download.fileExists").equals(TransferAction.ACTION_CALLBACK.toString())) {
            this.duplicateDownloadCombobox.selectItemWithTitle(TransferAction.ACTION_CALLBACK.getLocalizableString());
        } else if (Preferences.instance().getProperty("queue.download.fileExists").equals(TransferAction.ACTION_OVERWRITE.toString())) {
            this.duplicateDownloadCombobox.selectItemWithTitle(TransferAction.ACTION_OVERWRITE.getLocalizableString());
        } else if (Preferences.instance().getProperty("queue.download.fileExists").equals(TransferAction.ACTION_RESUME.toString())) {
            this.duplicateDownloadCombobox.selectItemWithTitle(TransferAction.ACTION_RESUME.getLocalizableString());
        } else if (Preferences.instance().getProperty("queue.download.fileExists").equals(TransferAction.ACTION_RENAME.toString())) {
            this.duplicateDownloadCombobox.selectItemWithTitle(TransferAction.ACTION_RENAME.getLocalizableString());
        } else if (Preferences.instance().getProperty("queue.download.fileExists").equals(TransferAction.ACTION_SKIP.toString())) {
            this.duplicateDownloadCombobox.selectItemWithTitle(TransferAction.ACTION_SKIP.getLocalizableString());
        }
    }

    public void duplicateDownloadComboboxClicked(NSPopUpButton sender) {
        this.duplicateComboboxClicked(sender.selectedItem().title(), "queue.download.fileExists");
        this.duplicateDownloadOverwriteButtonClicked(this.duplicateDownloadOverwriteButton);
    }

    public void setDuplicateDownloadOverwriteButton(NSButton duplicateDownloadOverwriteButton) {
        this.duplicateDownloadOverwriteButton = duplicateDownloadOverwriteButton;
        this.duplicateDownloadOverwriteButton.setTarget(this.id());
        this.duplicateDownloadOverwriteButton.setAction(Foundation.selector("duplicateDownloadOverwriteButtonClicked:"));
        this.duplicateDownloadOverwriteButton.setState(Preferences.instance().getProperty("queue.download.reload.fileExists").equals(TransferAction.ACTION_OVERWRITE.toString()) ? 1 : 0);
    }

    public void duplicateDownloadOverwriteButtonClicked(NSButton sender) {
        boolean enabled;
        boolean bl = enabled = sender.state() == 1;
        if (enabled) {
            Preferences.instance().setProperty("queue.download.reload.fileExists", TransferAction.ACTION_OVERWRITE.toString());
        } else {
            Preferences.instance().setProperty("queue.download.reload.fileExists", Preferences.instance().getProperty("queue.download.fileExists"));
        }
    }

    public void setDuplicateUploadCombobox(NSPopUpButton duplicateUploadCombobox) {
        this.duplicateUploadCombobox = duplicateUploadCombobox;
        this.duplicateUploadCombobox.setTarget(this.id());
        this.duplicateUploadCombobox.setAction(Foundation.selector("duplicateUploadComboboxClicked:"));
        this.duplicateUploadCombobox.removeAllItems();
        this.duplicateUploadCombobox.addItemsWithTitles(NSArray.arrayWithObjects(TransferAction.ACTION_CALLBACK.getLocalizableString(), TransferAction.ACTION_OVERWRITE.getLocalizableString(), TransferAction.ACTION_RESUME.getLocalizableString(), TransferAction.ACTION_RENAME.getLocalizableString(), TransferAction.ACTION_SKIP.getLocalizableString()));
        if (Preferences.instance().getProperty("queue.upload.fileExists").equals(TransferAction.ACTION_CALLBACK.toString())) {
            this.duplicateUploadCombobox.selectItemWithTitle(TransferAction.ACTION_CALLBACK.getLocalizableString());
        } else if (Preferences.instance().getProperty("queue.upload.fileExists").equals(TransferAction.ACTION_OVERWRITE.toString())) {
            this.duplicateUploadCombobox.selectItemWithTitle(TransferAction.ACTION_OVERWRITE.getLocalizableString());
        } else if (Preferences.instance().getProperty("queue.upload.fileExists").equals(TransferAction.ACTION_RESUME.toString())) {
            this.duplicateUploadCombobox.selectItemWithTitle(TransferAction.ACTION_RESUME.getLocalizableString());
        } else if (Preferences.instance().getProperty("queue.upload.fileExists").equals(TransferAction.ACTION_RENAME.toString())) {
            this.duplicateUploadCombobox.selectItemWithTitle(TransferAction.ACTION_RENAME.getLocalizableString());
        } else if (Preferences.instance().getProperty("queue.upload.fileExists").equals(TransferAction.ACTION_SKIP.toString())) {
            this.duplicateUploadCombobox.selectItemWithTitle(TransferAction.ACTION_SKIP.getLocalizableString());
        }
    }

    public void duplicateUploadComboboxClicked(NSPopUpButton sender) {
        this.duplicateComboboxClicked(sender.selectedItem().title(), "queue.upload.fileExists");
        this.duplicateUploadOverwriteButtonClicked(this.duplicateUploadOverwriteButton);
    }

    public void setDuplicateUploadOverwriteButton(NSButton duplicateUploadOverwriteButton) {
        this.duplicateUploadOverwriteButton = duplicateUploadOverwriteButton;
        this.duplicateUploadOverwriteButton.setTarget(this.id());
        this.duplicateUploadOverwriteButton.setAction(Foundation.selector("duplicateUploadOverwriteButtonClicked:"));
        this.duplicateUploadOverwriteButton.setState(Preferences.instance().getProperty("queue.upload.reload.fileExists").equals(TransferAction.ACTION_OVERWRITE.toString()) ? 1 : 0);
    }

    public void duplicateUploadOverwriteButtonClicked(NSButton sender) {
        boolean enabled;
        boolean bl = enabled = sender.state() == 1;
        if (enabled) {
            Preferences.instance().setProperty("queue.upload.reload.fileExists", TransferAction.ACTION_OVERWRITE.toString());
        } else {
            Preferences.instance().setProperty("queue.upload.reload.fileExists", Preferences.instance().getProperty("queue.upload.fileExists"));
        }
    }

    public void setLineEndingCombobox(NSPopUpButton lineEndingCombobox) {
        this.lineEndingCombobox = lineEndingCombobox;
        this.lineEndingCombobox.setTarget(this.id());
        this.lineEndingCombobox.setAction(Foundation.selector("lineEndingComboboxClicked:"));
        this.lineEndingCombobox.removeAllItems();
        this.lineEndingCombobox.addItemsWithTitles(NSArray.arrayWithObjects(UNIX_LINE_ENDINGS, MAC_LINE_ENDINGS, WINDOWS_LINE_ENDINGS));
        if (Preferences.instance().getProperty("ftp.line.separator").equals("unix")) {
            this.lineEndingCombobox.selectItemWithTitle(UNIX_LINE_ENDINGS);
        } else if (Preferences.instance().getProperty("ftp.line.separator").equals("mac")) {
            this.lineEndingCombobox.selectItemWithTitle(MAC_LINE_ENDINGS);
        } else if (Preferences.instance().getProperty("ftp.line.separator").equals("win")) {
            this.lineEndingCombobox.selectItemWithTitle(WINDOWS_LINE_ENDINGS);
        }
    }

    public void lineEndingComboboxClicked(NSPopUpButton sender) {
        if (sender.selectedItem().title().equals(UNIX_LINE_ENDINGS)) {
            Preferences.instance().setProperty("ftp.line.separator", "unix");
        } else if (sender.selectedItem().title().equals(MAC_LINE_ENDINGS)) {
            Preferences.instance().setProperty("ftp.line.separator", "mac");
        } else if (sender.selectedItem().title().equals(WINDOWS_LINE_ENDINGS)) {
            Preferences.instance().setProperty("ftp.line.separator", "win");
        }
    }

    public void setTransfermodeCombobox(NSPopUpButton transfermodeCombobox) {
        this.transfermodeCombobox = transfermodeCombobox;
        this.transfermodeCombobox.setTarget(this.id());
        this.transfermodeCombobox.setAction(Foundation.selector("transfermodeComboboxClicked:"));
        this.transfermodeCombobox.removeAllItems();
        this.transfermodeCombobox.addItemsWithTitles(NSArray.arrayWithObjects(TRANSFERMODE_AUTO, TRANSFERMODE_BINARY, TRANSFERMODE_ASCII));
        if (Preferences.instance().getProperty("ftp.transfermode").equals(FTPTransferType.BINARY.toString())) {
            this.transfermodeCombobox.selectItemWithTitle(TRANSFERMODE_BINARY);
        } else if (Preferences.instance().getProperty("ftp.transfermode").equals(FTPTransferType.ASCII.toString())) {
            this.transfermodeCombobox.selectItemWithTitle(TRANSFERMODE_ASCII);
        } else if (Preferences.instance().getProperty("ftp.transfermode").equals(FTPTransferType.AUTO.toString())) {
            this.transfermodeCombobox.selectItemWithTitle(TRANSFERMODE_AUTO);
        }
    }

    public void transfermodeComboboxClicked(NSPopUpButton sender) {
        if (sender.selectedItem().title().equals(TRANSFERMODE_BINARY)) {
            Preferences.instance().setProperty("ftp.transfermode", FTPTransferType.BINARY.toString());
            this.lineEndingCombobox.setEnabled(false);
            this.textFileTypeRegexField.setEnabled(false);
        } else if (sender.selectedItem().title().equals(TRANSFERMODE_ASCII)) {
            Preferences.instance().setProperty("ftp.transfermode", FTPTransferType.ASCII.toString());
            this.lineEndingCombobox.setEnabled(true);
            this.textFileTypeRegexField.setEnabled(false);
        } else if (sender.selectedItem().title().equals(TRANSFERMODE_AUTO)) {
            Preferences.instance().setProperty("ftp.transfermode", FTPTransferType.AUTO.toString());
            this.lineEndingCombobox.setEnabled(true);
            this.textFileTypeRegexField.setEnabled(true);
        }
    }

    public void setProtocolCombobox(NSPopUpButton protocolCombobox) {
        Protocol[] protocols;
        this.protocolCombobox = protocolCombobox;
        this.protocolCombobox.setTarget(this.id());
        this.protocolCombobox.setAction(Foundation.selector("protocolComboboxClicked:"));
        this.protocolCombobox.removeAllItems();
        this.protocolCombobox.addItemsWithTitles(NSArray.arrayWithObjects(Protocol.getProtocolDescriptions()));
        for (Protocol protocol : protocols = Protocol.getKnownProtocols()) {
            NSMenuItem item = this.protocolCombobox.itemWithTitle(protocol.getDescription());
            item.setRepresentedObject(protocol.getIdentifier());
            item.setImage(CDIconCache.iconNamed(protocol.icon(), 16));
        }
        Protocol defaultProtocol = Protocol.forName((String)Preferences.instance().getProperty("connection.protocol.default"));
        this.protocolCombobox.selectItemWithTitle(defaultProtocol.getDescription());
    }

    public void protocolComboboxClicked(NSPopUpButton sender) {
        Protocol selected = Protocol.forName((String)sender.selectedItem().representedObject());
        Preferences.instance().setProperty("connection.protocol.default", selected.getIdentifier());
        Preferences.instance().setProperty("connection.port.default", selected.getDefaultPort());
    }

    public void setConfirmDisconnectCheckbox(NSButton confirmDisconnectCheckbox) {
        this.confirmDisconnectCheckbox = confirmDisconnectCheckbox;
        this.confirmDisconnectCheckbox.setTarget(this.id());
        this.confirmDisconnectCheckbox.setAction(Foundation.selector("confirmDisconnectCheckboxClicked:"));
        this.confirmDisconnectCheckbox.setState(Preferences.instance().getBoolean("browser.confirmDisconnect") ? 1 : 0);
    }

    public void confirmDisconnectCheckboxClicked(NSButton sender) {
        boolean enabled = sender.state() == 1;
        Preferences.instance().setProperty("browser.confirmDisconnect", enabled);
    }

    public void setSecureDataChannelCheckbox(NSButton secureDataChannelCheckbox) {
        this.secureDataChannelCheckbox = secureDataChannelCheckbox;
        this.secureDataChannelCheckbox.setTarget(this.id());
        this.secureDataChannelCheckbox.setAction(Foundation.selector("secureDataChannelCheckboxClicked:"));
        this.secureDataChannelCheckbox.setState(Preferences.instance().getProperty("ftp.tls.datachannel").equals("P") ? 1 : 0);
    }

    public void secureDataChannelCheckboxClicked(NSButton sender) {
        if (sender.state() == 1) {
            Preferences.instance().setProperty("ftp.tls.datachannel", "P");
        }
        if (sender.state() == 0) {
            Preferences.instance().setProperty("ftp.tls.datachannel", "C");
        }
    }

    public void setFailInsecureDataChannelCheckbox(NSButton failInsecureDataChannelCheckbox) {
        this.failInsecureDataChannelCheckbox = failInsecureDataChannelCheckbox;
        this.failInsecureDataChannelCheckbox.setTarget(this.id());
        this.failInsecureDataChannelCheckbox.setAction(Foundation.selector("failInsecureDataChannelCheckboxClicked:"));
        this.failInsecureDataChannelCheckbox.setState(Preferences.instance().getBoolean("ftp.tls.datachannel.failOnError") ? 0 : 1);
    }

    public void failInsecureDataChannelCheckboxClicked(NSButton sender) {
        boolean enabled = sender.state() == 1;
        Preferences.instance().setProperty("ftp.tls.datachannel.failOnError", !enabled);
    }

    public void setSshTransfersCombobox(NSPopUpButton sshTransfersCombobox) {
        this.sshTransfersCombobox = sshTransfersCombobox;
        this.sshTransfersCombobox.setTarget(this.id());
        this.sshTransfersCombobox.setAction(Foundation.selector("sshTransfersComboboxClicked:"));
        this.sshTransfersCombobox.removeAllItems();
        this.sshTransfersCombobox.addItemsWithTitles(NSArray.arrayWithObjects(Protocol.SFTP.getDescription(), Protocol.SCP.getDescription()));
        this.sshTransfersCombobox.itemWithTitle(Protocol.SFTP.getDescription()).setRepresentedObject(Protocol.SFTP.getIdentifier());
        this.sshTransfersCombobox.itemWithTitle(Protocol.SCP.getDescription()).setRepresentedObject(Protocol.SCP.getIdentifier());
        if (Preferences.instance().getProperty("ssh.transfer").equals(Protocol.SFTP.toString())) {
            this.sshTransfersCombobox.selectItemWithTitle(Protocol.SFTP.getDescription());
        } else if (Preferences.instance().getProperty("ssh.transfer").equals(Protocol.SCP.toString())) {
            this.sshTransfersCombobox.selectItemWithTitle(Protocol.SCP.getDescription());
        }
    }

    public void sshTransfersComboboxClicked(NSPopUpButton sender) {
        Preferences.instance().setProperty("ssh.transfer", sender.selectedItem().representedObject());
    }

    private void configureDefaultProtocolHandlerCombobox(NSPopUpButton defaultProtocolHandlerCombobox, Protocol protocol) {
        String[] bundleIdentifiers;
        String defaultHandler = URLSchemeHandlerConfiguration.instance().getDefaultHandlerForURLScheme(protocol.getScheme());
        if (null == defaultHandler) {
            defaultProtocolHandlerCombobox.addItemWithTitle(Locale.localizedString((String)"Unknown"));
            defaultProtocolHandlerCombobox.setEnabled(false);
            return;
        }
        log.debug((Object)("Default Protocol Handler for " + protocol + ":" + defaultHandler));
        for (String bundleIdentifier : bundleIdentifiers = URLSchemeHandlerConfiguration.instance().getAllHandlersForURLScheme(protocol.getScheme())) {
            NSBundle app;
            String path = NSWorkspace.sharedWorkspace().absolutePathForAppBundleWithIdentifier(bundleIdentifier);
            if (StringUtils.isEmpty((String)path) || null == (app = NSBundle.bundleWithPath(path)) || null == app.infoDictionary().objectForKey("CFBundleName")) continue;
            defaultProtocolHandlerCombobox.addItemWithTitle(app.infoDictionary().objectForKey("CFBundleName").toString());
            NSMenuItem item = defaultProtocolHandlerCombobox.lastItem();
            item.setImage(CDIconCache.instance().iconForPath(LocalFactory.createLocal((String)path), (Integer)16));
            item.setRepresentedObject(bundleIdentifier);
            if (!bundleIdentifier.equals(defaultHandler)) continue;
            defaultProtocolHandlerCombobox.selectItem(item);
        }
    }

    public void setDefaultFTPHandlerCombobox(NSPopUpButton defaultFTPHandlerCombobox) {
        this.defaultFTPHandlerCombobox = defaultFTPHandlerCombobox;
        this.defaultFTPHandlerCombobox.setTarget(this.id());
        this.defaultFTPHandlerCombobox.setAction(Foundation.selector("defaultFTPHandlerComboboxClicked:"));
        this.defaultFTPHandlerCombobox.removeAllItems();
        this.configureDefaultProtocolHandlerCombobox(this.defaultFTPHandlerCombobox, Protocol.FTP);
    }

    public void defaultFTPHandlerComboboxClicked(NSPopUpButton sender) {
        Protocol protocol = Protocol.forName((String)sender.selectedItem().representedObject());
        URLSchemeHandlerConfiguration.instance().setDefaultHandlerForURLScheme(new String[]{Protocol.FTP.getScheme(), Protocol.FTP_TLS.getScheme()}, protocol.getIdentifier());
    }

    public void setDefaultSFTPHandlerCombobox(NSPopUpButton defaultSFTPHandlerCombobox) {
        this.defaultSFTPHandlerCombobox = defaultSFTPHandlerCombobox;
        this.defaultSFTPHandlerCombobox.setTarget(this.id());
        this.defaultSFTPHandlerCombobox.setAction(Foundation.selector("defaultSFTPHandlerComboboxClicked:"));
        this.defaultSFTPHandlerCombobox.removeAllItems();
        this.configureDefaultProtocolHandlerCombobox(this.defaultSFTPHandlerCombobox, Protocol.SFTP);
    }

    public void defaultSFTPHandlerComboboxClicked(NSPopUpButton sender) {
        URLSchemeHandlerConfiguration.instance().setDefaultHandlerForURLScheme(Protocol.SFTP.getScheme(), sender.selectedItem().representedObject());
    }

    public void setDefaultDownloadThrottleCombobox(NSPopUpButton defaultDownloadThrottleCombobox) {
        this.defaultDownloadThrottleCombobox = defaultDownloadThrottleCombobox;
        this.defaultDownloadThrottleCombobox.setTarget(this.id());
        this.defaultDownloadThrottleCombobox.setAction(Foundation.selector("defaultDownloadThrottleComboboxClicked:"));
        float bandwidth = (int)Preferences.instance().getFloat("queue.download.bandwidth.bytes");
        if (-1.0f == bandwidth) {
            this.defaultDownloadThrottleCombobox.selectItemWithTag(-1);
        } else {
            this.defaultDownloadThrottleCombobox.selectItemWithTag((int)bandwidth / 1024);
        }
    }

    public void defaultDownloadThrottleComboboxClicked(NSPopUpButton sender) {
        int tag = sender.selectedItem().tag();
        if (-1 == tag) {
            Preferences.instance().setProperty("queue.download.bandwidth.bytes", -1);
        } else {
            Preferences.instance().setProperty("queue.download.bandwidth.bytes", (float)tag * 1024.0f);
        }
    }

    public void setDefaultUploadThrottleCombobox(NSPopUpButton defaultUploadThrottleCombobox) {
        this.defaultUploadThrottleCombobox = defaultUploadThrottleCombobox;
        this.defaultUploadThrottleCombobox.setTarget(this.id());
        this.defaultUploadThrottleCombobox.setAction(Foundation.selector("defaultUploadThrottleComboboxClicked:"));
        float bandwidth = (int)Preferences.instance().getFloat("queue.upload.bandwidth.bytes");
        if (-1.0f == bandwidth) {
            this.defaultUploadThrottleCombobox.selectItemWithTag(-1);
        } else {
            this.defaultUploadThrottleCombobox.selectItemWithTag((int)bandwidth / 1024);
        }
    }

    public void defaultUploadThrottleComboboxClicked(NSPopUpButton sender) {
        int tag = sender.selectedItem().tag();
        if (-1 == tag) {
            Preferences.instance().setProperty("queue.upload.bandwidth.bytes", -1);
        } else {
            Preferences.instance().setProperty("queue.upload.bandwidth.bytes", (float)tag * 1024.0f);
        }
    }

    public void setUpdateCheckbox(NSButton updateCheckbox) {
        this.updateCheckbox = updateCheckbox;
        this.updateCheckbox.setTarget(this.id());
        this.updateCheckbox.setAction(Foundation.selector("updateCheckboxClicked:"));
        this.updateCheckbox.setState(Preferences.instance().getBoolean("update.check") ? 1 : 0);
    }

    public void updateCheckboxClicked(NSButton sender) {
        boolean enabled = sender.state() == 1;
        Preferences.instance().setProperty("update.check", enabled);
        if (enabled) {
            Preferences.instance().setProperty("SUScheduledCheckInterval", Preferences.instance().getProperty("update.check.interval"));
        } else {
            Preferences.instance().deleteProperty("SUScheduledCheckInterval");
        }
    }

    public void setDefaultBucketLocation(NSPopUpButton defaultBucketLocation) {
        this.defaultBucketLocation = defaultBucketLocation;
        this.defaultBucketLocation.setAutoenablesItems(false);
        this.defaultBucketLocation.removeAllItems();
        this.defaultBucketLocation.addItemWithTitle("US");
        this.defaultBucketLocation.addItemWithTitle("EU");
        this.defaultBucketLocation.setTarget(this.id());
        this.defaultBucketLocation.setAction(Foundation.selector("defaultBucketLocationClicked:"));
        this.defaultBucketLocation.selectItemWithTitle(Preferences.instance().getProperty("s3.location"));
    }

    public void defaultBucketLocationClicked(NSPopUpButton sender) {
        Preferences.instance().setProperty("s3.location", sender.titleOfSelectedItem());
    }
}

