/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa;

import ch.cyberduck.core.threading.MainAction;
import ch.cyberduck.ui.cocoa.CDSheetCallback;
import ch.cyberduck.ui.cocoa.CDWindowController;
import ch.cyberduck.ui.cocoa.application.NSApplication;
import ch.cyberduck.ui.cocoa.application.NSButton;
import ch.cyberduck.ui.cocoa.application.NSPanel;
import ch.cyberduck.ui.cocoa.application.NSWindow;
import ch.cyberduck.ui.cocoa.threading.WindowMainAction;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.rococoa.Foundation;
import org.rococoa.ID;

public abstract class CDSheetController
extends CDWindowController
implements CDSheetCallback {
    private static Logger log = Logger.getLogger(CDSheetController.class);
    protected final CDWindowController parent;
    private int returncode;
    private static final List<CDSheetController> sheetRegistry = new ArrayList<CDSheetController>();

    public CDSheetController(CDWindowController parent) {
        this.parent = parent;
    }

    public CDSheetController(CDWindowController parent, NSWindow sheet) {
        this.parent = parent;
        this.window = sheet;
    }

    protected String getBundleName() {
        return null;
    }

    protected CDWindowController getParentController() {
        return this.parent;
    }

    public void closeSheet(NSButton sender) {
        log.debug((Object)("closeSheet:" + sender));
        if (!(sender.tag() != 1 && sender.tag() != -1 || this.validateInput())) {
            return;
        }
        NSApplication.sharedApplication().endSheet(this.window(), sender.tag());
    }

    public int returnCode() {
        return this.returncode;
    }

    protected boolean validateInput() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void callback(int returncode, ID context) {
        this.returncode = returncode;
        this.callback(returncode);
        NSWindow nSWindow = this.parent.window();
        synchronized (nSWindow) {
            this.parent.window().notify();
        }
        if (!this.isSingleton()) {
            this.invalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginSheet() {
        CDWindowController cDWindowController = this.parent;
        synchronized (cDWindowController) {
            if (this.isMainThread()) {
                this.beginSheetImpl();
                return;
            }
            this.invoke((MainAction)new WindowMainAction(this.parent){

                public void run() {
                    CDSheetController.this.beginSheetImpl();
                }
            }, true);
            NSWindow nSWindow = this.parent.window();
            synchronized (nSWindow) {
                while (this.parent.hasSheet()) {
                    try {
                        log.debug((Object)"Sleeping:waitForSheetDismiss...");
                        this.parent.window().wait();
                        log.debug((Object)"Awakened:waitForSheetDismiss");
                    }
                    catch (InterruptedException e) {
                        log.error((Object)e.getMessage());
                    }
                }
            }
        }
    }

    protected void beginSheetImpl() {
        this.loadBundle();
        NSApplication app = NSApplication.sharedApplication();
        app.beginSheet(this.window(), this.parent.window(), this.id(), Foundation.selector("sheetDidClose:returnCode:contextInfo:"), null);
        sheetRegistry.add(this);
    }

    public void sheetDidClose_returnCode_contextInfo(NSPanel sheet, int returncode, ID contextInfo) {
        sheet.orderOut(null);
        this.callback(returncode, contextInfo);
        sheetRegistry.remove(this);
    }

    public boolean isSingleton() {
        return false;
    }
}

