/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.DownloadTransfer;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.Status;
import ch.cyberduck.core.SyncTransfer;
import ch.cyberduck.core.Transfer;
import ch.cyberduck.core.TransferAction;
import ch.cyberduck.core.TransferPrompt;
import ch.cyberduck.core.UploadTransfer;
import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.core.threading.MainAction;
import ch.cyberduck.ui.cocoa.CDAbstractPathTableDelegate;
import ch.cyberduck.ui.cocoa.CDBundleController;
import ch.cyberduck.ui.cocoa.CDDateFormatter;
import ch.cyberduck.ui.cocoa.CDDownloadPrompt;
import ch.cyberduck.ui.cocoa.CDIconCache;
import ch.cyberduck.ui.cocoa.CDOutlineCell;
import ch.cyberduck.ui.cocoa.CDSheetController;
import ch.cyberduck.ui.cocoa.CDSyncPrompt;
import ch.cyberduck.ui.cocoa.CDTransferPromptModel;
import ch.cyberduck.ui.cocoa.CDUploadPrompt;
import ch.cyberduck.ui.cocoa.CDWindowController;
import ch.cyberduck.ui.cocoa.application.NSButton;
import ch.cyberduck.ui.cocoa.application.NSButtonCell;
import ch.cyberduck.ui.cocoa.application.NSCell;
import ch.cyberduck.ui.cocoa.application.NSColor;
import ch.cyberduck.ui.cocoa.application.NSFont;
import ch.cyberduck.ui.cocoa.application.NSImageCell;
import ch.cyberduck.ui.cocoa.application.NSLayoutManager;
import ch.cyberduck.ui.cocoa.application.NSOutlineView;
import ch.cyberduck.ui.cocoa.application.NSPopUpButton;
import ch.cyberduck.ui.cocoa.application.NSProgressIndicator;
import ch.cyberduck.ui.cocoa.application.NSTableColumn;
import ch.cyberduck.ui.cocoa.application.NSTableView;
import ch.cyberduck.ui.cocoa.application.NSTextField;
import ch.cyberduck.ui.cocoa.application.NSTextFieldCell;
import ch.cyberduck.ui.cocoa.foundation.NSAttributedString;
import ch.cyberduck.ui.cocoa.foundation.NSIndexSet;
import ch.cyberduck.ui.cocoa.foundation.NSNotification;
import ch.cyberduck.ui.cocoa.foundation.NSObject;
import ch.cyberduck.ui.cocoa.threading.WindowMainAction;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.rococoa.Foundation;
import org.rococoa.ID;
import org.rococoa.Rococoa;
import org.rococoa.cocoa.CGFloat;
import org.rococoa.cocoa.foundation.NSInteger;
import org.rococoa.cocoa.foundation.NSUInteger;

public abstract class CDTransferPrompt
extends CDSheetController
implements TransferPrompt {
    private static Logger log = Logger.getLogger(CDTransferPrompt.class);
    private NSButton toggleDetailsButton;
    private ProgressListener l = new ProgressListener(){

        public void message(final String msg) {
            CDTransferPrompt.this.invoke((MainAction)new WindowMainAction(CDTransferPrompt.this){

                public void run() {
                    CDTransferPrompt.this.statusLabel.setAttributedStringValue(NSAttributedString.attributedStringWithAttributes(msg, CDBundleController.TRUNCATE_MIDDLE_ATTRIBUTES));
                }
            });
        }
    };
    protected TransferAction action = TransferAction.forName((String)Preferences.instance().getProperty("queue.prompt.action.default"));
    protected Transfer transfer;
    private static final NSAttributedString UNKNOWN_STRING = NSAttributedString.attributedStringWithAttributes(Locale.localizedString((String)"Unknown"), TRUNCATE_MIDDLE_ATTRIBUTES);
    protected final TableColumnFactory tableColumnsFactory = new TableColumnFactory();
    protected NSOutlineView browserView;
    protected CDTransferPromptModel browserModel;
    protected CDAbstractPathTableDelegate browserViewDelegate;
    protected final NSButtonCell buttonCellPrototype = NSButtonCell.buttonCell();
    protected final NSTextFieldCell outlineCellPrototype = CDOutlineCell.outlineCell();
    protected final NSImageCell imageCellPrototype = NSImageCell.imageCell();
    protected final NSTextFieldCell textCellPrototype = NSTextFieldCell.textFieldCell();
    private NSTextField remoteURLField;
    private NSTextField remoteSizeField;
    private NSTextField remoteModificationField;
    private NSTextField localURLField;
    private NSTextField localSizeField;
    private NSTextField localModificationField;
    private NSProgressIndicator statusIndicator;
    private NSTextField statusLabel;
    protected NSPopUpButton actionPopup;

    public static TransferPrompt create(CDWindowController parent, Transfer transfer) {
        if (transfer instanceof DownloadTransfer) {
            return new CDDownloadPrompt(parent, transfer);
        }
        if (transfer instanceof UploadTransfer) {
            return new CDUploadPrompt(parent, transfer);
        }
        if (transfer instanceof SyncTransfer) {
            return new CDSyncPrompt(parent, transfer);
        }
        throw new IllegalArgumentException(transfer.toString());
    }

    public CDTransferPrompt(CDWindowController parent, Transfer transfer) {
        super(parent);
        this.transfer = transfer;
    }

    protected String getBundleName() {
        return "Prompt";
    }

    public void setToggleDetailsButton(NSButton toggleDetailsButton) {
        this.toggleDetailsButton = toggleDetailsButton;
    }

    public void awakeFromNib() {
        this.transfer.getSession().addProgressListener(this.l);
        this.reloadData();
        if (this.browserView.numberOfRows().intValue() > 0) {
            this.browserView.selectRowIndexes(NSIndexSet.indexSetWithIndex(new NSInteger(0L)), false);
        }
        this.setState(this.toggleDetailsButton, Preferences.instance().getBoolean("transfer.toggle.details"));
        super.awakeFromNib();
    }

    public void invalidate() {
        this.transfer.getSession().removeProgressListener(this.l);
        this.browserView.setDataSource(null);
        this.browserView.setDelegate(null);
        this.browserModel.invalidate();
        super.invalidate();
    }

    public TransferAction getAction() {
        return this.action;
    }

    public void callback(int returncode) {
        log.debug((Object)("callback:" + returncode));
        if (returncode == 0) {
            this.action = TransferAction.ACTION_CANCEL;
        }
        Preferences.instance().setProperty("transfer.toggle.details", this.toggleDetailsButton.state());
    }

    public void reloadData() {
        log.debug((Object)"reloadData");
        this.statusIndicator.startAnimation(null);
        this.browserView.reloadData();
        this.statusIndicator.stopAnimation(null);
        this.statusLabel.setAttributedStringValue(NSAttributedString.attributedStringWithAttributes((Object)((Object)this.browserView.numberOfRows()) + " " + Locale.localizedString((String)"files"), TRUNCATE_MIDDLE_ATTRIBUTES));
    }

    public TransferAction prompt() {
        log.debug((Object)("prompt:" + this.transfer));
        for (Path next : this.transfer.getRoots()) {
            if (!this.browserModel.filter().accept((AbstractPath)next)) continue;
            this.browserModel.add(next);
        }
        this.beginSheet();
        return this.action;
    }

    public void setBrowserView(NSOutlineView view) {
        this.browserView = view;
        this.browserView.setHeaderView(null);
        this.browserView.setDataSource(this.browserModel.id());
        this.browserViewDelegate = new CDAbstractPathTableDelegate(){

            public void enterKeyPressed(ID sender) {
            }

            public void deleteKeyPressed(ID sender) {
            }

            public void tableColumnClicked(NSTableView view, NSTableColumn tableColumn) {
            }

            public void tableRowDoubleClicked(ID sender) {
            }

            public void selectionDidChange(NSNotification notification) {
                if (CDTransferPrompt.this.browserView.selectedRow().intValue() == -1) {
                    CDTransferPrompt.this.remoteURLField.setStringValue("");
                    CDTransferPrompt.this.remoteSizeField.setStringValue("");
                    CDTransferPrompt.this.remoteModificationField.setStringValue("");
                    CDTransferPrompt.this.localURLField.setStringValue("");
                    CDTransferPrompt.this.localSizeField.setStringValue("");
                    CDTransferPrompt.this.localModificationField.setStringValue("");
                } else {
                    Path p = CDTransferPrompt.this.browserModel.lookup(CDTransferPrompt.this.browserView.itemAtRow(CDTransferPrompt.this.browserView.selectedRow()));
                    CDTransferPrompt.this.localURLField.setAttributedStringValue(NSAttributedString.attributedStringWithAttributes(p.getLocal().getAbsolute(), CDBundleController.TRUNCATE_MIDDLE_ATTRIBUTES));
                    CDTransferPrompt.this.localURLField.setHidden(false);
                    if (p.getLocal().exists()) {
                        if (p.getLocal().attributes.getSize() == -1L) {
                            CDTransferPrompt.this.localSizeField.setAttributedStringValue(UNKNOWN_STRING);
                        } else {
                            CDTransferPrompt.this.localSizeField.setAttributedStringValue(NSAttributedString.attributedStringWithAttributes(Status.getSizeAsString((double)p.getLocal().attributes.getSize()), CDBundleController.TRUNCATE_MIDDLE_ATTRIBUTES));
                        }
                        CDTransferPrompt.this.localSizeField.setHidden(false);
                        if (p.getLocal().attributes.getModificationDate() == -1L) {
                            CDTransferPrompt.this.localModificationField.setAttributedStringValue(UNKNOWN_STRING);
                        } else {
                            CDTransferPrompt.this.localModificationField.setAttributedStringValue(NSAttributedString.attributedStringWithAttributes(CDDateFormatter.getLongFormat(p.getLocal().attributes.getModificationDate()), CDBundleController.TRUNCATE_MIDDLE_ATTRIBUTES));
                        }
                        CDTransferPrompt.this.localModificationField.setHidden(false);
                    } else {
                        CDTransferPrompt.this.localSizeField.setStringValue("");
                        CDTransferPrompt.this.localModificationField.setStringValue("");
                    }
                    CDTransferPrompt.this.remoteURLField.setAttributedStringValue(NSAttributedString.attributedStringWithAttributes(p.getHost().toURL() + p.getAbsolute(), CDBundleController.TRUNCATE_MIDDLE_ATTRIBUTES));
                    CDTransferPrompt.this.remoteURLField.setHidden(false);
                    if (p.exists()) {
                        if (p.attributes.getSize() == -1L) {
                            CDTransferPrompt.this.remoteSizeField.setAttributedStringValue(UNKNOWN_STRING);
                        } else {
                            CDTransferPrompt.this.remoteSizeField.setAttributedStringValue(NSAttributedString.attributedStringWithAttributes(Status.getSizeAsString((double)p.attributes.getSize()), CDBundleController.TRUNCATE_MIDDLE_ATTRIBUTES));
                        }
                        CDTransferPrompt.this.remoteSizeField.setHidden(false);
                        if (p.attributes.getModificationDate() == -1L) {
                            CDTransferPrompt.this.remoteModificationField.setAttributedStringValue(UNKNOWN_STRING);
                        } else {
                            CDTransferPrompt.this.remoteModificationField.setAttributedStringValue(NSAttributedString.attributedStringWithAttributes(CDDateFormatter.getLongFormat(p.attributes.getModificationDate()), CDBundleController.TRUNCATE_MIDDLE_ATTRIBUTES));
                        }
                        CDTransferPrompt.this.remoteModificationField.setHidden(false);
                    } else {
                        CDTransferPrompt.this.remoteSizeField.setStringValue("");
                        CDTransferPrompt.this.remoteModificationField.setStringValue("");
                    }
                }
            }

            public void outlineView_willDisplayCell_forTableColumn_item(NSOutlineView view, NSCell cell, NSTableColumn tableColumn, NSObject item) {
                String identifier = tableColumn.identifier();
                Path path = CDTransferPrompt.this.browserModel.lookup(item);
                if (identifier.equals("INCLUDE")) {
                    cell.setEnabled(CDTransferPrompt.this.transfer.isSelectable(path));
                }
                if (identifier.equals("FILENAME")) {
                    Rococoa.cast(cell, CDOutlineCell.class).setIcon(CDIconCache.instance().iconForPath(path, (Integer)16));
                }
                if (cell.isKindOfClass(Foundation.getClass(NSTextFieldCell.class.getSimpleName()))) {
                    if (!CDTransferPrompt.this.transfer.isIncluded(path)) {
                        Rococoa.cast(cell, NSTextFieldCell.class).setTextColor(NSColor.disabledControlTextColor());
                    } else {
                        Rococoa.cast(cell, NSTextFieldCell.class).setTextColor(NSColor.controlTextColor());
                    }
                }
            }
        };
        this.browserView.setDelegate(this.browserViewDelegate.id());
        this.browserView.setRowHeight(new CGFloat(NSLayoutManager.layoutManager().defaultLineHeightForFont(NSFont.systemFontOfSize(Preferences.instance().getFloat("browser.font.size"))).intValue() + 2));
        this.browserView.setAllowsMultipleSelection(true);
        this.browserView.setAllowsEmptySelection(true);
        this.browserView.setAllowsColumnResizing(true);
        this.browserView.setAllowsColumnSelection(false);
        this.browserView.setAllowsColumnReordering(true);
        this.browserView.setUsesAlternatingRowBackgroundColors(Preferences.instance().getBoolean("browser.alternatingRows"));
        if (Preferences.instance().getBoolean("browser.horizontalLines") && Preferences.instance().getBoolean("browser.verticalLines")) {
            this.browserView.setGridStyleMask(new NSUInteger(NSTableView.NSTableViewSolidHorizontalGridLineMask.intValue() | NSTableView.NSTableViewSolidVerticalGridLineMask.intValue()));
        } else if (Preferences.instance().getBoolean("browser.verticalLines")) {
            this.browserView.setGridStyleMask(NSTableView.NSTableViewSolidVerticalGridLineMask);
        } else if (Preferences.instance().getBoolean("browser.horizontalLines")) {
            this.browserView.setGridStyleMask(NSTableView.NSTableViewSolidHorizontalGridLineMask);
        } else {
            this.browserView.setGridStyleMask(NSTableView.NSTableViewGridNone);
        }
        NSTableColumn c = this.tableColumnsFactory.create("FILENAME");
        c.headerCell().setStringValue(Locale.localizedString((String)"Filename"));
        c.setMinWidth(100.0);
        c.setWidth(220.0);
        c.setMaxWidth(800.0);
        c.setResizingMask(3);
        c.setEditable(false);
        c.setDataCell(this.outlineCellPrototype);
        this.browserView.addTableColumn(c);
        this.browserView.setOutlineTableColumn(c);
        c = this.tableColumnsFactory.create("SIZE");
        c.headerCell().setStringValue("");
        c.setMinWidth(50.0);
        c.setWidth(80.0);
        c.setMaxWidth(100.0);
        c.setResizingMask(3);
        c.setEditable(false);
        c.setDataCell(this.textCellPrototype);
        this.browserView.addTableColumn(c);
        c = this.tableColumnsFactory.create("WARNING");
        c.headerCell().setStringValue("");
        c.setMinWidth(20.0);
        c.setWidth(20.0);
        c.setMaxWidth(20.0);
        c.setResizingMask(1);
        c.setEditable(false);
        c.setDataCell(this.imageCellPrototype);
        c.dataCell().setAlignment(2);
        this.browserView.addTableColumn(c);
        c = this.tableColumnsFactory.create("INCLUDE");
        c.headerCell().setStringValue("");
        c.setMinWidth(20.0);
        c.setWidth(20.0);
        c.setMaxWidth(20.0);
        c.setResizingMask(1);
        c.setEditable(false);
        NSButtonCell cell = this.buttonCellPrototype;
        cell.setTitle("");
        cell.setControlSize(1);
        cell.setButtonType(3);
        cell.setAllowsMixedState(false);
        cell.setTarget(this.id());
        cell.setAlignment(2);
        c.setDataCell(cell);
        this.browserView.addTableColumn(c);
        this.browserView.sizeToFit();
    }

    public void setRemoteURLField(NSTextField f) {
        this.remoteURLField = f;
        this.remoteURLField.setHidden(true);
    }

    public void setRemoteSizeField(NSTextField f) {
        this.remoteSizeField = f;
        this.remoteSizeField.setHidden(true);
    }

    public void setRemoteModificationField(NSTextField f) {
        this.remoteModificationField = f;
        this.remoteModificationField.setHidden(true);
    }

    public void setLocalURLField(NSTextField f) {
        this.localURLField = f;
        this.localURLField.setHidden(true);
    }

    public void setLocalSizeField(NSTextField f) {
        this.localSizeField = f;
        this.localSizeField.setHidden(true);
    }

    public void setLocalModificationField(NSTextField f) {
        this.localModificationField = f;
        this.localModificationField.setHidden(true);
    }

    public void setStatusIndicator(NSProgressIndicator f) {
        this.statusIndicator = f;
        this.statusIndicator.setDisplayedWhenStopped(false);
    }

    public void setStatusLabel(NSTextField f) {
        this.statusLabel = f;
    }

    public void setActionPopup(NSPopUpButton actionPopup) {
        TransferAction[] actions;
        this.actionPopup = actionPopup;
        this.actionPopup.removeAllItems();
        TransferAction defaultAction = TransferAction.forName((String)Preferences.instance().getProperty("queue.prompt.action.default"));
        for (TransferAction action : actions = new TransferAction[]{this.transfer.isResumable() ? TransferAction.ACTION_RESUME : null, TransferAction.ACTION_OVERWRITE, TransferAction.ACTION_RENAME, TransferAction.ACTION_SKIP}) {
            if (null == action) continue;
            this.actionPopup.addItemWithTitle(action.getLocalizableString());
            this.actionPopup.lastItem().setRepresentedObject(action.toString());
            if (!action.equals((Object)defaultAction)) continue;
            this.actionPopup.selectItem(actionPopup.lastItem());
        }
        this.action = TransferAction.forName((String)this.actionPopup.selectedItem().representedObject());
        this.actionPopup.setTarget(this.id());
        this.actionPopup.setAction(Foundation.selector("actionPopupClicked:"));
    }

    public void actionPopupClicked(NSPopUpButton sender) {
        TransferAction selected = TransferAction.forName((String)sender.selectedItem().representedObject());
        if (this.action.equals((Object)selected)) {
            return;
        }
        Preferences.instance().setProperty("queue.prompt.action.default", selected.toString());
        this.action = selected;
        this.browserView.reloadData();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class TableColumnFactory
    extends HashMap<String, NSTableColumn> {
        protected TableColumnFactory() {
        }

        protected NSTableColumn create(String identifier) {
            if (!this.containsKey(identifier)) {
                this.put(identifier, NSTableColumn.tableColumnWithIdentifier(identifier));
            }
            return (NSTableColumn)this.get(identifier);
        }
    }
}

