/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.Collection;
import ch.cyberduck.core.NullComparator;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathFilter;
import ch.cyberduck.core.PathReference;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.Transfer;
import ch.cyberduck.core.TransferAction;
import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.core.threading.AbstractBackgroundAction;
import ch.cyberduck.core.threading.BackgroundAction;
import ch.cyberduck.ui.cocoa.AttributeCache;
import ch.cyberduck.ui.cocoa.CDIconCache;
import ch.cyberduck.ui.cocoa.CDOutlineDataSource;
import ch.cyberduck.ui.cocoa.CDTableCellAttributes;
import ch.cyberduck.ui.cocoa.CDTransferPrompt;
import ch.cyberduck.ui.cocoa.CDWindowController;
import ch.cyberduck.ui.cocoa.application.NSImage;
import ch.cyberduck.ui.cocoa.application.NSOutlineView;
import ch.cyberduck.ui.cocoa.application.NSTableColumn;
import ch.cyberduck.ui.cocoa.foundation.NSAttributedString;
import ch.cyberduck.ui.cocoa.foundation.NSNumber;
import ch.cyberduck.ui.cocoa.foundation.NSObject;
import ch.cyberduck.ui.cocoa.foundation.NSString;
import ch.cyberduck.ui.cocoa.model.CDPathReference;
import java.text.MessageFormat;
import java.util.Comparator;
import java.util.List;
import org.apache.log4j.Logger;
import org.rococoa.Rococoa;
import org.rococoa.cocoa.foundation.NSInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CDTransferPromptModel
extends CDOutlineDataSource {
    protected static Logger log = Logger.getLogger(CDTransferPromptModel.class);
    protected final Transfer transfer;
    protected final List<Path> roots = new Collection();
    private CDWindowController controller;
    protected static final String INCLUDE_COLUMN = "INCLUDE";
    protected static final String WARNING_COLUMN = "WARNING";
    protected static final String FILENAME_COLUMN = "FILENAME";
    protected static final String SIZE_COLUMN = "SIZE";
    protected static final String TYPEAHEAD_COLUMN = "TYPEAHEAD";
    private final Cache<Path> cache = new Cache();
    private final List<Path> isLoadingListingInBackground = new Collection();
    protected final NSImage ALERT_ICON = CDIconCache.iconNamed("alert.tiff");
    protected AttributeCache<Path> modelCache = new AttributeCache(Preferences.instance().getInteger("browser.model.cache.size"));

    public CDTransferPromptModel(CDWindowController c, Transfer transfer) {
        this.controller = c;
        this.transfer = transfer;
    }

    @Override
    protected void invalidate() {
        this.modelCache.clear();
        this.cache.clear();
        super.invalidate();
    }

    public void add(Path p) {
        this.roots.add(p);
    }

    protected Path lookup(NSObject reference) {
        if (this.roots.contains(reference)) {
            return this.roots.get(this.roots.indexOf(reference));
        }
        return (Path)this.cache.lookup((PathReference)new CDPathReference(reference));
    }

    @Override
    public void outlineView_setObjectValue_forTableColumn_byItem(NSOutlineView outlineView, NSObject value, NSTableColumn tableColumn, NSObject item) {
        String identifier = tableColumn.identifier();
        if (identifier.equals(INCLUDE_COLUMN)) {
            Path path = this.lookup(item);
            this.transfer.setSkipped(path, Rococoa.cast(value, NSNumber.class).intValue() == 0);
            if (path.attributes.isDirectory()) {
                outlineView.setNeedsDisplay(true);
            }
        }
    }

    protected abstract PathFilter<Path> filter();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AttributedList<Path> childs(final Path path) {
        List<Path> list = this.isLoadingListingInBackground;
        synchronized (list) {
            if (!this.isLoadingListingInBackground.contains(path)) {
                if (this.cache.containsKey((AbstractPath)path)) {
                    return this.cache.get((AbstractPath)path, (Comparator)new NullComparator(), this.filter());
                }
                log.warn((Object)("No cached listing for " + path.getName()));
                this.isLoadingListingInBackground.add(path);
                this.controller.background((BackgroundAction)new AbstractBackgroundAction(){

                    public void run() {
                        CDTransferPromptModel.this.cache.put((AbstractPath)path, CDTransferPromptModel.this.transfer.childs(path));
                    }

                    public String getActivity() {
                        return MessageFormat.format(Locale.localizedString((String)"Listing directory {0}", (String)"Status"), path.getName());
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void cleanup() {
                        List list = CDTransferPromptModel.this.isLoadingListingInBackground;
                        synchronized (list) {
                            CDTransferPromptModel.this.isLoadingListingInBackground.remove(path);
                            if (CDTransferPromptModel.this.isLoadingListingInBackground.isEmpty()) {
                                ((CDTransferPrompt)CDTransferPromptModel.this.controller).reloadData();
                            }
                        }
                    }
                });
            }
            return this.cache.get((AbstractPath)path, (Comparator)new NullComparator(), this.filter());
        }
    }

    protected NSObject objectValueForItem(Path item, String identifier) {
        NSObject cached = this.modelCache.get(item, identifier);
        if (null == cached) {
            if (identifier.equals(INCLUDE_COLUMN)) {
                boolean skipped = !this.transfer.isIncluded(item) || ((CDTransferPrompt)this.controller).getAction().equals((Object)TransferAction.ACTION_SKIP);
                return NSNumber.numberWithInt(skipped ? 0 : 1);
            }
            if (identifier.equals(FILENAME_COLUMN)) {
                return this.modelCache.put(item, identifier, NSAttributedString.attributedStringWithAttributes(item.getName(), CDTableCellAttributes.browserFontLeftAlignment()));
            }
            if (identifier.equals(TYPEAHEAD_COLUMN)) {
                return this.modelCache.put(item, identifier, NSString.stringWithString(item.getName()));
            }
            throw new IllegalArgumentException("Unknown identifier: " + identifier);
        }
        return cached;
    }

    @Override
    public boolean outlineView_isItemExpandable(NSOutlineView view, NSObject item) {
        if (null == item) {
            return false;
        }
        return this.lookup((NSObject)item).attributes.isDirectory();
    }

    @Override
    public NSInteger outlineView_numberOfChildrenOfItem(NSOutlineView view, NSObject item) {
        if (null == item) {
            return new NSInteger(this.roots.size());
        }
        return new NSInteger(this.childs(this.lookup(item)).size());
    }

    @Override
    public NSObject outlineView_child_ofItem(NSOutlineView view, NSInteger index, NSObject item) {
        if (null == item) {
            return (NSObject)this.roots.get(index.intValue()).getReference().unique();
        }
        AttributedList<Path> childs = this.childs(this.lookup(item));
        if (childs.isEmpty()) {
            return null;
        }
        return (NSObject)((Path)childs.get(index.intValue())).getReference().unique();
    }

    @Override
    public NSObject outlineView_objectValueForTableColumn_byItem(NSOutlineView outlineView, NSTableColumn tableColumn, NSObject item) {
        return this.objectValueForItem(this.lookup(item), tableColumn.identifier());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class PromptFilter
    implements PathFilter<Path> {
        protected PromptFilter() {
        }

        public boolean accept(Path file) {
            return true;
        }
    }
}

