/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa;

import ch.cyberduck.core.AbstractCollectionListener;
import ch.cyberduck.core.CollectionListener;
import ch.cyberduck.core.DownloadTransfer;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.NullTransferFilter;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.Transfer;
import ch.cyberduck.core.TransferCollection;
import ch.cyberduck.core.TransferFilter;
import ch.cyberduck.ui.cocoa.AttributeCache;
import ch.cyberduck.ui.cocoa.CDDownloadController;
import ch.cyberduck.ui.cocoa.CDListDataSource;
import ch.cyberduck.ui.cocoa.CDProgressController;
import ch.cyberduck.ui.cocoa.CDTransferController;
import ch.cyberduck.ui.cocoa.CDWindowController;
import ch.cyberduck.ui.cocoa.PathPasteboard;
import ch.cyberduck.ui.cocoa.application.NSDraggingInfo;
import ch.cyberduck.ui.cocoa.application.NSTableColumn;
import ch.cyberduck.ui.cocoa.application.NSTableView;
import ch.cyberduck.ui.cocoa.foundation.NSArray;
import ch.cyberduck.ui.cocoa.foundation.NSDictionary;
import ch.cyberduck.ui.cocoa.foundation.NSIndexSet;
import ch.cyberduck.ui.cocoa.foundation.NSObject;
import ch.cyberduck.ui.cocoa.foundation.NSString;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.rococoa.cocoa.foundation.NSInteger;
import org.rococoa.cocoa.foundation.NSUInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDTransferTableDataSource
extends CDListDataSource {
    private static Logger log = Logger.getLogger(CDTransferTableDataSource.class);
    public static final String PROGRESS_COLUMN = "PROGRESS";
    protected static final String TYPEAHEAD_COLUMN = "TYPEAHEAD";
    private final Map<Transfer, CDProgressController> controllers = new HashMap<Transfer, CDProgressController>();
    private TransferFilter filter = new NullTransferFilter();
    private AttributeCache<Transfer> cache = new AttributeCache(Preferences.instance().getInteger("queue.model.cache.size"));

    public CDTransferTableDataSource() {
        TransferCollection.instance().addListener((CollectionListener)new AbstractCollectionListener<Transfer>(){

            public void collectionItemRemoved(Transfer item) {
                CDProgressController controller = (CDProgressController)CDTransferTableDataSource.this.controllers.remove(item);
                if (controller != null) {
                    controller.invalidate();
                }
            }
        });
    }

    @Override
    protected void invalidate() {
        this.cache.clear();
        super.invalidate();
    }

    public void setFilter(final String searchString) {
        this.filter = StringUtils.isBlank((String)searchString) ? new NullTransferFilter() : new TransferFilter(){

            public boolean accept(Transfer transfer) {
                return transfer.getName().toLowerCase().contains(searchString.toLowerCase()) || transfer.getSession().getHost().getHostname().toLowerCase().contains(searchString.toLowerCase());
            }
        };
    }

    protected ch.cyberduck.core.Collection<Transfer> getSource() {
        if (null == this.filter) {
            return TransferCollection.instance();
        }
        ch.cyberduck.core.Collection filtered = new ch.cyberduck.core.Collection((Collection)TransferCollection.instance());
        Iterator i = filtered.iterator();
        while (i.hasNext()) {
            if (this.filter.accept((Transfer)i.next())) continue;
            i.remove();
        }
        return filtered;
    }

    @Override
    public NSInteger numberOfRowsInTableView(NSTableView view) {
        return new NSInteger(this.getSource().size());
    }

    @Override
    public NSObject tableView_objectValueForTableColumn_row(NSTableView view, NSTableColumn tableColumn, NSInteger row) {
        String identifier = tableColumn.identifier();
        Transfer item = (Transfer)this.getSource().get(row.intValue());
        NSObject cached = this.cache.get(item, identifier);
        if (null == cached) {
            if (identifier.equals(PROGRESS_COLUMN)) {
                return this.cache.put(item, identifier, null);
            }
            if (identifier.equals(TYPEAHEAD_COLUMN)) {
                return this.cache.put(item, identifier, NSString.stringWithString(item.getName()));
            }
            throw new IllegalArgumentException("Unknown identifier: " + identifier);
        }
        return cached;
    }

    @Override
    public NSUInteger tableView_validateDrop_proposedRow_proposedDropOperation(NSTableView view, NSDraggingInfo draggingInfo, NSInteger row, NSUInteger operation) {
        log.debug((Object)("tableViewValidateDrop:row:" + (Object)((Object)row) + ",operation:" + (Object)((Object)operation)));
        if (draggingInfo.draggingPasteboard().availableTypeFromArray(NSArray.arrayWithObject("NSStringPboardType")) != null) {
            view.setDropRow(row, NSTableView.NSTableViewDropAbove);
            return NSDraggingInfo.NSDragOperationCopy;
        }
        if (!PathPasteboard.allPasteboards().isEmpty()) {
            view.setDropRow(row, NSTableView.NSTableViewDropAbove);
            return NSDraggingInfo.NSDragOperationCopy;
        }
        log.debug((Object)"tableViewValidateDrop:DragOperationNone");
        return NSDraggingInfo.NSDragOperationNone;
    }

    @Override
    public boolean tableView_acceptDrop_row_dropOperation(NSTableView view, NSDraggingInfo draggingInfo, NSInteger row, NSUInteger operation) {
        if (draggingInfo.draggingPasteboard().availableTypeFromArray(NSArray.arrayWithObject("NSStringPboardType")) != null) {
            String droppedText = draggingInfo.draggingPasteboard().stringForType("NSStringPboardType");
            if (StringUtils.isNotBlank((String)droppedText)) {
                log.info((Object)("NSPasteboard.StringPboardType:" + droppedText));
                CDDownloadController c = new CDDownloadController((CDWindowController)CDTransferController.instance(), droppedText);
                c.beginSheet();
                return true;
            }
            return false;
        }
        Map<Host, PathPasteboard<NSDictionary>> boards = PathPasteboard.allPasteboards();
        if (!boards.isEmpty()) {
            for (PathPasteboard<NSDictionary> pasteboard : boards.values()) {
                TransferCollection.instance().add(row.intValue(), (Transfer)new DownloadTransfer(pasteboard.getFiles()));
                view.reloadData();
                view.selectRowIndexes(NSIndexSet.indexSetWithIndex(row), false);
                view.scrollRowToVisible(row);
            }
            boards.clear();
            return true;
        }
        return false;
    }

    public CDProgressController getController(int row) {
        return this.getController((Transfer)this.getSource().get(row));
    }

    public CDProgressController getController(Transfer t) {
        if (!this.controllers.containsKey(t)) {
            this.controllers.put(t, new CDProgressController(t));
        }
        return this.controllers.get(t);
    }

    public void setHighlighted(int row, boolean highlighted) {
        this.getController(row).setHighlighted(highlighted);
    }
}

