/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa;

import ch.cyberduck.core.Collection;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathFactory;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.SessionFactory;
import ch.cyberduck.ui.cocoa.Pasteboard;
import ch.cyberduck.ui.cocoa.foundation.NSDictionary;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathPasteboard<T>
extends Collection<T>
implements Pasteboard<T> {
    private static Logger log = Logger.getLogger(PathPasteboard.class);
    private static Map<Host, PathPasteboard<NSDictionary>> instances = new HashMap<Host, PathPasteboard<NSDictionary>>(){

        @Override
        public boolean isEmpty() {
            for (PathPasteboard pasteboard : this.values()) {
                if (pasteboard.isEmpty()) continue;
                return false;
            }
            return true;
        }
    };
    private Host host;

    public static PathPasteboard<NSDictionary> getPasteboard(Host host) {
        if (!instances.containsKey(host)) {
            instances.put(host, new PathPasteboard(host));
        }
        return instances.get(host);
    }

    public static Map<Host, PathPasteboard<NSDictionary>> allPasteboards() {
        return instances;
    }

    private PathPasteboard(Host host) {
        this.host = host;
    }

    public List<Path> getFiles() {
        return this.getFiles(SessionFactory.createSession((Host)this.host));
    }

    public List<Path> getFiles(Session session) {
        ArrayList<Path> content = new ArrayList<Path>();
        Iterator i$ = this.iterator();
        while (i$.hasNext()) {
            Object dict = i$.next();
            content.add(PathFactory.createPath((Session)session, dict));
        }
        return content;
    }

    @Override
    public void clear() {
        instances.remove(this.host);
        super.clear();
    }
}

