/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.delegate;

import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostCollection;
import ch.cyberduck.ui.cocoa.CDBrowserController;
import ch.cyberduck.ui.cocoa.CDIconCache;
import ch.cyberduck.ui.cocoa.CDMainController;
import ch.cyberduck.ui.cocoa.application.NSMenu;
import ch.cyberduck.ui.cocoa.application.NSMenuItem;
import ch.cyberduck.ui.cocoa.delegate.MenuDelegate;
import org.apache.log4j.Logger;
import org.rococoa.Foundation;
import org.rococoa.cocoa.foundation.NSInteger;

public class BookmarkMenuDelegate
extends MenuDelegate {
    private static Logger log = Logger.getLogger(BookmarkMenuDelegate.class);

    public NSInteger numberOfItemsInMenu(NSMenu menu) {
        return new NSInteger(HostCollection.defaultCollection().size() + 9);
    }

    public boolean menuUpdateItemAtIndex(NSMenu menu, NSMenuItem item, NSInteger index, boolean shouldCancel) {
        if (index.intValue() == 6) {
            item.setEnabled(true);
            item.setImage(CDIconCache.iconNamed("history", 16));
        }
        if (index.intValue() == 7) {
            item.setEnabled(true);
            item.setImage(CDIconCache.iconNamed("rendezvous", 16));
        }
        if (index.intValue() > 8) {
            Host h = HostCollection.defaultCollection().get(index.intValue() - 9);
            item.setTitle(h.getNickname());
            item.setTarget(this.id());
            item.setImage(CDIconCache.iconNamed(h.getProtocol().icon(), 16));
            item.setAction(Foundation.selector("bookmarkMenuItemClicked:"));
            item.setRepresentedObject(h.getNickname());
        }
        return true;
    }

    public void bookmarkMenuItemClicked(NSMenuItem sender) {
        log.debug((Object)("bookmarkMenuItemClicked:" + sender));
        CDBrowserController controller = CDMainController.newDocument();
        controller.mount(HostCollection.defaultCollection().get(HostCollection.defaultCollection().indexOf((Object)sender.representedObject())));
    }
}

