/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.delegate;

import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.ui.cocoa.CDIconCache;
import ch.cyberduck.ui.cocoa.application.NSMenu;
import ch.cyberduck.ui.cocoa.application.NSMenuItem;
import ch.cyberduck.ui.cocoa.application.NSWorkspace;
import ch.cyberduck.ui.cocoa.delegate.MenuDelegate;
import ch.cyberduck.ui.cocoa.odb.EditorFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.rococoa.Foundation;
import org.rococoa.cocoa.foundation.NSInteger;

public class EditMenuDelegate
extends MenuDelegate {
    private static Logger log = Logger.getLogger(EditMenuDelegate.class);

    public NSInteger numberOfItemsInMenu(NSMenu menu) {
        int n = EditorFactory.getInstalledOdbEditors().size();
        if (0 == n) {
            return new NSInteger(1L);
        }
        return new NSInteger(n);
    }

    public boolean menuUpdateItemAtIndex(NSMenu menu, NSMenuItem item, NSInteger index, boolean shouldCancel) {
        if (EditorFactory.getInstalledOdbEditors().size() == 0) {
            item.setTitle(Locale.localizedString((String)"No external editor available"));
            return false;
        }
        String identifier = EditorFactory.getInstalledOdbEditors().values().toArray(new String[EditorFactory.getInstalledOdbEditors().size()])[index.intValue()];
        item.setRepresentedObject(identifier);
        String editor = EditorFactory.getInstalledOdbEditors().keySet().toArray(new String[EditorFactory.getInstalledOdbEditors().size()])[index.intValue()];
        item.setTitle(editor);
        if (identifier.equals(EditorFactory.getSelectedEditor())) {
            item.setKeyEquivalent("k");
            item.setKeyEquivalentModifierMask(0x100000);
        } else {
            item.setKeyEquivalent("");
        }
        String path = NSWorkspace.sharedWorkspace().absolutePathForAppBundleWithIdentifier(identifier);
        if (StringUtils.isNotEmpty((String)path)) {
            item.setImage(CDIconCache.instance().iconForPath(LocalFactory.createLocal((String)path), (Integer)16));
        } else {
            item.setImage(CDIconCache.iconNamed("pencil.tiff"));
        }
        item.setAction(Foundation.selector("editMenuClicked:"));
        return !shouldCancel;
    }
}

