/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.delegate;

import ch.cyberduck.core.HistoryCollection;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.ui.cocoa.CDBrowserController;
import ch.cyberduck.ui.cocoa.CDIconCache;
import ch.cyberduck.ui.cocoa.CDMainController;
import ch.cyberduck.ui.cocoa.application.NSMenu;
import ch.cyberduck.ui.cocoa.application.NSMenuItem;
import ch.cyberduck.ui.cocoa.delegate.MenuDelegate;
import org.apache.log4j.Logger;
import org.rococoa.Foundation;
import org.rococoa.cocoa.foundation.NSInteger;

public class HistoryMenuDelegate
extends MenuDelegate {
    private static Logger log = Logger.getLogger(HistoryMenuDelegate.class);

    public NSInteger numberOfItemsInMenu(NSMenu menu) {
        if (HistoryCollection.defaultCollection().size() > 0) {
            return new NSInteger(HistoryCollection.defaultCollection().size() + 2);
        }
        return new NSInteger(1L);
    }

    public boolean menuUpdateItemAtIndex(NSMenu menu, NSMenuItem sender, NSInteger index, boolean shouldCancel) {
        if (HistoryCollection.defaultCollection().size() == 0) {
            sender.setTitle(Locale.localizedString((String)"No recently connected servers available"));
            sender.setTarget(null);
            sender.setAction(null);
            sender.setImage(null);
            sender.setEnabled(false);
            return false;
        }
        if (index.intValue() < HistoryCollection.defaultCollection().size()) {
            Host h = HistoryCollection.defaultCollection().get(index.intValue());
            menu.removeItemAtIndex(index);
            NSMenuItem bookmark = menu.insertItemWithTitle_action_keyEquivalent_atIndex(h.getNickname(), Foundation.selector("historyMenuItemClicked:"), "", index);
            bookmark.setRepresentedObject(h.getNickname());
            bookmark.setTarget(this.id());
            bookmark.setEnabled(true);
            bookmark.setImage(CDIconCache.iconNamed(h.getProtocol().icon(), 16));
            return !shouldCancel;
        }
        if (index.intValue() == HistoryCollection.defaultCollection().size()) {
            menu.removeItemAtIndex(index);
            menu.insertItem_atIndex(NSMenuItem.separatorItem(), index);
            return !shouldCancel;
        }
        if (index.intValue() == HistoryCollection.defaultCollection().size() + 1) {
            menu.removeItemAtIndex(index);
            NSMenuItem clear = menu.insertItemWithTitle_action_keyEquivalent_atIndex(Locale.localizedString((String)"Clear Menu"), Foundation.selector("clearMenuItemClicked:"), "", index);
            clear.setTarget(this.id());
            clear.setEnabled(true);
            return !shouldCancel;
        }
        return true;
    }

    public void historyMenuItemClicked(NSMenuItem sender) {
        log.debug((Object)("historyMenuItemClicked:" + sender));
        CDBrowserController controller = CDMainController.newDocument();
        controller.mount(HistoryCollection.defaultCollection().get(HistoryCollection.defaultCollection().indexOf((Object)sender.representedObject())));
    }

    public void clearMenuItemClicked(NSMenuItem sender) {
        HistoryCollection.defaultCollection().clear();
    }
}

