/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.odb;

import ch.cyberduck.core.DownloadTransfer;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Permission;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.TransferAction;
import ch.cyberduck.core.TransferOptions;
import ch.cyberduck.core.TransferPrompt;
import ch.cyberduck.core.UploadTransfer;
import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.core.threading.BackgroundAction;
import ch.cyberduck.ui.cocoa.CDBrowserController;
import ch.cyberduck.ui.cocoa.application.NSWorkspace;
import ch.cyberduck.ui.cocoa.foundation.NSDictionary;
import ch.cyberduck.ui.cocoa.foundation.NSEnumerator;
import ch.cyberduck.ui.cocoa.foundation.NSObject;
import ch.cyberduck.ui.cocoa.threading.BrowserBackgroundAction;
import java.text.MessageFormat;
import org.apache.log4j.Logger;
import org.rococoa.Rococoa;

public abstract class Editor {
    private static Logger log = Logger.getLogger(Editor.class);
    private CDBrowserController controller;
    protected Path edited;
    protected String bundleIdentifier;
    private boolean deferredDelete;

    public Editor(CDBrowserController controller, String bundleIdentifier, Path path) {
        this.controller = controller;
        this.bundleIdentifier = bundleIdentifier;
        this.edited = path;
        Local folder = LocalFactory.createLocal((String)Preferences.instance().getProperty("editor.tmp.directory"), (String)this.edited.getParent().getAbsolute());
        this.edited.setLocal(LocalFactory.createLocal((Local)folder, (String)this.edited.getName()));
    }

    public void open() {
        this.controller.background((BackgroundAction)new BrowserBackgroundAction(this.controller){

            public void run() {
                TransferOptions options = new TransferOptions();
                options.closeSession = false;
                DownloadTransfer download = new DownloadTransfer(Editor.this.edited){

                    public TransferAction action(boolean resumeRequested, boolean reloadRequested) {
                        return TransferAction.ACTION_RENAME;
                    }

                    protected boolean shouldOpenWhenComplete() {
                        return false;
                    }
                };
                download.start(new TransferPrompt(){

                    public TransferAction prompt() {
                        return TransferAction.ACTION_OVERWRITE;
                    }
                }, options);
            }

            public String getActivity() {
                return MessageFormat.format(Locale.localizedString((String)"Downloading {0}", (String)"Status"), Editor.this.edited.getName());
            }

            public void cleanup() {
                if (Editor.this.edited.getStatus().isComplete()) {
                    Permission permissions = Editor.this.edited.getLocal().attributes.getPermission();
                    if (null != permissions) {
                        permissions.getOwnerPermissions()[0] = true;
                        permissions.getOwnerPermissions()[1] = true;
                        Editor.this.edited.getLocal().writePermissions(permissions, false);
                    }
                    Editor.this.edit();
                }
            }
        });
    }

    public boolean isOpen() {
        NSObject next;
        NSEnumerator apps = NSWorkspace.sharedWorkspace().launchedApplications().objectEnumerator();
        while ((next = apps.nextObject()) != null) {
            NSDictionary app = Rococoa.cast(next, NSDictionary.class);
            NSObject identifier = app.objectForKey("NSApplicationBundleIdentifier");
            if (!identifier.toString().equals(this.bundleIdentifier)) continue;
            return true;
        }
        return false;
    }

    protected abstract void edit();

    protected void delete() {
        log.debug((Object)"delete");
        this.edited.getLocal().delete(Preferences.instance().getBoolean("editor.file.trash"));
    }

    protected void setDeferredDelete(boolean deferredDelete) {
        this.deferredDelete = deferredDelete;
    }

    public boolean isDeferredDelete() {
        return this.deferredDelete;
    }

    protected void save() {
        log.debug((Object)"save");
        this.edited.getStatus().reset();
        this.controller.background((BackgroundAction)new BrowserBackgroundAction(this.controller){

            public void run() {
                TransferOptions options = new TransferOptions();
                options.closeSession = false;
                UploadTransfer upload = new UploadTransfer(Editor.this.edited){

                    public TransferAction action(boolean resumeRequested, boolean reloadRequested) {
                        return TransferAction.ACTION_OVERWRITE;
                    }
                };
                upload.start(new TransferPrompt(){

                    public TransferAction prompt() {
                        return TransferAction.ACTION_OVERWRITE;
                    }
                }, options);
            }

            public String getActivity() {
                return MessageFormat.format(Locale.localizedString((String)"Uploading {0}", (String)"Status"), Editor.this.edited.getName());
            }

            public void cleanup() {
                if (Editor.this.edited.getStatus().isComplete()) {
                    if (Editor.this.isDeferredDelete()) {
                        Editor.this.delete();
                    }
                    Editor.this.setDeferredDelete(false);
                }
            }
        });
    }
}

