/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.odb;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.ui.cocoa.CDBrowserController;
import ch.cyberduck.ui.cocoa.application.NSWorkspace;
import ch.cyberduck.ui.cocoa.foundation.NSBundle;
import ch.cyberduck.ui.cocoa.odb.Editor;
import ch.cyberduck.ui.cocoa.odb.ODBEditor;
import ch.cyberduck.ui.cocoa.odb.WatchEditor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditorFactory {
    private static Logger log = Logger.getLogger(EditorFactory.class);
    private static final Map<String, String> SUPPORTED_ODB_EDITORS = new HashMap<String, String>();
    private static final Map<String, String> INSTALLED_ODB_EDITORS = new HashMap<String, String>();
    private static String SELECTED_EDITOR;

    public static String defaultEditor() {
        if (null == NSWorkspace.sharedWorkspace().absolutePathForAppBundleWithIdentifier(Preferences.instance().getProperty("editor.bundleIdentifier"))) {
            return null;
        }
        return Preferences.instance().getProperty("editor.bundleIdentifier");
    }

    public static String editorBundleIdentifierForFile(Local file) {
        String defaultApplication = file.getDefaultEditor();
        if (null == defaultApplication) {
            return EditorFactory.defaultEditor();
        }
        if (Preferences.instance().getBoolean("editor.kqueue.enable")) {
            return NSBundle.bundleWithPath(defaultApplication).bundleIdentifier();
        }
        for (String identifier : INSTALLED_ODB_EDITORS.values()) {
            String path = NSWorkspace.sharedWorkspace().absolutePathForAppBundleWithIdentifier(identifier);
            if (null == path || !path.equals(defaultApplication)) continue;
            return identifier;
        }
        if (INSTALLED_ODB_EDITORS.containsValue(Preferences.instance().getProperty("editor.bundleIdentifier"))) {
            return EditorFactory.defaultEditor();
        }
        log.warn((Object)("No editor for file type " + file.getExtension()));
        return null;
    }

    public static Editor createEditor(CDBrowserController c, Path path) {
        return EditorFactory.createEditor(c, EditorFactory.editorBundleIdentifierForFile(path.getLocal()), path);
    }

    public static Editor createEditor(CDBrowserController c, String bundleIdentifier, Path path) {
        if (EditorFactory.getInstalledOdbEditors().containsValue(bundleIdentifier)) {
            return new ODBEditor(c, bundleIdentifier, path);
        }
        if (!Preferences.instance().getBoolean("editor.kqueue.enable")) {
            log.error((Object)"Support for non ODB editors must be enabled first");
            return null;
        }
        return new WatchEditor(c, bundleIdentifier, path);
    }

    public static void setSelectedEditor(String editorBundleIdentifier) {
        SELECTED_EDITOR = editorBundleIdentifier;
    }

    public static String getSelectedEditor() {
        return SELECTED_EDITOR;
    }

    public static Map<String, String> getSupportedOdbEditors() {
        return SUPPORTED_ODB_EDITORS;
    }

    public static Map<String, String> getInstalledOdbEditors() {
        return INSTALLED_ODB_EDITORS;
    }

    static {
        SUPPORTED_ODB_EDITORS.put("SubEthaEdit", "de.codingmonkeys.SubEthaEdit");
        SUPPORTED_ODB_EDITORS.put("BBEdit", "com.barebones.bbedit");
        SUPPORTED_ODB_EDITORS.put("TextWrangler", "com.barebones.textwrangler");
        SUPPORTED_ODB_EDITORS.put("TextMate", "com.macromates.textmate");
        SUPPORTED_ODB_EDITORS.put("Tex-Edit Plus", "com.transtex.texeditplus");
        SUPPORTED_ODB_EDITORS.put("Jedit X", "jp.co.artman21.JeditX");
        SUPPORTED_ODB_EDITORS.put("mi", "mi");
        SUPPORTED_ODB_EDITORS.put("Smultron", "org.smultron.Smultron");
        SUPPORTED_ODB_EDITORS.put("CotEditor", "com.aynimac.CotEditor");
        SUPPORTED_ODB_EDITORS.put("CSSEdit", "com.macrabbit.cssedit");
        SUPPORTED_ODB_EDITORS.put("Tag", "com.talacia.Tag");
        SUPPORTED_ODB_EDITORS.put("skEdit", "org.skti.skEdit");
        SUPPORTED_ODB_EDITORS.put("JarInspector", "com.cgerdes.ji");
        SUPPORTED_ODB_EDITORS.put("PageSpinner", "com.optima.PageSpinner");
        SUPPORTED_ODB_EDITORS.put("WriteRoom", "com.hogbaysoftware.WriteRoom");
        SUPPORTED_ODB_EDITORS.put("MacVim", "org.vim.MacVim");
        SUPPORTED_ODB_EDITORS.put("ForgEdit", "com.forgedit.ForgEdit");
        SUPPORTED_ODB_EDITORS.put("Taco HTML Edit", "com.tacosw.TacoHTMLEdit");
        SUPPORTED_ODB_EDITORS.put("Espresso", "com.macrabbit.Espresso");
        Iterator<String> editorNames = SUPPORTED_ODB_EDITORS.keySet().iterator();
        Iterator<String> editorIdentifiers = SUPPORTED_ODB_EDITORS.values().iterator();
        while (editorNames.hasNext()) {
            String editor = editorNames.next();
            String identifier = editorIdentifiers.next();
            if (NSWorkspace.sharedWorkspace().absolutePathForAppBundleWithIdentifier(identifier) == null) continue;
            INSTALLED_ODB_EDITORS.put(editor, identifier);
        }
        SELECTED_EDITOR = null;
        if (EditorFactory.getInstalledOdbEditors().containsValue(Preferences.instance().getProperty("editor.bundleIdentifier"))) {
            SELECTED_EDITOR = Preferences.instance().getProperty("editor.bundleIdentifier");
        }
    }
}

