/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.serializer;

import ch.cyberduck.core.Factory;
import ch.cyberduck.core.serializer.Deserializer;
import ch.cyberduck.core.serializer.DeserializerFactory;
import ch.cyberduck.ui.cocoa.foundation.NSArray;
import ch.cyberduck.ui.cocoa.foundation.NSDictionary;
import ch.cyberduck.ui.cocoa.foundation.NSEnumerator;
import ch.cyberduck.ui.cocoa.foundation.NSObject;
import java.util.ArrayList;
import java.util.List;
import org.rococoa.Rococoa;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlistDeserializer
implements Deserializer<NSDictionary> {
    final NSDictionary dict;

    public static void register() {
        DeserializerFactory.addFactory((Factory.Platform)Factory.NATIVE_PLATFORM, (DeserializerFactory)new Factory());
    }

    public PlistDeserializer(NSDictionary dict) {
        this.dict = dict;
    }

    public String stringForKey(String key) {
        NSObject value = this.dict.objectForKey(key);
        if (null == value) {
            return null;
        }
        return value.toString();
    }

    public NSDictionary objectForKey(String key) {
        NSObject value = this.dict.objectForKey(key);
        if (null == value) {
            return null;
        }
        return Rococoa.cast(value, NSDictionary.class);
    }

    public List<NSDictionary> listForKey(String key) {
        NSObject next;
        NSObject value = this.dict.objectForKey(key);
        if (null == value) {
            return null;
        }
        ArrayList<NSDictionary> list = new ArrayList<NSDictionary>();
        NSArray array = Rococoa.cast(value, NSArray.class);
        NSEnumerator enumerator = array.objectEnumerator();
        while ((next = enumerator.nextObject()) != null) {
            list.add(Rococoa.cast(next, NSDictionary.class));
        }
        return list;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Factory
    extends DeserializerFactory<NSDictionary> {
        private Factory() {
        }

        protected Deserializer create(NSDictionary dict) {
            return new PlistDeserializer(dict);
        }
    }
}

