/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.threading;

import ch.cyberduck.core.Collection;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.threading.BackgroundAction;
import ch.cyberduck.core.threading.BackgroundException;
import ch.cyberduck.core.threading.RepeatableBackgroundAction;
import ch.cyberduck.ui.cocoa.CDAbstractTableDelegate;
import ch.cyberduck.ui.cocoa.CDControllerCell;
import ch.cyberduck.ui.cocoa.CDErrorController;
import ch.cyberduck.ui.cocoa.CDListDataSource;
import ch.cyberduck.ui.cocoa.CDSheetController;
import ch.cyberduck.ui.cocoa.CDWindowController;
import ch.cyberduck.ui.cocoa.application.NSButton;
import ch.cyberduck.ui.cocoa.application.NSCell;
import ch.cyberduck.ui.cocoa.application.NSTableColumn;
import ch.cyberduck.ui.cocoa.application.NSTableView;
import ch.cyberduck.ui.cocoa.application.NSTextView;
import ch.cyberduck.ui.cocoa.foundation.NSAttributedString;
import ch.cyberduck.ui.cocoa.foundation.NSNotification;
import ch.cyberduck.ui.cocoa.foundation.NSObject;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.rococoa.Foundation;
import org.rococoa.ID;
import org.rococoa.Rococoa;
import org.rococoa.cocoa.CGFloat;
import org.rococoa.cocoa.foundation.NSInteger;

public abstract class AlertRepeatableBackgroundAction
extends RepeatableBackgroundAction {
    private static Logger log = Logger.getLogger(AlertRepeatableBackgroundAction.class);
    private CDWindowController controller;
    private CDSheetController alert;

    public AlertRepeatableBackgroundAction(CDWindowController controller) {
        this.controller = controller;
        this.exceptions = new Collection();
    }

    public Object lock() {
        return this.controller;
    }

    public void finish() {
        super.finish();
        if (this.hasFailed() && !this.isCanceled()) {
            this.alert();
        }
    }

    protected void alert() {
        if (this.controller.isVisible()) {
            this.alert = new CDSheetController(this.controller){
                private NSButton diagnosticsButton;
                private NSButton transcriptButton;
                private final TableColumnFactory tableColumnsFactory;
                private NSTableView errorView;
                private CDListDataSource model;
                private CDAbstractTableDelegate<CDErrorController> delegate;
                private List<CDErrorController> errors;
                private final NSCell prototype;
                private NSTextView transcriptView;
                {
                    this.tableColumnsFactory = new TableColumnFactory();
                    this.prototype = CDControllerCell.controllerCell();
                }

                protected String getBundleName() {
                    return "Alert";
                }

                public void awakeFromNib() {
                    this.setState(this.transcriptButton, AlertRepeatableBackgroundAction.this.transcript.length() > 0 && Preferences.instance().getBoolean("alert.toggle.transcript"));
                    super.awakeFromNib();
                }

                protected void invalidate() {
                    this.errorView.setDataSource(null);
                    this.errorView.setDelegate(null);
                    super.invalidate();
                }

                public void setDiagnosticsButton(NSButton diagnosticsButton) {
                    this.diagnosticsButton = diagnosticsButton;
                    this.diagnosticsButton.setTarget(this.id());
                    this.diagnosticsButton.setAction(Foundation.selector("diagnosticsButtonClicked:"));
                    boolean hidden = true;
                    for (BackgroundException e : AlertRepeatableBackgroundAction.this.exceptions) {
                        Throwable cause = e.getCause();
                        if (!(cause instanceof SocketException) && !(cause instanceof UnknownHostException)) continue;
                        hidden = false;
                        break;
                    }
                    this.diagnosticsButton.setHidden(hidden);
                }

                public void diagnosticsButtonClicked(NSButton sender) {
                    ((BackgroundException)AlertRepeatableBackgroundAction.this.exceptions.get(AlertRepeatableBackgroundAction.this.exceptions.size() - 1)).getSession().getHost().diagnose();
                }

                public void setTranscriptButton(NSButton transcriptButton) {
                    this.transcriptButton = transcriptButton;
                }

                public void setErrorView(NSTableView errorView) {
                    this.errorView = errorView;
                    this.errors = new ArrayList<CDErrorController>();
                    for (BackgroundException e : AlertRepeatableBackgroundAction.this.exceptions) {
                        this.errors.add(new CDErrorController(e));
                    }
                    this.model = new CDListDataSource(){

                        public NSInteger numberOfRowsInTableView(NSTableView view) {
                            return new NSInteger(errors.size());
                        }

                        public NSObject tableView_objectValueForTableColumn_row(NSTableView view, NSTableColumn tableColumn, NSInteger row) {
                            return null;
                        }
                    };
                    this.errorView.setDataSource(this.model.id());
                    this.delegate = new CDAbstractTableDelegate<CDErrorController>(){

                        @Override
                        public void tableColumnClicked(NSTableView view, NSTableColumn tableColumn) {
                        }

                        @Override
                        public void tableRowDoubleClicked(ID sender) {
                        }

                        @Override
                        public boolean selectionShouldChange() {
                            return false;
                        }

                        @Override
                        public void selectionDidChange(NSNotification notification) {
                        }

                        @Override
                        public void enterKeyPressed(ID sender) {
                        }

                        @Override
                        public void deleteKeyPressed(ID sender) {
                        }

                        @Override
                        public String tooltip(CDErrorController e) {
                            return e.getTooltip();
                        }

                        public void tableView_willDisplayCell_forTableColumn_row(NSTableView view, NSCell cell, NSTableColumn tableColumn, NSInteger row) {
                            Rococoa.cast(cell, CDControllerCell.class).setView(((CDErrorController)errors.get(row.intValue())).view());
                        }
                    };
                    this.errorView.setDelegate(this.delegate.id());
                    NSTableColumn c = this.tableColumnsFactory.create("Error");
                    c.setMinWidth(50.0);
                    c.setWidth(400.0);
                    c.setMaxWidth(1000.0);
                    c.setDataCell(this.prototype);
                    this.errorView.addTableColumn(c);
                    this.errorView.setRowHeight(new CGFloat(77.0));
                }

                public void setTranscriptView(NSTextView transcriptView) {
                    this.transcriptView = transcriptView;
                    this.transcriptView.textStorage().setAttributedString(NSAttributedString.attributedStringWithAttributes(AlertRepeatableBackgroundAction.this.transcript.toString(), FIXED_WITH_FONT_ATTRIBUTES));
                }

                public void callback(int returncode) {
                    if (returncode == 1) {
                        for (BackgroundException e : AlertRepeatableBackgroundAction.this.exceptions) {
                            Path workdir = e.getPath();
                            if (null == workdir) continue;
                            workdir.invalidate();
                        }
                        AlertRepeatableBackgroundAction.this.exceptions.clear();
                        AlertRepeatableBackgroundAction.this.controller.background((BackgroundAction)AlertRepeatableBackgroundAction.this);
                    }
                    Preferences.instance().setProperty("alert.toggle.transcript", this.transcriptButton.state());
                }
            };
            this.alert.beginSheet();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TableColumnFactory
    extends HashMap<String, NSTableColumn> {
        private TableColumnFactory() {
        }

        private NSTableColumn create(String identifier) {
            if (!this.containsKey(identifier)) {
                this.put(identifier, NSTableColumn.tableColumnWithIdentifier(identifier));
            }
            return (NSTableColumn)this.get(identifier);
        }
    }
}

