/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.threading;

import ch.cyberduck.core.Session;
import ch.cyberduck.core.threading.BackgroundAction;
import ch.cyberduck.core.threading.BackgroundActionRegistry;
import ch.cyberduck.core.threading.MainAction;
import ch.cyberduck.ui.cocoa.CDBrowserController;
import ch.cyberduck.ui.cocoa.threading.AlertRepeatableBackgroundAction;
import ch.cyberduck.ui.cocoa.threading.WindowMainAction;

public abstract class BrowserBackgroundAction
extends AlertRepeatableBackgroundAction {
    private CDBrowserController controller;

    public BrowserBackgroundAction(CDBrowserController controller) {
        super(controller);
        this.controller = controller;
    }

    public CDBrowserController getController() {
        return this.controller;
    }

    public void init() {
        BackgroundActionRegistry.instance().add((BackgroundAction)this);
    }

    public Session getSession() {
        return this.controller.getSession();
    }

    public boolean prepare() {
        this.controller.invoke((MainAction)new WindowMainAction(this.controller){

            public void run() {
                BrowserBackgroundAction.this.controller.getSpinner().startAnimation(null);
            }
        });
        return super.prepare();
    }

    public void cancel() {
        if (this.isRunning()) {
            this.getSession().interrupt();
        }
        super.cancel();
    }

    public void finish() {
        super.finish();
        this.controller.invoke((MainAction)new WindowMainAction(this.controller){

            public void run() {
                BrowserBackgroundAction.this.controller.getSpinner().stopAnimation(null);
                BrowserBackgroundAction.this.controller.updateStatusLabel();
            }
        });
    }

    public boolean isCanceled() {
        if (!this.controller.isVisible()) {
            return false;
        }
        return super.isCanceled();
    }

    public Object lock() {
        return this.controller.getSession();
    }
}

