/*
 * Decompiled with CFR 0.152.
 */
package org.rococoa.internal;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.Structure;
import java.util.HashMap;
import java.util.Map;
import org.rococoa.Foundation;
import org.rococoa.ID;
import org.rococoa.NSObject;
import org.rococoa.Rococoa;
import org.rococoa.cocoa.CGFloat;
import org.rococoa.cocoa.foundation.NSInteger;
import org.rococoa.cocoa.foundation.NSUInteger;
import org.rococoa.internal.NSInvocationMapper;
import org.rococoa.internal.NSInvocationStructureMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NSInvocationMapperLookup {
    private static final int NATIVE_POINTER_SIZE = Native.POINTER_SIZE;
    private static final int NATIVE_LONG_SIZE = Native.LONG_SIZE;
    private static final String NATIVE_LONG_ENCODING = NATIVE_LONG_SIZE == 4 ? "l" : "q";
    private static final String NSINTEGER_ENCODING = NATIVE_LONG_SIZE == 4 ? "i" : "q";
    private static final String NSUINTEGER_ENCODING = NATIVE_LONG_SIZE == 4 ? "I" : "Q";
    private static final String CGFLOAT_ENCODING = NATIVE_LONG_SIZE == 4 ? "f" : "d";
    private static final Map<Class<?>, NSInvocationMapper> classToMapperLookup = new HashMap();
    static NSInvocationMapper NSOBJECT;
    static NSInvocationMapper NATIVE_LONG;

    public static NSInvocationMapper mapperForType(Class<?> type) {
        NSInvocationMapper directMatch = classToMapperLookup.get(type);
        if (directMatch != null) {
            return directMatch;
        }
        if (NSInvocationMapperLookup.NSOBJECT.type.isAssignableFrom(type)) {
            return NSOBJECT;
        }
        if (NSInvocationMapperLookup.NATIVE_LONG.type.isAssignableFrom(type)) {
            return NATIVE_LONG;
        }
        if (Structure.class.isAssignableFrom(type)) {
            NSInvocationStructureMapper result = new NSInvocationStructureMapper(type);
            NSInvocationMapperLookup.addToLookup(result);
            return result;
        }
        return null;
    }

    public static String stringForType(Class<?> type) {
        return NSInvocationMapperLookup.mapperForType(type).typeString();
    }

    private static void addToLookup(NSInvocationMapper mapper) {
        Class<?> type = mapper.type;
        classToMapperLookup.put(type, mapper);
        if (type.isPrimitive()) {
            classToMapperLookup.put(NSInvocationMapperLookup.boxTypeFor(type), mapper);
        }
    }

    private static Class<?> boxTypeFor(Class<?> type) {
        if (type == Void.TYPE) {
            return null;
        }
        if (type == Boolean.TYPE) {
            return Boolean.class;
        }
        if (type == Byte.TYPE) {
            return Byte.class;
        }
        if (type == Short.TYPE) {
            return Short.class;
        }
        if (type == Character.TYPE) {
            return Character.class;
        }
        if (type == Integer.TYPE) {
            return Integer.class;
        }
        if (type == Long.TYPE) {
            return Long.class;
        }
        if (type == Float.TYPE) {
            return Float.class;
        }
        if (type == Double.TYPE) {
            return Double.class;
        }
        throw new IllegalArgumentException("Not a primitive class " + type);
    }

    static {
        NSInvocationMapperLookup.addToLookup(new NSInvocationMapper("v", (Class)Void.TYPE){

            @Override
            public Object readFrom(Memory buffer, Class<?> type) {
                throw new IllegalStateException("Should not have to read void");
            }

            @Override
            public Memory bufferForResult(Object methodCallResult) {
                return new Memory(0L);
            }
        });
        NSInvocationMapperLookup.addToLookup(new NSInvocationMapper("c", (Class)Boolean.TYPE){

            @Override
            public Object readFrom(Memory buffer, Class<?> type) {
                byte character = buffer.getByte(0L);
                return character == 0 ? Boolean.FALSE : Boolean.TRUE;
            }

            @Override
            public Memory bufferForResult(Object methodCallResult) {
                Memory result = new Memory(1L);
                result.setByte(0L, (Boolean)methodCallResult != false ? (byte)1 : 0);
                return result;
            }
        });
        NSInvocationMapperLookup.addToLookup(new NSInvocationMapper("c", (Class)Byte.TYPE){

            @Override
            public Object readFrom(Memory buffer, Class<?> type) {
                return buffer.getByte(0L);
            }

            @Override
            public Memory bufferForResult(Object methodCallResult) {
                Memory result = new Memory(1L);
                result.setByte(0L, ((Byte)methodCallResult).byteValue());
                return result;
            }
        });
        NSInvocationMapperLookup.addToLookup(new NSInvocationMapper("s", (Class)Character.TYPE){

            @Override
            public Object readFrom(Memory buffer, Class<?> type) {
                throw new UnsupportedOperationException("Don't yet support char, while I think what to do");
            }

            @Override
            public Memory bufferForResult(Object methodCallResult) {
                throw new UnsupportedOperationException("Don't yet support char, while I think what to do");
            }
        });
        NSInvocationMapperLookup.addToLookup(new NSInvocationMapper("s", (Class)Short.TYPE){

            @Override
            public Object readFrom(Memory buffer, Class<?> type) {
                return buffer.getShort(0L);
            }

            @Override
            public Memory bufferForResult(Object methodCallResult) {
                Memory result = new Memory(2L);
                result.setShort(0L, ((Short)methodCallResult).shortValue());
                return result;
            }
        });
        NSInvocationMapperLookup.addToLookup(new NSInvocationMapper("i", (Class)Integer.TYPE){

            @Override
            public Object readFrom(Memory buffer, Class<?> type) {
                return buffer.getInt(0L);
            }

            @Override
            public Memory bufferForResult(Object methodCallResult) {
                Memory result = new Memory(4L);
                result.setInt(0L, ((Integer)methodCallResult).intValue());
                return result;
            }
        });
        NSInvocationMapperLookup.addToLookup(new NSInvocationMapper("q", (Class)Long.TYPE){

            @Override
            public Object readFrom(Memory buffer, Class<?> type) {
                return buffer.getLong(0L);
            }

            @Override
            public Memory bufferForResult(Object methodCallResult) {
                Memory result = new Memory(8L);
                result.setLong(0L, ((Long)methodCallResult).longValue());
                return result;
            }
        });
        NSInvocationMapperLookup.addToLookup(new NSInvocationMapper("f", (Class)Float.TYPE){

            @Override
            public Object readFrom(Memory buffer, Class<?> type) {
                return Float.valueOf(buffer.getFloat(0L));
            }

            @Override
            public Memory bufferForResult(Object methodCallResult) {
                Memory result = new Memory(4L);
                result.setFloat(0L, ((Float)methodCallResult).floatValue());
                return result;
            }
        });
        NSInvocationMapperLookup.addToLookup(new NSInvocationMapper("d", (Class)Double.TYPE){

            @Override
            public Object readFrom(Memory buffer, Class<?> type) {
                return buffer.getDouble(0L);
            }

            @Override
            public Memory bufferForResult(Object methodCallResult) {
                Memory result = new Memory(8L);
                result.setDouble(0L, ((Double)methodCallResult).doubleValue());
                return result;
            }
        });
        NSInvocationMapperLookup.addToLookup(new NSInvocationMapper("@", (Class)ID.class){

            @Override
            public Object readFrom(Memory buffer, Class<?> type) {
                return ID.fromLong(buffer.getNativeLong(0L).longValue());
            }

            @Override
            public Memory bufferForResult(Object methodCallResult) {
                Memory result = new Memory((long)NATIVE_POINTER_SIZE);
                result.setNativeLong(0L, (NativeLong)((ID)((Object)methodCallResult)));
                return result;
            }
        });
        NSInvocationMapperLookup.addToLookup(new NSInvocationMapper("@", (Class)String.class){

            @Override
            public Object readFrom(Memory buffer, Class<?> type) {
                ID id = ID.fromLong(buffer.getNativeLong(0L).longValue());
                if (id.isNull()) {
                    return null;
                }
                return Foundation.toString(id);
            }

            @Override
            public Memory bufferForResult(Object methodCallResult) {
                Memory buffer = new Memory((long)NATIVE_POINTER_SIZE);
                ID idString = Foundation.cfString((String)methodCallResult);
                Foundation.sendReturnsID(idString, "autorelease", new Object[0]);
                buffer.setNativeLong(0L, (NativeLong)idString);
                return buffer;
            }
        });
        NSInvocationMapperLookup.addToLookup(new NSInvocationMapper(NSINTEGER_ENCODING, (Class)NSInteger.class){

            @Override
            public Object readFrom(Memory buffer, Class<?> type) {
                return new NSInteger(buffer.getNativeLong(0L));
            }

            @Override
            public Memory bufferForResult(Object methodCallResult) {
                Memory result = new Memory((long)NATIVE_LONG_SIZE);
                result.setNativeLong(0L, (NativeLong)methodCallResult);
                return result;
            }
        });
        NSInvocationMapperLookup.addToLookup(new NSInvocationMapper(NSUINTEGER_ENCODING, (Class)NSUInteger.class){

            @Override
            public Object readFrom(Memory buffer, Class<?> type) {
                return new NSUInteger(buffer.getNativeLong(0L));
            }

            @Override
            public Memory bufferForResult(Object methodCallResult) {
                Memory result = new Memory((long)NATIVE_LONG_SIZE);
                result.setNativeLong(0L, (NativeLong)methodCallResult);
                return result;
            }
        });
        NSInvocationMapperLookup.addToLookup(new NSInvocationMapper(CGFLOAT_ENCODING, (Class)CGFloat.class){

            @Override
            public Object readFrom(Memory buffer, Class<?> type) {
                if (NATIVE_LONG_SIZE == 4) {
                    return new CGFloat(buffer.getFloat(0L));
                }
                if (NATIVE_LONG_SIZE == 8) {
                    return new CGFloat(buffer.getDouble(0L));
                }
                throw new IllegalStateException();
            }

            @Override
            public Memory bufferForResult(Object methodCallResult) {
                Memory result = new Memory((long)NATIVE_LONG_SIZE);
                if (NATIVE_LONG_SIZE == 4) {
                    result.setFloat(0L, ((Float)methodCallResult).floatValue());
                }
                if (NATIVE_LONG_SIZE == 8) {
                    result.setDouble(0L, ((Double)methodCallResult).doubleValue());
                }
                return result;
            }
        });
        NSOBJECT = new NSInvocationMapper("@", (Class)NSObject.class){

            @Override
            public Object readFrom(Memory buffer, Class<?> type) {
                ID id = ID.fromLong(buffer.getNativeLong(0L).longValue());
                if (id.isNull()) {
                    return null;
                }
                return Rococoa.wrap(id, type);
            }

            @Override
            public Memory bufferForResult(Object methodCallResult) {
                Memory buffer = new Memory((long)NATIVE_POINTER_SIZE);
                buffer.setNativeLong(0L, (NativeLong)((NSObject)methodCallResult).id());
                return buffer;
            }
        };
        NATIVE_LONG = new NSInvocationMapper(NATIVE_LONG_ENCODING, (Class)NativeLong.class){

            @Override
            public Object readFrom(Memory buffer, Class<?> type) {
                return buffer.getNativeLong(0L);
            }

            @Override
            public Memory bufferForResult(Object methodCallResult) {
                Memory result = new Memory((long)NATIVE_LONG_SIZE);
                result.setNativeLong(0L, (NativeLong)methodCallResult);
                return result;
            }
        };
    }
}

