/*
 * Decompiled with CFR 0.152.
 */
package org.rococoa.internal;

import com.sun.jna.FromNativeContext;
import com.sun.jna.FunctionResultContext;
import com.sun.jna.NativeMapped;
import com.sun.jna.ToNativeContext;
import com.sun.jna.TypeConverter;
import org.rococoa.Foundation;
import org.rococoa.ID;
import org.rococoa.NSObject;
import org.rococoa.Rococoa;
import org.rococoa.Selector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NSObjectTypeConverter<T extends NSObject>
implements TypeConverter {
    private static final NativeMapped nativeLongConverter = new ID();
    private final Class<T> javaType;

    public NSObjectTypeConverter(Class<T> javaType) {
        this.javaType = javaType;
    }

    public Class<?> nativeType() {
        return nativeLongConverter.nativeType();
    }

    public T fromNative(Object nativeValue, FromNativeContext context) {
        Number nativeValueAsNumber = (Number)nativeValue;
        if (nativeValueAsNumber == null) {
            return null;
        }
        ID id = ID.fromLong(nativeValueAsNumber.longValue());
        if (id.isNull()) {
            return null;
        }
        boolean shouldRetain = this.shouldRetainFor(context);
        return Rococoa.wrap(id, this.javaType, shouldRetain);
    }

    public Object toNative(Object value, ToNativeContext context) {
        if (value == null) {
            return null;
        }
        NSObject valueAsNSObject = (NSObject)value;
        ID idToReturn = valueAsNSObject.id();
        return idToReturn.toNative();
    }

    boolean convertsJavaType(Class<?> javaType) {
        return this.javaType == javaType;
    }

    private boolean shouldRetainFor(FromNativeContext context) {
        if (context == null || !(context instanceof FunctionResultContext)) {
            return true;
        }
        FunctionResultContext resultContext = (FunctionResultContext)context;
        Object[] arguments = resultContext.getArguments();
        if (arguments.length < 2) {
            return true;
        }
        if (!(arguments[1] instanceof Selector)) {
            return true;
        }
        boolean dontRetain = Foundation.selectorNameMeansWeOwnReturnedObject(((Selector)((Object)arguments[1])).getName());
        return !dontRetain;
    }
}

