/*
 * Decompiled with CFR 0.152.
 */
package org.rococoa.test;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.AccessController;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import sun.security.action.GetPropertyAction;

public class LogFormatter
extends Formatter {
    private String lineSeparator = AccessController.doPrivileged(new GetPropertyAction("line.separator"));

    public synchronized String format(LogRecord record) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.shortName(Thread.currentThread())).append('\t');
        try {
            sb.append(Class.forName(record.getSourceClassName()).getSimpleName());
        }
        catch (Exception e) {
            sb.append(record.getLoggerName());
        }
        if (record.getSourceMethodName() != null) {
            sb.append(".");
            sb.append(record.getSourceMethodName());
        }
        sb.append(" - ");
        sb.append(this.formatMessage(record));
        this.appendExtras(record, sb);
        sb.append(this.lineSeparator);
        if (record.getThrown() != null) {
            try {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                record.getThrown().printStackTrace(pw);
                pw.close();
                sb.append(sw.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return sb.toString();
    }

    private String shortName(Thread thread) {
        String name = thread.getName();
        return name.length() <= 7 ? name : name.substring(0, 7);
    }

    protected void appendExtras(LogRecord record, StringBuffer sb) {
    }
}

