/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jets3t.service.Constants;
import org.jets3t.service.Jets3tProperties;
import org.jets3t.service.S3ObjectsChunk;
import org.jets3t.service.S3ServiceException;
import org.jets3t.service.acl.AccessControlList;
import org.jets3t.service.acl.GrantAndPermission;
import org.jets3t.service.acl.GroupGrantee;
import org.jets3t.service.acl.Permission;
import org.jets3t.service.model.S3Bucket;
import org.jets3t.service.model.S3BucketLoggingStatus;
import org.jets3t.service.model.S3Object;
import org.jets3t.service.model.S3Owner;
import org.jets3t.service.mx.MxDelegate;
import org.jets3t.service.security.AWSCredentials;
import org.jets3t.service.security.AWSDevPayCredentials;
import org.jets3t.service.utils.RestUtils;
import org.jets3t.service.utils.ServiceUtils;

public abstract class S3Service
implements Serializable {
    private static final Log log = LogFactory.getLog(S3Service.class);
    public static final String VERSION_NO__JETS3T_TOOLKIT = "0.7.1";
    public static final int BUCKET_STATUS__MY_BUCKET = 0;
    public static final int BUCKET_STATUS__DOES_NOT_EXIST = 1;
    public static final int BUCKET_STATUS__ALREADY_CLAIMED = 2;
    protected Jets3tProperties jets3tProperties = null;
    private AWSCredentials awsCredentials = null;
    private String awsDevPayUserToken = null;
    private String awsDevPayProductToken = null;
    private boolean isRequesterPaysEnabled = false;
    private String invokingApplicationDescription = null;
    private boolean isHttpsOnly = true;
    private int internalErrorRetryMax = 5;
    protected long timeOffset = 0L;

    protected S3Service(AWSCredentials awsCredentials, String invokingApplicationDescription, Jets3tProperties jets3tProperties) throws S3ServiceException {
        this.awsCredentials = awsCredentials;
        this.invokingApplicationDescription = invokingApplicationDescription;
        this.jets3tProperties = jets3tProperties;
        this.isHttpsOnly = jets3tProperties.getBoolProperty("s3service.https-only", true);
        this.internalErrorRetryMax = jets3tProperties.getIntProperty("s3service.internal-error-retry-max", 5);
        if (awsCredentials instanceof AWSDevPayCredentials) {
            AWSDevPayCredentials awsDevPayCredentials = (AWSDevPayCredentials)awsCredentials;
            this.awsDevPayUserToken = awsDevPayCredentials.getUserToken();
            this.awsDevPayProductToken = awsDevPayCredentials.getProductToken();
        } else {
            this.awsDevPayUserToken = jets3tProperties.getStringProperty("devpay.user-token", null);
            this.awsDevPayProductToken = jets3tProperties.getStringProperty("devpay.product-token", null);
        }
        System.setProperty("networkaddress.cache.ttl", "300");
        System.setProperty("networkaddress.cache.negative.ttl", "1");
        String customS3Hostname = this.jets3tProperties.getStringProperty("s3service.s3-endpoint", Constants.S3_HOSTNAME);
        if (!Constants.S3_HOSTNAME.equals(customS3Hostname)) {
            Constants.S3_HOSTNAME = customS3Hostname;
        }
        MxDelegate.getInstance().init();
        MxDelegate.getInstance().registerS3ServiceMBean();
        MxDelegate.getInstance().registerS3ServiceExceptionMBean();
    }

    protected S3Service(AWSCredentials awsCredentials, String invokingApplicationDescription) throws S3ServiceException {
        this(awsCredentials, invokingApplicationDescription, Jets3tProperties.getInstance(Constants.JETS3T_PROPERTIES_FILENAME));
    }

    protected S3Service(AWSCredentials awsCredentials) throws S3ServiceException {
        this(awsCredentials, null);
    }

    public void setDevPayUserToken(String userToken) {
        this.awsDevPayUserToken = userToken;
    }

    public String getDevPayUserToken() {
        return this.awsDevPayUserToken;
    }

    public void setDevPayProductToken(String productToken) {
        this.awsDevPayProductToken = productToken;
    }

    public String getDevPayProductToken() {
        return this.awsDevPayProductToken;
    }

    public void setRequesterPaysEnabled(boolean isRequesterPays) {
        this.isRequesterPaysEnabled = isRequesterPays;
    }

    public boolean isRequesterPaysEnabled() {
        return this.isRequesterPaysEnabled;
    }

    public boolean isAuthenticatedConnection() {
        return this.awsCredentials != null;
    }

    public boolean isHttpsOnly() {
        return this.isHttpsOnly;
    }

    public int getInternalErrorRetryMax() {
        return this.internalErrorRetryMax;
    }

    public Jets3tProperties getJetS3tProperties() {
        return this.jets3tProperties;
    }

    public static boolean isBucketNameValidDNSName(String bucketName) {
        if (bucketName == null || bucketName.length() > 63 || bucketName.length() < 3) {
            return false;
        }
        if (!Pattern.matches("^[a-z0-9][a-z0-9.-]+$", bucketName)) {
            return false;
        }
        if (!Pattern.matches(".*[a-z].*", bucketName)) {
            return false;
        }
        String[] fragments = bucketName.split("\\.");
        for (int i = 0; i < fragments.length; ++i) {
            if (!Pattern.matches("^-.*", fragments[i]) && !Pattern.matches(".*-$", fragments[i]) && !Pattern.matches("^$", fragments[i])) continue;
            return false;
        }
        return true;
    }

    public static String generateS3HostnameForBucket(String bucketName, boolean isDnsBucketNamingDisabled) {
        if (S3Service.isBucketNameValidDNSName(bucketName) && !isDnsBucketNamingDisabled) {
            return bucketName + "." + Constants.S3_HOSTNAME;
        }
        return Constants.S3_HOSTNAME;
    }

    protected void sleepOnInternalError(int internalErrorCount) throws S3ServiceException, InterruptedException {
        long delayMs;
        if (internalErrorCount <= this.internalErrorRetryMax) {
            delayMs = 50L * (long)((int)Math.pow(internalErrorCount, 2.0));
            if (log.isWarnEnabled()) {
                log.warn((Object)("Encountered " + internalErrorCount + " S3 Internal Server error(s), will retry in " + delayMs + "ms"));
            }
        } else {
            throw new S3ServiceException("Encountered too many S3 Internal Server errors (" + internalErrorCount + "), aborting request.");
        }
        Thread.sleep(delayMs);
    }

    public AWSCredentials getAWSCredentials() {
        return this.awsCredentials;
    }

    public String getInvokingApplicationDescription() {
        return this.invokingApplicationDescription;
    }

    public static String createSignedUrl(String method, String bucketName, String objectKey, String specialParamName, Map headersMap, AWSCredentials awsCredentials, long secondsSinceEpoch, boolean isVirtualHost, boolean isHttps, boolean isDnsBucketNamingDisabled) throws S3ServiceException {
        String hostname;
        String uriPath = "";
        String string = hostname = isVirtualHost ? bucketName : S3Service.generateS3HostnameForBucket(bucketName, isDnsBucketNamingDisabled);
        if (headersMap == null) {
            headersMap = new HashMap<String, String>();
        }
        String virtualBucketPath = "";
        if (!Constants.S3_HOSTNAME.equals(hostname)) {
            int subdomainOffset = hostname.lastIndexOf("." + Constants.S3_HOSTNAME);
            virtualBucketPath = subdomainOffset > 0 ? hostname.substring(0, subdomainOffset) + "/" : hostname + "/";
            uriPath = objectKey != null ? RestUtils.encodeUrlPath(objectKey, "/") : "";
        } else {
            uriPath = bucketName + (objectKey != null ? "/" + RestUtils.encodeUrlPath(objectKey, "/") : "");
        }
        uriPath = specialParamName != null ? uriPath + "?" + specialParamName + "&" : uriPath + "?";
        if (awsCredentials instanceof AWSDevPayCredentials) {
            AWSDevPayCredentials devPayCredentials = (AWSDevPayCredentials)awsCredentials;
            if (devPayCredentials.getProductToken() != null) {
                String securityToken = devPayCredentials.getUserToken() + "," + devPayCredentials.getProductToken();
                headersMap.put("x-amz-security-token", securityToken);
            } else {
                headersMap.put("x-amz-security-token", devPayCredentials.getUserToken());
            }
            uriPath = uriPath + "x-amz-security-token=" + RestUtils.encodeUrlString((String)headersMap.get("x-amz-security-token")) + "&";
        }
        uriPath = uriPath + "AWSAccessKeyId=" + awsCredentials.getAccessKey();
        uriPath = uriPath + "&Expires=" + secondsSinceEpoch;
        if (specialParamName != null && specialParamName.toLowerCase().indexOf("x-amz-request-payer=requester") >= 0) {
            String[] requesterPaysHeaderAndValue = "x-amz-request-payer=requester".split("=");
            headersMap.put(requesterPaysHeaderAndValue[0], requesterPaysHeaderAndValue[1]);
        }
        String canonicalString = RestUtils.makeS3CanonicalString(method, "/" + virtualBucketPath + uriPath, RestUtils.renameMetadataKeys(headersMap), String.valueOf(secondsSinceEpoch));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Signing canonical string:\n" + canonicalString));
        }
        String signedCanonical = ServiceUtils.signWithHmacSha1(awsCredentials.getSecretKey(), canonicalString);
        String encodedCanonical = RestUtils.encodeUrlString(signedCanonical);
        uriPath = uriPath + "&Signature=" + encodedCanonical;
        if (isHttps) {
            return "https://" + hostname + "/" + uriPath;
        }
        return "http://" + hostname + "/" + uriPath;
    }

    public static String createSignedUrl(String method, String bucketName, String objectKey, String specialParamName, Map headersMap, AWSCredentials awsCredentials, long secondsSinceEpoch, boolean isVirtualHost) throws S3ServiceException {
        Jets3tProperties jets3tProperties = Jets3tProperties.getInstance(Constants.JETS3T_PROPERTIES_FILENAME);
        boolean isHttps = jets3tProperties.getBoolProperty("s3service.https-only", true);
        boolean disableDnsBuckets = jets3tProperties.getBoolProperty("s3service.disable-dns-buckets", false);
        return S3Service.createSignedUrl(method, bucketName, objectKey, specialParamName, headersMap, awsCredentials, secondsSinceEpoch, isVirtualHost, isHttps, disableDnsBuckets);
    }

    public static String createSignedUrl(String method, String bucketName, String objectKey, String specialParamName, Map headersMap, AWSCredentials awsCredentials, long secondsSinceEpoch) throws S3ServiceException {
        return S3Service.createSignedUrl(method, bucketName, objectKey, specialParamName, headersMap, awsCredentials, secondsSinceEpoch, false);
    }

    public static String createSignedGetUrl(String bucketName, String objectKey, AWSCredentials awsCredentials, Date expiryTime, boolean isVirtualHost) throws S3ServiceException {
        long secondsSinceEpoch = expiryTime.getTime() / 1000L;
        return S3Service.createSignedUrl("GET", bucketName, objectKey, null, null, awsCredentials, secondsSinceEpoch, isVirtualHost);
    }

    public static String createSignedGetUrl(String bucketName, String objectKey, AWSCredentials awsCredentials, Date expiryTime) throws S3ServiceException {
        return S3Service.createSignedGetUrl(bucketName, objectKey, awsCredentials, expiryTime, false);
    }

    public static String createSignedPutUrl(String bucketName, String objectKey, Map headersMap, AWSCredentials awsCredentials, Date expiryTime, boolean isVirtualHost) throws S3ServiceException {
        long secondsSinceEpoch = expiryTime.getTime() / 1000L;
        return S3Service.createSignedUrl("PUT", bucketName, objectKey, null, headersMap, awsCredentials, secondsSinceEpoch, isVirtualHost);
    }

    public static String createSignedPutUrl(String bucketName, String objectKey, Map headersMap, AWSCredentials awsCredentials, Date expiryTime) throws S3ServiceException {
        return S3Service.createSignedPutUrl(bucketName, objectKey, headersMap, awsCredentials, expiryTime, false);
    }

    public static String createSignedDeleteUrl(String bucketName, String objectKey, AWSCredentials awsCredentials, Date expiryTime, boolean isVirtualHost) throws S3ServiceException {
        long secondsSinceEpoch = expiryTime.getTime() / 1000L;
        return S3Service.createSignedUrl("DELETE", bucketName, objectKey, null, null, awsCredentials, secondsSinceEpoch, isVirtualHost);
    }

    public static String createSignedDeleteUrl(String bucketName, String objectKey, AWSCredentials awsCredentials, Date expiryTime) throws S3ServiceException {
        return S3Service.createSignedDeleteUrl(bucketName, objectKey, awsCredentials, expiryTime, false);
    }

    public static String createSignedHeadUrl(String bucketName, String objectKey, AWSCredentials awsCredentials, Date expiryTime, boolean isVirtualHost) throws S3ServiceException {
        long secondsSinceEpoch = expiryTime.getTime() / 1000L;
        return S3Service.createSignedUrl("HEAD", bucketName, objectKey, null, null, awsCredentials, secondsSinceEpoch, isVirtualHost);
    }

    public static String createSignedHeadUrl(String bucketName, String objectKey, AWSCredentials awsCredentials, Date expiryTime) throws S3ServiceException {
        return S3Service.createSignedHeadUrl(bucketName, objectKey, awsCredentials, expiryTime, false);
    }

    public static String createTorrentUrl(String bucketName, String objectKey) {
        return "http://" + S3Service.generateS3HostnameForBucket(bucketName, true) + "/" + (S3Service.isBucketNameValidDNSName(bucketName) ? "" : bucketName + "/") + objectKey + "?torrent";
    }

    public static String generatePostPolicyCondition(String operation, String name, String value) {
        return "[\"" + operation + "\", \"$" + name + "\", \"" + value + "\"]";
    }

    public static String generatePostPolicyCondition_AllowAnyValue(String name) {
        return "[\"starts-with\", \"$" + name + "\", \"\"]";
    }

    public static String generatePostPolicyCondition_Equality(String name, String value) {
        return "{\"" + name + "\": \"" + value + "\"}";
    }

    public static String generatePostPolicyCondition_Equality(String name, String[] values) {
        return "{\"" + name + "\": \"" + ServiceUtils.join(values, ",") + "\"}";
    }

    public static String generatePostPolicyCondition_Equality(String name, List values) {
        return "{\"" + name + "\": \"" + ServiceUtils.join(values, ",") + "\"}";
    }

    public static String generatePostPolicyCondition_Range(int min, int max) {
        return "[\"content-length-range\", " + min + ", " + max + "]";
    }

    public static String buildPostForm(String bucketName, String key) throws S3ServiceException, UnsupportedEncodingException {
        return S3Service.buildPostForm(bucketName, key, null, null, null, null, null, true);
    }

    public static String buildPostForm(String bucketName, String key, AWSCredentials awsCredentials, Date expiration, String[] conditions, String[] inputFields, String textInput, boolean isSecureHttp) throws S3ServiceException, UnsupportedEncodingException {
        return S3Service.buildPostForm(bucketName, key, awsCredentials, expiration, conditions, inputFields, textInput, isSecureHttp, false, "Upload to Amazon S3");
    }

    public static String buildPostForm(String bucketName, String key, AWSCredentials awsCredentials, Date expiration, String[] conditions, String[] inputFields, String textInput, boolean isSecureHttp, boolean usePathStyleUrl, String submitButtonName) throws S3ServiceException, UnsupportedEncodingException {
        ArrayList<String> myInputFields = new ArrayList<String>();
        if (expiration != null || conditions != null) {
            String policyDocument = "{\"expiration\": \"" + ServiceUtils.formatIso8601Date(expiration) + "\", \"conditions\": [" + ServiceUtils.join(conditions, ",") + "]}";
            if (log.isDebugEnabled()) {
                log.debug((Object)("Policy document for POST form:\n" + policyDocument));
            }
            String policyB64 = ServiceUtils.toBase64(policyDocument.getBytes(Constants.DEFAULT_ENCODING));
            myInputFields.add("<input type=\"hidden\" name=\"policy\" value=\"" + policyB64 + "\">");
            myInputFields.add("<input type=\"hidden\" name=\"AWSAccessKeyId\" value=\"" + awsCredentials.getAccessKey() + "\">");
            String signature = ServiceUtils.signWithHmacSha1(awsCredentials.getSecretKey(), policyB64);
            myInputFields.add("<input type=\"hidden\" name=\"signature\" value=\"" + signature + "\">");
        }
        if (inputFields != null) {
            myInputFields.addAll(Arrays.asList(inputFields));
        }
        if (textInput != null) {
            myInputFields.add(textInput);
        } else {
            myInputFields.add("<input name=\"file\" type=\"file\">");
        }
        String url = null;
        url = usePathStyleUrl ? "http" + (isSecureHttp ? "s" : "") + "://s3.amazonaws.com/" + bucketName : "http" + (isSecureHttp ? "s" : "") + "://" + bucketName + ".s3.amazonaws.com/";
        String form = "<form action=\"" + url + "\" method=\"post\" " + "enctype=\"multipart/form-data\">\n" + "<input type=\"hidden\" name=\"key\" value=\"" + key + "\">\n" + ServiceUtils.join(myInputFields, "\n") + "\n<br>\n" + "<input type=\"submit\" value=\"" + submitButtonName + "\">\n" + "</form>";
        if (log.isDebugEnabled()) {
            log.debug((Object)("POST Form:\n" + form));
        }
        return form;
    }

    protected void assertAuthenticatedConnection(String action) throws S3ServiceException {
        if (!this.isAuthenticatedConnection()) {
            throw new S3ServiceException("The requested action cannot be performed with a non-authenticated S3 Service: " + action);
        }
    }

    protected void assertValidBucket(S3Bucket bucket, String action) throws S3ServiceException {
        if (bucket == null || bucket.getName() == null || bucket.getName().length() == 0) {
            throw new S3ServiceException("The action " + action + " cannot be performed with an invalid bucket: " + bucket);
        }
    }

    protected void assertValidObject(S3Object object, String action) throws S3ServiceException {
        if (object == null || object.getKey() == null || object.getKey().length() == 0) {
            throw new S3ServiceException("The action " + action + " cannot be performed with an invalid object: " + object);
        }
    }

    protected void assertValidObject(String key, String action) throws S3ServiceException {
        if (key == null || key.length() == 0) {
            throw new S3ServiceException("The action " + action + " cannot be performed with an invalid object key name: " + key);
        }
    }

    public S3Object[] listObjects(S3Bucket bucket) throws S3ServiceException {
        this.assertValidBucket(bucket, "listObjects");
        return this.listObjects(bucket, null, null, 1000L);
    }

    public S3Object[] listObjects(S3Bucket bucket, String prefix, String delimiter) throws S3ServiceException {
        this.assertValidBucket(bucket, "listObjects");
        return this.listObjects(bucket, prefix, delimiter, 1000L);
    }

    public S3Bucket createBucket(String bucketName, String location) throws S3ServiceException {
        this.assertAuthenticatedConnection("createBucket");
        S3Bucket bucket = new S3Bucket(bucketName, location);
        return this.createBucket(bucket);
    }

    public S3Bucket createBucket(String bucketName) throws S3ServiceException {
        String defaultBucketLocation = this.jets3tProperties.getStringProperty("s3service.default-bucket-location", S3Bucket.LOCATION_US);
        return this.createBucket(bucketName, defaultBucketLocation);
    }

    public S3Object getObject(S3Bucket bucket, String objectKey) throws S3ServiceException {
        this.assertValidBucket(bucket, "getObject");
        return this.getObject(bucket, objectKey, null, null, null, null, null, null);
    }

    public S3Object getObjectDetails(S3Bucket bucket, String objectKey) throws S3ServiceException {
        this.assertValidBucket(bucket, "getObjectDetails");
        return this.getObjectDetails(bucket, objectKey, null, null, null, null);
    }

    public S3Bucket[] listAllBuckets() throws S3ServiceException {
        this.assertAuthenticatedConnection("List all buckets");
        S3Bucket[] buckets = this.listAllBucketsImpl();
        MxDelegate.getInstance().registerS3BucketMBeans(buckets);
        return buckets;
    }

    public S3Owner getAccountOwner() throws S3ServiceException {
        this.assertAuthenticatedConnection("List all buckets to find account owner");
        return this.getAccountOwnerImpl();
    }

    public S3Object[] listObjects(S3Bucket bucket, String prefix, String delimiter, long maxListingLength) throws S3ServiceException {
        this.assertValidBucket(bucket, "List objects in bucket");
        return this.listObjects(bucket.getName(), prefix, delimiter, maxListingLength);
    }

    public S3Object[] listObjects(String bucketName, String prefix, String delimiter, long maxListingLength) throws S3ServiceException {
        MxDelegate.getInstance().registerS3BucketListEvent(bucketName);
        S3Object[] objects = this.listObjectsImpl(bucketName, prefix, delimiter, maxListingLength);
        MxDelegate.getInstance().registerS3ObjectMBean(bucketName, objects);
        return objects;
    }

    public S3ObjectsChunk listObjectsChunked(String bucketName, String prefix, String delimiter, long maxListingLength, String priorLastKey) throws S3ServiceException {
        MxDelegate.getInstance().registerS3BucketListEvent(bucketName);
        S3ObjectsChunk chunk = this.listObjectsChunkedImpl(bucketName, prefix, delimiter, maxListingLength, priorLastKey, false);
        MxDelegate.getInstance().registerS3ObjectMBean(bucketName, chunk.getObjects());
        return chunk;
    }

    public S3ObjectsChunk listObjectsChunked(String bucketName, String prefix, String delimiter, long maxListingLength, String priorLastKey, boolean completeListing) throws S3ServiceException {
        MxDelegate.getInstance().registerS3BucketListEvent(bucketName);
        S3ObjectsChunk chunk = this.listObjectsChunkedImpl(bucketName, prefix, delimiter, maxListingLength, priorLastKey, completeListing);
        MxDelegate.getInstance().registerS3ObjectMBean(bucketName, chunk.getObjects());
        return chunk;
    }

    public S3Bucket createBucket(S3Bucket bucket) throws S3ServiceException {
        this.assertAuthenticatedConnection("Create Bucket");
        this.assertValidBucket(bucket, "Create Bucket");
        return this.createBucketImpl(bucket.getName(), bucket.getLocation(), bucket.getAcl());
    }

    public S3Bucket getBucket(String bucketName) throws S3ServiceException {
        this.assertAuthenticatedConnection("Create Bucket");
        S3Bucket[] existingBuckets = this.listAllBuckets();
        for (int i = 0; i < existingBuckets.length; ++i) {
            if (!existingBuckets[i].getName().equals(bucketName)) continue;
            return existingBuckets[i];
        }
        return null;
    }

    public S3Bucket getOrCreateBucket(String bucketName) throws S3ServiceException {
        this.assertAuthenticatedConnection("Get or Create Bucket");
        S3Bucket bucket = this.getBucket(bucketName);
        if (bucket == null) {
            bucket = this.createBucket(new S3Bucket(bucketName));
        }
        return bucket;
    }

    public void deleteBucket(S3Bucket bucket) throws S3ServiceException {
        this.assertValidBucket(bucket, "Delete bucket");
        this.deleteBucketImpl(bucket.getName());
    }

    public void deleteBucket(String bucketName) throws S3ServiceException {
        this.deleteBucketImpl(bucketName);
    }

    public S3Object putObject(String bucketName, S3Object object) throws S3ServiceException {
        this.assertValidObject(object, "Create Object in bucket " + bucketName);
        MxDelegate.getInstance().registerS3ObjectPutEvent(bucketName, object.getKey());
        return this.putObjectImpl(bucketName, object);
    }

    public Map copyObject(String sourceBucketName, String sourceObjectKey, String destinationBucketName, S3Object destinationObject, boolean replaceMetadata, Calendar ifModifiedSince, Calendar ifUnmodifiedSince, String[] ifMatchTags, String[] ifNoneMatchTags) throws S3ServiceException {
        this.assertAuthenticatedConnection("copyObject");
        Map destinationMetadata = replaceMetadata ? destinationObject.getModifiableMetadata() : null;
        MxDelegate.getInstance().registerS3ObjectCopyEvent(sourceBucketName, sourceObjectKey);
        return this.copyObjectImpl(sourceBucketName, sourceObjectKey, destinationBucketName, destinationObject.getKey(), destinationObject.getAcl(), destinationMetadata, ifModifiedSince, ifUnmodifiedSince, ifMatchTags, ifNoneMatchTags);
    }

    public Map copyObject(String sourceBucketName, String sourceObjectKey, String destinationBucketName, S3Object destinationObject, boolean replaceMetadata) throws S3ServiceException {
        return this.copyObject(sourceBucketName, sourceObjectKey, destinationBucketName, destinationObject, replaceMetadata, null, null, null, null);
    }

    public Map moveObject(String sourceBucketName, String sourceObjectKey, String destinationBucketName, S3Object destinationObject, boolean replaceMetadata) throws S3ServiceException {
        Map copyResult = this.copyObject(sourceBucketName, sourceObjectKey, destinationBucketName, destinationObject, replaceMetadata);
        try {
            this.deleteObject(sourceBucketName, sourceObjectKey);
        }
        catch (Exception e) {
            copyResult.put("DeleteException", e);
        }
        return copyResult;
    }

    public Map renameObject(String bucketName, String sourceObjectKey, S3Object destinationObject) throws S3ServiceException {
        return this.moveObject(bucketName, sourceObjectKey, bucketName, destinationObject, false);
    }

    public Map updateObjectMetadata(String bucketName, S3Object object) throws S3ServiceException {
        return this.copyObject(bucketName, object.getKey(), bucketName, object, true);
    }

    public S3Object putObject(S3Bucket bucket, S3Object object) throws S3ServiceException {
        this.assertValidBucket(bucket, "Create Object in bucket");
        return this.putObject(bucket.getName(), object);
    }

    public void deleteObject(S3Bucket bucket, String objectKey) throws S3ServiceException {
        this.assertValidBucket(bucket, "deleteObject");
        this.assertValidObject(objectKey, "deleteObject");
        this.deleteObject(bucket.getName(), objectKey);
    }

    public void deleteObject(String bucketName, String objectKey) throws S3ServiceException {
        this.assertValidObject(objectKey, "deleteObject");
        MxDelegate.getInstance().registerS3ObjectDeleteEvent(bucketName, objectKey);
        this.deleteObjectImpl(bucketName, objectKey);
    }

    public S3Object getObjectDetails(S3Bucket bucket, String objectKey, Calendar ifModifiedSince, Calendar ifUnmodifiedSince, String[] ifMatchTags, String[] ifNoneMatchTags) throws S3ServiceException {
        this.assertValidBucket(bucket, "Get Object Details");
        MxDelegate.getInstance().registerS3ObjectHeadEvent(bucket.getName(), objectKey);
        return this.getObjectDetailsImpl(bucket.getName(), objectKey, ifModifiedSince, ifUnmodifiedSince, ifMatchTags, ifNoneMatchTags);
    }

    public S3Object getObjectDetails(String bucketName, String objectKey, Calendar ifModifiedSince, Calendar ifUnmodifiedSince, String[] ifMatchTags, String[] ifNoneMatchTags) throws S3ServiceException {
        MxDelegate.getInstance().registerS3ObjectHeadEvent(bucketName, objectKey);
        return this.getObjectDetailsImpl(bucketName, objectKey, ifModifiedSince, ifUnmodifiedSince, ifMatchTags, ifNoneMatchTags);
    }

    public S3Object getObject(S3Bucket bucket, String objectKey, Calendar ifModifiedSince, Calendar ifUnmodifiedSince, String[] ifMatchTags, String[] ifNoneMatchTags, Long byteRangeStart, Long byteRangeEnd) throws S3ServiceException {
        this.assertValidBucket(bucket, "Get Object");
        MxDelegate.getInstance().registerS3ObjectGetEvent(bucket.getName(), objectKey);
        return this.getObjectImpl(bucket.getName(), objectKey, ifModifiedSince, ifUnmodifiedSince, ifMatchTags, ifNoneMatchTags, byteRangeStart, byteRangeEnd);
    }

    public S3Object getObject(String bucketName, String objectKey, Calendar ifModifiedSince, Calendar ifUnmodifiedSince, String[] ifMatchTags, String[] ifNoneMatchTags, Long byteRangeStart, Long byteRangeEnd) throws S3ServiceException {
        MxDelegate.getInstance().registerS3ObjectGetEvent(bucketName, objectKey);
        return this.getObjectImpl(bucketName, objectKey, ifModifiedSince, ifUnmodifiedSince, ifMatchTags, ifNoneMatchTags, byteRangeStart, byteRangeEnd);
    }

    public void putObjectAcl(S3Bucket bucket, S3Object object) throws S3ServiceException {
        this.assertValidBucket(bucket, "Put Object Access Control List");
        this.assertValidObject(object, "Put Object Access Control List");
        this.putObjectAcl(bucket.getName(), object.getKey(), object.getAcl());
    }

    public void putObjectAcl(String bucketName, String objectKey, AccessControlList acl) throws S3ServiceException {
        if (acl == null) {
            throw new S3ServiceException("The object '" + objectKey + "' does not include ACL information");
        }
        this.putObjectAclImpl(bucketName, objectKey, acl);
    }

    public void putBucketAcl(S3Bucket bucket) throws S3ServiceException {
        this.assertValidBucket(bucket, "Put Bucket Access Control List");
        this.putBucketAcl(bucket.getName(), bucket.getAcl());
    }

    public void putBucketAcl(String bucketName, AccessControlList acl) throws S3ServiceException {
        if (acl == null) {
            throw new S3ServiceException("The bucket '" + bucketName + "' does not include ACL information");
        }
        this.putBucketAclImpl(bucketName, acl);
    }

    public AccessControlList getObjectAcl(S3Bucket bucket, String objectKey) throws S3ServiceException {
        this.assertValidBucket(bucket, "Get Object Access Control List");
        return this.getObjectAclImpl(bucket.getName(), objectKey);
    }

    public AccessControlList getObjectAcl(String bucketName, String objectKey) throws S3ServiceException {
        return this.getObjectAclImpl(bucketName, objectKey);
    }

    public AccessControlList getBucketAcl(S3Bucket bucket) throws S3ServiceException {
        this.assertValidBucket(bucket, "Get Bucket Access Control List");
        return this.getBucketAclImpl(bucket.getName());
    }

    public AccessControlList getBucketAcl(String bucketName) throws S3ServiceException {
        return this.getBucketAclImpl(bucketName);
    }

    public String getBucketLocation(String bucketName) throws S3ServiceException {
        return this.getBucketLocationImpl(bucketName);
    }

    public S3BucketLoggingStatus getBucketLoggingStatus(String bucketName) throws S3ServiceException {
        return this.getBucketLoggingStatusImpl(bucketName);
    }

    public void setBucketLoggingStatus(String bucketName, S3BucketLoggingStatus status, boolean updateTargetACLifRequired) throws S3ServiceException {
        if (status.isLoggingEnabled() && updateTargetACLifRequired) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Checking whether the target logging bucket '" + status.getTargetBucketName() + "' has the appropriate ACL settings"));
            }
            boolean isSetLoggingGroupWrite = false;
            boolean isSetLoggingGroupReadACP = false;
            String groupIdentifier = GroupGrantee.LOG_DELIVERY.getIdentifier();
            AccessControlList logBucketACL = this.getBucketAcl(status.getTargetBucketName());
            for (GrantAndPermission gap : logBucketACL.getGrants()) {
                if (!groupIdentifier.equals(gap.getGrantee().getIdentifier())) continue;
                if (gap.getPermission().equals(Permission.PERMISSION_WRITE)) {
                    isSetLoggingGroupWrite = true;
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Target bucket '" + status.getTargetBucketName() + "' has ACL " + "permission " + Permission.PERMISSION_WRITE + " for group " + groupIdentifier));
                    continue;
                }
                if (!gap.getPermission().equals(Permission.PERMISSION_READ_ACP)) continue;
                isSetLoggingGroupReadACP = true;
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Target bucket '" + status.getTargetBucketName() + "' has ACL " + "permission " + Permission.PERMISSION_READ_ACP + " for group " + groupIdentifier));
            }
            if (!isSetLoggingGroupWrite || !isSetLoggingGroupReadACP) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)("Target logging bucket '" + status.getTargetBucketName() + "' does not have the necessary ACL settings, updating ACL now"));
                }
                logBucketACL.grantPermission(GroupGrantee.LOG_DELIVERY, Permission.PERMISSION_WRITE);
                logBucketACL.grantPermission(GroupGrantee.LOG_DELIVERY, Permission.PERMISSION_READ_ACP);
                this.putBucketAcl(status.getTargetBucketName(), logBucketACL);
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Target logging bucket '" + status.getTargetBucketName() + "' has the necessary ACL settings"));
            }
        }
        this.setBucketLoggingStatusImpl(bucketName, status);
    }

    public boolean isRequesterPaysBucket(String bucketName) throws S3ServiceException {
        return this.isRequesterPaysBucketImpl(bucketName);
    }

    public void setRequesterPaysBucket(String bucketName, boolean requesterPays) throws S3ServiceException {
        this.setRequesterPaysBucketImpl(bucketName, requesterPays);
    }

    public Date getCurrentTimeWithOffset() {
        return new Date(System.currentTimeMillis() + this.timeOffset);
    }

    public abstract boolean isBucketAccessible(String var1) throws S3ServiceException;

    public abstract int checkBucketStatus(String var1) throws S3ServiceException;

    protected abstract String getBucketLocationImpl(String var1) throws S3ServiceException;

    protected abstract S3BucketLoggingStatus getBucketLoggingStatusImpl(String var1) throws S3ServiceException;

    protected abstract void setBucketLoggingStatusImpl(String var1, S3BucketLoggingStatus var2) throws S3ServiceException;

    protected abstract void setRequesterPaysBucketImpl(String var1, boolean var2) throws S3ServiceException;

    protected abstract boolean isRequesterPaysBucketImpl(String var1) throws S3ServiceException;

    protected abstract S3Bucket[] listAllBucketsImpl() throws S3ServiceException;

    protected abstract S3Owner getAccountOwnerImpl() throws S3ServiceException;

    protected abstract S3Object[] listObjectsImpl(String var1, String var2, String var3, long var4) throws S3ServiceException;

    protected abstract S3ObjectsChunk listObjectsChunkedImpl(String var1, String var2, String var3, long var4, String var6, boolean var7) throws S3ServiceException;

    protected abstract S3Bucket createBucketImpl(String var1, String var2, AccessControlList var3) throws S3ServiceException;

    protected abstract void deleteBucketImpl(String var1) throws S3ServiceException;

    protected abstract S3Object putObjectImpl(String var1, S3Object var2) throws S3ServiceException;

    protected abstract Map copyObjectImpl(String var1, String var2, String var3, String var4, AccessControlList var5, Map var6, Calendar var7, Calendar var8, String[] var9, String[] var10) throws S3ServiceException;

    protected abstract void deleteObjectImpl(String var1, String var2) throws S3ServiceException;

    protected abstract S3Object getObjectDetailsImpl(String var1, String var2, Calendar var3, Calendar var4, String[] var5, String[] var6) throws S3ServiceException;

    protected abstract S3Object getObjectImpl(String var1, String var2, Calendar var3, Calendar var4, String[] var5, String[] var6, Long var7, Long var8) throws S3ServiceException;

    protected abstract void putBucketAclImpl(String var1, AccessControlList var2) throws S3ServiceException;

    protected abstract void putObjectAclImpl(String var1, String var2, AccessControlList var3) throws S3ServiceException;

    protected abstract AccessControlList getObjectAclImpl(String var1, String var2) throws S3ServiceException;

    protected abstract AccessControlList getBucketAclImpl(String var1) throws S3ServiceException;
}

