/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webdav.lib.search;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.webdav.lib.PropertyName;
import org.apache.webdav.lib.search.BasicSearchBuilder;
import org.apache.webdav.lib.search.CompareOperator;
import org.apache.webdav.lib.search.SearchException;
import org.apache.webdav.lib.search.SearchExpression;
import org.apache.webdav.lib.search.SearchScope;
import org.apache.webdav.lib.search.TestOperator;
import org.apache.webdav.lib.search.expressions.AndExpression;
import org.apache.webdav.lib.search.expressions.CompareExpression;
import org.apache.webdav.lib.search.expressions.ContainsExpression;
import org.apache.webdav.lib.search.expressions.IsDefinedExpression;
import org.apache.webdav.lib.search.expressions.NotExpression;
import org.apache.webdav.lib.search.expressions.OrExpression;
import org.apache.webdav.lib.search.expressions.TestExpression;

public class SearchRequest {
    private List selections = new ArrayList();
    private List scopes = new ArrayList();
    private SearchExpression whereClause = null;

    public void addSelection(PropertyName propertyName) {
        this.selections.add(propertyName);
    }

    public Iterator getSelection() {
        return this.selections.iterator();
    }

    public void addScope(SearchScope scope) {
        this.scopes.add(scope);
    }

    public void setWhereExpression(SearchExpression expression) {
        this.whereClause = expression;
    }

    public SearchExpression getWhereExpression() {
        return this.whereClause;
    }

    public CompareExpression compare(CompareOperator op, PropertyName property, Object value) {
        return new CompareExpression(op, property, value);
    }

    public ContainsExpression contains(String text) {
        return new ContainsExpression(text);
    }

    public AndExpression and(SearchExpression e1, SearchExpression e2) {
        AndExpression and = new AndExpression();
        and.add(e1);
        and.add(e2);
        return and;
    }

    public AndExpression and(SearchExpression e1, SearchExpression e2, SearchExpression e3) {
        AndExpression and = new AndExpression();
        and.add(e1);
        and.add(e2);
        and.add(e3);
        return and;
    }

    public OrExpression or(SearchExpression e1, SearchExpression e2) {
        OrExpression or = new OrExpression();
        or.add(e1);
        or.add(e2);
        return or;
    }

    public OrExpression or(SearchExpression e1, SearchExpression e2, SearchExpression e3) {
        OrExpression or = new OrExpression();
        or.add(e1);
        or.add(e2);
        or.add(e3);
        return or;
    }

    public NotExpression not(SearchExpression ex) {
        return new NotExpression(ex);
    }

    public IsDefinedExpression isDefined(PropertyName property) {
        return new IsDefinedExpression(property);
    }

    public TestExpression test(TestOperator operator) {
        return new TestExpression(operator.getNamespaceURI(), operator.getLocalName());
    }

    public Object variable(String name) {
        return this.variable(name, null);
    }

    public Object variable(String name, Object defaultValue) {
        return new Variable(name, defaultValue);
    }

    public String asString() throws SearchException {
        BasicSearchBuilder builder = new BasicSearchBuilder();
        return builder.build(this, Collections.EMPTY_MAP, this.scopes);
    }

    public String asString(List scopes) throws SearchException {
        BasicSearchBuilder builder = new BasicSearchBuilder();
        return builder.build(this, Collections.EMPTY_MAP, scopes);
    }

    public String asString(Map variables) throws SearchException {
        BasicSearchBuilder builder = new BasicSearchBuilder();
        return builder.build(this, variables, this.scopes);
    }

    public String asString(Map variables, List scopes) throws SearchException {
        BasicSearchBuilder builder = new BasicSearchBuilder();
        return builder.build(this, variables, scopes);
    }

    public static class Variable {
        private String name;
        private Object defaultValue;

        Variable(String name, Object value) {
            if (value instanceof Variable) {
                throw new IllegalArgumentException("Variables values must not be variables.");
            }
            this.name = name;
            this.defaultValue = value;
        }

        public Object getDefaultValue() {
            return this.defaultValue;
        }

        public String getName() {
            return this.name;
        }
    }
}

