/*
 * Decompiled with CFR 0.152.
 */
package com.jamesmurty.utils;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLBuilder {
    private Document xmlDocument = null;
    private XMLBuilder myParent = null;
    private Element xmlElement = null;

    protected XMLBuilder(Document document, Element element) {
        this.myParent = null;
        this.xmlElement = element;
        this.xmlDocument = document;
        this.xmlDocument.appendChild(element);
    }

    protected XMLBuilder(XMLBuilder xMLBuilder, Element element) {
        this.myParent = xMLBuilder;
        this.xmlElement = element;
        xMLBuilder.xmlElement.appendChild(element);
    }

    public static XMLBuilder create(String string) throws ParserConfigurationException, FactoryConfigurationError {
        DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        return new XMLBuilder(document, document.createElement(string));
    }

    public Element getElement() {
        return this.xmlElement;
    }

    public XMLBuilder root() {
        XMLBuilder xMLBuilder = this;
        while (xMLBuilder.myParent != null) {
            xMLBuilder = xMLBuilder.myParent;
        }
        return xMLBuilder;
    }

    public Document getDocument() {
        return this.root().xmlDocument;
    }

    public XMLBuilder element(String string) {
        Node node = null;
        NodeList nodeList = this.xmlElement.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (3 != nodeList.item(i).getNodeType()) continue;
            node = nodeList.item(i);
            break;
        }
        if (node != null) {
            throw new IllegalStateException("Cannot add sub-element <" + string + "> to element <" + this.xmlElement.getNodeName() + "> that already contains the Text node: " + node);
        }
        XMLBuilder xMLBuilder = new XMLBuilder(this, this.getDocument().createElement(string));
        return xMLBuilder;
    }

    public XMLBuilder elem(String string) {
        return this.element(string);
    }

    public XMLBuilder e(String string) {
        return this.element(string);
    }

    public XMLBuilder attribute(String string, String string2) {
        this.xmlElement.setAttribute(string, string2);
        return this;
    }

    public XMLBuilder attr(String string, String string2) {
        return this.attribute(string, string2);
    }

    public XMLBuilder a(String string, String string2) {
        return this.attribute(string, string2);
    }

    public XMLBuilder text(String string) {
        this.xmlElement.appendChild(this.getDocument().createTextNode(string));
        return this;
    }

    public XMLBuilder t(String string) {
        return this.text(string);
    }

    public XMLBuilder cdata(String string) {
        this.xmlElement.appendChild(this.getDocument().createCDATASection(string));
        return this;
    }

    public XMLBuilder data(String string) {
        return this.cdata(string);
    }

    public XMLBuilder d(String string) {
        return this.cdata(string);
    }

    public XMLBuilder comment(String string) {
        this.xmlElement.appendChild(this.getDocument().createComment(string));
        return this;
    }

    public XMLBuilder cmnt(String string) {
        return this.comment(string);
    }

    public XMLBuilder c(String string) {
        return this.comment(string);
    }

    public XMLBuilder instruction(String string, String string2) {
        this.xmlElement.appendChild(this.getDocument().createProcessingInstruction(string, string2));
        return this;
    }

    public XMLBuilder inst(String string, String string2) {
        return this.instruction(string, string2);
    }

    public XMLBuilder i(String string, String string2) {
        return this.instruction(string, string2);
    }

    public XMLBuilder reference(String string) {
        this.xmlElement.appendChild(this.getDocument().createEntityReference(string));
        return this;
    }

    public XMLBuilder ref(String string) {
        return this.reference(string);
    }

    public XMLBuilder r(String string) {
        return this.reference(string);
    }

    public XMLBuilder up(int n) {
        XMLBuilder xMLBuilder = this;
        for (int i = 0; xMLBuilder.myParent != null && i < n; ++i) {
            xMLBuilder = xMLBuilder.myParent;
        }
        return xMLBuilder;
    }

    public XMLBuilder up() {
        return this.up(1);
    }

    public void toWriter(Writer writer, Properties properties) throws TransformerException {
        StreamResult streamResult = new StreamResult(writer);
        DOMSource dOMSource = new DOMSource(this.getDocument());
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        if (properties != null) {
            Iterator<Map.Entry<Object, Object>> iterator = properties.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Object, Object> entry = iterator.next();
                transformer.setOutputProperty((String)entry.getKey(), (String)entry.getValue());
            }
        }
        transformer.transform(dOMSource, streamResult);
    }

    public String asString(Properties properties) throws TransformerException {
        StringWriter stringWriter = new StringWriter();
        this.toWriter(stringWriter, properties);
        return stringWriter.toString();
    }
}

