/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Attributes;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.NullComparator;
import ch.cyberduck.core.NullPathFilter;
import ch.cyberduck.core.PathFilter;
import ch.cyberduck.core.PathReference;
import ch.cyberduck.core.Permission;
import ch.cyberduck.core.Preferences;
import com.ibm.icu.text.Normalizer;
import java.util.Comparator;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jets3t.service.utils.Mimetypes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPath {
    private static Logger log = Logger.getLogger(AbstractPath.class);
    public static final String DELIMITER = "/";
    public static final String HOME = "~";
    public Attributes attributes;
    public static final int FILE_TYPE = 1;
    public static final int DIRECTORY_TYPE = 2;
    public static final int SYMBOLIC_LINK_TYPE = 4;
    public static final int VOLUME_TYPE = 8;
    private String symbolic = null;

    public boolean isCached() {
        return this.cache().containsKey(this) && !this.cache().get(this).attributes().isDirty();
    }

    public abstract <T extends AbstractPath> Cache<T> cache();

    public void invalidate() {
        if (this.attributes.isDirectory() && this.isCached()) {
            this.cache().get(this).attributes().setDirty(true);
        }
    }

    public abstract <T> PathReference<T> getReference();

    public abstract String toURL();

    public abstract <T extends AbstractPath> AttributedList<T> list();

    public <T extends AbstractPath> AttributedList<T> childs() {
        return this.childs(new NullPathFilter());
    }

    public <T extends AbstractPath> AttributedList<T> childs(PathFilter<T> filter) {
        return this.childs(new NullComparator(), filter);
    }

    public <T extends AbstractPath> AttributedList<T> childs(Comparator<T> comparator, PathFilter<T> filter) {
        if (!this.isCached()) {
            this.cache().put(this, this.list());
        }
        return this.cache().get(this, comparator, filter);
    }

    public boolean isRoot() {
        return this.getAbsolute().equals(DELIMITER);
    }

    public static String getParent(String absolute) {
        int cut;
        int index = absolute.length() - 1;
        if (absolute.charAt(index) == '/' && index > 0) {
            --index;
        }
        if ((cut = absolute.lastIndexOf(47, index)) > 0) {
            return absolute.substring(0, cut);
        }
        return DELIMITER;
    }

    public abstract String getAbsolute();

    public abstract String getName();

    public abstract AbstractPath getParent();

    public abstract boolean exists();

    public static String normalize(String path) {
        return AbstractPath.normalize(path, true);
    }

    public static String normalize(String path, boolean absolute) {
        if (null == path) {
            return DELIMITER;
        }
        String normalized = path;
        if (Preferences.instance().getBoolean("path.normalize")) {
            String[] segments;
            int index;
            if (absolute) {
                while (!normalized.startsWith("\\\\") && !normalized.startsWith(DELIMITER)) {
                    normalized = DELIMITER + normalized;
                }
            }
            while (!normalized.endsWith(DELIMITER)) {
                normalized = normalized + DELIMITER;
            }
            while ((index = normalized.indexOf("/./")) >= 0) {
                normalized = normalized.substring(0, index) + normalized.substring(index + 2);
            }
            while ((index = normalized.indexOf("/../")) >= 0) {
                if (index == 0) {
                    return DELIMITER;
                }
                normalized = normalized.substring(0, normalized.lastIndexOf(47, index - 1)) + normalized.substring(index + 3);
            }
            StringBuffer n = new StringBuffer();
            if (normalized.startsWith("//")) {
                n.append(DELIMITER);
                n.append(DELIMITER);
            } else if (!normalized.startsWith("\\\\")) {
                if (absolute) {
                    n.append(DELIMITER);
                } else if (normalized.startsWith(DELIMITER)) {
                    n.append(DELIMITER);
                }
            }
            for (String segment : segments = normalized.split(DELIMITER)) {
                if (segment.equals("")) continue;
                n.append(segment);
                n.append(DELIMITER);
            }
            normalized = n.toString();
            while (normalized.endsWith(DELIMITER) && normalized.length() > 1) {
                normalized = normalized.substring(0, normalized.length() - 1);
            }
        }
        if (Preferences.instance().getBoolean("path.normalize.unicode") && !Normalizer.isNormalized((String)normalized, (Normalizer.Mode)Normalizer.NFC, (int)32)) {
            normalized = Normalizer.normalize((String)normalized, (Normalizer.Mode)Normalizer.NFC, (int)32);
        }
        return normalized;
    }

    public String getExtension() {
        String extension = FilenameUtils.getExtension((String)this.getName());
        if (StringUtils.isEmpty((String)extension)) {
            return null;
        }
        return extension;
    }

    public String getMimeType() {
        return Mimetypes.getInstance().getMimetype(this.getName().toLowerCase());
    }

    public void setPath(String parent, String name) {
        if (null == parent) {
            parent = DELIMITER;
        }
        if (parent.endsWith(DELIMITER)) {
            this.setPath(parent + name);
        } else {
            this.setPath(parent + DELIMITER + name);
        }
    }

    public abstract void setPath(String var1);

    public boolean isChild(AbstractPath p) {
        AbstractPath parent = this.getParent();
        while (!parent.isRoot()) {
            if (parent.equals(p)) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    public void setSymbolicLinkPath(String parent, String name) {
        if (name.startsWith(DELIMITER)) {
            this.setSymbolicLinkPath(name);
        } else if (parent.endsWith(DELIMITER)) {
            this.setSymbolicLinkPath(parent + name);
        } else {
            this.setSymbolicLinkPath(parent + DELIMITER + name);
        }
    }

    public void setSymbolicLinkPath(String p) {
        this.symbolic = AbstractPath.normalize(p);
    }

    public String getSymbolicLinkPath() {
        if (this.attributes.isSymbolicLink()) {
            return this.symbolic;
        }
        return null;
    }

    public boolean isMkdirSupported() {
        return true;
    }

    public void mkdir() {
        this.mkdir(false);
    }

    public abstract void mkdir(boolean var1);

    public boolean isWritePermissionsSupported() {
        return true;
    }

    public abstract void writePermissions(Permission var1, boolean var2);

    public void writeModificationDate(long millis) {
        throw new UnsupportedOperationException();
    }

    public abstract void delete();

    public boolean isEmpty() {
        return this.childs().size() == 0;
    }

    public boolean isRenameSupported() {
        return true;
    }

    public abstract void rename(AbstractPath var1);

    public abstract void copy(AbstractPath var1);

    public boolean isExecutable() {
        Permission perm = this.attributes.getPermission();
        if (null == perm) {
            log.warn((Object)"Unknown permissions");
            return true;
        }
        return perm.getOwnerPermissions()[2] || perm.getGroupPermissions()[2] || perm.getOtherPermissions()[2];
    }

    public boolean isReadable() {
        Permission perm = this.attributes.getPermission();
        if (null == perm) {
            log.warn((Object)"Unknown permissions");
            return true;
        }
        return perm.getOwnerPermissions()[0] || perm.getGroupPermissions()[0] || perm.getOtherPermissions()[0];
    }

    public boolean isWritable() {
        Permission perm = this.attributes.getPermission();
        if (null == perm) {
            log.warn((Object)"Unknown permissions");
            return true;
        }
        return perm.getOwnerPermissions()[1] || perm.getGroupPermissions()[1] || perm.getOtherPermissions()[1];
    }
}

