/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathFactory;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.i18n.Locale;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Archive {
    private static Logger log = Logger.getLogger(Archive.class);
    public static final Archive TAR = new Archive("tar"){

        public String getDescription() {
            return Locale.localizedString("tar archive", "Archive");
        }
    };
    public static final Archive TARGZ = new Archive("tar.gz"){

        public String getDescription() {
            return Locale.localizedString("gzip compressed tar archive", "Archive");
        }

        public String[] getExtensions() {
            return new String[]{this.getIdentifier(), "tgz"};
        }
    };
    public static final Archive TARBZ2 = new Archive("tar.bz2"){

        public String getDescription() {
            return Locale.localizedString("bzip2 compressed tar archive", "Archive");
        }

        public String[] getExtensions() {
            return new String[]{this.getIdentifier(), "tbz", "tbz2"};
        }
    };
    public static final Archive ZIP = new Archive("zip"){

        public String getDescription() {
            return Locale.localizedString("ZIP archive", "Archive");
        }
    };
    public static final Archive GZIP = new Archive("gz"){

        public String getDescription() {
            return Locale.localizedString("gzip compressed tar archive", "Archive");
        }

        public String[] getExtensions() {
            return new String[]{this.getIdentifier(), "gzip"};
        }
    };
    public static final Archive BZ2 = new Archive("bz2"){

        public String getDescription() {
            return Locale.localizedString("bzip2 compressed archive", "Archive");
        }

        public String[] getExtensions() {
            return new String[]{this.getIdentifier(), "bz", "bzip2"};
        }
    };
    private String identifier;

    public static Archive getDefault() {
        return Archive.forName(Preferences.instance().getProperty("archive.default"));
    }

    public static Archive[] getKnownArchives() {
        return new Archive[]{TAR, TARGZ, TARBZ2, ZIP};
    }

    public static Archive forName(String name) {
        if (StringUtils.isNotBlank((String)name)) {
            for (Archive archive : Archive.getKnownArchives()) {
                for (String extension : archive.getExtensions()) {
                    if (!name.toLowerCase().endsWith(extension.toLowerCase())) continue;
                    return archive;
                }
            }
        }
        log.fatal((Object)("Unknown archive:" + name));
        return null;
    }

    private Archive(String extension) {
        this.identifier = extension;
    }

    public String[] getExtensions() {
        return new String[]{this.getIdentifier()};
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public abstract String getDescription();

    public Path getArchive(List<Path> files) {
        if (files.size() == 0) {
            return null;
        }
        if (files.size() == 1) {
            return PathFactory.createPath(files.get(0).getSession(), files.get(0).getParent().getAbsolute(), files.get(0).getName() + "." + this.getIdentifier(), 1);
        }
        return PathFactory.createPath(files.get(0).getSession(), files.get(0).getParent().getAbsolute(), Locale.localizedString("Archive", "Archive") + "." + this.getIdentifier(), 1);
    }

    public List<Path> getExpanded(List<Path> files) {
        ArrayList<Path> expanded = new ArrayList<Path>();
        for (Path file : files) {
            expanded.add(PathFactory.createPath(file.getSession(), file.getParent().getAbsolute(), StringUtils.remove((String)file.getName(), (String)("." + this.getIdentifier())), 1));
        }
        return expanded;
    }

    public String getTitle(List<Path> files) {
        Path archive = this.getArchive(files);
        if (null == archive) {
            return this.getIdentifier();
        }
        return archive.getName();
    }

    public String getCompressCommand(List<Path> paths) {
        String archive = paths.size() == 1 ? paths.get(0).getAbsolute() : paths.get(0).getParent().getAbsolute() + "/" + "Archive";
        ArrayList<String> files = new ArrayList<String>();
        for (Path path : paths) {
            files.add(this.escape(path.getAbsolute()));
        }
        return MessageFormat.format(Preferences.instance().getProperty("archive.command.create." + this.getIdentifier()), this.escape(archive), StringUtils.join(files, (String)" "));
    }

    public String getDecompressCommand(Path path) {
        return MessageFormat.format(Preferences.instance().getProperty("archive.command.expand." + this.getIdentifier()), this.escape(path.getAbsolute()), this.escape(path.getParent().getAbsolute()));
    }

    private String escape(String path) {
        return StringUtils.replace((String)path, (String)" ", (String)"\\ ");
    }

    public static boolean isArchive(String filename) {
        if (StringUtils.isNotBlank((String)filename)) {
            for (Archive archive : Archive.getKnownArchives()) {
                for (String extension : archive.getExtensions()) {
                    if (!filename.endsWith(extension)) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

