/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.NullComparator;
import ch.cyberduck.core.NullPathFilter;
import ch.cyberduck.core.PathFilter;
import ch.cyberduck.core.PathReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributedList<E extends AbstractPath>
extends ArrayList<E> {
    protected static final String FILTER = "FILTER";
    protected static final String COMPARATOR = "COMPARATOR";
    protected static final String HIDDEN = "HIDDEN";
    private static final String INVALID = "INVALID";
    private static final String READABLE = "READABLE";
    private Attributes<E> attributes;
    private static final AttributedList<AbstractPath> EMPTY_LIST = new EmptyList();
    private Map<PathReference, E> references = new HashMap<PathReference, E>();

    public AttributedList() {
        this.attributes = new Attributes();
    }

    public AttributedList(Collection<E> collection) {
        this.attributes = new Attributes();
        this.addAll(collection);
    }

    public static <T extends AbstractPath> AttributedList<T> emptyList() {
        return EMPTY_LIST;
    }

    public Attributes<E> attributes() {
        return this.attributes;
    }

    @Override
    public boolean add(E path) {
        this.references.put(((AbstractPath)path).getReference(), path);
        return super.add(path);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        for (AbstractPath item : c) {
            this.references.put(item.getReference(), item);
        }
        return super.addAll(c);
    }

    public E get(PathReference reference) {
        return (E)((AbstractPath)this.references.get(reference));
    }

    @Override
    public void clear() {
        this.attributes.clear();
        this.references.clear();
        super.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Attributes<E>
    extends HashMap<String, Object> {
        public Attributes() {
            this.put(AttributedList.FILTER, new NullPathFilter());
            this.put(AttributedList.COMPARATOR, new NullComparator());
            this.put(AttributedList.HIDDEN, new HashSet());
            this.put(AttributedList.INVALID, Boolean.FALSE);
            this.put(AttributedList.READABLE, Boolean.TRUE);
        }

        public Attributes(Comparator<E> comparator, PathFilter filter) {
            this.put(AttributedList.COMPARATOR, comparator);
            this.put(AttributedList.FILTER, filter);
            this.put(AttributedList.HIDDEN, new HashSet());
            this.put(AttributedList.INVALID, Boolean.FALSE);
            this.put(AttributedList.READABLE, Boolean.TRUE);
        }

        public void addHidden(E child) {
            ((Set)this.get(AttributedList.HIDDEN)).add(child);
        }

        public Set<E> getHidden() {
            return (Set)this.get(AttributedList.HIDDEN);
        }

        public void setReadable(boolean readable) {
            this.put(AttributedList.READABLE, readable);
        }

        public boolean isReadable() {
            return this.get(AttributedList.READABLE).equals(Boolean.TRUE);
        }

        public void setDirty(boolean dirty) {
            this.put(AttributedList.INVALID, dirty);
            if (dirty) {
                this.put(AttributedList.READABLE, Boolean.TRUE);
            }
        }

        public boolean isDirty() {
            return this.get(AttributedList.INVALID).equals(Boolean.TRUE);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EmptyList
    extends AttributedList<AbstractPath> {
        private EmptyList() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean contains(Object obj) {
            return false;
        }

        @Override
        public AbstractPath get(int index) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }

        private Object readResolve() {
            return EMPTY_LIST;
        }
    }
}

