/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.CollectionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Collection<E>
extends ArrayList<E>
implements CollectionListener<E> {
    private Set<CollectionListener<E>> listeners = Collections.synchronizedSet(new HashSet());

    public Collection() {
    }

    public Collection(java.util.Collection<E> c) {
        super(c);
    }

    @Override
    public int indexOf(Object elem) {
        for (int i = 0; i < this.size(); ++i) {
            if (!this.get(i).equals(elem)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object elem) {
        for (int i = this.size() - 1; i >= 0; --i) {
            if (!this.get(i).equals(elem)) continue;
            return i;
        }
        return -1;
    }

    public void addListener(CollectionListener<E> listener) {
        this.listeners.add(listener);
    }

    public void removeListener(CollectionListener<E> listener) {
        this.listeners.remove(listener);
    }

    @Override
    public boolean addAll(java.util.Collection<? extends E> es) {
        super.addAll(es);
        for (E item : es) {
            this.collectionItemAdded(item);
        }
        return true;
    }

    @Override
    public boolean add(E object) {
        super.add(object);
        this.collectionItemAdded(object);
        return true;
    }

    @Override
    public void add(int row, E object) {
        super.add(row, object);
        this.collectionItemAdded(object);
    }

    @Override
    public E get(int row) {
        return super.get(row);
    }

    @Override
    public Iterator<E> iterator() {
        return super.iterator();
    }

    @Override
    public int size() {
        return super.size();
    }

    @Override
    public boolean contains(Object o) {
        return super.contains(o);
    }

    @Override
    public void clear() {
        for (E o : this) {
            this.collectionItemRemoved(o);
        }
        super.clear();
    }

    @Override
    public E remove(int row) {
        Object previous = super.remove(row);
        this.collectionItemRemoved((E)previous);
        return previous;
    }

    @Override
    public boolean remove(Object item) {
        boolean previous = super.remove(item);
        this.collectionItemRemoved((E)item);
        return previous;
    }

    @Override
    public void collectionItemAdded(E item) {
        for (CollectionListener listener : this.listeners.toArray(new CollectionListener[this.listeners.size()])) {
            listener.collectionItemAdded(item);
        }
    }

    @Override
    public void collectionItemRemoved(E item) {
        for (CollectionListener listener : this.listeners.toArray(new CollectionListener[this.listeners.size()])) {
            listener.collectionItemRemoved(item);
        }
    }

    @Override
    public void collectionItemChanged(E item) {
        for (CollectionListener listener : this.listeners.toArray(new CollectionListener[this.listeners.size()])) {
            listener.collectionItemChanged(item);
        }
    }
}

