/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.AbstractStreamListener;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Collection;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathFactory;
import ch.cyberduck.core.PathFilter;
import ch.cyberduck.core.Permission;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.Transfer;
import ch.cyberduck.core.TransferAction;
import ch.cyberduck.core.io.BandwidthThrottle;
import ch.cyberduck.core.serializer.Serializer;
import ch.cyberduck.ui.growl.Growl;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownloadTransfer
extends Transfer {
    private final PathFilter<Path> childFilter = new PathFilter<Path>(){

        @Override
        public boolean accept(Path child) {
            if (Preferences.instance().getBoolean("queue.download.skip.enable")) {
                try {
                    if (Pattern.compile(Preferences.instance().getProperty("queue.download.skip.regex")).matcher(child.getName()).matches()) {
                        return false;
                    }
                }
                catch (PatternSyntaxException e) {
                    Transfer.log.warn((Object)e.getMessage());
                }
            }
            return true;
        }
    };
    private final Transfer.TransferFilter ACTION_OVERWRITE = new DownloadTransferFilter(){

        public boolean accept(Path p) {
            if (p.attributes.isDirectory()) {
                return !p.getLocal().exists();
            }
            return true;
        }

        public void prepare(Path p) {
            if (p.attributes.isFile()) {
                p.getStatus().setResume(false);
            }
            super.prepare(p);
        }
    };
    private final Transfer.TransferFilter ACTION_RESUME = new DownloadTransferFilter(){

        public boolean accept(Path p) {
            if (p.getStatus().isComplete() || p.getLocal().attributes.getSize() == p.attributes.getSize()) {
                p.getStatus().setComplete(true);
                return false;
            }
            if (p.attributes.isDirectory()) {
                return !p.getLocal().exists();
            }
            return true;
        }

        public void prepare(Path p) {
            if (p.attributes.isFile()) {
                boolean resume = p.getLocal().exists() && p.getLocal().attributes.getSize() > 0L;
                p.getStatus().setResume(resume);
                long skipped = p.getLocal().attributes.getSize();
                p.getStatus().setCurrent(skipped);
            }
            super.prepare(p);
        }
    };
    private final Transfer.TransferFilter ACTION_RENAME = new DownloadTransferFilter(){

        public boolean accept(Path p) {
            return true;
        }

        public void prepare(Path p) {
            if (p.attributes.isFile()) {
                p.getStatus().setResume(false);
            }
            if (p.getLocal().exists() && p.getLocal().attributes.getSize() > 0L) {
                String parent = p.getLocal().getParent().getAbsolute();
                String filename = p.getName();
                int no = 0;
                while (p.getLocal().exists()) {
                    String proposal = FilenameUtils.getBaseName((String)filename) + "-" + ++no;
                    if (StringUtils.isNotBlank((String)FilenameUtils.getExtension((String)filename))) {
                        proposal = proposal + "." + FilenameUtils.getExtension((String)filename);
                    }
                    p.setLocal(LocalFactory.createLocal(parent, proposal));
                }
                Transfer.log.info((Object)("Changed local name to:" + p.getName()));
            }
            super.prepare(p);
        }
    };
    private final DownloadTransferFilter ACTION_SKIP = new DownloadTransferFilter(){

        public boolean accept(Path p) {
            return !p.getLocal().exists();
        }
    };

    public DownloadTransfer(Path root) {
        super(root);
    }

    public DownloadTransfer(List<Path> roots) {
        super(roots);
    }

    public <T> DownloadTransfer(T dict, Session s) {
        super(dict, s);
    }

    @Override
    protected void setRoots(List<Path> downloads) {
        Collection<Path> normalized = new Collection<Path>();
        for (Path download : downloads) {
            boolean duplicate = false;
            Iterator iter = normalized.iterator();
            while (iter.hasNext()) {
                Path n = (Path)iter.next();
                if (download.isChild(n)) {
                    duplicate = true;
                    break;
                }
                if (n.isChild(download)) {
                    iter.remove();
                }
                if (!download.getLocal().getName().equals(n.getLocal().getName())) continue;
                String parent = download.getLocal().getParent().getAbsolute();
                String filename = download.getName();
                int no = 0;
                do {
                    String proposal = FilenameUtils.getBaseName((String)filename) + "-" + ++no;
                    if (StringUtils.isNotBlank((String)FilenameUtils.getExtension((String)filename))) {
                        proposal = proposal + "." + FilenameUtils.getExtension((String)filename);
                    }
                    download.setLocal(LocalFactory.createLocal(parent, proposal));
                } while (download.getLocal().exists());
                log.info((Object)("Changed local name to:" + download.getName()));
            }
            if (duplicate) continue;
            normalized.add(download);
        }
        super.setRoots(normalized);
    }

    @Override
    public <T> T getAsDictionary() {
        Serializer dict = super.getSerializer();
        dict.setStringForKey(String.valueOf(0), "Kind");
        return dict.getSerialized();
    }

    @Override
    protected void init() {
        log.debug((Object)"init");
        this.bandwidth = new BandwidthThrottle(Preferences.instance().getFloat("queue.download.bandwidth.bytes"));
    }

    @Override
    public AttributedList<Path> childs(Path parent) {
        AttributedList<Path> list = parent.childs(this.childFilter);
        for (Path download : list) {
            download.setLocal(LocalFactory.createLocal(parent.getLocal(), download.getName()));
            download.getStatus().setSkipped(parent.getStatus().isSkipped());
        }
        return list;
    }

    @Override
    public Transfer.TransferFilter filter(TransferAction action) {
        log.debug((Object)("filter:" + action));
        if (action.equals(TransferAction.ACTION_OVERWRITE)) {
            return this.ACTION_OVERWRITE;
        }
        if (action.equals(TransferAction.ACTION_RESUME)) {
            return this.ACTION_RESUME;
        }
        if (action.equals(TransferAction.ACTION_RENAME)) {
            return this.ACTION_RENAME;
        }
        if (action.equals(TransferAction.ACTION_SKIP)) {
            return this.ACTION_SKIP;
        }
        if (action.equals(TransferAction.ACTION_CALLBACK)) {
            for (Path root : this.getRoots()) {
                if (!root.getLocal().exists() || root.getLocal().attributes.isDirectory() && 0 == root.getLocal().childs().size() || root.getLocal().attributes.isFile() && root.getLocal().attributes.getSize() == 0L) continue;
                TransferAction result = this.prompt.prompt();
                return this.filter(result);
            }
            return this.filter(TransferAction.ACTION_OVERWRITE);
        }
        return super.filter(action);
    }

    @Override
    public TransferAction action(boolean resumeRequested, boolean reloadRequested) {
        log.debug((Object)("action:" + resumeRequested + "," + reloadRequested));
        if (resumeRequested) {
            return TransferAction.ACTION_RESUME;
        }
        if (reloadRequested) {
            return TransferAction.forName(Preferences.instance().getProperty("queue.download.reload.fileExists"));
        }
        return TransferAction.forName(Preferences.instance().getProperty("queue.download.fileExists"));
    }

    @Override
    protected void _transferImpl(Path p) {
        p.download(this.bandwidth, new AbstractStreamListener(){

            public void bytesReceived(long bytes) {
                DownloadTransfer.this.transferred += (double)bytes;
            }
        });
        if (Preferences.instance().getBoolean("queue.download.changePermissions")) {
            log.info((Object)"Updating permissions");
            Permission perm = Preferences.instance().getBoolean("queue.download.permissions.useDefault") && p.attributes.isFile() ? new Permission(Preferences.instance().getInteger("queue.download.permissions.file.default")) : p.attributes.getPermission();
            if (null != perm) {
                if (p.attributes.isDirectory()) {
                    perm.getOwnerPermissions()[1] = true;
                    perm.getOwnerPermissions()[2] = true;
                }
                p.getLocal().writePermissions(perm, false);
            }
        }
        if (Preferences.instance().getBoolean("queue.download.preserveDate")) {
            log.info((Object)"Updating timestamp");
            if (-1L == p.attributes.getModificationDate()) {
                p.readTimestamp();
            }
            if (p.attributes.getModificationDate() != -1L) {
                long timestamp = p.attributes.getModificationDate();
                p.getLocal().writeModificationDate(timestamp);
            }
        }
    }

    @Override
    protected void fireTransferDidEnd() {
        if (this.isReset() && this.isComplete() && !this.isCanceled() && this.getTransferred() != 0.0) {
            Growl.instance().notify("Download complete", this.getName());
            if (this.shouldOpenWhenComplete()) {
                this.getRoot().getLocal().open();
            }
            this.getRoot().getLocal().bounce();
        }
        super.fireTransferDidEnd();
    }

    protected boolean shouldOpenWhenComplete() {
        return Preferences.instance().getBoolean("queue.postProcessItemWhenComplete");
    }

    private abstract class DownloadTransferFilter
    extends Transfer.TransferFilter {
        private DownloadTransferFilter() {
        }

        public void prepare(Path p) {
            if (p.attributes.getSize() == -1L) {
                p.readSize();
            }
            if (p.attributes.getModificationDate() == -1L && Preferences.instance().getBoolean("queue.download.preserveDate")) {
                p.readTimestamp();
            }
            if (p.attributes.getPermission() == null && Preferences.instance().getBoolean("queue.download.changePermissions")) {
                p.readPermission();
            }
            if (p.attributes.isFile()) {
                if (p.attributes.isSymbolicLink()) {
                    if (null != p.getSymbolicLinkPath()) {
                        Path symlink = PathFactory.createPath(p.getSession(), p.getSymbolicLinkPath(), 1);
                        if (symlink.attributes.getSize() == -1L) {
                            symlink.readSize();
                        }
                        DownloadTransfer.this.size += (double)symlink.attributes.getSize();
                    }
                } else {
                    DownloadTransfer.this.size += (double)p.attributes.getSize();
                }
                if (p.getStatus().isResume()) {
                    DownloadTransfer.this.transferred += (double)p.getLocal().attributes.getSize();
                }
            }
            if (!p.getLocal().getParent().exists()) {
                p.getLocal().getParent().mkdir(true);
            }
        }
    }
}

