/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Attributes;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathReference;
import ch.cyberduck.core.Permission;
import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.core.io.FileWatcher;
import ch.cyberduck.core.io.FileWatcherListener;
import ch.cyberduck.core.io.RepeatableFileInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Local
extends AbstractPath
implements Attributes {
    private static Logger log = Logger.getLogger(Local.class);
    protected File _impl;
    private Cache<Local> cache;

    @Override
    public Permission getPermission() {
        return null;
    }

    @Override
    public void setPermission(Permission p) {
    }

    @Override
    public boolean isVolume() {
        return null == this._impl.getParent();
    }

    @Override
    public boolean isDirectory() {
        return this._impl.isDirectory();
    }

    @Override
    public boolean isFile() {
        return this._impl.isFile();
    }

    @Override
    public boolean isSymbolicLink() {
        if (!this.exists()) {
            return false;
        }
        try {
            return !this._impl.getAbsolutePath().equals(this._impl.getCanonicalPath());
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public void setType(int i) {
    }

    @Override
    public void setSize(long size) {
    }

    @Override
    public void setOwner(String owner) {
    }

    @Override
    public void setGroup(String group) {
    }

    @Override
    public String getOwner() {
        return null;
    }

    @Override
    public String getGroup() {
        return null;
    }

    @Override
    public long getModificationDate() {
        return this._impl.lastModified();
    }

    @Override
    public void setModificationDate(long millis) {
    }

    @Override
    public long getCreationDate() {
        return this.getModificationDate();
    }

    @Override
    public void setCreationDate(long millis) {
    }

    @Override
    public long getAccessedDate() {
        return this.getModificationDate();
    }

    @Override
    public void setAccessedDate(long millis) {
    }

    @Override
    public int getType() {
        int t;
        int n = t = this.isFile() ? 1 : 2;
        if (this.isSymbolicLink()) {
            return t | 4;
        }
        return t;
    }

    @Override
    public long getSize() {
        if (this.isDirectory()) {
            return -1L;
        }
        return this._impl.length();
    }

    public Local(Local parent, String name) {
        this(parent.getAbsolute(), name);
    }

    public Local(String parent, String name) {
        if (!"/".equals(name)) {
            name = name.replace('/', ':');
        }
        this.setPath(parent, name);
    }

    public Local(String path) {
        this.setPath(path);
    }

    public Local(File path) {
        this.setPath(path.getAbsolutePath());
    }

    protected void init() {
        this.attributes = this;
    }

    public void watch(FileWatcherListener listener) throws IOException {
        FileWatcher.instance().watch(this, listener);
    }

    @Override
    public boolean isReadable() {
        return this._impl.canRead();
    }

    @Override
    public boolean isWritable() {
        return this._impl.canWrite();
    }

    public boolean touch() {
        if (!this.exists()) {
            try {
                if (this._impl.createNewFile()) {
                    this.setIcon(0);
                }
            }
            catch (IOException e) {
                log.error((Object)e.getMessage());
            }
        }
        return false;
    }

    public abstract void setIcon(int var1);

    @Override
    public void delete() {
        this.delete(true);
    }

    public void delete(boolean trash) {
        if (trash) {
            this.trash();
        } else if (!this._impl.delete()) {
            log.warn((Object)("Delete failed:" + this.getAbsolute()));
        }
    }

    public abstract void trash();

    @Override
    public boolean isCached() {
        return false;
    }

    public Cache<Local> cache() {
        if (null == this.cache) {
            this.cache = new Cache();
        }
        return this.cache;
    }

    public AttributedList<Local> list() {
        AttributedList<Local> childs = new AttributedList<Local>();
        File[] files = this._impl.listFiles();
        if (null == files) {
            log.error((Object)"_impl.listFiles == null");
            return childs;
        }
        for (File file : files) {
            childs.add(LocalFactory.createLocal(file));
        }
        return childs;
    }

    public String kind() {
        if (this.attributes.isDirectory()) {
            return Locale.localizedString("Folder");
        }
        String extension = this.getExtension();
        if (StringUtils.isEmpty((String)extension)) {
            return Locale.localizedString("Unknown");
        }
        String kind = this.kind(this.getExtension());
        if (StringUtils.isEmpty((String)kind)) {
            return Locale.localizedString("Unknown");
        }
        return kind;
    }

    protected String kind(String extension) {
        return null;
    }

    @Override
    public String getAbsolute() {
        return this._impl.getAbsolutePath();
    }

    public String getAbbreviatedPath() {
        return this.getAbsolute();
    }

    @Override
    public <T> PathReference<T> getReference() {
        return null;
    }

    @Override
    public String getSymbolicLinkPath() {
        try {
            return this._impl.getCanonicalPath();
        }
        catch (IOException e) {
            log.error((Object)e.getMessage());
            return this.getAbsolute();
        }
    }

    @Override
    public String getName() {
        return this._impl.getName();
    }

    @Override
    public Local getParent() {
        return LocalFactory.createLocal(this._impl.getParentFile());
    }

    @Override
    public boolean exists() {
        return this._impl.exists();
    }

    @Override
    public void setPath(String name) {
        this._impl = new File(Path.normalize(name));
        this.init();
    }

    @Override
    public void mkdir(boolean recursive) {
        if (recursive) {
            if (this._impl.mkdirs()) {
                log.info((Object)("Created directory " + this.getAbsolute()));
            }
        } else if (this._impl.mkdir()) {
            log.warn((Object)("Created directory " + this.getAbsolute()));
        }
    }

    @Override
    public void rename(AbstractPath renamed) {
        if (this._impl.renameTo(new File(this.getParent().getAbsolute(), renamed.getAbsolute()))) {
            this.setPath(this.getParent().getAbsolute(), renamed.getAbsolute());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void copy(AbstractPath copy) {
        if (copy.equals(this)) {
            return;
        }
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            try {
                in = new FileInputStream(this._impl);
                out = new FileOutputStream(copy.getAbsolute());
                IOUtils.copy((java.io.InputStream)in, (java.io.OutputStream)out);
            }
            catch (IOException e) {
                log.error((Object)e.getMessage());
                Object var6_5 = null;
                IOUtils.closeQuietly((java.io.InputStream)in);
                IOUtils.closeQuietly((java.io.OutputStream)out);
                return;
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            IOUtils.closeQuietly((java.io.InputStream)in);
            IOUtils.closeQuietly(out);
            throw throwable;
        }
        IOUtils.closeQuietly((java.io.InputStream)in);
        IOUtils.closeQuietly((java.io.OutputStream)out);
    }

    public int hashCode() {
        return this._impl.getAbsolutePath().hashCode();
    }

    public boolean equals(Object other) {
        if (null == other) {
            return false;
        }
        if (other instanceof Local) {
            return this.getAbsolute().equalsIgnoreCase(((Local)other).getAbsolute());
        }
        return false;
    }

    public String toString() {
        return this.getAbsolute();
    }

    @Override
    public String toURL() {
        try {
            return this._impl.toURI().toURL().toString();
        }
        catch (MalformedURLException e) {
            log.error((Object)e.getMessage());
            return null;
        }
    }

    public abstract void open();

    public abstract void bounce();

    public String getDefaultEditor() {
        String extension = this.getExtension();
        if (StringUtils.isEmpty((String)extension)) {
            return null;
        }
        return this.applicationForExtension(extension);
    }

    protected abstract String applicationForExtension(String var1);

    public abstract void setQuarantine(String var1, String var2);

    public abstract void setWhereFrom(String var1);

    public static class InputStream
    extends RepeatableFileInputStream {
        public InputStream(Local local) throws FileNotFoundException {
            super(local._impl);
        }
    }

    public static class OutputStream
    extends FileOutputStream {
        public OutputStream(Local local, boolean resume) throws FileNotFoundException {
            super(local._impl, resume);
        }
    }
}

