/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import java.text.Collator;
import java.util.Comparator;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NaturalOrderComparator
implements Comparator<String> {
    private Collator collator = Collator.getInstance(Locale.getDefault());

    private boolean isDigit(char ch) {
        return ch >= '0' && ch <= '9';
    }

    private String getChunk(String s, int slength, int marker) {
        StringBuffer chunk = new StringBuffer();
        char c = s.charAt(marker);
        chunk.append(c);
        ++marker;
        if (this.isDigit(c)) {
            while (marker < slength && this.isDigit(c = s.charAt(marker))) {
                chunk.append(c);
                ++marker;
            }
        } else {
            while (marker < slength && !this.isDigit(c = s.charAt(marker))) {
                chunk.append(c);
                ++marker;
            }
        }
        return chunk.toString();
    }

    @Override
    public int compare(String s1, String s2) {
        int thisMarker = 0;
        int thatMarker = 0;
        int s1Length = s1.length();
        int s2Length = s2.length();
        while (thisMarker < s1Length && thatMarker < s2Length) {
            String thisChunk = this.getChunk(s1, s1Length, thisMarker);
            thisMarker += thisChunk.length();
            String thatChunk = this.getChunk(s2, s2Length, thatMarker);
            thatMarker += thatChunk.length();
            int result = 0;
            if (this.isDigit(thisChunk.charAt(0)) && this.isDigit(thatChunk.charAt(0))) {
                int thisChunkLength = thisChunk.length();
                result = thisChunkLength - thatChunk.length();
                if (result == 0) {
                    for (int i = 0; i < thisChunkLength; ++i) {
                        result = thisChunk.charAt(i) - thatChunk.charAt(i);
                        if (result == 0) continue;
                        return result;
                    }
                }
            } else {
                result = this.collator.compare(thisChunk, thatChunk);
            }
            if (result == 0) continue;
            return result;
        }
        return s1Length - s2Length;
    }
}

