/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.i18n.Locale;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jets3t.service.Constants;

public abstract class Protocol {
    private static Logger log = Logger.getLogger(Protocol.class);
    public static final Protocol SFTP = new Protocol(){

        public String getDescription() {
            return Locale.localizedString("SFTP (SSH File Transfer Protocol)");
        }

        public int getDefaultPort() {
            return 22;
        }

        public String getScheme() {
            return "sftp";
        }

        public boolean isSecure() {
            return true;
        }
    };
    public static final Protocol SCP = new Protocol(){

        public String getDescription() {
            return Locale.localizedString("SCP (Secure Copy)");
        }

        public int getDefaultPort() {
            return 22;
        }

        public String getScheme() {
            return "scp";
        }

        public boolean isSecure() {
            return true;
        }
    };
    public static final Protocol FTP = new Protocol(){

        public String getDescription() {
            return Locale.localizedString("FTP (File Transfer Protocol)");
        }

        public int getDefaultPort() {
            return 21;
        }

        public String getScheme() {
            return "ftp";
        }
    };
    public static final Protocol FTP_TLS = new Protocol(){

        public String getName() {
            return "FTP-SSL";
        }

        public String getDescription() {
            return Locale.localizedString("FTP-SSL (Explicit AUTH TLS)");
        }

        public int getDefaultPort() {
            return 21;
        }

        public String getScheme() {
            return "ftps";
        }

        public boolean isSecure() {
            return true;
        }

        public String disk() {
            return SFTP.disk();
        }

        public String icon() {
            return SFTP.icon();
        }
    };
    public static final Protocol S3 = new Protocol(){

        public String getName() {
            return "S3";
        }

        public String getDescription() {
            return Locale.localizedString("S3 (Amazon Simple Storage Service)", "S3");
        }

        public String getIdentifier() {
            return "s3";
        }

        public int getDefaultPort() {
            return 443;
        }

        public String getScheme() {
            return "https";
        }

        public String[] getSchemes() {
            return new String[]{this.getScheme(), "s3"};
        }

        public boolean isSecure() {
            return true;
        }

        public boolean isHostnameConfigurable() {
            return false;
        }

        public String getDefaultHostname() {
            return Constants.S3_HOSTNAME;
        }

        public boolean isWebUrlConfigurable() {
            return false;
        }
    };
    public static final Protocol EUCALYPTUS = new Protocol(){

        public String getName() {
            return "Walrus";
        }

        public String getDescription() {
            return Locale.localizedString("Eucalyptus Walrus", "S3");
        }

        public String getIdentifier() {
            return "ec";
        }

        public int getDefaultPort() {
            return 8773;
        }

        public String getScheme() {
            return "http";
        }

        public String[] getSchemes() {
            return new String[]{this.getScheme(), "walrus"};
        }

        public boolean isSecure() {
            return false;
        }

        public boolean isHostnameConfigurable() {
            return true;
        }

        public String getDefaultHostname() {
            return "mayhem9.cs.ucsb.edu";
        }

        public boolean isWebUrlConfigurable() {
            return false;
        }

        public String disk() {
            return S3.disk();
        }

        public String icon() {
            return "eucalyptus-icon.png";
        }
    };
    public static final Protocol WEBDAV = new Protocol(){

        public String getName() {
            return "WebDAV (HTTP)";
        }

        public String getDescription() {
            return Locale.localizedString("WebDAV (Web-based Distributed Authoring and Versioning)");
        }

        public String getIdentifier() {
            return "dav";
        }

        public int getDefaultPort() {
            return 80;
        }

        public String getScheme() {
            return "http";
        }

        public String[] getSchemes() {
            return new String[]{this.getScheme(), "dav"};
        }
    };
    public static final Protocol WEBDAV_SSL = new Protocol(){

        public String getName() {
            return "WebDAV (HTTPS)";
        }

        public String getDescription() {
            return Locale.localizedString("WebDAV (HTTP/SSL)");
        }

        public String getIdentifier() {
            return "davs";
        }

        public int getDefaultPort() {
            return 443;
        }

        public String getScheme() {
            return "https";
        }

        public boolean isSecure() {
            return true;
        }

        public String[] getSchemes() {
            return new String[]{this.getScheme(), "davs"};
        }

        public String disk() {
            return WEBDAV.disk();
        }

        public String icon() {
            return WEBDAV.icon();
        }
    };
    public static final Protocol IDISK = new Protocol(){

        public String getName() {
            return "MobileMe";
        }

        public String getDescription() {
            return Locale.localizedString("MobileMe iDisk (WebDAV)");
        }

        public String getIdentifier() {
            return "me";
        }

        public int getDefaultPort() {
            return 443;
        }

        public String getScheme() {
            return "https";
        }

        public boolean isSecure() {
            return true;
        }

        public String[] getSchemes() {
            return new String[]{this.getScheme(), "idisk"};
        }

        public boolean isHostnameConfigurable() {
            return false;
        }

        public String getDefaultHostname() {
            return "idisk.me.com";
        }

        public boolean isWebUrlConfigurable() {
            return false;
        }
    };
    public static final Protocol MOSSO = new Protocol(){

        public String getName() {
            return "Cloud Files";
        }

        public String getDescription() {
            return "Mosso Cloud Files";
        }

        public String getIdentifier() {
            return "cf";
        }

        public int getDefaultPort() {
            return 443;
        }

        public String getScheme() {
            return "https";
        }

        public String[] getSchemes() {
            return new String[]{this.getScheme(), "mosso", "cloudfiles", "cf"};
        }

        public boolean isSecure() {
            return true;
        }

        public boolean isHostnameConfigurable() {
            return false;
        }

        public String getDefaultHostname() {
            return "storage.clouddrive.com";
        }

        public boolean isWebUrlConfigurable() {
            return false;
        }
    };

    public String getIdentifier() {
        return this.getScheme();
    }

    public String getName() {
        return this.getScheme().toUpperCase();
    }

    public abstract String getDescription();

    public abstract String getScheme();

    public String[] getSchemes() {
        return new String[]{this.getScheme()};
    }

    public boolean equals(Object other) {
        if (other instanceof Protocol) {
            return ((Protocol)other).getIdentifier().equals(this.getIdentifier());
        }
        return false;
    }

    public String toString() {
        return this.getIdentifier();
    }

    public String disk() {
        return this.getIdentifier() + ".icns";
    }

    public String icon() {
        return this.getIdentifier() + "-icon.png";
    }

    public boolean isSecure() {
        return false;
    }

    public boolean isHostnameConfigurable() {
        return true;
    }

    public boolean isWebUrlConfigurable() {
        return true;
    }

    public String getDefaultHostname() {
        return Preferences.instance().getProperty("connection.hostname.default");
    }

    public abstract int getDefaultPort();

    public static Protocol getDefaultProtocol(int port) {
        Protocol[] protocols;
        for (Protocol protocol : protocols = Protocol.getKnownProtocols()) {
            if (protocol.getDefaultPort() != port) continue;
            return protocol;
        }
        log.warn((Object)("Cannot find default protocol for port:" + port));
        return Protocol.forName(Preferences.instance().getProperty("connection.protocol.default"));
    }

    public static String[] getProtocolDescriptions() {
        Protocol[] protocols = Protocol.getKnownProtocols();
        String[] descriptions = new String[protocols.length];
        for (int i = 0; i < protocols.length; ++i) {
            descriptions[i] = protocols[i].getDescription();
        }
        return descriptions;
    }

    public static Protocol forName(String identifier) {
        Protocol[] protocols;
        for (Protocol protocol : protocols = Protocol.getKnownProtocols()) {
            if (!protocol.getIdentifier().equals(identifier)) continue;
            return protocol;
        }
        log.fatal((Object)("Unknown protocol:" + identifier));
        return Protocol.forScheme(identifier);
    }

    public static Protocol forScheme(String scheme) {
        Protocol[] protocols;
        for (Protocol protocol : protocols = Protocol.getKnownProtocols()) {
            for (int k = 0; k < protocol.getSchemes().length; ++k) {
                if (!protocol.getSchemes()[k].equals(scheme)) continue;
                return protocol;
            }
        }
        log.fatal((Object)("Unknown scheme:" + scheme));
        return Protocol.forName(Preferences.instance().getProperty("connection.protocol.default"));
    }

    public static Protocol[] getKnownProtocols() {
        return new Protocol[]{FTP, FTP_TLS, SFTP, WEBDAV, WEBDAV_SSL, IDISK, S3, MOSSO, EUCALYPTUS};
    }

    public static boolean isURL(String str) {
        if (StringUtils.isNotBlank((String)str)) {
            Protocol[] protocols;
            for (Protocol protocol : protocols = Protocol.getKnownProtocols()) {
                String[] schemes;
                for (String scheme : schemes = protocol.getSchemes()) {
                    if (!str.startsWith(scheme + "://")) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

