/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.Native;
import java.util.Properties;
import org.apache.log4j.Logger;

public class Proxy {
    private static Logger log = Logger.getLogger(Proxy.class);
    private static final String SOCKS_PORT = "socksProxyPort";
    private static final String SOCKS_HOST = "socksProxyHost";

    public static void configure(String hostname) {
        if (Proxy.isSOCKSProxyEnabled() && !Proxy.isHostExcluded(hostname)) {
            log.info((Object)"Using SOCKS Proxy");
            Proxy.initSOCKS(Proxy.getSOCKSProxyPort(), Proxy.getSOCKSProxyHost());
        } else {
            Proxy.clearSOCKS();
        }
    }

    private static void initSOCKS(int port, String host) {
        Properties props = System.getProperties();
        props.put(SOCKS_PORT, Integer.toString(port));
        props.put(SOCKS_HOST, host);
        System.setProperties(props);
    }

    private static void clearSOCKS() {
        Properties prop = System.getProperties();
        prop.remove(SOCKS_HOST);
        prop.remove(SOCKS_PORT);
        System.setProperties(prop);
    }

    public static native boolean usePassiveFTP();

    public static native boolean isHostExcluded(String var0);

    public static native boolean isSOCKSProxyEnabled();

    public static native String getSOCKSProxyHost();

    public static native int getSOCKSProxyPort();

    public static native boolean isHTTPProxyEnabled();

    public static native String getHTTPProxyHost();

    public static native int getHTTPProxyPort();

    public static native boolean isHTTPSProxyEnabled();

    public static native String getHTTPSProxyHost();

    public static native int getHTTPSProxyPort();

    static {
        Native.load("Proxy");
    }
}

