/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.BookmarkCollection;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.Rendezvous;
import ch.cyberduck.core.RendezvousListener;

public class RendezvousCollection
extends BookmarkCollection {
    private static RendezvousCollection RENDEZVOUS_COLLECTION = new RendezvousCollection();

    private RendezvousCollection() {
        Rendezvous.instance().addListener(new RendezvousListener(){

            public void serviceResolved(String servicename, String hostname) {
                RendezvousCollection.this.collectionItemAdded(null);
            }

            public void serviceLost(String servicename) {
                RendezvousCollection.this.collectionItemRemoved(null);
            }
        });
    }

    public static RendezvousCollection defaultCollection() {
        return RENDEZVOUS_COLLECTION;
    }

    public Host get(int row) {
        return Rendezvous.instance().getService(row);
    }

    public int size() {
        return Rendezvous.instance().numberOfServices();
    }

    public Host remove(int row) {
        return null;
    }

    public Object[] toArray() {
        Object[] content = new Host[this.size()];
        int i = 0;
        for (Host host : this) {
            content[i] = host;
        }
        return content;
    }

    public boolean allowsAdd() {
        return false;
    }

    public boolean allowsDelete() {
        return false;
    }

    public boolean allowsEdit() {
        return false;
    }

    public void save() {
    }

    public void load() {
    }
}

