/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.ResolveCanceledException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.log4j.Logger;

public class Resolver
implements Runnable {
    private static Logger log = Logger.getLogger(Resolver.class);
    private final Object signal = new Object();
    private String hostname;
    private InetAddress resolved;
    private UnknownHostException exception;

    public boolean isResolved() {
        return this.resolved != null;
    }

    public boolean hasFailed() {
        return this.exception != null;
    }

    public Resolver(String hostname) {
        this.hostname = hostname;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InetAddress resolve() throws UnknownHostException, ResolveCanceledException {
        if (this.isResolved()) {
            return this.resolved;
        }
        this.resolved = null;
        this.exception = null;
        Thread t = new Thread((Runnable)this, this.toString());
        t.start();
        Object object = this.signal;
        synchronized (object) {
            if (!this.isResolved() && !this.hasFailed()) {
                try {
                    log.debug((Object)("Waiting for resolving of " + this.hostname));
                    this.signal.wait();
                }
                catch (InterruptedException e) {
                    log.error((Object)e.getMessage());
                }
            }
        }
        if (!this.isResolved()) {
            if (this.hasFailed()) {
                throw this.exception;
            }
            log.warn((Object)("Canceled resolving " + this.hostname));
            throw new ResolveCanceledException();
        }
        return this.resolved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        Object object = this.signal;
        synchronized (object) {
            this.signal.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.resolved = InetAddress.getByName(this.hostname);
            log.info((Object)("Resolved " + this.hostname + " to " + this.resolved.getHostAddress()));
        }
        catch (UnknownHostException e) {
            log.warn((Object)("Failed resolving " + this.hostname));
            this.exception = e;
        }
        finally {
            Object object = this.signal;
            synchronized (object) {
                this.signal.notify();
            }
        }
    }

    public String toString() {
        return "Resolver for " + this.hostname;
    }

    static {
        if (Preferences.instance().getBoolean("connection.dns.ipv6")) {
            System.setProperty("java.net.preferIPv6Addresses", String.valueOf(true));
        }
    }
}

