/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.Archive;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.ConnectionCanceledException;
import ch.cyberduck.core.ConnectionListener;
import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.ErrorListener;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.LoginCanceledException;
import ch.cyberduck.core.LoginController;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathFactory;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.Proxy;
import ch.cyberduck.core.ResolveCanceledException;
import ch.cyberduck.core.Resolver;
import ch.cyberduck.core.TranscriptListener;
import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.core.threading.BackgroundException;
import java.io.IOException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.net.ssl.SSLHandshakeException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import sun.security.validator.ValidatorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Session {
    private static Logger log = Logger.getLogger(Session.class);
    protected Host host;
    protected Path workdir;
    private final String ua = Preferences.instance().getProperty("application") + "/" + Preferences.instance().getProperty("version");
    private Resolver resolver;
    protected LoginController login;
    private Set<ConnectionListener> connectionListeners = Collections.synchronizedSet(new HashSet());
    private Set<TranscriptListener> transcriptListeners = Collections.synchronizedSet(new HashSet());
    private Set<ProgressListener> progressListeners = Collections.synchronizedSet(new HashSet());
    private Set<ErrorListener> errorListeners = Collections.synchronizedSet(new HashSet());
    private Cache<Path> cache;

    protected Session(Host h) {
        this.host = h;
    }

    public String getIdentification() {
        try {
            return this.host.getIp();
        }
        catch (UnknownHostException e) {
            return this.host.getHostname();
        }
    }

    public String getUserAgent() {
        return this.ua;
    }

    public void check() throws IOException {
        try {
            try {
                if (!this.isConnected()) {
                    this.connect();
                } else {
                    try {
                        this.noop();
                    }
                    catch (IOException e) {
                        this.interrupt();
                        this.connect();
                    }
                }
            }
            catch (SocketException e) {
                if (e.getMessage().equals("Software caused connection abort")) {
                    log.warn((Object)("Supressed socket exception:" + e.getMessage()));
                    throw new ConnectionCanceledException();
                }
                if (e.getMessage().equals("Socket closed")) {
                    log.warn((Object)("Supressed socket exception:" + e.getMessage()));
                    throw new ConnectionCanceledException();
                }
                throw e;
            }
            catch (SSLHandshakeException e) {
                log.error((Object)("SSL Handshake failed: " + e.getMessage()));
                if (e.getCause() instanceof ValidatorException) {
                    throw e;
                }
                throw new ConnectionCanceledException(e.getMessage());
            }
        }
        catch (IOException e) {
            this.interrupt();
            this.error(null, "Connection failed", e);
            throw e;
        }
    }

    protected int timeout() {
        return (int)Preferences.instance().getDouble("connection.timeout.seconds") * 1000;
    }

    public boolean isSecure() {
        if (this.isConnected()) {
            return this.host.getProtocol().isSecure();
        }
        return false;
    }

    protected abstract void connect() throws IOException, ConnectionCanceledException, LoginCanceledException;

    public void setLoginController(LoginController loginController) {
        this.login = loginController;
    }

    protected void login() throws IOException {
        this.login.check(this.host);
        Credentials credentials = this.host.getCredentials();
        this.message(MessageFormat.format(Locale.localizedString("Authenticating as {0}", "Status"), credentials.getUsername()));
        this.login(credentials);
        if (!this.isConnected()) {
            throw new ConnectionCanceledException();
        }
        this.login.success(this.host);
    }

    protected abstract void login(Credentials var1) throws IOException;

    public Path mount() {
        try {
            if (StringUtils.isNotBlank((String)this.host.getDefaultPath())) {
                return this.mount(this.host.getDefaultPath());
            }
            return this.mount(null);
        }
        catch (IOException e) {
            this.interrupt();
            return null;
        }
    }

    protected Path mount(String directory) throws IOException {
        Path home;
        this.message(MessageFormat.format(Locale.localizedString("Mounting {0}", "Status"), this.host.getHostname()));
        this.check();
        if (!this.isConnected()) {
            return null;
        }
        if (directory != null) {
            home = directory.startsWith("/") || directory.equals(this.workdir().getName()) ? PathFactory.createPath(this, directory, directory.equals("/") ? 10 : 2) : (directory.startsWith("~") ? PathFactory.createPath(this, this.workdir().getAbsolute(), directory.substring(1), 2) : PathFactory.createPath(this, this.workdir().getAbsolute(), directory, 2));
            if (!home.childs().attributes().isReadable()) {
                home = this.workdir();
            }
        } else {
            home = this.workdir();
        }
        return home;
    }

    public abstract void close();

    public Host getHost() {
        return this.host;
    }

    public String getEncoding() {
        if (null == this.host.getEncoding()) {
            return Preferences.instance().getProperty("browser.charset.encoding");
        }
        return this.host.getEncoding();
    }

    public int getMaxConnections() {
        if (null == this.host.getMaxConnections()) {
            return Preferences.instance().getInteger("connection.host.max");
        }
        return this.host.getMaxConnections();
    }

    public abstract Path workdir() throws IOException;

    protected abstract void noop() throws IOException;

    public void interrupt() {
        if (null == this.resolver) {
            return;
        }
        this.resolver.cancel();
    }

    public boolean isSendCommandSupported() {
        return false;
    }

    public abstract void sendCommand(String var1) throws IOException;

    public boolean isArchiveSupported() {
        return false;
    }

    public void archive(Archive archive, List<Path> files) {
        try {
            this.check();
            this.sendCommand(archive.getCompressCommand(files));
            for (Path file : files) {
                file.getParent().invalidate();
            }
        }
        catch (IOException e) {
            this.error(null, "Cannot create archive", e);
        }
    }

    public boolean isUnarchiveSupported() {
        return false;
    }

    public void unarchive(Archive archive, Path file) {
        try {
            this.check();
            this.sendCommand(archive.getDecompressCommand(file));
            file.getParent().invalidate();
        }
        catch (IOException e) {
            this.error(null, "Cannot expand archive", e);
        }
    }

    public abstract boolean isConnected();

    public boolean isOpening() {
        return this.resolver != null;
    }

    public void addConnectionListener(ConnectionListener listener) {
        this.connectionListeners.add(listener);
    }

    public void removeConnectionListener(ConnectionListener listener) {
        this.connectionListeners.remove(listener);
    }

    protected void fireConnectionWillOpenEvent() throws ResolveCanceledException, UnknownHostException {
        ConnectionListener[] l;
        log.debug((Object)"connectionWillOpen");
        for (ConnectionListener listener : l = this.connectionListeners.toArray(new ConnectionListener[this.connectionListeners.size()])) {
            listener.connectionWillOpen();
        }
        Proxy.configure(this.host.getHostname());
        this.resolver = new Resolver(this.host.getHostname(true));
        this.message(MessageFormat.format(Locale.localizedString("Resolving {0}", "Status"), this.host.getHostname()));
        this.resolver.resolve();
    }

    protected void fireConnectionDidOpenEvent() {
        log.debug((Object)"connectionDidOpen");
        this.resolver = null;
        for (ConnectionListener listener : this.connectionListeners.toArray(new ConnectionListener[this.connectionListeners.size()])) {
            listener.connectionDidOpen();
        }
    }

    protected void fireConnectionWillCloseEvent() {
        log.debug((Object)"connectionWillClose");
        this.message(MessageFormat.format(Locale.localizedString("Disconnecting {0}", "Status"), this.getHost().getHostname()));
        for (ConnectionListener listener : this.connectionListeners.toArray(new ConnectionListener[this.connectionListeners.size()])) {
            listener.connectionWillClose();
        }
    }

    protected void fireConnectionDidCloseEvent() {
        log.debug((Object)"connectionDidClose");
        this.resolver = null;
        this.workdir = null;
        for (ConnectionListener listener : this.connectionListeners.toArray(new ConnectionListener[this.connectionListeners.size()])) {
            listener.connectionDidClose();
        }
    }

    public void addTranscriptListener(TranscriptListener listener) {
        this.transcriptListeners.add(listener);
    }

    public void removeTranscriptListener(TranscriptListener listener) {
        this.transcriptListeners.remove(listener);
    }

    public void log(boolean request, String message) {
        log.info((Object)message);
        for (TranscriptListener listener : this.transcriptListeners) {
            listener.log(request, message);
        }
    }

    public void addProgressListener(ProgressListener listener) {
        this.progressListeners.add(listener);
    }

    public void removeProgressListener(ProgressListener listener) {
        this.progressListeners.remove(listener);
    }

    public void message(String message) {
        log.info((Object)message);
        for (ProgressListener listener : this.progressListeners.toArray(new ProgressListener[this.progressListeners.size()])) {
            listener.message(message);
        }
    }

    public void addErrorListener(ErrorListener listener) {
        this.errorListeners.add(listener);
    }

    public void removeErrorListener(ErrorListener listener) {
        this.errorListeners.remove(listener);
    }

    public void error(Path path, String message, Throwable e) {
        BackgroundException failure = new BackgroundException(this, path, message, e);
        this.message(failure.getMessage());
        for (ErrorListener listener : this.errorListeners.toArray(new ErrorListener[this.errorListeners.size()])) {
            listener.error(failure);
        }
    }

    public Cache<Path> cache() {
        if (null == this.cache) {
            this.cache = new Cache<Path>(){

                public String toString() {
                    return "Cache for " + Session.this.toString();
                }
            };
        }
        return this.cache;
    }

    public boolean equals(Object other) {
        if (null == other) {
            return false;
        }
        if (other instanceof Session) {
            return this.getHost().getHostname().equals(((Session)other).getHost().getHostname()) && this.getHost().getProtocol().equals(((Session)other).getHost().getProtocol());
        }
        return false;
    }

    public String toString() {
        return "Session " + this.host.toURL();
    }
}

