/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.Status;
import ch.cyberduck.core.Transfer;
import ch.cyberduck.core.i18n.Locale;

public class Speedometer {
    private long timestamp;
    private double initialBytesTransfered;
    private double bytesTransferred;
    private Transfer transfer;

    public Speedometer(Transfer transfer) {
        this.transfer = transfer;
        this.reset();
    }

    public float getSpeed() {
        this.bytesTransferred = this.transfer.getTransferred();
        if (this.bytesTransferred > this.initialBytesTransfered) {
            if (0.0 == this.initialBytesTransfered) {
                this.initialBytesTransfered = this.bytesTransferred;
                return -1.0f;
            }
            double elapsedSeconds = (System.currentTimeMillis() - this.timestamp) / 1000L;
            if (elapsedSeconds > 1.0) {
                return (float)((this.bytesTransferred - this.initialBytesTransfered) / elapsedSeconds);
            }
        }
        return -1.0f;
    }

    public String getProgress() {
        StringBuffer b = new StringBuffer();
        b.append(Status.getSizeAsString(this.transfer.getTransferred()));
        b.append(" ");
        b.append(Locale.localizedString("of", "1.2MB of 3.4MB"));
        b.append(" ");
        b.append(Status.getSizeAsString(this.transfer.getSize()));
        if (this.transfer.isRunning()) {
            b.append(" (");
            b.append((int)(this.transfer.getTransferred() / this.transfer.getSize() * 100.0));
            b.append("%");
            float speed = this.getSpeed();
            if (speed > 0.0f) {
                b.append(", ");
                b.append(Status.getSizeAsString(speed));
                b.append("/sec");
                if (this.transfer.getSize() > 0.0) {
                    b.append(", ");
                    double remaining = (this.transfer.getSize() - this.getBytesTransfered()) / (double)speed;
                    b.append(Status.getRemainingAsString(remaining));
                }
            }
            b.append(")");
        }
        return b.toString();
    }

    public double getBytesTransfered() {
        return this.bytesTransferred;
    }

    public void reset() {
        this.timestamp = System.currentTimeMillis();
        this.initialBytesTransfered = this.transfer.getTransferred();
        this.bytesTransferred = 0.0;
    }
}

