/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.i18n.Locale;
import java.math.BigDecimal;
import java.text.MessageFormat;
import org.apache.log4j.Logger;

public class Status {
    private static Logger log = Logger.getLogger(Status.class);
    private boolean resume = false;
    private long current = 0L;
    private boolean canceled;
    private boolean complete = false;
    public static final long KILO = 1024L;
    public static final long MEGA = 0x100000L;
    public static final long GIGA = 0x40000000L;
    private boolean skip = false;

    public static String getSizeAsString(double size) {
        if (-1.0 == size) {
            return Locale.localizedString("Unknown size");
        }
        if (size < 1024.0) {
            return (int)size + " B";
        }
        if (size < 1048576.0) {
            return new BigDecimal(size).divide(new BigDecimal(1024L), 1, 1).toString() + " KB";
        }
        if (size < 1.073741824E9) {
            return new BigDecimal(size).divide(new BigDecimal(0x100000L), 1, 1).toString() + " MB";
        }
        return new BigDecimal(size).divide(new BigDecimal(0x40000000L), 1, 1).toString() + " GB";
    }

    public static String getRemainingAsString(double remaining) {
        StringBuffer b = new StringBuffer();
        if (remaining > 7200.0) {
            b.append(MessageFormat.format(Locale.localizedString("{0} hours remaining", "Status"), new BigDecimal(remaining).divide(new BigDecimal(3600), 1, 1).toString()));
        } else if (remaining > 120.0) {
            b.append(MessageFormat.format(Locale.localizedString("{0} minutes remaining", "Status"), String.valueOf((int)(remaining / 60.0))));
        } else {
            b.append(MessageFormat.format(Locale.localizedString("{0} seconds remaining", "Status"), String.valueOf((int)remaining)));
        }
        return b.toString();
    }

    public void setComplete(boolean complete) {
        this.complete = complete;
        log.info((Object)("------------------- Complete:" + this.getCurrent()));
    }

    public boolean isComplete() {
        return this.complete;
    }

    public void setCanceled() {
        this.canceled = true;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public long getCurrent() {
        return this.current;
    }

    public void setCurrent(long current) {
        this.current = current;
    }

    public void setSkipped(boolean ignore) {
        log.debug((Object)("setSkipped:" + ignore));
        this.skip = ignore;
    }

    public boolean isSkipped() {
        return this.skip;
    }

    public void setResume(boolean resume) {
        if (!resume) {
            this.current = 0L;
        }
        this.resume = resume;
    }

    public boolean isResume() {
        return this.resume;
    }

    public void reset() {
        this.complete = false;
        this.canceled = false;
    }
}

