/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.DownloadTransfer;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.Transfer;
import ch.cyberduck.core.TransferAction;
import ch.cyberduck.core.TransferOptions;
import ch.cyberduck.core.UploadTransfer;
import ch.cyberduck.core.ftp.FTPPath;
import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.core.serializer.Serializer;
import ch.cyberduck.ui.growl.Growl;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyncTransfer
extends Transfer {
    private Transfer _delegateUpload;
    private Transfer _delegateDownload;
    private TransferAction action = TransferAction.forName(Preferences.instance().getProperty("queue.sync.action.default"));
    public static final TransferAction ACTION_DOWNLOAD = new TransferAction(){

        public String toString() {
            return "download";
        }

        public String getLocalizableString() {
            return Locale.localizedString("Download");
        }
    };
    public static final TransferAction ACTION_UPLOAD = new TransferAction(){

        public String toString() {
            return "upload";
        }

        public String getLocalizableString() {
            return Locale.localizedString("Upload");
        }
    };
    public static final TransferAction ACTION_MIRROR = new TransferAction(){

        public String toString() {
            return "mirror";
        }

        public String getLocalizableString() {
            return Locale.localizedString("Mirror");
        }
    };
    private Transfer.TransferFilter ACTION_OVERWRITE = new Transfer.TransferFilter(){
        private Transfer.TransferFilter _delegateFilterDownload;
        private Transfer.TransferFilter _delegateFilterUpload;
        {
            this._delegateFilterDownload = SyncTransfer.this._delegateDownload.filter(TransferAction.ACTION_OVERWRITE);
            this._delegateFilterUpload = SyncTransfer.this._delegateUpload.filter(TransferAction.ACTION_OVERWRITE);
        }

        public void prepare(Path p) {
            Comparison compare = SyncTransfer.this.compare(p);
            if (compare.equals(COMPARISON_REMOTE_NEWER)) {
                this._delegateFilterDownload.prepare(p);
            } else if (compare.equals(COMPARISON_LOCAL_NEWER)) {
                this._delegateFilterUpload.prepare(p);
            }
        }

        public boolean accept(Path p) {
            Comparison compare = SyncTransfer.this.compare(p);
            if (!COMPARISON_EQUAL.equals(compare)) {
                if (compare.equals(COMPARISON_REMOTE_NEWER)) {
                    return this._delegateFilterDownload.accept(p);
                }
                if (compare.equals(COMPARISON_LOCAL_NEWER)) {
                    return this._delegateFilterUpload.accept(p);
                }
            }
            return false;
        }
    };
    private final Map<Path, Comparison> _comparisons = new HashMap<Path, Comparison>();
    public static final Comparison COMPARISON_REMOTE_NEWER = new Comparison(){

        public String toString() {
            return "COMPARISON_REMOTE_NEWER";
        }
    };
    public static final Comparison COMPARISON_LOCAL_NEWER = new Comparison(){

        public String toString() {
            return "COMPARISON_LOCAL_NEWER";
        }
    };
    public static final Comparison COMPARISON_EQUAL = new Comparison(){

        public String toString() {
            return "COMPARISON_EQUAL";
        }
    };
    private static final Comparison COMPARISON_UNEQUAL = new Comparison(){

        public String toString() {
            return "COMPARISON_UNEQUAL";
        }
    };

    public SyncTransfer(Path root) {
        super(root);
    }

    public <T> SyncTransfer(T dict, Session s) {
        super(dict, s);
    }

    @Override
    public <T> T getAsDictionary() {
        Serializer dict = super.getSerializer();
        dict.setStringForKey(String.valueOf(2), "Kind");
        return dict.getSerialized();
    }

    @Override
    protected void init() {
        log.debug((Object)"init");
        this._delegateUpload = new UploadTransfer(this.getRoots());
        this._delegateDownload = new DownloadTransfer(this.getRoots());
    }

    @Override
    public void setBandwidth(float bytesPerSecond) {
    }

    @Override
    public float getBandwidth() {
        return -1.0f;
    }

    @Override
    public String getName() {
        return this.getRoot().getName() + " \u2194 " + this.getRoot().getLocal().getName();
    }

    @Override
    public double getSize() {
        double size = this._delegateDownload.getSize() + this._delegateUpload.getSize();
        if (0.0 == size) {
            return super.getSize();
        }
        return size;
    }

    @Override
    public double getTransferred() {
        double transferred = this._delegateDownload.getTransferred() + this._delegateUpload.getTransferred();
        if (0.0 == transferred) {
            return super.getTransferred();
        }
        return transferred;
    }

    public void setTransferAction(TransferAction action) {
        this.action = action;
        this._comparisons.clear();
    }

    public TransferAction getAction() {
        return this.action;
    }

    @Override
    public Transfer.TransferFilter filter(TransferAction action) {
        log.debug((Object)("filter:" + action));
        if (action.equals(TransferAction.ACTION_OVERWRITE)) {
            return this.ACTION_OVERWRITE;
        }
        if (action.equals(TransferAction.ACTION_CALLBACK)) {
            TransferAction result = this.prompt.prompt();
            return this.filter(result);
        }
        return super.filter(action);
    }

    @Override
    public AttributedList<Path> childs(Path parent) {
        AttributedList<Path> childs = new AttributedList<Path>();
        childs.addAll(this._delegateDownload.childs(parent));
        childs.addAll(this._delegateUpload.childs(parent));
        return childs;
    }

    @Override
    public boolean isSelectable(Path item) {
        return item.attributes.isDirectory() || !this.compare(item).equals(COMPARISON_EQUAL);
    }

    @Override
    public TransferAction action(boolean resumeRequested, boolean reloadRequested) {
        log.debug((Object)("action:" + resumeRequested + "," + reloadRequested));
        return TransferAction.ACTION_CALLBACK;
    }

    @Override
    protected void _transferImpl(Path p) {
        Comparison compare = this.compare(p);
        if (compare.equals(COMPARISON_REMOTE_NEWER)) {
            this._delegateDownload._transferImpl(p);
        } else if (compare.equals(COMPARISON_LOCAL_NEWER)) {
            this._delegateUpload._transferImpl(p);
        }
    }

    @Override
    protected void fireTransferDidEnd() {
        if (this.isReset() && this.isComplete() && !this.isCanceled()) {
            Growl.instance().notify("Synchronization complete", this.getName());
        }
        super.fireTransferDidEnd();
    }

    @Override
    protected void clear(TransferOptions options) {
        this._comparisons.clear();
        this._delegateDownload.clear(options);
        this._delegateUpload.clear(options);
        super.clear(options);
    }

    @Override
    protected void reset() {
        this._delegateDownload.reset();
        this._delegateUpload.reset();
        super.reset();
    }

    public Comparison compare(Path p) {
        if (!this._comparisons.containsKey(p)) {
            log.debug((Object)("compare:" + p));
            Comparison result = COMPARISON_EQUAL;
            if (p.getLocal().exists() && p.exists()) {
                if (p.attributes.isFile() && (result = this.compareSize(p)).equals(COMPARISON_UNEQUAL)) {
                    if (this.getAction().equals(ACTION_DOWNLOAD)) {
                        result = COMPARISON_REMOTE_NEWER;
                    } else if (this.getAction().equals(ACTION_UPLOAD)) {
                        result = COMPARISON_LOCAL_NEWER;
                    } else if (this.getAction().equals(ACTION_MIRROR)) {
                        result = this.compareTimestamp(p);
                    }
                }
            } else if (p.exists()) {
                result = COMPARISON_REMOTE_NEWER;
            } else if (p.getLocal().exists()) {
                result = COMPARISON_LOCAL_NEWER;
            }
            if (COMPARISON_EQUAL.equals(result)) {
                this.setSkipped(p, p.attributes.isFile());
            } else if (result.equals(COMPARISON_REMOTE_NEWER)) {
                this.setSkipped(p, this.getAction().equals(ACTION_UPLOAD));
            } else if (result.equals(COMPARISON_LOCAL_NEWER)) {
                this.setSkipped(p, this.getAction().equals(ACTION_DOWNLOAD));
            }
            this._comparisons.put(p, result);
        }
        return this._comparisons.get(p);
    }

    private Comparison compareSize(Path p) {
        log.debug((Object)("compareSize:" + p));
        if (p.attributes.getSize() == -1L) {
            p.readSize();
        }
        if (p.attributes.getSize() == 0L && p.getLocal().attributes.getSize() == 0L) {
            return COMPARISON_EQUAL;
        }
        if (p.attributes.getSize() == 0L) {
            return COMPARISON_LOCAL_NEWER;
        }
        if (p.getLocal().attributes.getSize() == 0L) {
            return COMPARISON_REMOTE_NEWER;
        }
        if (p.attributes.getSize() == p.getLocal().attributes.getSize()) {
            return COMPARISON_EQUAL;
        }
        return COMPARISON_UNEQUAL;
    }

    private Comparison compareTimestamp(Path p) {
        log.debug((Object)("compareTimestamp:" + p));
        if (p.attributes.getModificationDate() == -1L || p instanceof FTPPath) {
            p.readTimestamp();
        }
        Calendar remote = this.asCalendar(p.attributes.getModificationDate(), 13);
        Calendar local = this.asCalendar(p.getLocal().attributes.getModificationDate(), 13);
        if (local.before(remote)) {
            return COMPARISON_REMOTE_NEWER;
        }
        if (local.after(remote)) {
            return COMPARISON_LOCAL_NEWER;
        }
        return COMPARISON_EQUAL;
    }

    private Calendar asCalendar(long timestamp, int precision) {
        log.debug((Object)("asCalendar:" + timestamp));
        Calendar c = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        c.setTimeInMillis(timestamp);
        if (precision == 14) {
            return c;
        }
        c.clear(14);
        if (precision == 13) {
            return c;
        }
        c.clear(13);
        if (precision == 12) {
            return c;
        }
        c.clear(12);
        if (precision == 10) {
            return c;
        }
        c.clear(10);
        return c;
    }

    public static class Comparison {
        public boolean equals(Object other) {
            if (null == other) {
                return false;
            }
            return this == other;
        }
    }
}

