/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Collection;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathFactory;
import ch.cyberduck.core.PathFilter;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.Queue;
import ch.cyberduck.core.Serializable;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.TransferAction;
import ch.cyberduck.core.TransferCollection;
import ch.cyberduck.core.TransferListener;
import ch.cyberduck.core.TransferOptions;
import ch.cyberduck.core.TransferPrompt;
import ch.cyberduck.core.ftp.FTPSession;
import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.core.io.BandwidthThrottle;
import ch.cyberduck.core.serializer.Deserializer;
import ch.cyberduck.core.serializer.DeserializerFactory;
import ch.cyberduck.core.serializer.Serializer;
import ch.cyberduck.core.serializer.SerializerFactory;
import ch.cyberduck.core.sftp.SFTPSession;
import ch.cyberduck.ui.growl.Growl;
import com.enterprisedt.net.ftp.FTPTransferType;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Transfer
implements Serializable {
    protected static Logger log = Logger.getLogger(Transfer.class);
    protected List<Path> roots;
    protected double size = 0.0;
    protected double transferred = 0.0;
    private boolean canceled;
    public static final int KIND_DOWNLOAD = 0;
    public static final int KIND_UPLOAD = 1;
    public static final int KIND_SYNC = 2;
    private boolean running;
    private boolean queued;
    private Session session;
    private boolean reset;
    private Date timestamp;
    private Set<TransferListener> listeners = Collections.synchronizedSet(new HashSet());
    protected BandwidthThrottle bandwidth;
    private Path _current = null;
    protected TransferPrompt prompt;

    protected Transfer() {
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isQueued() {
        return this.queued;
    }

    public boolean isResumable() {
        if (!this.isComplete()) {
            if (this.getSession() instanceof SFTPSession) {
                return Preferences.instance().getProperty("ssh.transfer").equals(Protocol.SFTP.getIdentifier());
            }
            if (this.getSession() instanceof FTPSession) {
                return Preferences.instance().getProperty("ftp.transfermode").equals(FTPTransferType.BINARY.toString());
            }
            return true;
        }
        return false;
    }

    public Transfer(Path root) {
        this(new Collection<Path>((java.util.Collection<Path>)Collections.singletonList(root)));
    }

    public Transfer(List<Path> roots) {
        this.setRoots(roots);
        this.session = this.getRoot().getSession();
        this.init();
    }

    protected abstract void init();

    public <T> Transfer(T dict, Session s) {
        this.session = s;
        this.init(dict);
    }

    @Override
    public <T> void init(T serialized) {
        String currentObj;
        String timestampObj;
        String sizeObj;
        Deserializer dict = DeserializerFactory.createDeserializer(serialized);
        List rootsObj = dict.listForKey("Roots");
        if (rootsObj != null) {
            this.roots = new Collection<Path>();
            for (Object rootDict : rootsObj) {
                this.roots.add(PathFactory.createPath(this.session, rootDict));
            }
        }
        if ((sizeObj = dict.stringForKey("Size")) != null) {
            this.size = Double.parseDouble(sizeObj.toString());
        }
        if ((timestampObj = dict.stringForKey("Timestamp")) != null) {
            this.timestamp = new Date(Long.parseLong(timestampObj.toString()));
        }
        if ((currentObj = dict.stringForKey("Current")) != null) {
            this.transferred = Double.parseDouble(currentObj.toString());
        }
        this.init();
        String bandwidthObj = dict.stringForKey("Bandwidth");
        if (bandwidthObj != null) {
            this.bandwidth.setRate(Float.parseFloat(bandwidthObj.toString()));
        }
    }

    @Override
    public abstract <T> T getAsDictionary();

    public Serializer getSerializer() {
        Serializer dict = SerializerFactory.createSerializer();
        dict.setObjectForKey(this.getSession().getHost(), "Host");
        dict.setListForKey(this.roots, "Roots");
        dict.setStringForKey(String.valueOf(this.getSize()), "Size");
        dict.setStringForKey(String.valueOf(this.getTransferred()), "Current");
        if (this.timestamp != null) {
            dict.setStringForKey(String.valueOf(this.timestamp.getTime()), "Timestamp");
        }
        if (this.bandwidth != null) {
            dict.setStringForKey(String.valueOf(this.bandwidth.getRate()), "Bandwidth");
        }
        return dict;
    }

    public void addListener(TransferListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(TransferListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireTransferWillStart() {
        this.canceled = false;
        this.running = true;
        this.queued = false;
        for (TransferListener listener : this.listeners.toArray(new TransferListener[this.listeners.size()])) {
            listener.transferWillStart();
        }
    }

    public void fireTransferQueued() {
        Session session = this.getSession();
        Growl.instance().notify("Transfer queued", session.getHost().getHostname());
        session.message(Locale.localizedString("Maximum allowed connections exceeded. Waiting", "Status"));
        this.queued = true;
        for (TransferListener listener : this.listeners.toArray(new TransferListener[this.listeners.size()])) {
            listener.transferQueued();
        }
    }

    public void fireTransferResumed() {
        this.queued = false;
        for (TransferListener listener : this.listeners.toArray(new TransferListener[this.listeners.size()])) {
            listener.transferResumed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireTransferDidEnd() {
        this.running = false;
        this.queued = false;
        for (TransferListener listener : this.listeners.toArray(new TransferListener[this.listeners.size()])) {
            listener.transferDidEnd();
        }
        Queue queue = Queue.instance();
        synchronized (queue) {
            Queue.instance().notify();
        }
        this.timestamp = new Date();
    }

    protected void fireWillTransferPath(Path path) {
        for (TransferListener listener : this.listeners.toArray(new TransferListener[this.listeners.size()])) {
            listener.willTransferPath(path);
        }
    }

    protected void fireDidTransferPath(Path path) {
        for (TransferListener listener : this.listeners.toArray(new TransferListener[this.listeners.size()])) {
            listener.didTransferPath(path);
        }
    }

    public void setBandwidth(float bytesPerSecond) {
        log.debug((Object)("setBandwidth:" + bytesPerSecond));
        this.bandwidth.setRate(bytesPerSecond);
        for (TransferListener listener : this.listeners.toArray(new TransferListener[this.listeners.size()])) {
            listener.bandwidthChanged(this.bandwidth);
        }
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public float getBandwidth() {
        return this.bandwidth.getRate();
    }

    public Path getRoot() {
        return this.roots.get(0);
    }

    public List<Path> getRoots() {
        return this.roots;
    }

    protected void setRoots(List<Path> roots) {
        this.roots = roots;
    }

    public Session getSession() {
        return this.session;
    }

    public String getName() {
        String name = "";
        for (Path next : this.roots) {
            name = name + next.getLocal().getName() + " ";
        }
        return name;
    }

    public TransferFilter filter(TransferAction action) {
        if (action.equals(TransferAction.ACTION_CANCEL)) {
            return null;
        }
        throw new IllegalArgumentException("Unknown transfer action:" + action);
    }

    public abstract TransferAction action(boolean var1, boolean var2);

    public abstract AttributedList<Path> childs(Path var1);

    public boolean isIncluded(Path item) {
        return !item.getStatus().isSkipped() && this.isSelectable(item);
    }

    public boolean isSelectable(Path item) {
        return true;
    }

    public void setSkipped(Path item, boolean skipped) {
        item.getStatus().setSkipped(skipped);
        if (item.attributes.isDirectory() && item.isCached()) {
            for (Path child : this.childs(item)) {
                this.setSkipped(child, skipped);
            }
        }
    }

    private void transfer(Path p, TransferFilter filter) {
        if (!this.isIncluded(p)) {
            return;
        }
        if (!this.check()) {
            return;
        }
        if (filter.accept(p)) {
            this.fireWillTransferPath(p);
            this._current = p;
            this._current.getStatus().reset();
            this._transferImpl(this._current);
            this.fireDidTransferPath(this._current);
        }
        if (!this.check()) {
            return;
        }
        if (p.attributes.isDirectory()) {
            boolean failure = false;
            AttributedList<Path> childs = this.childs(p);
            if (!childs.attributes().isReadable()) {
                failure = true;
            }
            for (Path child : childs) {
                this.transfer(child, filter);
                if (child.getStatus().isComplete()) continue;
                failure = true;
            }
            if (!failure) {
                p.getStatus().setComplete(true);
            }
        }
    }

    protected abstract void _transferImpl(Path var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transfer(TransferOptions options) {
        Session session = this.getSession();
        try {
            try {
                session.check();
            }
            catch (IOException e) {
                this.clear(options);
                if (options.closeSession) {
                    session.close();
                }
                return;
            }
            if (!this.check()) {
                return;
            }
            TransferAction action = this.action(options.resumeRequested, options.reloadRequested);
            if (action.equals(TransferAction.ACTION_CANCEL)) {
                this.cancel();
                return;
            }
            this.clear(options);
            TransferFilter filter = this.filter(action);
            if (null == filter) {
                this.cancel();
                return;
            }
            this.reset();
            for (Path next : this.roots) {
                this.prepare(next, filter);
            }
            for (Path next : this.roots) {
                this.transfer(next, filter);
            }
        }
        finally {
            this.clear(options);
            if (options.closeSession) {
                session.close();
            }
        }
    }

    private void prepare(Path p, TransferFilter filter) {
        log.debug((Object)("prepare:" + p));
        if (!this.check()) {
            return;
        }
        if (!this.isIncluded(p)) {
            return;
        }
        if (filter.accept(p)) {
            filter.prepare(p);
        }
        if (p.attributes.isDirectory()) {
            for (Path child : this.childs(p)) {
                this.prepare(child, filter);
            }
        }
    }

    private boolean check() {
        log.debug((Object)"check:");
        if (!this.getSession().isConnected()) {
            return false;
        }
        return !this.isCanceled();
    }

    protected void clear(TransferOptions options) {
        log.debug((Object)"clear");
        if (options.closeSession) {
            this.session.cache().clear();
        }
    }

    public void start(TransferPrompt prompt) {
        this.start(prompt, TransferOptions.DEFAULT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(TransferPrompt prompt, TransferOptions options) {
        log.debug((Object)("start:" + prompt));
        this.prompt = prompt;
        try {
            this.fireTransferWillStart();
            this.queue();
            if (this.isCanceled()) {
                return;
            }
            this.transfer(options);
        }
        finally {
            this.fireTransferDidEnd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queue() {
        TransferCollection q = TransferCollection.instance();
        if (q.numberOfRunningTransfers() - q.numberOfQueuedTransfers() - 1 >= (int)Preferences.instance().getDouble("queue.maxtransfers")) {
            this.fireTransferQueued();
            log.info((Object)("Queuing " + this.toString()));
            try {
                Queue queue = Queue.instance();
                synchronized (queue) {
                    Queue.instance().wait();
                }
            }
            catch (InterruptedException e) {
                log.error((Object)e.getMessage());
            }
            log.info((Object)(this.toString() + " released from queue"));
            this.fireTransferResumed();
        }
    }

    public void interrupt() {
        log.debug((Object)"interrupt:");
        this.getSession().interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        log.debug((Object)"cancel:");
        if (this.isCanceled()) {
            this.interrupt();
        } else {
            if (this._current != null) {
                this._current.getStatus().setCanceled();
            }
            this.canceled = true;
        }
        Queue queue = Queue.instance();
        synchronized (queue) {
            Queue.instance().notify();
        }
    }

    protected void reset() {
        log.debug((Object)"reset:");
        this.transferred = 0.0;
        this.size = 0.0;
        this.reset = true;
    }

    public boolean isReset() {
        return this.reset;
    }

    public int numberOfRoots() {
        return this.roots.size();
    }

    public boolean isComplete() {
        log.debug((Object)"isComplete");
        for (Path root : this.roots) {
            if (root.getStatus().isSkipped() || root.getStatus().isComplete()) continue;
            return false;
        }
        return true;
    }

    public double getSize() {
        return this.size;
    }

    public void setSize(double size) {
        this.size = size;
    }

    public double getTransferred() {
        return this.transferred;
    }

    public void setTransferred(double transferred) {
        this.transferred = transferred;
    }

    public String toString() {
        return this.getName();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class TransferFilter
    implements PathFilter<Path> {
        protected TransferFilter() {
        }

        public abstract void prepare(Path var1);
    }
}

