/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.aquaticprime;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.Native;
import ch.cyberduck.core.Preferences;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FalseFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.log4j.Logger;

public class License {
    private static Logger log = Logger.getLogger(License.class);
    private static boolean JNI_LOADED = false;
    private static final License EMPTY = new License(){

        public boolean verify() {
            return false;
        }

        public String getValue(String property) {
            return null;
        }
    };
    private Local file;

    private static boolean loadNative() {
        if (!JNI_LOADED) {
            JNI_LOADED = Native.load("Prime");
        }
        return JNI_LOADED;
    }

    public static License find() {
        Collection licenses = FileUtils.listFiles((File)new File(LocalFactory.createLocal(Preferences.instance().getProperty("application.support.path")).getAbsolute()), (IOFileFilter)new SuffixFileFilter(".cyberducklicense"), (IOFileFilter)FalseFileFilter.FALSE);
        Iterator i$ = licenses.iterator();
        if (i$.hasNext()) {
            File license = (File)i$.next();
            return new License(LocalFactory.createLocal(license));
        }
        log.info((Object)"No license found");
        return EMPTY;
    }

    private License() {
    }

    public License(Local file) {
        this.file = file;
    }

    public boolean verify() {
        if (!License.loadNative()) {
            return false;
        }
        boolean valid = this.verify(this.file.getAbsolute());
        if (valid) {
            log.info((Object)("Valid donation key:" + this.file.getAbsolute()));
        } else {
            log.warn((Object)("Not a valid donation key:" + this.file.getAbsolute()));
        }
        return valid;
    }

    private native boolean verify(String var1);

    public String getValue(String property) {
        if (!License.loadNative()) {
            return null;
        }
        return this.getValue(this.file.getAbsolute(), property);
    }

    private native String getValue(String var1, String var2);
}

